
<?php $__env->startSection('content'); ?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
</br>
<section class="content">
  <div class="container-fluid">
    <?php if(\Session::has('success')): ?>
        <div class="alert alert-success">
            <p><?php echo e(\Session::get('success')); ?></p>
        </div>
    <?php endif; ?>
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-0">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Overview</span>
                          <h3 class="m-0"><strong>Trade Account</strong></h3>
                        </div><!-- /.col -->
                        <div  hidden="hidden" class="col-sm-6">
                          <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                          </ol>
                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div>
          <div class="card-header  border-0">
          <div class="card-tools">
            <div class="card-header border-0">
                          <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('trade-create')): ?>
                          <a class="btn btn-warning  btn-block waves-effect" href="<?php echo e(route('trades.create')); ?>">  Add Trade</a>
                          <?php endif; ?>
                      </div>
       </div>
          </div>
          <div class="card-header border-0 ">
            <div class="text-right">
                </div>
              </div>
          <!-- /.card-header -->
          <div class="card-body">
            <table id="example2" class="table table-bordered rounded table-hover">
              <thead class="bg-warning">
            <tr class="text-center">
              <th width="20px">No</th>
              <th>Account Name</th>
              <th>Total Winnnings</th>
              <th>Total Lossings</th>
              <th>Total Profit/Loss</th>
              <th>ROI</th>
              <th width="150px">Action</th>
            </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="text-center">
              <td class="align-middle"><?php echo e($key + 1); ?></td>
              <td class="align-middle" ><?php echo e($row->portfolio_name); ?></td>
              <td class="align-middle " ><?php echo e($row->win); ?></td>
              <td class="align-middle " ><?php echo e($row->loss); ?></td>
              <?php if($row->total_profit < 0): ?>
              <td class="align-middle text-danger"  >MYR <?php echo e(round($row->total_profit, 2)); ?></td>
              <?php elseif($row->total_profit > 1): ?>
              <td class="align-middle text-success"  >MYR <?php echo e(round($row->total_profit, 2)); ?></td>
              <?php else: ?>
              <td class="align-middle "  >MYR <?php echo e(round($row->total_profit, 2)); ?></td>
              <?php endif; ?>
              <?php if($row->roi_port < 0): ?>
              <td class="align-middle text-danger"  ><?php echo e(round($row->roi_port, 2)); ?>%</td>
              <?php elseif($row->roi_port > 1): ?>
              <td class="align-middle text-success"  ><?php echo e(round($row->roi_port, 2)); ?>%</td>
              <?php else: ?>
              <td class="align-middle "  ><?php echo e(round($row->roi_port, 2)); ?>%</td>
              <?php endif; ?>
              <td>
                <a class="btn btn-warning btn-sm btn-block waves-effect" href="<?php echo e(route('trades.statistic',$row->id)); ?>"><i class="nav-icon fas fa-chart-pie"></i>  Statistic</a>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('portfolio-edit')): ?>

                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('portfolio-delete')): ?>

                     <?php endif; ?>
              </td>

            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
<?php $__env->stopSection(); ?>

    <script type="text/javascript">
                  function deletePrograms(id) {
                    Swal.fire({
                      title: 'Are you sure?',
                      text: "You won't be able to revert this!",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
              if (result.value) {
                event.preventDefault();
                document.getElementById('delete-form-'+id).submit();

              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
              }
              })
                  }
    </script>

<?php echo $__env->make('layouts.backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/theprotegeportal/resources/views/trades/index.blade.php ENDPATH**/ ?>