
<?php $__env->startSection('content'); ?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->

  <!-- /.content-header -->
</br>
<section class="content">
  <div class="container-fluid">
    <?php if(\Session::has('success')): ?>
        <div class="alert alert-success">
            <p><?php echo e(\Session::get('success')); ?></p>
        </div>
    <?php endif; ?>
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-0">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Overview</span>
                          <h3 class="m-0"><strong>Trade History</strong></h3>
                        </div><!-- /.col -->
                        <div  hidden="hidden" class="col-sm-6">
                          <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                          </ol>
                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.contaizner-fluid -->
          </br>
            <div class="card elevation-1 pb-3 bg-gradient-warning text-dark ">
              <div class="content-header">
                <div class="container-fluid ">
                  <div class="row mb-2">
                            <div class="col-sm-6">
                              <h3 class="m-0"><strong><?php echo e($result->stock_name); ?> | <?php echo e($result->stock_symbol); ?></strong></h3>
                              <span class="m-0 text-muted">Open Date : <?php echo e(date('d/m/Y h:i A  ', strtotime($result->open_trade))); ?></span>
                            </br>
                            <?php if($result->close_trade === NULL): ?>
                            <?php else: ?>
                            <span class="m-0 text-muted">Close Date : <?php echo e(date('d/m/Y h:i A  ', strtotime($result->close_trade))); ?></span>
                            <?php endif; ?>
                            </div><!-- /.col -->
                            <div  class="col-sm-6">
                              <div class="float-sm-right">
                                    <?php if($result->status == 'WIN'): ?>
                                    <h2> <span class="badge badge-success float-right">PROFIT</span></h2>
                                    <h4> <span class="text-success float-right"><strong>MYR <?php echo e(round($result->net_profit, 2)); ?> (<?php echo e(round($result->net_roi, 2)); ?>%)</strong></span></h4>

                                    <?php elseif($result->status == 'LOSS'): ?>
                                    <h2> <span class="badge badge-danger float-right">LOSS</span></h2>
                                    <h4> <span class="text-danger float-right"><strong>MYR <?php echo e(round($result->net_profit, 2)); ?> (<?php echo e(round($result->net_roi, 2)); ?>%)</strong></span></h4>
                                    <?php else: ?>
                                    <?php endif; ?>

                              </div>
                            </div><!-- /.col -->
                          </div><!-- /.row -->
                </div><!-- /.container-fluid -->
              </div>
            </div>
          </div>
          <div class="card-header  border-0">
          <div class="card-tools">
            <div class="card-header border-0">

                      </div>
       </div>
          </div>
          <div class="card-header border-0 ">
            <div class="text-right">
                </div>
              </div>
          <!-- /.card-header -->
          <div class="card-body">
            <table id="example2" class="table table-bordered rounded table-hover">
              <thead class="bg-warning">
            <tr class="text-center">
              <th width="100px">No</th>
              <th >Action</th>
              <th>Date</th>
              <th >Price</th>
              <th >Quantity</th>
              <th >Total</th>
              <th >Broker Fee</th>
              <th >Stamp Fee</th>
              <th >Clearing Fee</th>
              <th >Total Cost</th>
              <th >Reason</th>
            </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="text-center">
              <td class="align-middle"><?php echo e($key + 1); ?></td>
              <td class="align-middle" >
                <?php if($row->action == 'buy'): ?>
                <h5> <span class="badge badge-primary">BUY</span></h5>
                <?php else: ?>
                <h5> <span class="badge badge-danger">SELL</span></h5>
                <?php endif; ?>
              </td>
              <td class="align-middle" ><?php echo e(date('d/m/Y h:i A ', strtotime($row->date))); ?></td>
              <td class="align-middle">MYR <?php echo e($row -> price); ?></td>
              <td class="align-middle"><?php echo e($row -> quantity); ?> Unit</td>
              <td class="align-middle">MYR <?php echo e(round($row -> subtotal, 2)); ?></td>
              <td class="align-middle">MYR <?php echo e(round($row -> broker_fee, 2)); ?></td>
              <td class="align-middle">MYR <?php echo e(round($row -> stamp_duty, 2)); ?></td>
              <td class="align-middle">MYR <?php echo e(round($row -> clearing_fee, 2)); ?></td>
              <td class="align-middle">MYR <?php echo e(round($row -> total_cost, 2)); ?></td>
              <td class="align-middle"><?php echo e($row -> remark); ?></td>


            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

          </table>

          </div>
          <!-- /.card-body -->
          <div class="card-header  border-0">
            <div class="row">
              <div class="col-lg-2 col-6">
                <!-- small box -->
                <div class="small-box bg-yellow elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Average Buy </strong></h6>
                    <h6><strong>MYR <?php echo e(round($data->sum('price') / $data->count(), 2)); ?></strong></h6>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div class="col-lg-2 col-6">
                <!-- small box -->
                <div class="small-box bg-yellow elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Available Shares </strong></h6>
                    <h6><strong><?php echo e($data->sum('quantity_bal')); ?> Unit</strong></h6>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div class="col-lg-2 col-6">
                <!-- small box -->
                <div class="small-box bg-yellow elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Total Fee </strong></h6>
                    <h6><strong>MYR <?php echo e(round($result->total_fees_buy + $result->total_fees_sell, 2)); ?></strong></h6>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div  class="col-lg-2 col-6">
                <!-- small box -->
                <div class="small-box bg-yellow elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Profit/Loss </strong></h6>
                    <?php if($result->status == 'WIN'): ?>
                    <h6 class="text-success"><strong>MYR <?php echo e(round($result->gross_profit, 2)); ?></strong></h6>
                    <?php elseif($result->status == 'LOSS'): ?>
                    <h6 class="text-danger"><strong>MYR <?php echo e(round($result->gross_profit, 2)); ?></strong></h6>
                    <?php else: ?>
                    <h6 ><strong>MYR 0.00</strong></h6>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
              <div  class="col-lg-2 col-6">
                <!-- small box -->
                <div class="small-box bg-yellow elevation-1">
                  <div class="inner text-center">
                    <h6><strong>ROI (%) </strong></h6>
                    <?php if($result->status == 'WIN'): ?>
                    <h6 class="text-success"><strong><?php echo e(round($result->net_roi, 2)); ?>%</strong></h6>
                    <?php elseif($result->status == 'LOSS'): ?>
                    <h6 class="text-danger"><strong><?php echo e(round($result->net_roi, 2)); ?>%</strong></h6>
                    <?php else: ?>
                    <h6 ><strong>0.00%</strong></h6>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
              <div  class="col-lg-2 col-6">
                <!-- small box -->
                <div class="small-box bg-yellow elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Total Profit/Loss </strong></h6>
                    <?php if($result->status == 'WIN'): ?>
                    <h6 class="text-success"><strong>MYR <?php echo e(round($result->net_profit, 2)); ?></strong></h6>
                    <?php elseif($result->status == 'LOSS'): ?>
                    <h6 class="text-danger"><strong>MYR <?php echo e(round($result->net_profit, 2)); ?></strong></h6>
                    <?php else: ?>
                    <h6 ><strong>MYR 0.00</strong></h6>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
              <!-- ./col -->
            </div>
          </div>
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
<?php $__env->stopSection(); ?>

    <script type="text/javascript">
                  function deleteTrade(id) {
                    Swal.fire({
                      title: 'Are you sure?',
                      text: "You won't be able to revert this!",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
              if (result.value) {
                event.preventDefault();
                document.getElementById('delete-form-'+id).submit();

              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
              }
              })
                  }
    </script>

<?php echo $__env->make('layouts.backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/theprotegeportal/resources/views/programstatistic/history.blade.php ENDPATH**/ ?>