<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\PostController;
use App\Http\Controllers\StockController;
use App\Http\Controllers\BrokerageController;
use App\Http\Controllers\ProgramController;
use App\Http\Controllers\ProgramStatisticController;
use App\Http\Controllers\BoardController;
use App\Http\Controllers\PortfolioController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\TradeController;
use App\Http\Controllers\CauseController;
use App\Http\Controllers\SellController;
use App\Http\Controllers\BuyController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\CoachRegisterController;
use App\Http\Controllers\ResultController;
use App\Http\Controllers\StatisticsController;
use App\Http\Controllers\SupportController;
use App\Http\Controllers\TicketController;

Route::get('/', function () {
    return view('auth.login');
});

Route::get('/coach-register', function () {
    return view('admincoachregister');
});

//Route::get('/', function () {
// return view('under404');
//});

Route::get('/s','App\Http\Controllers\MailController@home');
Auth::routes();

Route::get('/home', 'HomeController@index');
Route::post('send/email', 'App\Http\Controllers\MailController@sendemail');


Route::get('/system-down', function() {
    Artisan::call('down');
});

Route::get('/storage-link', function() {
    Artisan::call('storage:link');
});

Route::get('/route-cache', function() {
    Artisan::call('route:cache');
});

Route::get('/route-clear', function() {
    Artisan::call('route:clear');
});

Route::get('/optimize', function() {
    Artisan::call('optimize');
});

Route::get('/clear-cache', function() {
    Artisan::call('cache:clear');
   /* return view('contactus');*/
});

Route::get('/config-cache', function() {
    Artisan::call('config:cache');
});

Route::get('causes_cat', 'App\Http\Controllers\CauseController@index');
Route::get('GetSubCatAgainstMainCatEdit/{id}', 'App\Http\Controllers\CauseController@GetSubCatAgainstMainCatEdit');
Route::get('GetSubCatAgainstMainCatEdit/{id}', 'App\Http\Controllers\TradeController@GetSubCatAgainstMainCatEdit');
Route::post('coachregister/store', 'App\Http\Controllers\CoachRegisterController@store')->name('coachregister.store');
Route::resource('coach-register', CoachRegisterController::class);
Route::get('users/export/', [UserController::class, 'export']);


Auth::routes(['verify' => true]);


Route::get('/home', [HomeController::class, 'index'])->name('home')->middleware('verified');

Route::group(['middleware' => ['auth']], function() {
    Route::resource('users', UserController::class);
    Route::resource('roles', RoleController::class);
    Route::resource('permissions', PermissionController::class);
    Route::resource('posts', PostController::class);
    Route::resource('stocks', StockController::class);
    Route::resource('brokerages', BrokerageController::class);
    Route::resource('programs', ProgramController::class);
    Route::resource('programstatistic', ProgramStatisticController::class);
    Route::resource('upadate-boards', BoardController::class);
    Route::resource('portfolios', PortfolioController::class);
    Route::resource('transactions', TransactionController::class);
    Route::resource('trades', TradeController::class);
    Route::resource('sells', SellController::class);
    Route::resource('buys', BuyController::class);
    Route::resource('profiles', ProfileController::class);
    Route::resource('settings', SettingsController::class);
    Route::resource('results', ResultController::class);
    Route::resource('statistics', StatisticsController::class);
    Route::resource('supports', SupportController::class);
    Route::resource('tickets', TicketController::class);
    Route::get('trades/GetSubCatAgainstMainCatEdit/{id}', 'App\Http\Controllers\TradeController@GetSubCatAgainstMainCatEdit');
    Route::get('trades/GetStockAgainstMainCatEdit/{id}', 'App\Http\Controllers\TradeController@GetStockAgainstMainCatEdit');
    Route::get('{id}/trade-history','App\Http\Controllers\TradeController@tradeHistory')->name('trades.history');
    Route::get('{id}/trade-statistic','App\Http\Controllers\TradeController@tradeStatistic')->name('trades.statistic');
    Route::get('{id}/sell-trade','App\Http\Controllers\TradeController@sellTrade')->name('trades.sell');
    Route::get('{id}/buy-trade','App\Http\Controllers\TradeController@buyTrade')->name('trades.buy');
    Route::get('{id}/user-trade-history','App\Http\Controllers\ProgramStatisticController@ProgramUsertradeHistory')->name('programstatistic.history');
    Route::get('{id}/user-trade-statistic','App\Http\Controllers\ProgramStatisticController@ProgramUsertradeStatistic')->name('programstatistic.statistic');
    //Route::get('{id2}/GetSubCatAgainstMainCatEdit/{id}', 'App\Http\Controllers\TradeController@GetSubCatAgainstMainCatEdit')->name('trades.sell');
    Route::delete('/{id}','App\Http\Controllers\SettingsController@destroy')->name('profile.destroy');
    Route::get('settings','App\Http\Controllers\SettingsController@index')->name('settings');
    Route::put('profile-update','App\Http\Controllers\SettingsController@updateProfile')->name('profile.update');
    Route::put('profilepassword-update','App\Http\Controllers\SettingsController@updatePassword')->name('profilepassword.update');
    Route::put('/tickets/{id}/approve','App\Http\Controllers\TicketController@approval')->name('tickets.approve');
    Route::put('/tickets/{id}/close','App\Http\Controllers\TicketController@close')->name('tickets.close');
    Route::get('/{id}/printtrade','App\Http\Controllers\TradeController@createPDF')->name('trades.print');
    Route::get('supports-user/{id}','App\Http\Controllers\SupportController@showUser')->name('supports.supportuser');
    Route::post('supports/store-user','App\Http\Controllers\SupportController@storeUser')->name('supports.storeuser');

    Route::get('/{id}/printusertrade','App\Http\Controllers\ProgramStatisticController@createuserPDF')->name('programstatistic.print');


    Route::get('/{id}/export-programstatistic', 'App\Http\Controllers\ProgramStatisticController@export')->name('export');

    Route::get('file-export', 'App\Http\Controllers\TradeController@fileExport')->name('file-export');

    Route::get('/GetBroke/{data}', 'App\Http\Controllers\ProgramStatisticController@GetBroke');

    Route::post('programstatistic/search','App\Http\Controllers\ProgramStatisticController@search')->name('programstatistic.search');



});
