@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
</br>
</br>
    </div><!-- /.container-fluid -->
  </div>
  <!-- /.content-header -->
  <section class="content">
    <div class="container-fluid">
              <div class="row">
                <div class="col-lg-8 offset-2">
                  <div class="card elevation-1">
                    <div class="card-body">
                      @if (\Session::has('success'))
                          <div class="alert alert-success">
                              <p>{{ \Session::get('success') }}</p>
                          </div>
                      @endif
                      @if (count($errors) > 0)
                          <div class="alert alert-danger">
                              <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                              <ul>
                                  @foreach ($errors->all() as $error)
                                      <li>{{ $error }}</li>
                                  @endforeach
                              </ul>
                          </div>
                      @endif
                      
                      <span class="m-0 text-muted">View</span>
                      <h3 class="m-0"><strong>{{$user->name}}</strong></h3>
                    </br>
                      <h5 class="m-0"><strong>User Details</strong></h5>
                      <span class="m-0 text-muted">Update the information below</span>
                    </br>
                  </br>
                      {!! Form::model($user, ['route' => ['users.update', $user->id], 'method'=>'PATCH']) !!}
                          <div class="form-group">
                            <label>Name:  </label>
                              {!! Form::text('name', null, array('placeholder' => 'Name','class' => 'form-control')) !!}
                          </div>
                          <div class="form-group">
                              <label>Email:</label>
                              {!! Form::text('email', null, array('placeholder' => 'Email','class' => 'form-control')) !!}
                          </div>
                          <div class="form-group">
                              <label>Phone Number:</label>
                              {!! Form::text('phone', null, array('placeholder' => 'Phone','class' => 'form-control')) !!}
                          </div>
                          <div class="form-group">
                              <label>Role:</label>
                              {!! Form::select('roles[]', $roles, $userRole, array('class' => 'form-control','multiple')) !!}
                          </div>
                          <h5 class="m-0"><strong>User Password</strong></h5>
                          <span class="m-0 text-muted">Ensure your account is using a long, random password to stay secure.</span>
                          <br>
                          <strong><span class="m-0 text-danger">Use minimum 8 characters with a mix of letters, numbers & symbols.</span></strong>
                          <div class="form-group">
                              <label>Password:</label>
                              {!! Form::password('password', array('placeholder' => 'Password','class' => 'form-control')) !!}
                          </div>
                          <div class="form-group">
                              <label>Confirm Password:</label>
                              {!! Form::password('password_confirmation', array('placeholder' => 'Confirm Password','class' => 'form-control')) !!}
                          </div>

                          <div class=" text-right">
                          <button type="submit" class="btn btn-warning btn-sm  waves-effect">Submit</button>
                          </div>
                          {!! Form::close() !!}
                    </div>
                  </div>
                </div>

              </div>


    </div>
    <!-- /.container-fluid -->
  </section>
@endsection
