@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->

  <!-- /.content-header -->
</br>
<section class="content ">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    <div class="row mb-2 justify-content-center">
      <div class="col-lg-12">
        @if ($data->count() == 0)
        <div class="card ">
        </br>
            <div class="card-body">

                <div class="row justify-content-center">
                  <div class="col-8 col-sm-8">
                    <div class="card elevation-0 mh-100 my-5 ">
                      <div class="card-body">
                        <div class=" clearfix">
                          <div class="text-center">
                            <img src="{{ URL::to('public/backend/images/trade.png') }}" class="rounded" width="65%">
                          </div>
                          <div class="text-center mt-2">
                            <div class="card-header border-0">
                              <h5 class="m-0"><strong>There is no trade record found in your account</strong></h5>
                              <span class="m-0 text-muted">Please fill the trade record with your information</span>
                            </div>
                          <!--   <a type="button" class="btn btn-light" href="{{ route('trades.create') }}"><i class="nav-icon fas fa-plus-circle"></i>    Import</a> -->
                            <a type="button" class="btn btn-light" href="{{ route('trades.create') }}"><i class="nav-icon fas fa-plus-circle"></i> Add Trade Counter</a>

                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

            </div>
        </div>
        @else
        <div class="card elevation-0">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Overview</span>
                          <h3 class="m-0"><strong>Trade Statistic</strong></h3>
                        </div><!-- /.col -->
                        <div class="col-sm-6 text-right">
                        <div class="row mb-2">
                        <div class="col-sm-12">
                        <a class="btn btn-dark  waves-effect elevation-1" id="back-portfolio" href="{{ route('portfolios.index') }}"> <i class="nav-icon fa fa-arrow-circle-left"></i>  Back to Portfolio</a>&nbsp;&nbsp
                        </div>
                        <div class="col-sm-12 my-2">
                        <a class="btn btn-dark  waves-effect elevation-1" id="restart-tour" > <i class="nav-icon fas fa fa-info-circle"></i>   Start page tour again!</a>&nbsp;&nbsp
                        </div>
                        <div class="col-sm-12 ">
                        <button class="btn btn-dark  waves-effect elevation-1 my-1" id="need-help" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="nav-icon fas fa fa-info-circle"></i> Need Help?
                </button>&nbsp;&nbsp;

              <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
              <a class="dropdown-item" id="launch-tour-1" ><small>1.How to add new trade counter?</small></a>
              <a class="dropdown-item" id="launch-tour-2" ><small>2.How to add deposit and withdrawal my portfolio transaction?</small></a>
              <a class="dropdown-item" id="launch-tour-3"><small>3.How to check my transaction history?</small></a>
              <a class="dropdown-item" id="launch-tour-4"><small>4.Can i export all my trade history?</small></a>
              <a class="dropdown-item" id="launch-tour-5"><small>5.How to add buy trade into existing open trade counter?</small></a>
              <a class="dropdown-item" id="launch-tour-6"><small>6.How to add stock quantity into existing open trade counter?</small></a>
              <a class="dropdown-item" id="launch-tour-7"> <small>7.Can i sell partially quantity in my trade counter?</small></a>
              <a class="dropdown-item" id="launch-tour-8"> <small>8.Can i sell fully quantity in my trade counter?</small></a>
              <a class="dropdown-item" id="launch-tour-9"> <small>9.If i fully sell my quantity stock, can i add buy again in my close trade counter?</small></a>
              <a class="dropdown-item" id="launch-tour-10"> <small>10.Can i delete my existing open trade counter?</small></a>
              <a class="dropdown-item" id="launch-tour-11"> <small>11.I have make a mistake when entering the data in close trade counter. How to adjust back my history?</small></a>
              </div>
                                    </div>
                        </div>
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div>

  <!-- Modal Start -->
  <div class="modal fade" id="page_tutorial">
              <div class="modal-dialog ">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title">Need Help?</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                  <div class="modal-body">

                    <div class="card card-widget collapsed-card elevation-1 mb-0 bg-light">
                        <div class="card-header">
                          <div class="user-block">
                            <span class=""><a class="text-secondary" href="" data-card-widget="collapse">xsdsadxasx</a></span>
                          </div>
                          <!-- /.user-block -->
                          <div class="card-tools ">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                              <i class="fas fa-plus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove">
                              <i class="fas fa-times"></i>
                            </button>
                          </div>
                          <!-- /.card-tools -->
                        </div>
                        <!-- /.card-header -->

                        <div class="card-body bg-white" style="display: none;">
                          <img class="img-fluid pad" src="" alt="Photo">
                        <br></br>
                          <p>scascsa</p>
                        </div>
                     </div>

                     <div class="card card-widget collapsed-card elevation-1  bg-light">
                        <div class="card-header">
                          <div class="user-block">
                            <span class=""><a class="text-secondary" href="" data-card-widget="collapse">xsdsadxasx</a></span>
                          </div>
                          <!-- /.user-block -->
                          <div class="card-tools ">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                              <i class="fas fa-plus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove">
                              <i class="fas fa-times"></i>
                            </button>
                          </div>
                          <!-- /.card-tools -->
                        </div>
                        <!-- /.card-header -->

                        <div class="card-body bg-white" style="display: none;">
                          <img class="img-fluid pad" src="" alt="Photo">
                        <br></br>
                          <p>scascsa</p>
                        </div>
                      </div>

               <!-- /.card-body -->
               <div class=" text-right">
                 <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
               </div>

                  </div>
                </div>
                <!-- /.modal-content -->
              </div>
              <!-- /.modal-dialog -->
            </div>
            <!-- /.modal emd -->

          <div class="card-header border-0 mb-0" id="trade-statistic" >
            <div class="row">
              <div class="col-lg-3 col-12">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Fund Available </strong></h6>
                    <h5><strong>MYR {{ round($fund_available,2) }}</strong></h5>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div class="col-lg-3 col-12">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Total Profit </strong></h6>
                    <h5 class="text-success"><strong>MYR {{ round($profit,2) }}</strong></h5>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div class="col-lg-3 col-12">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Total Loss </strong></h6>
                    <h5 class="text-danger"><strong>MYR {{ round(abs($loss),2) }}</strong></h5>
                  </div>
                </div>
              </div>
              <!-- ./col -->

              <div  class="col-lg-3 col-12">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>ROI </strong></h6>
                    @if ($roi_port <= 0)
                    <h5 class="text-danger"><strong>{{round($roi_port, 2)}}%</strong></h5>
                    @elseif ($roi_port >= 0)
                    <h5 class="text-success"><strong>{{round($roi_port, 2)}}%</strong></h5>
                    @endif
                  </div>
                </div>
              </div>
              <!-- ./col -->
            </div>
            <div class="row " >
              <div  class="col-lg-4 col-12">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Total Profit/Loss </strong></h6>
                    <h5><strong>MYR {{ round($total_q , 2) }}</strong></h5>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div  class="col-lg-4 col-12">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Total Winnings </strong></h6>
                    <h5><strong>{{ $winnings }}</strong></h5>
                  </div>
                </div>
              </div>
              <div  class="col-lg-4 col-12">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Total Losings </strong></h6>
                    <h5><strong>{{ $lossing }}</strong></h5>
                  </div>
                </div>
              </div>
            </div>



          </div>
          @can('trade-create')
            <div class="content-header mb-3">
              <div class="container-fluid">
                <div class="row">
                          <div class="col-sm-4" id="portfolio">
                            <span class="m-0 text-muted">Portfolio</span>
                            <h4 class="m-0"><strong> {{$portfolio->portfolio_name}}</strong></h4>
                          </div><!-- /.col -->
                          <div  class="col-sm-8 text-right">
                          <a class="btn btn-light  waves-effect elevation-1 my-1" id="add-trade-counter" href="{{ route('trades.create') }}"> <i class="nav-icon fas fa-plus-circle"></i>   Add Trade Counter</a>&nbsp;&nbsp;

                          <button class="btn btn-light dropdown-toggle elevation-1 my-1" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="nav-icon fas fa-plus-circle"></i>&nbsp;&nbsp;Deposit/Withdraw
              </button>&nbsp;&nbsp;

              <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                <a class="dropdown-item" data-toggle="modal" data-target="#createTransaction" >Add</a>
                <a class="dropdown-item" href="{{ route('portfolios.show',$portfolio->id) }}">History</a>
              </div>
              <a class="btn btn-light  waves-effect elevation-1 my-1" id="exportexcell" href="{{ route('trades.print',$portfolio->id) }}"> <i class="nav-icon fas fa-plus-circle"></i>   Export</a>&nbsp;&nbsp;

                          </div><!-- /.col -->
                        </div><!-- /.row -->
              </div><!-- /.container-fluid -->
            </div>
             <!-- Modal Start -->
             <div class="modal fade" id="createTransaction">
              <div class="modal-dialog ">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title">Add Transaction</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                  <div class="modal-body">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form action="{{ route('transactions.store') }}" method="POST" enctype="multipart/form-data">
                      @csrf
                 <div class="form-group">
                   <label>Portfolio</label>
                    <select class="form-control select2bs4" style="width: 100%;" name="type">
                      <option value="Deposit">Deposit</option>
                      <option value="Withdraw">Withdraw</option>
                    </select>
                </div>

               <div class="form-group">
                 <label for="exampleInputEmail1">Amount  </label>
                 <input type="number" class="form-control"  placeholder="Amount" name="amount" >
              </div>
              <div class="form-group">
                <label for="exampleInputEmail1">Remark  </label>
                <input type="text" class="form-control"  placeholder="Remark" name="remark" >
             </div>
             <div class="form-group">

               <input type="hidden" class="form-control"  value="{{$portfolio->id}}" placeholder="Remark" name="portfolio_id" >
            </div>

            <div class="form-group">
              <label class="form-label"><strong>Deposit Date :</strong></label>
              <input type="datetime-local" id="date" name="date" class="form-control" required="true">
           </div>

               <!-- /.card-body -->
               <div class=" text-right">
                 <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
               <button type="submit" class="btn btn-dark  waves-effect">Submit</button>
               </div>
           </form>
                  </div>
                </div>
                <!-- /.modal-content -->
              </div>
              <!-- /.modal-dialog -->
            </div>
            <!-- /.modal -->
            @endcan
          <!-- /.card-header -->
          <div class="card-body" id="open-trade-counter">
            <div class="row mb-2" >
                      <div class="col-sm-6">
                        <h4 class="m-0"><strong> Open Trade Counter</strong></h4>
                      </div><!-- /.col -->
                      <div  hidden="hidden" class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                          <li class="breadcrumb-item"><a href="#">Home</a></li>
                          <li class="breadcrumb-item active">Dashboard</li>
                        </ol>
                      </div><!-- /.col -->
                    </div><!-- /.row -->
                  </br>
            <table id="example2" class="table table-bordered rounded table-hover">
              <thead class="bg-light">
            <tr class="text-center">
              <th>Status</th>
              <th>Stock Code</th>
              <th>Stock Name</th>

              <th>Open Date</th>
              <th> Buy Price </th>
              <th>Quantity </th>
              <th>Total Fees</th>
              <th>Total Cost</th>
              <th width="100px">Action</th>
            </tr>
            </thead>
            <tbody>
              @foreach ($data as $key => $row)
              @if ($row->status == Null)
              <tr class="text-center">
                <td class="align-middle" >
                  <h4> <span class="badge badge-primary">Open</span></h4>
                </td>
                <td class="align-middle" >{{ $row->stock_code }}</td>

                <td class="align-middle" >{{ $row->stock_name }}</td>
                <td class="align-middle" >{{ date('d/m/Y h:i A  ', strtotime($row->open_trade))}}</td>
                <!-- <td class="align-middle" >{{ date('d/m/Y h:i:s A ', strtotime($row->date))}}</td> -->
                <td class="align-middle" >MYR {{ round($row->average_buy, 2) }}</td>
                <td class="align-middle" >{{ $row->quantity_buy }} Unit</td>
                <td class="align-middle" >MYR {{ round($row->total_fees_buy, 2) }}</td>
                <td class="align-middle" >MYR {{ round($row->total_cost_buy, 2) }}</td>
                <td id="action-trade-counter">


                  @can('trade-edit')
                  <a class="btn btn-secondary btn-sm btn-block waves-effect elevation-1" id="action-trade-buy" href="{{ route('trades.buy',$row->id) }}"> Buy</a>
                  <a class="btn btn-secondary btn-sm btn-block waves-effect elevation-1" id="action-trade-sell" href="{{ route('trades.sell',$row->id) }}"> Sell</a>
                  <a class="btn btn-secondary btn-sm btn-block waves-effect elevation-1" id="action-trade-history" href="{{ route('trades.history',$row->id) }}">  Trade History</a>
                  <a class="btn btn-secondary btn-sm btn-block waves-effect elevation-1" id="action-trade-delete" type="button" onclick="deleteResult({{ $row->id }})">
                     Delete
                     </a>
                       <form id="delete-form-{{ $row->id }}" action="{{ route('results.destroy',$row->id) }}" method="POST" style="display: none;">
                       @csrf
                       @method('delete')
                       </form>
                  @endcan

                  @can('portfolio-delete')

                       @endcan
                </td>
              </tr>
              @else

                @endif
            @endforeach
            </tbody>
          </table>
        </br>
        <div class="row justify-content-center">

          <div class="col-lg-4 col-12" id="action-opencounter-totalcost">
            <!-- small box -->
            <div class="small-box bg-light elevation-1 mb-0">
              <div class="inner text-center">
                <h6><strong>Total Cost </strong></h6>
                <h5><strong>MYR {{ round($result->sum('total_cost_buy'), 2) }}</strong></h5>
              </div>
            </div>
          </div>
          <!-- ./col -->
        </div>
          </div>
          <!-- /.card-body -->
          <div class="card-body" id="close-trade-counter">
            <div class="row mb-2" >
                      <div class="col-sm-6">
                        <h4 class="m-0"><strong> Close Trade Counter</strong></h4>
                      </div><!-- /.col -->
                      <div  hidden="hidden" class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                          <li class="breadcrumb-item"><a href="#">Home</a></li>
                          <li class="breadcrumb-item active">Dashboard</li>
                        </ol>
                      </div><!-- /.col -->
                    </div><!-- /.row -->
                  </br>
                  <table id="example1" class="table table-bordered rounded table-hover">
                    <thead class="bg-light">
                  <tr class="text-center">
                    <th>Status</th>
                    <th>Stock Code</th>
                    <th>Stock Name</th>
                    <th>Open Date</th>
                    <th>Close Date</th>
                    <th>Buy Price </th>
                    <th>Sell Price </th>
                    <th>Total Cost Buy </th>
                    <th>Total Cost Sell </th>
                    <th>Total Fees</th>
                    <!-- <th>Gross Profit</th> -->
                    <th>Net Profit</th>
                    <th width="100px">Action</th>
                  </tr>
                  </thead>
                  <tbody>
                    @foreach ($data as $key => $row)
                    @if ($row->status == Null)
                    @else
                      <tr class="text-center">
                        <td class="align-middle" >
                          @if ($row->status == 'WIN')
                          <h5> <span class="badge badge-info">WIN</span></h5>
                          @else
                          <h5> <span class="badge badge-danger">LOSS</span></h5>
                          @endif
                        </td>
                        <!-- <td class="align-middle">{{ $key + 1 }}</td> -->
                        <td class="align-middle" >{{ $row->stock_code }}</td>
                        <td class="align-middle" >{{ $row->stock_name }} | {{$row->stock_symbol}}</td>
                        <td class="align-middle" >{{ date('d/m/Y h:i A ', strtotime($row->open_trade))}}</td>
                        <td class="align-middle" >{{ date('d/m/Y h:i A ', strtotime($row->close_trade))}}</td>
                        <!-- <td class="align-middle" >{{ date('d/m/Y h:i:s A ', strtotime($row->date))}}</td> -->
                        <td class="align-middle" >MYR {{ round($row->average_buy, 2) }}</td>
                        <td class="align-middle" >MYR {{ round($row->average_sell, 2) }}</td>
                        <td class="align-middle" >MYR {{ round($row->total_cost_buy, 2) }}</td>
                        <td class="align-middle" >MYR {{ round($row->total_sell_cost, 2) }}</td>
                      <!--  <td class="align-middle" >MYR {{ ($row->sum('total_sell_cost')) + ($result->sum('total_cost_buy')) }}</td> -->
                        <td class="align-middle" >MYR {{ round($row->subtotal_fee, 2) }} </td>
                      <!--  <td class="align-middle" >MYR {{ $row->gross_profit }}
                          @if ($row->gross_profit > '0')
                          <h5> <span class="text-success">({{round($row->gross_roi, 2)}}%)</span></h5>
                          @else
                          <h5> <span class="text-danger">({{round($row->gross_roi, 2)}}%)</span></h5>
                          @endif
                        </td> -->

                        <td class="align-middle" >
                          @if ($row->net_profit > '0')
                          <h5> <span class="text-success"><strong>  MYR {{ round($row->net_profit , 2) }}</strong></span></h5>
                          <h5> <span class="text-success"><strong>({{round($row->net_roi, 2)}}%)</strong></span></h5>
                          @else
                          <h5> <span class="text-danger"><strong>  MYR {{ round($row->net_profit , 2) }}</strong></span></h5>
                          <h5> <span class="text-danger"><strong>({{round($row->net_roi, 2)}}%)</strong></span></h5>
                          @endif</td>
                        <td>

                          <a class="btn btn-secondary btn-sm btn-block waves-effect" id="action-close-history" href="{{ route('trades.history',$row->id) }}">  Trade History</a>
                          <a class="btn btn-secondary btn-sm btn-block waves-effect" id="action-close-delete" type="button" onclick="deleteResult({{ $row->id }})">
                     Delete
                     </a>
                       <form id="delete-form-{{ $row->id }}" action="{{ route('results.destroy',$row->id) }}" method="POST" style="display: none;">
                       @csrf
                       @method('delete')
                       </form>
                          @can('portfolio-edit')

                          @endcan

                          @can('portfolio-delete')

                               @endcan
                        </td>
                      </tr>
                  @endif
                  @endforeach
                  </tbody>
                </table>
              </br>
              <div class="row justify-content-center">
                <div class="col-lg-3 col-12" id="close-trade-totalcost">
                  <!-- small box -->
                  <div class="small-box bg-light elevation-1 mb-0">
                    <div class="inner text-center">
                      <h6><strong>Total Cost </strong></h6>
                      <h5><strong>MYR {{ round(($result->sum('total_sell_cost')) + ($result->sum('total_cost_buy')), 2) }}</strong></h5>
                    </div>
                  </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-12" id="close-trade-profit">
                  <!-- small box -->
                  <div class="small-box bg-light elevation-1 mb-0">
                    <div class="inner text-center">
                      <h6><strong>Net Profit/Loss </strong></h6>
                      <h5><strong>MYR {{ round($result->sum('net_profit') , 2) }}</strong></h5>
                    </div>
                  </div>
                </div>
              </div>
        </br>





        </div>
        <!-- /.card -->
        <div  class="content-header" id="graph-statistic">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Account</span>
                          <h4 class="m-0"><strong> Graph Statistic</strong></h4>
                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div>
        <script src="https://code.highcharts.com/highcharts.js"></script>
          <script src="https://code.highcharts.com/modules/exporting.js"></script>
          <script src="https://code.highcharts.com/modules/export-data.js"></script>
          <script src="https://code.highcharts.com/modules/accessibility.js"></script>


          <body>
    <div id="linechart" style="width:100%; height:400px;"></div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const total_harga = @json($total_harga);
            const bulan = @json($bulan);

            Highcharts.chart('linechart', {
                chart: {
                    type: 'line'
                },
                title: {
                    text: 'Net Profit Over Time'
                },
                xAxis: {
                    categories: bulan,
                    title: {
                        text: 'Date'
                    }
                },
                yAxis: {
                    title: {
                        text: 'Net Profit (MYR) '
                    }
                },
                legend: {
        layout: 'vertical',
        align: 'right',
        verticalAlign: 'middle'
    },

    plotOptions: {
      series: {
          allowPointSelect: true
      }
    },

                responsive: {
        rules: [{
            condition: {
                maxWidth: 500
            },
            chartOptions: {
                legend: {
                    layout: 'horizontal',
                    align: 'center',
                    verticalAlign: 'bottom'
                }
            }
        }]
    },
                series: [{
                    name: 'Net Profit',
                    data: total_harga.map(parseFloat) // Ensure the data is in the correct format
                }]
            });
        });
    </script>
</body>
      </br>
  <body>
    <div id="barchart"></div>
  </body>

  <script>
        document.addEventListener('DOMContentLoaded', function () {
            const profits = @json($profits);
            const losses = @json($losses);
            const months = @json($months);

            Highcharts.chart('barchart', {
                chart: {
                    type: 'column'
                },
                title: {
                    text: 'Monthly Profit and Loss'
                },
                xAxis: {
                    categories: Object.values(months),
                    title: {
                        text: 'Month'
                    }
                },
                yAxis: {
                    title: {
                        text: 'Amount (MYR)'
                    },
                    labels: {
                        formatter: function () {
                            return this.value;
                        }
                    }
                },
                legend: {
                  layout: 'vertical',
                  align: 'right',
                  verticalAlign: 'middle'
              },
              responsive: {
                  rules: [{
                      condition: {
                          maxWidth: 500
                      },
                      chartOptions: {
                          legend: {
                              layout: 'horizontal',
                              align: 'center',
                              verticalAlign: 'bottom'
                          }
                      }
                  }]
              },
              plotOptions: {
                  series: {
                      allowPointSelect: true
                  }
              },
                series: [{
                    name: 'Profit',
                    data: profits
                }, {
                    name: 'Loss',
                    data: losses
                }]

            });
        });
    </script>
    <script type="text/javascript">
                  function deleteResult(id) {
                    Swal.fire({
                      title: 'Are you sure?',
                      text: "You won't be able to revert this!",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
              if (result.value) {
                event.preventDefault();
                document.getElementById('delete-form-'+id).submit();

              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
              }
              })
                  }
    </script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Function to start the tour
        function startTour() {
            introJs().setOptions({
                steps: [
                    {
                        intro: "Welcome to <b>Trade Statistic</b> page! Let's take a quick tour."
                    },
                    {
                        element: '#trade-statistic',
                        intro: 'This is your porfolio details contain of</br></br><ul><li>Fund Available</li><li>Total Profit</li><li>Total Loss</li><li>ROI (Return of Investment)</li><li>Total Profit/Loss</li><li>Total Winnings</li><li>Total Lossings</li></ul>that available in your portfolio.'
                    },
                    {
                        element: '#portfolio',
                        intro: 'This is your porfolio name'
                    },
                    {
                        element: '#add-trade-counter',
                        intro: 'This button are function to add new open trade counter in your portfolio.'
                    },
                    {
                        element: '#dropdownMenuButton',
                        intro: `This button are function to show a dropdown such as</br></br><ul><li><b>Add :</b>To add the transaction deposit or withdrawal in your portfolio</li><li><b>History :</b>To show the history the transaction occur in your portfolio </li><ul> `
                    },
                    {
                        element: '#exportexcell',
                        intro: 'This button <b>Export</b> are function to export all your trade history through pdf for your referance.'
                    },
                    {
                        element: '#open-trade-counter',
                        intro: 'This is show the table of <b>Open Trade Counter</b> history in your portfolio.'
                    },
                   // {
                     //   element: '#action-trade-counter',
                       // intro: 'You can add your buy and sell history inside this trade counter using this action tab in the table.'
                    //},
                    {
                        element: '#action-trade-buy',
                        intro: 'This button are fuction to <b>Add Buy History</b> inside your open trade counter.'
                    },
                    {
                        element: '#action-trade-sell',
                        intro: 'This button are fuction to <b>Add Sell History</b> inside to your trade counte such as you want to sell partly or fully quantity in your trade counter. '
                    },
                    {
                        element: '#action-trade-history',
                        intro: 'This button are fuction to redirect to your <b>Trade History</b> that contain your buy and sell history inside your trade counter.'
                    },
                    {
                        element: '#action-trade-delete',
                        intro: 'This button are fuction to <b>Delete</b> all trade in your open trade counter table.'
                    },
                    {
                        element: '#action-opencounter-totalcost',
                        intro: 'This show <b>Total Cost</b> of your open trade counter history.'
                    },
                    {
                        element: '#close-trade-counter',
                        intro: 'This is show the table of <b>Close Trade Counter</b> history in your portfolio.'
                    },
                   {
                        element: '#action-close-history',
                        intro: 'This button are fuction to redirect to your <b>Trade History</b> that contain your buy and sell history inside your trade counter.'
                    },
                    {
                        element: '#action-close-delete',
                        intro: 'This button are fuction to <b>Delete</b> all trade in your close trade counter table.'
                    },
                    {
                        element: '#close-trade-totalcost',
                        intro: 'This show <b>Total Cost</b> of your close trade history.'
                    },
                    {
                        element: '#close-trade-profit',
                        intro: 'This show <b>Total Profit</b> of your close trade history.'
                    },
                    {
                        element: '#graph-statistic',
                        intro: 'This is show the <b>Line Chart</b> and <b>Bar Chart</b> of trade history in your portfolio.'
                    },
                    {
                        element: '#linechart',
                        intro: 'This is show all your close trade history that contain the profit or loss of your trade history in line chart diagram.'
                    },
                    {
                        element: '#barchart',
                        intro: 'This is show all your profit or loss of your trade history in bar chart diagram.'
                    },
                    {
                        element: '#back-portfolio',
                        intro: 'This button are fuction to <b>Redirect</b> to portfolio page.'
                    },
                    {
                        element: '#restart-tour',
                        intro: 'This button are fuction to restart again <b>Tutorial Tour</b> in your account.'
                    },
                    {
                        element: '#need-help',
                        intro: 'This button are fuction to get <b>Help Support</b> about your account.'
                    },
                    {
                        intro: `
                            <div style="text-align: center;">
                                <p>Would you like to enable or disable the tour for future visits?</p>
                                <label class="form-check-label">
                                    <input type="radio"  name="tourOption" value="enable" checked> Show again next time
                                </label>
                                </br>
                                <label class="form-check-label">
                                    <input type="radio" name="tourOption" value="disable"> Don't show it again
                                </label>
                            </div>
                        `,
                        position: 'bottom'
                    }
                ]
            })
            .onbeforeexit(function () {
                return confirm("Stop!! Please complete the page tour before you exit! Are you sure you want to quit page tour?");
            })
            .oncomplete(function() {
                handleTourOption('secondTourOption', 'secondTourDisabled');
            })
            .onexit(function() {
                handleTourOption('secondTourOption', 'secondTourDisabled');
            })
            .start();
        }

        // Function to handle the tour option
        function handleTourOption() {
            const selectedOption = document.querySelector('input[name="tourOption"]:checked').value;
            if (selectedOption === 'disable') {
                // Save preference to localStorage or send to server
                localStorage.setItem('secondTourDisabled', 'true');
            } else {
                localStorage.removeItem('secondTourDisabled');
            }
        }

        // Check if the tour is disabled
        if (!localStorage.getItem('secondTourDisabled')) {
            startTour();
        }

    });
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('restart-tour').addEventListener('click', function() {
        introJs().setOptions({
          steps: [
            {
                        intro: "Welcome to <b>Trade Statistic</b> page! Let's take a quick tour."
                    },
                    {
                        element: '#trade-statistic',
                        intro: 'This is your porfolio details contain of</br></br><ul><li>Fund Available</li><li>Total Profit</li><li>Total Loss</li><li>ROI (Return of Investment)</li><li>Total Profit/Loss</li><li>Total Winnings</li><li>Total Lossings</li></ul>that available in your portfolio.'
                    },
                    {
                        element: '#portfolio',
                        intro: 'This is your porfolio name'
                    },
                    {
                        element: '#dropdownMenuButton',
                        intro: `This button are function to show a dropdown such as</br></br><ul><li><b>Add :</b>To add the transaction deposit or withdrawal in your portfolio</li><li><b>History :</b>To show the history the transaction occur in your portfolio </li><ul> `
                    },
                    {
                        element: '#add-trade-counter',
                        intro: 'This button are function to add new open trade counter in your portfolio.'
                    },
                    {
                        element: '#exportexcell',
                        intro: 'This button <b>Export</b> are function to export all your trade history through pdf for your referance.'
                    },
                    {
                        element: '#open-trade-counter',
                        intro: 'This is show the table of <b>Open Trade Counter</b> history in your portfolio.'
                    },
                   // {
                     //   element: '#action-trade-counter',
                       // intro: 'You can add your buy and sell history inside this trade counter using this action tab in the table.'
                    //},
                    {
                        element: '#action-trade-buy',
                        intro: 'This button are fuction to <b>Add Buy History</b> inside your open trade counter.'
                    },
                    {
                        element: '#action-trade-sell',
                        intro: 'This button are fuction to <b>Add Sell History</b> inside to your trade counte such as you want to sell partly or fully quantity in your trade counter. '
                    },
                    {
                        element: '#action-trade-history',
                        intro: 'This button are fuction to redirect to your <b>Trade History</b> that contain your buy and sell history inside your trade counter.'
                    },
                    {
                        element: '#action-trade-delete',
                        intro: 'This button are fuction to <b>Delete</b> all trade in your open trade counter table.'
                    },
                    {
                        element: '#action-opencounter-totalcost',
                        intro: 'This show <b>Total Cost</b> of your open trade counter history.'
                    },
                    {
                        element: '#close-trade-counter',
                        intro: 'This is show the table of <b>Close Trade Counter</b> history in your portfolio.'
                    },
                   {
                        element: '#action-close-history',
                        intro: 'This button are fuction to redirect to your <b>Trade History</b> that contain your buy and sell history inside your trade counter.'
                    },
                    {
                        element: '#action-close-delete',
                        intro: 'This button are fuction to <b>Delete</b> all trade in your close trade counter table.'
                    },
                    {
                        element: '#close-trade-totalcost',
                        intro: 'This show <b>Total Cost</b> of your close trade history.'
                    },
                    {
                        element: '#close-trade-profit',
                        intro: 'This show <b>Total Profit</b> of your close trade history.'
                    },
                    {
                        element: '#graph-statistic',
                        intro: 'This is show the <b>Line Chart</b> and <b>Bar Chart</b> of trade history in your portfolio.'
                    },
                    {
                        element: '#linechart',
                        intro: 'This is show all your close trade history that contain the profit or loss of your trade history in line chart diagram.'
                    },
                    {
                        element: '#barchart',
                        intro: 'This is show all your profit or loss of your trade history in bar chart diagram.'
                    },
                    {
                        element: '#back-portfolio',
                        intro: 'This button are fuction to <b>Redirect</b> to portfolio page.'
                    },
                    {
                        element: '#restart-tour',
                        intro: 'This button are fuction to restart again <b>Tutorial Tour</b> in your account.'
                    },
                    {
                        element: '#need-help',
                        intro: 'This button are fuction to get <b>Help Support</b> about your account.'
                    },

            ]
        })

        .start();
    });

});

    </script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-1').addEventListener('click', function() {
        introJs().setOptions({
            steps: [
                {
                  element: '#add-trade-counter',
                    intro: 'Click this button <b>Add Trade Counter</b> for add new portfolio in your account.'
                },
                {
                  element: '#add-trade-counter',
                  intro: 'After you click, the page with redirect to <b>Add Trade Counter</b> page'
                },
                {
                  element: '#add-trade-counter',
                  intro: 'Insert the information carefully and read the tour instruction have provide on the page'
                },

            ]
        })

        .start();
    });

});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-2').addEventListener('click', function() {
        introJs().setOptions({
            steps: [
                {
                  element: '#dropdownMenuButton',
                    intro: 'Click this button <b>Deposit/Withdraw</b> and select <b>Add</b>.'
                },
                {
                  element: '#dropdownMenuButton',
                  intro: 'After selecting, the page with redirect to <b>Transaction</b> page'
                },
                {
                  element: '#dropdownMenuButton',
                  intro: 'Insert the information carefully and read the tour instruction have provide on the page'
                },

            ]
        })

        .start();
    });

});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-3').addEventListener('click', function() {
        introJs().setOptions({
            steps: [
                {
                  element: '#dropdownMenuButton',
                    intro: 'Click this button <b>Deposit/Withdraw</b> and select <b>History</b>.'
                },
                {
                  element: '#dropdownMenuButton',
                  intro: 'After selecting, the page with redirect to <b>Transaction</b> page'
                },
                {
                  element: '#dropdownMenuButton',
                  intro: 'After redirecting to the page, you can see to the table show the portfolio transaction'
                },

            ]
        })

        .start();
    });

});
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-4').addEventListener('click', function() {
        introJs().setOptions({
            steps: [
                {
                  element: '#exportexcell',
                    intro: '<b>Yess!</b>Click this button <b>Export</b> and all the trade history will auto download to your device by pdf file.'
                },
                {
                  element: '#exportexcell',
                  intro: 'After downloading the file, open the pdf file and all the transaction are export to the file'
                },

            ]
        })

        .start();
    });

});
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-5').addEventListener('click', function() {
        introJs().setOptions({
            steps: [
                {
                  element: '#add-trade-counter',
                  intro: 'Brief Reminders, firstly you need to click <b>Add Trade Counter</b> button by entering new buy trade to open the trade counter'
                },
                {
                  element: '#add-trade-counter',
                  intro:
                  `
                            <div style="text-align: left;">
                                <p>After your <b>Open</b> status have state at the Open Trade Counter table</p>
                                <img src="{{ url('public/backend/images/launch-tour-5-1.png') }}" alt="Intro Image" style="max-width: 100%; height: auto;">
                            </div>
                        `
                },
                {
                  element: '#action-trade-buy',
                  intro: 'Click <b>Buy</b> in the <b>Action</b> coloum at the table to redirect to <b>Buy Trade History</b> page'
                },
                {
                  element: '#action-trade-buy',
                  intro: 'Insert the information carefully and read the tour instruction have provide on the page'
                },
            ]
        })

        .start();
    });

});
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-6').addEventListener('click', function() {
        introJs().setOptions({
            steps: [
                {
                  element: '#action-trade-buy',
                  intro: 'Click <b>Buy</b> button inside <b>Action</b> the table coloum'
                },
                {
                  element: '#action-trade-buy',
                  intro: 'After click the button, you will redirect to <b>Buy Trade History</b> page.'
                },
                {
                  element: '#action-trade-buy',
                  intro: 'Insert the information carefully and read the tour instruction have provide on the page'
                },
            ]
        })

        .start();
    });

});
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-7').addEventListener('click', function() {
        introJs().setOptions({
            steps: [
                {
                  element: '#action-trade-sell',
                  intro: 'Click <b>Sell</b> button inside <b>Action</b> the table coloum'
                },
                {
                  element: '#action-trade-sell',
                  intro: 'After click the button, you will redirect to <b>Sell Trade History</b> page.'
                },
                {
                  element: '#action-trade-sell',
                  intro: 'Insert the amount quantity that you want to sell. For more info, read the tour instruction have provide on the page'
                },
            ]
        })

        .start();
    });

});
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-8').addEventListener('click', function() {
        introJs().setOptions({
            steps: [
                {
                  element: '#action-trade-sell',
                  intro: 'Click <b>Sell</b> button inside <b>Action</b> the table coloum'
                },
                {
                  element: '#action-trade-sell',
                  intro: 'After click the button, you will redirect to <b>Sell Trade History</b> page.'
                },
                {
                  element: '#action-trade-sell',
                  intro: 'Insert the full amount quantity that you want to sell. For more info, read the tour instruction have provide on the page'
                },
            ]
        })

        .start();
    });

});
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-9').addEventListener('click', function() {
        introJs().setOptions({
            steps: [
                {
                  intro: '<b>No!!</b> Your open trade counter will close automatically if you sell all your stock quantity in the trade counter'
                },
                {
                  element: '#add-trade-counter',
                  intro: 'If you want to add buy again, you need to click <b>Add Trade Counter</b> for open new trade counter'
                },
                {
                  element: '#add-trade-counter',
                  intro: 'After click the button, you will redirect to <b>Add Trade Counter</b> page.'
                },
                {
                  element: '#add-trade-counter',
                  intro: 'Insert the information carefully and read the tour instruction have provide on the page'
                },
            ]
        })

        .start();
    });

});
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-10').addEventListener('click', function() {
        introJs().setOptions({
            steps: [
                {
                  intro: '<b>Yess!!</b> you can delete your trade by two option </br></br><b>Option 1 :</b>by delete in the Open Trade Counter</br><b>Option 2 :</b>by delete one by one trade in the trade history'
                },
                {
                  intro: '<b>Option 1</b>'
                },
                {
                  element: '#action-trade-delete',
                  intro: 'Click <b>Delete</b> button in the open trade counter table'
                },
                {
                  element: '#action-trade-delete',
                  intro: 'After click the button, page will show auto popup modal to confirm your delete data'
                },
                {
                  intro: '<b>Option 2</b>'
                },
                {
                  element: '#action-trade-history',
                  intro: 'Click <b>Trade History</b> button in the open trade counter table'
                },
                {
                  element: '#action-trade-history',
                  intro: 'After click the button, you will redirect to trade history page, at the page you can delete the trade one by one'
                },
            ]
        })

        .start();
    });

});
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-11').addEventListener('click', function() {
        introJs().setOptions({
            steps: [
              {
                element: '#action-trade-history',
                  intro: 'Click <b>Trade History</b> button in the open trade counter table'
                },
                {
                  element: '#action-trade-delete',
                  intro: 'After click the button, you will redirect to trade history page,'
                },
                {
                  element: '#add-trade-counter',
                  intro: 'You can adjust the mistake by delete the trade in the trade history table'
                },
            ]
        })

        .start();
    });

});
</script>


        @endif
      </div>
      <!-- /.col -->

    </div>
  </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
@endsection
