@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
</br>
<section class="content">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-0">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Overview</span>
                          <h3 class="m-0"><strong>Trade Account</strong></h3>
                        </div><!-- /.col -->
                        <div  hidden="hidden" class="col-sm-6">
                          <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                          </ol>
                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div>
          <div class="card-header  border-0">
          <div class="card-tools">
            <div class="card-header border-0">
                          @can('trade-create')
                          <a class="btn btn-warning  btn-block waves-effect" href="{{ route('trades.create') }}">  Add Trade</a>
                          @endcan
                      </div>
       </div>
          </div>
          <div class="card-header border-0 ">
            <div class="text-right">
                </div>
              </div>
          <!-- /.card-header -->
          <div class="card-body">
            <table id="example2" class="table table-bordered rounded table-hover">
              <thead class="bg-warning">
            <tr class="text-center">
              <th width="20px">No</th>
              <th>Account Name</th>
              <th>Total Winnnings</th>
              <th>Total Lossings</th>
              <th>Total Profit/Loss</th>
              <th>ROI</th>
              <th width="150px">Action</th>
            </tr>
            </thead>
            <tbody>
              @foreach ($data as $key => $row)
            <tr class="text-center">
              <td class="align-middle">{{ $key + 1 }}</td>
              <td class="align-middle" >{{ $row->portfolio_name }}</td>
              <td class="align-middle " >{{ $row->win }}</td>
              <td class="align-middle " >{{ $row->loss }}</td>
              @if ($row->total_profit < 0)
              <td class="align-middle text-danger"  >MYR {{ round($row->total_profit, 2) }}</td>
              @elseif ($row->total_profit > 1)
              <td class="align-middle text-success"  >MYR {{ round($row->total_profit, 2) }}</td>
              @else
              <td class="align-middle "  >MYR {{ round($row->total_profit, 2) }}</td>
              @endif
              @if ($row->roi_port < 0)
              <td class="align-middle text-danger"  >{{ round($row->roi_port, 2) }}%</td>
              @elseif ($row->roi_port > 1)
              <td class="align-middle text-success"  >{{ round($row->roi_port, 2) }}%</td>
              @else
              <td class="align-middle "  >{{ round($row->roi_port, 2) }}%</td>
              @endif
              <td>
                <a class="btn btn-warning btn-sm btn-block waves-effect" href="{{ route('trades.statistic',$row->id) }}"><i class="nav-icon fas fa-chart-pie"></i>  Statistic</a>

                @can('portfolio-edit')

                @endcan

                @can('portfolio-delete')

                     @endcan
              </td>

            </tr>
            @endforeach
            </tbody>
          </table>
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
@endsection

    <script type="text/javascript">
                  function deletePrograms(id) {
                    Swal.fire({
                      title: 'Are you sure?',
                      text: "You won't be able to revert this!",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
              if (result.value) {
                event.preventDefault();
                document.getElementById('delete-form-'+id).submit();

              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
              }
              })
                  }
    </script>
