@extends('layouts.backend.app')
@section('content')
@can('support_admin')

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->

  <!-- /.content-header -->
</br>
<section class="content ">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    <div class="row">
      <div class="col-lg-12 ">
        <div class="card elevation-2">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Overview</span>
                          <h5 class="m-0 text-mute"><strong>Case Id: #{{$dataTicket -> case_id}}</strong></h5>
                          <h5 class="m-0"><strong>Title : {{$dataTicket -> title}}</strong></h5>
                        </br>
                          <small><b>User Details</b> </small>
                        </br>
                          <small class="mute">Name : {{ $dataTicket->user_name }}</small>
                        </br>
                          <small class="mute">Batch :{{ $dataTicket->user_batch }}</small>

                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div>
          <div class="card-body ">
                @foreach ($data as $key => $data)
              <div class="small-box bg-white elevation-0 text-left">
              <div class="inner py-3">
                <div class="row">
                  <div class="col-lg-10 col-12">
                    <small class="mute">{{ $data->user_name }}</small>
                  </br>
                    <small class="mute">Created on {{ $data->created_at->format('D, j F Y, h:i A') }} </small>
                  <h6 class="py-2">{!! html_entity_decode($data->body) !!} </h6>
                </br>
                @if ($data->image1 == 'default.png')
                @else
                <small class="mute"><strong>Attachment File</strong> </small>
              </br>
              <!-- Button trigger modal -->

                <button type="button" class="btn btn-light btn-sm" data-toggle="modal" data-target="#{{ $data->image1_name }}">
                  <i class="fas fa-paperclip"></i>&nbsp;&nbsp;{{$data->image1}}
                </button>
              @endif
              @if ($data->image2 == 'default.png')
              @else
                <button type="button" class="btn btn-light btn-sm" data-toggle="modal" data-target="#{{ $data->image2_name }}">
                  <i class="fas fa-paperclip"></i>&nbsp;&nbsp;{{$data->image2}}
                </button>
                @endif
                @if ($data->image3 == 'default.png')
                @else
                <button type="button" class="btn btn-light btn-sm" data-toggle="modal" data-target="#{{ $data->image3_name }}">
                  <i class="fas fa-paperclip"></i>&nbsp;&nbsp;{{$data->image3}}
                </button>
                @endif
                @if ($data->image4 == 'default.png')
                @else
                <button type="button" class="btn btn-light btn-sm" data-toggle="modal" data-target="#{{ $data->image4_name }}">
                  <i class="fas fa-paperclip"></i>&nbsp;&nbsp;{{$data->image4}}
                </button>
                @endif
                <!-- Modal 1 -->
                <div class="modal fade" id="{{ $data->image1_name }}" tabindex="-1" role="dialog" aria-labelledby="{{ $data->image1_name }}" aria-hidden="true">
                  <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                      <div class="modal-header border-0">
                        <h5 class="modal-title" id="exampleModalCenterTitle"></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      <div class="modal-body border-0">
                        <img class="img-fluid"	 src="{{ url('/storage/app/support/' . $data->image1) }}"alt="{{ $data->image1 }}">
                      </div>
                      <div class="modal-footer border-0">

                      </div>
                    </div>
                  </div>
                </div>
                <!-- Modal 1 End -->

                <!-- Modal 2 -->
                <div class="modal fade" id="{{ $data->image2_name }}" tabindex="-1" role="dialog" aria-labelledby="{{ $data->image2_name }}}" aria-hidden="true">
                  <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                      <div class="modal-header border-0">
                        <h5 class="modal-title" id="exampleModalCenterTitle"></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      <div class="modal-body border-0">
                        <img class="img-fluid"	 src="{{ url('storage/app/support/' . $data->image2) }}"alt="{{ $data->image2 }}">
                      </div>
                    </div>
                  </div>
                </div>
                <!-- Modal 2 End -->

                <!-- Modal 3 -->
                <div class="modal fade" id="{{ $data->image3_name }}" tabindex="-1" role="dialog" aria-labelledby="{{ $data->image3_name }}" aria-hidden="true">
                  <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                      <div class="modal-header border-0">
                        <h5 class="modal-title" id="exampleModalCenterTitle"></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      <div class="modal-body border-0">
                        <img class="img-fluid"	 src="{{ url('storage/app/support/' . $data->image3) }}"alt="{{ $data->image3 }}">
                      </div>

                    </div>
                  </div>
                </div>
                <!-- Modal 3 End -->

                <!-- Modal 4 -->
                <div class="modal fade" id="{{ $data->image4_name }}" tabindex="-1" role="dialog" aria-labelledby="{{ $data->image4_name }}" aria-hidden="true">
                  <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                      <div class="modal-header border-0">
                        <h5 class="modal-title" id="exampleModalCenterTitle"></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      <div class="modal-body border-0">
                        <img class="img-fluid"	 src="{{ url('storage/app/support/' . $data->image4) }}"alt="{{ $data->image4 }}">
                      </div>

                    </div>
                  </div>
                </div>
                <!-- Modal 4 End -->

                  </div>
                </div>
              </div>

            </div>
            <hr></hr>
              @endforeach
              @if($dataTicket->complete == '0')
              @if($dataTicket->close == '0')
              <form action="{{ route('tickets.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div hidden="hidden" class="form-group">
                   <label for="exampleInputEmail1">Title </label>
                   <input type="text"  class="form-control" name="title" value="{{$dataTicket -> title}}" >
                </div>
                <div hidden="hidden" class="form-group">
                   <label for="exampleInputEmail1">Ticket id </label>
                   <input type="text"  class="form-control" name="ticket_id" value="{{$dataTicket -> id}}" >
                </div>
                <div  class="form-group">
                   <input type="hidden"  class="form-control" name="sent_name" value="{{$dataTicket -> user_name}}" >
                </div>
                <div hidden="hidden" class="form-group">
                <label for="exampleInputEmail1">Case Id </label>
                <input type="text"  class="form-control" name="case_id" value="{{$dataTicket -> case_id}}" >
              </div>
              <div  class="form-group">
              <input type="hidden"  class="form-control" name="sender_email" value="{{$dataTicket -> sender_email}}" >
            </div>

              <div class="form-group">
                 <label for="exampleInputEmail1">Message </label>
                 <textarea class="summernote" name="body" ></textarea>
              </div>
              <div class="form-group">
                <label class="form-label">Attachment</label>
                <div class="row clearfix">
                  <div class="col-lg-12 ">
                    <div class="file-upload file-uploadAll">
                      <div class="image-upload-wrap image-upload-wrapAll">

                        <input class="file-upload-input file-upload-inputAll" type='file'
                        onchange="readURL(this);" accept="image/*" name="image1"
                        multiple/>
                        <div class="drag-text drag-textAll">
                          <h5>Drag and drop a image in this box or click this box to insert image</br>File Size: Max 2MB</h5>
                        </div>
                      </div>
                      <div class="file-upload-content file-upload-contentAll">
                        <img class="file-upload-image file-upload-imageAll" src="#"
                        alt="your image"/>
                        <div class="image-title-wrap image-title-wrapAll">
                          <button type="button" onclick="removeUpload()"
                          class="btn-sm remove-image remove-imageAll">Remove <span
                          class="image-title image-titleAll">Uploaded Image</span>
                        </button>
                      </div>
                    </div>
                  </div>
                  <div hidden="hidden" id="addImageDiv">
                    <center>
                      <button id="btnAddmul" type="button" onclick="addMul('add')"
                      class="btn btn-success"
                      style="width: 140px;height: 36px; font-size: 1.5em; padding: 3px;">
                      Add
                    </button>
                  </center>
                </div>
              </div>

              <div class="col-lg-12 ">
                  <div id="image2">
                      <div class="file-upload file-uploadAll">
                          <div class="image-upload-wrap2 image-upload-wrapAll">

                              <input class="file-upload-input2 file-upload-inputAll" type='file'
                                     onchange="readURL2(this);" accept="image/*" name="image2"
                                     multiple/>
                              <div class="drag-text drag-textAll">
                                <h5>Drag and drop a image in this box or click this box to insert image</br>File Size: Max 2MB</h5>
                              </div>
                          </div>
                          <div class="file-upload-content2 file-upload-contentAll">
                              <img class="file-upload-image2 file-upload-imageAll" src="#"
                                   alt="your image"/>
                              <div class="image-title-wrap2 image-title-wrapAll">
                                  <button type="button" onclick="removeUpload2()"
                                          class="btn-sm remove-image remove-imageAll">Remove <span
                                              class="image-title2 image-titleAll">Uploaded Image</span>
                                  </button>
                              </div>
                          </div>
                      </div>
                      <div hidden="hidden" id="addImageDiv2">
                          <center>
                              <button id="btnAddmul2" type="button" onclick="addMul('add2')"
                                      class="btn btn-success"
                                      style="width: 140px;height: 36px; font-size: 1.5em; padding: 3px;">
                                  Add
                              </button>
                              </br>
                              </br>
                              <button id="btn2Addmul" type="button" class="btn btn-success"
                                      onclick="addMul('minus2')">Cancel
                              </button>
                          </center>
                      </div>
                  </div>
              </div>
              <div class="col-lg-12 ">
                  <div id="image3">
                      <div class="file-upload file-uploadAll">
                          <div class="image-upload-wrap3 image-upload-wrapAll">

                              <input class="file-upload-input3 file-upload-inputAll" type='file'
                                     onchange="readURL3(this);" accept="image/*" name="image3"
                                     multiple/>
                              <div class="drag-text drag-textAll">
                                <h5>Drag and drop a image in this box or click this box to insert image</br>File Size: Max 2MB</h5>
                              </div>
                          </div>
                          <div class="file-upload-content3 file-upload-contentAll">
                              <img class="file-upload-image3 file-upload-imageAll" src="#"
                                   alt="your image"/>
                              <div class="image-title-wrap3 image-title-wrapAll">
                                  <button type="button" onclick="removeUpload3()"
                                          class="btn-sm remove-image remove-imageAll">Remove <span
                                              class="image-title3 image-titleAll">Uploaded Image</span>
                                  </button>
                              </div>
                          </div>
                      </div>
                      <div hidden="hidden" id="addImageDiv3">
                          <center>
                              <button id="btnAddmul3" type="button" onclick="addMul('add3')"
                                      class="btn btn-success"
                                      style="width: 140px;height: 36px; font-size: 1.5em; padding: 3px;">
                                  Add
                              </button>
                              </br>
                              </br>
                              <button id="btn3Addmul" type="button" class="btn btn-success"
                                      onclick="addMul('minus3')">Cancel
                              </button>
                          </center>
                      </div>
                  </div>
              </div>
              <div class="col-lg-12 ">
                  <div id="image4">
                      <div class="file-upload file-uploadAll">
                          <div class="image-upload-wrap4 image-upload-wrapAll">

                              <input class="file-upload-input4 file-upload-inputAll" type='file'
                                     onchange="readURL4(this);" accept="image/*" name="image4"
                                     multiple/>
                              <div class="drag-text drag-textAll">
                                <h5>Drag and drop a image in this box or click this box to insert image</br>File Size: Max 2MB</h5>
                              </div>
                          </div>
                          <div class="file-upload-content4 file-upload-contentAll">
                              <img class="file-upload-image4 file-upload-imageAll" src="#"
                                   alt="your image"/>
                              <div class="image-title-wrap4 image-title-wrapAll">
                                  <button type="button" onclick="removeUpload4()"
                                          class="btn-sm remove-image remove-imageAll">Remove <span
                                              class="image-title4 image-titleAll">Uploaded Image</span>
                                  </button>
                              </div>
                          </div>
                      </div>
                      <div hidden="hidden" id="addImageDiv4">
                          <center>
                              <button id="btnAddmul4" type="button" onclick="addMul('add4')"
                                      class="btn btn-success"
                                      style="width: 140px;height: 36px; font-size: 1.5em; padding: 3px;">
                                  Add
                              </button>
                              </br>
                              </br>
                              <button id="btn4Addmul" type="button" class="btn btn-success"
                                      onclick="addMul('minus4')">Cancel
                              </button>
                          </center>
                      </div>
                  </div>
              </div>

          </div>
            </div>
            <div class=" text-right">


            <button type="submit" class="btn btn-dark  waves-effect">Submit</button>
            </div>
              </form>
              @else
              @endif
              @else
              @endif
              <div class="col-lg-12 mt-3">
            @if($dataTicket->complete == '0')
            @if($dataTicket->close == '0')

            <button class="btn btn-success btn-sm  waves-effect" type="button" onclick="deletePortfolio({{ $dataTicket->id }})">
                  Complete Ticket
            </button>
            <form id="delete-form-{{ $dataTicket->id }}" action="{{ route('tickets.approve',$dataTicket->id) }}" method="post" style="display: none;">
            @csrf
            @method('put')
            </form>
            @else
            @endif
            @else
            @endif
            @if($dataTicket->close == '0')
            <button class="btn btn-warning btn-sm  waves-effect" type="button" onclick="closeTicket({{ $dataTicket->id }})">
                  Close Ticket
                 </button>
                 <form id="close-form-{{ $dataTicket->id }}" action="{{ route('tickets.close',$dataTicket->id) }}" method="post" style="display: none;">
                 @csrf
                 @method('put')
                 </form>
                 @else
                 @endif
              </div>

              <div class=" text-right">
                <a type="button" class="btn btn-default" href="{{url ('supports')}}">Go Back</a>

              </div>
              </div>
            </div>

          </div>
          <!-- /.card-body -->

          <div class="card-body ">

          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
@endcan

@endsection

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script>
  $(document).ready(function() {
      $('#summernote').summernote();
  });
</script>

<script type="text/javascript">
    $(document).ready(function() {
      $('.summernote').summernote({
        placeholder: 'Reply Here !!',
        tabsize: 2,
        height: 200,
        toolbar: [
          ['style', ['style']],
          ['font', ['bold', 'underline', 'clear']],
          ['color', ['color']],
          ['para', ['ul', 'ol', 'paragraph']],
          ['table', ['table']],
          //['insert', ['link', 'picture', 'video']],
          //['view', ['fullscreen', 'codeview', 'help']]
        ]
      });
    });
</script>

  <script type="text/javascript">
      function deletePortfolio(id) {
        Swal.fire({
          title: 'Are you sure?',
          text: "You went change ticket status to complete",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes !'
        }).then((result) => {
  if (result.value) {
    event.preventDefault();
    document.getElementById('delete-form-'+id).submit();

  Swal.fire(
    'Deleted!',
    'Your file has been deleted.',
    'success'
  )
  }
  })
      }
</script>
<script type="text/javascript">
    function closeTicket(id) {
      Swal.fire({
        title: 'Are you sure?',
        text: "You went change ticket status to complete",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes !'
      }).then((result) => {
if (result.value) {
  event.preventDefault();
  document.getElementById('close-form-'+id).submit();

Swal.fire(
  'Deleted!',
  'Your file has been deleted.',
  'success'
)
}
})
    }
</script>
    <script>
    function readURL(input) {
        if (input.files && input.files[0]) {

            var reader = new FileReader();

            reader.onload = function (e) {
                $('.image-upload-wrap').hide();

                $('.file-upload-image').attr('src', e.target.result);
                $('.file-upload-content').show();

                $('.image-title').html(input.files[0].name);
            };

            reader.readAsDataURL(input.files[0]);

        } else {
            removeUpload();
        }
    }

    function removeUpload() {
        $('.file-upload-input').replaceWith($('.file-upload-input').clone());
        $('.file-upload-content').hide();
        $('.image-upload-wrap').show();
    }

    $('.image-upload-wrap').bind('dragover', function () {
        $('.image-upload-wrap').addClass('image-dropping');
    });
    $('.image-upload-wrap').bind('dragleave', function () {
        $('.image-upload-wrap').removeClass('image-dropping');
    });


    function readURL2(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('.image-upload-wrap2').hide();
                $('.file-upload-image2').attr('src', e.target.result);
                $('.file-upload-content2').show();
                $('.image-title2').html(input.files[0].name);
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            removeUpload();
        }
    }

    function removeUpload2() {
        $('.file-upload-input2').replaceWith($('.file-upload-input2').clone());
        $('.file-upload-content2').hide();
        $('.image-upload-wrap2').show();
    }

    $('.image-upload-wrap2').bind('dragover', function () {
        $('.image-upload-wrap2').addClass('image-dropping');
    });
    $('.image-upload-wrap2').bind('dragleave', function () {
        $('.image-upload-wrap2').removeClass('image-dropping');
    });

    function readURL3(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('.image-upload-wrap3').hide();
                $('.file-upload-image3').attr('src', e.target.result);
                $('.file-upload-content3').show();
                $('.image-title3').html(input.files[0].name);
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            removeUpload();
        }
    }

    function removeUpload3() {
        $('.file-upload-input3').replaceWith($('.file-upload-input3').clone());
        $('.file-upload-content3').hide();
        $('.image-upload-wrap3').show();
    }

    $('.image-upload-wrap3').bind('dragover', function () {
        $('.image-upload-wrap3').addClass('image-dropping');
    });
    $('.image-upload-wrap3').bind('dragleave', function () {
        $('.image-upload-wrap3').removeClass('image-dropping');
    });

    function readURL4(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('.image-upload-wrap4').hide();
                $('.file-upload-image4').attr('src', e.target.result);
                $('.file-upload-content4').show();
                $('.image-title4').html(input.files[0].name);
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            removeUpload();
        }
    }

    function removeUpload4() {
        $('.file-upload-input4').replaceWith($('.file-upload-input4').clone());
        $('.file-upload-content4').hide();
        $('.image-upload-wrap4').show();
    }

    $('.image-upload-wrap4').bind('dragover', function () {
        $('.image-upload-wrap4').addClass('image-dropping');
    });
    $('.image-upload-wrap4').bind('dragleave', function () {
        $('.image-upload-wrap4').removeClass('image-dropping');
    });


    function readURL5(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('.image-upload-wrap5').hide();
                $('.file-upload-image5').attr('src', e.target.result);
                $('.file-upload-content5').show();
                $('.image-title5').html(input.files[0].name);
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            removeUpload();
        }
    }

    function removeUpload5() {
        $('.file-upload-input5').replaceWith($('.file-upload-input5').clone());
        $('.file-upload-content5').hide();
        $('.image-upload-wrap5').show();
    }

    $('.image-upload-wrap5').bind('dragover', function () {
        $('.image-upload-wrap5').addClass('image-dropping');
    });
    $('.image-upload-wrap5').bind('dragleave', function () {
        $('.image-upload-wrap5').removeClass('image-dropping');
    });


    function readURL6(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('.image-upload-wrap6').hide();
                $('.file-upload-image6').attr('src', e.target.result);
                $('.file-upload-content6').show();
                $('.image-title6').html(input.files[0].name);
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            removeUpload();
        }
    }

    function removeUpload6() {
        $('.file-upload-input6').replaceWith($('.file-upload-input6').clone());
        $('.file-upload-content6').hide();
        $('.image-upload-wrap6').show();
    }

    $('.image-upload-wrap6').bind('dragover', function () {
        $('.image-upload-wrap6').addClass('image-dropping');
    });
    $('.image-upload-wrap6').bind('dragleave', function () {
        $('.image-upload-wrap6').removeClass('image-dropping');
    });

</script>
<script type="text/javascript">
  $(document).ready(function(){

    $(document).on('change','.category',function(){
      //console.log("hmm its change");

      var cat_id=$(this).val();
      // console.log(cat_id);
      var div=$(this).parent();

      var op=" ";

      $.ajax({
        type:'get',
        url:'{!!URL::to('findCategoryName')!!}',
        data:{'id':cat_id},
        success:function(data){
          //console.log('success');

          //console.log(data);
        //  console.log(data.length);
          op+='<option value="0" selected disabled>- Select Sub-Category/Sub-Brand - </option>';
                  for(var i=0;i<data.length;i++){
                  op+='<option value="'+data[i].id+'">'+data[i].name+'</option>';
                   }
                   div.find('.name').html(" ");
                   div.find('.name').append(op);

        },
        error:function(){

        }
      });
    });
  });
</script>
<script type="text/javascript">
    $(document).ready(function () {
        // count = 1;
    });

    function addMul(action) {
        // alert(action);

        var image2 = document.getElementById('image2');
        image2h = image2.hidden;
        var image3 = document.getElementById('image3');
        var image4 = document.getElementById('image4');
        var image5 = document.getElementById('image5');
        var image6 = document.getElementById('image6');

        var addImageDiv = document.getElementById('addImageDiv');
        var addImageDiv2 = document.getElementById('addImageDiv2');

        var btnAddmul = document.getElementById('btnAddmul');
        var btnAddmul6 = document.getElementById('btnAddmul6');
        // alert(btnAddmul);
        // return;

        if (action == 'add') {
            // alert(action);
            // alert(image2h);
            image2.style.display = 'block';
            addImageDiv.style.display = 'none';
        } else if (action == 'add2') {
            // alert(image2h);
            image3.style.display = 'block';
        } else if (action == 'add3') {
            // alert(image2h);
            image4.style.display = 'block';
        } else if (action == 'add4') {
            // alert(image2h);
            image5.style.display = 'block';
        } else if (action == 'add5') {
            // alert(image2h);
            image6.style.display = 'block';
            btnAddmul6.innerHTML = 'Full';
            btnAddmul6.disabled = true;
        }


        if (action == 'minus2') {
            addImageDiv.style.display = 'block';
            // alert(image2h);
            image2.style.display = 'none';
        } else if (action == 'minus3') {
            addImageDiv2.style.display = 'block';
            image3.style.display = 'none';
        } else if (action == 'minus4') {
            addImageDiv3.style.display = 'block';
            image4.style.display = 'none';
        } else if (action == 'minus5') {
            addImageDiv4.style.display = 'block';
            image5.style.display = 'none';
        } else if (action == 'minus6') {
            addImageDiv5.style.display = 'block';
            image6.style.display = 'none';
            btnAddmul.innerHTML = 'Add';
        }

    }
</script>
<style>
#addmul {

}



.file-uploadAll {
margin: 0 auto;
padding: 0;

}

.file-upload-btnAll {
width: 100%;
margin: 0;
background: #fbfbfb;
border: 1px solid;
padding: 5px 10px;
border-radius: 5px;
transition: all .2s ease;
text-transform: uppercase;
font-weight: 700;
color: #212529;
border-color: #dae0e5;
}

.file-upload-btnAll:hover {

transition: all .2s ease;
cursor: pointer;
background: #333;
color: #fff;
border-color: #333;
}

.file-upload-btnAll:active {
border: 0;
transition: all .2s ease;
}

.file-upload-contentAll {
display: none;
text-align: center;
margin-top: 20px;
position: relative;
padding: 0px 0;
}

.file-upload-inputAll {
position: absolute;
margin: 0;
padding: 0;
width: 100%;
height: 100%;
outline: none;
opacity: 0;
cursor: pointer;
}

.image-upload-wrapAll {
margin-top: 20px;
border: 4px dashed #ddd;
position: relative;
padding: 10px;
}
.drag-textAll h5{
margin: 0;
font-weight: 500;
font-size: 14px;
font-style: italic;
}
.image-droppingAll, .image-upload-wrapAll:hover {
background-color: #f5f5f5;
border: 4px dashed #ddd;
}

.image-title-wrapAll {
padding: 0 0px px 15px;
color: #222;
}

.drag-textAll {
text-align: center;
}

.drag-textAll h3 {
font-weight: 100;
text-transform: uppercase;
color: #15824B;
padding: 60px 0;
}

.file-upload-imageAll {
max-height: 180px;
max-width: 100%;
margin: auto;
padding: 0;
}

.remove-imageAll {
width: 100%;
margin: 10px 0;
color: #fff;
background: #cd4535;
border: none;
padding: 10px;
border-radius: 4px;
border-bottom: 4px solid #b02818;
transition: all .2s ease;
outline: none;
text-transform: capitalize;
font-weight: 700;
}

.remove-imageAll:hover {
background: #c13b2a;
color: #ffffff;
transition: all .2s ease;
cursor: pointer;
}

.remove-imageAll:active {
border: 0;
transition: all .2s ease;
}

</style>
