@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->

  <!-- /.content-header -->
</br>
@can('support_user')
<section class="content">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    @if (count($errors) > 0)
        <div class="alert alert-danger">
            <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-0">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Overview</span>
                          <h3 class="m-0"><strong>Support</strong></h3>
                        </div><!-- /.col -->
                        <div  hidden="hidden" class="col-sm-6">
                          <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                          </ol>
                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div>
          <div class="card-header  border-0">
            <div class="row">
              <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>All Ticket </strong></h6>
                    <h5><strong> {{ count($data) }}</strong></h5>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Pending Ticket </strong></h6>
                    <h5 ><strong>{{ count($ongoing_data) }}</strong></h5>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Ongoing Ticket  </strong></h6>
                    <h5><strong>{{ count($pending_data) }}</strong></h5>
                  </div>
                </div>
              </div>
              <!-- ./col -->

              <div  class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Complete Ticket </strong></h6>
                    <h5 ><strong>{{ count($complete_close_data) }}</strong></h5>
                  </div>
                </div>
              </div>
              <!-- ./col -->
            </div>
            <div class="card-tools">
            <div class="card-header border-0">
              @can('portfolio-create')

              <!-- Modal Popup Start -->
              <button type="button" class="btn btn-warning btn-block waves-effect" data-toggle="modal" data-target="#createTicket">
                Submit a Ticket
              </button>
              <!-- Modal Popup End -->

              <!-- Modal Start -->
              <div class="modal fade" id="createTicket">
              <div class="modal-dialog modal-lg">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title">Submit a Ticket</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                  <div class="modal-body">

                    <form action="{{ route('supports.store') }}" method="POST" enctype="multipart/form-data">
                      @csrf
                 <div class="form-group">
                   <label for="exampleInputEmail1">Title </label>
                   <input type="text"  class="form-control"  placeholder="" name="title" >
                </div>

               <div class="form-group">
                 <label for="exampleInputEmail1">Message </label>
                 <textarea class="summernote" name="body"></textarea>
              </div>

              <div class="form-group">
                <input type="hidden"  class="form-control" name="user_batch" value="{{ $batch_program }}" >
             </div>




              <div class="form-group">
                <label class="form-label">Attachment</label>

                <div class="row clearfix">
                  <div class="col-lg-12 ">
                      <div class="file-upload file-uploadAll">
                          <div class="image-upload-wrap image-upload-wrapAll">

                              <input class="file-upload-input file-upload-inputAll" type='file'
                                     onchange="readURL(this);" accept="image/*" name="image1"
                                     multiple/>
                              <div class="drag-text drag-textAll">
                                <h5>Drag and drop a image in this box or click this box to insert image</br>File Size: Max 2MB</h5>
                              </div>
                          </div>
                          <div class="file-upload-content file-upload-contentAll">
                              <img class="file-upload-image file-upload-imageAll" src="#"
                                   alt="your image"/>
                              <div class="image-title-wrap image-title-wrapAll">
                                  <button type="button" onclick="removeUpload()"
                                          class="btn-sm remove-image remove-imageAll">Remove <span
                                              class="image-title image-titleAll">Uploaded Image</span>
                                  </button>
                              </div>
                          </div>
                      </div>
                      <div hidden="hidden" id="addImageDiv">
                          <center>
                              <button id="btnAddmul" type="button" onclick="addMul('add')"
                                      class="btn btn-success"
                                      style="width: 140px;height: 36px; font-size: 1.5em; padding: 3px;">
                                  Add
                              </button>
                          </center>
                      </div>
                  </div>

                  <div class="col-lg-12 ">
                      <div id="image2">
                          <div class="file-upload file-uploadAll">
                              <div class="image-upload-wrap2 image-upload-wrapAll">

                                  <input class="file-upload-input2 file-upload-inputAll" type='file'
                                         onchange="readURL2(this);" accept="image/*" name="image2"
                                         multiple/>
                                  <div class="drag-text drag-textAll">
                                    <h5>Drag and drop a image in this box or click this box to insert image</br>File Size: Max 2MB</h5>
                                  </div>
                              </div>
                              <div class="file-upload-content2 file-upload-contentAll">
                                  <img class="file-upload-image2 file-upload-imageAll" src="#"
                                       alt="your image"/>
                                  <div class="image-title-wrap2 image-title-wrapAll">
                                      <button type="button" onclick="removeUpload2()"
                                              class="btn-sm remove-image remove-imageAll">Remove <span
                                                  class="image-title2 image-titleAll">Uploaded Image</span>
                                      </button>
                                  </div>
                              </div>
                          </div>
                          <div hidden="hidden" id="addImageDiv2">
                              <center>
                                  <button id="btnAddmul2" type="button" onclick="addMul('add2')"
                                          class="btn btn-success"
                                          style="width: 140px;height: 36px; font-size: 1.5em; padding: 3px;">
                                      Add
                                  </button>
                                  </br>
                                  </br>
                                  <button id="btn2Addmul" type="button" class="btn btn-success"
                                          onclick="addMul('minus2')">Cancel
                                  </button>
                              </center>
                          </div>
                      </div>
                  </div>

                  <div class="col-lg-12 ">
                      <div id="image3">
                          <div class="file-upload file-uploadAll">
                              <div class="image-upload-wrap3 image-upload-wrapAll">

                                  <input class="file-upload-input3 file-upload-inputAll" type='file'
                                         onchange="readURL3(this);" accept="image/*" name="image3"
                                         multiple/>
                                  <div class="drag-text drag-textAll">
                                    <h5>Drag and drop a image in this box or click this box to insert image</br>File Size: Max 2MB</h5>
                                  </div>
                              </div>
                              <div class="file-upload-content3 file-upload-contentAll">
                                  <img class="file-upload-image3 file-upload-imageAll" src="#"
                                       alt="your image"/>
                                  <div class="image-title-wrap3 image-title-wrapAll">
                                      <button type="button" onclick="removeUpload3()"
                                              class="btn-sm remove-image remove-imageAll">Remove <span
                                                  class="image-title3 image-titleAll">Uploaded Image</span>
                                      </button>
                                  </div>
                              </div>
                          </div>
                          <div hidden="hidden" id="addImageDiv3">
                              <center>
                                  <button id="btnAddmul3" type="button" onclick="addMul('add3')"
                                          class="btn btn-success"
                                          style="width: 140px;height: 36px; font-size: 1.5em; padding: 3px;">
                                      Add
                                  </button>
                                  </br>
                                  </br>
                                  <button id="btn3Addmul" type="button" class="btn btn-success"
                                          onclick="addMul('minus3')">Cancel
                                  </button>
                              </center>
                          </div>
                      </div>
                  </div>

                  <div class="col-lg-12 ">
                      <div id="image4">
                          <div class="file-upload file-uploadAll">
                              <div class="image-upload-wrap4 image-upload-wrapAll">

                                  <input class="file-upload-input4 file-upload-inputAll" type='file'
                                         onchange="readURL4(this);" accept="image/*" name="image4"
                                         multiple/>
                                  <div class="drag-text drag-textAll">
                                    <h5>Drag and drop a image in this box or click this box to insert image</br>File Size: Max 2MB</h5>
                                  </div>
                              </div>
                              <div class="file-upload-content4 file-upload-contentAll">
                                  <img class="file-upload-image4 file-upload-imageAll" src="#"
                                       alt="your image"/>
                                  <div class="image-title-wrap4 image-title-wrapAll">
                                      <button type="button" onclick="removeUpload4()"
                                              class="btn-sm remove-image remove-imageAll">Remove <span
                                                  class="image-title4 image-titleAll">Uploaded Image</span>
                                      </button>
                                  </div>
                              </div>
                          </div>
                          <div hidden="hidden" id="addImageDiv4">
                              <center>
                                  <button id="btnAddmul4" type="button" onclick="addMul('add4')"
                                          class="btn btn-success"
                                          style="width: 140px;height: 36px; font-size: 1.5em; padding: 3px;">
                                      Add
                                  </button>
                                  </br>
                                  </br>
                                  <button id="btn4Addmul" type="button" class="btn btn-success"
                                          onclick="addMul('minus4')">Cancel
                                  </button>
                              </center>
                          </div>
                      </div>
                  </div>
              </div>

             </div>
               <!-- /.card-body -->
               <div class=" text-right">
                 <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
               <button type="submit" class="btn btn-dark  waves-effect">Submit</button>
               </div>
           </form>
                  </div>
                </div>
                <!-- /.modal-content -->
              </div>
              <!-- /.modal-dialog -->
            </div>
            <!-- /.modal -->
              @endcan
            </div>
       </div>
          </div>
          <!-- /.card-header -->
          <div class="card-body">
            <div class="tabs-to-dropdown">
              <div class="nav-wrapper d-flex align-items-center justify-content-between">
                <ul class="nav nav-pills d-none d-md-flex" id="pills-tab" role="tablist">
                  <li class="nav-item" role="presentation">
                    <a class="nav-link active" id="pills-company-tab" data-toggle="pill" href="#pills-company" role="tab" aria-controls="pills-company" aria-selected="true">All Ticket</a>
                  </li>
                  <li class="nav-item" role="presentation">
                    <a class="nav-link" id="pills-product-tab" data-toggle="pill" href="#pills-product" role="tab" aria-controls="pills-product" aria-selected="false">Open or Pending </a>
                  </li>
                  <li class="nav-item" role="presentation">
                    <a class="nav-link" id="pills-ongoing-tab" data-toggle="pill" href="#pills-ongoing" role="tab" aria-controls="pills-ongoing" aria-selected="false">Ongoing </a>
                  </li>
                  <li class="nav-item" role="presentation">
                    <a class="nav-link" id="pills-news-tab" data-toggle="pill" href="#pills-news" role="tab" aria-controls="pills-news" aria-selected="false">Resolved or Closed </a>
                  </li>
                </ul>

                <ul class="list-group list-group-horizontal">
                  <!-- social links here -->
                </ul>
              </div>

              <div class="tab-content" id="pills-tabContent">
                <div class="tab-pane fade show active" id="pills-company" role="tabpanel" aria-labelledby="pills-company-tab">
                  @foreach ($data as $key => $data)
                  <a href="{{ route('supports.supportuser',$data->id) }}">
                    <div class="small-box bg-white elevation-1 my-4">
                    <div class="inner py-3">
                      <div class="row">
                        <div class="col-lg-10 col-12">
                        <small class="mute">Created on {{ $data->created_at->format('D, j F Y, h:i A') }} </small>
                          <h5><strong>Case Id: #{{ $data->case_id }} - {{ $data->title }}  </strong></h5>
                        </div>
                        @if ($data->pending == '1')
                        <div class="col-lg-2 col-12 text-center">
                          <span class="badge bg-danger">THIS TICKET ARE PENDING REVIEW</span>
                        </div>
                        @elseif ($data->ongoing == '1')
                        <div class="col-lg-2 col-12 text-center">
                          <span class="badge bg-blue">THIS TICKET ARE ON RESOLVED </span>
                        </div>
                        @elseif ($data->complete == '1')
                        <div class="col-lg-2 col-12 text-center">
                          <span class="badge bg-success">THIS TICKET HAS BEEN COMPLETE</span>
                        </div>
                        @else
                        <div class="col-lg-2 col-12 text-center">
                          <span class="badge bg-warning">THIS TICKET HAS BEEN CLOSED</span>
                        </div>
                        @endif
                      </div>
                    </div>
                  </div>
                </a>
                  @endforeach
                </div>
                <div class="tab-pane fade" id="pills-product" role="tabpanel" aria-labelledby="pills-product-tab">
                  @foreach ($pending_data as $key => $data)
                  <a href="{{ route('supports.show',$data->id) }}">
                    <div class="small-box bg-white elevation-1 my-4">
                    <div class="inner py-3">
                      <div class="row">
                        <div class="col-lg-10 col-12">
                          <small class="mute">{{ $data->user_id }}</small>
                        </br>
                          <small class="mute">Created on {{ $data->created_at->format('mY') }} Thus, 5 May at 1:07 PM </small>
                          <h5><strong>Case Id: #{{ $data->case_id }} - {{ $data->title }}  </strong></h5>
                        </div>
                        <div class="col-lg-2 col-12 text-center">
                          <span class="badge bg-danger">THIS TICKET ARE PENDING REVIEW</span>
                        </div>

                      </div>
                    </div>
                  </div>
                </a>
                  @endforeach
                </div>
                <div class="tab-pane fade" id="pills-ongoing" role="tabpanel" aria-labelledby="pills-ongoing-tab">
                  @foreach ($ongoing_data as $key => $data)
                  <a href="{{ route('supports.show',$data->id) }}">
                    <div class="small-box bg-white elevation-1 my-4">
                    <div class="inner py-3">
                      <div class="row">
                        <div class="col-lg-10 col-12">
                          <small class="mute">{{ $data->user_id }}</small>
                        </br>
                          <small class="mute">Created on {{ $data->created_at->format('mY') }} Thus, 5 May at 1:07 PM </small>
                          <h5><strong>Case Id: #{{ $data->case_id }} - {{ $data->title }}  </strong></h5>
                        </div>
                        <div class="col-lg-2 col-12 text-center">
                          <span class="badge bg-blue">THIS TICKET ARE ON RESOLVED </span>
                        </div>

                      </div>
                    </div>
                  </div>
                </a>
                  @endforeach
                </div>
                <div class="tab-pane fade" id="pills-news" role="tabpanel" aria-labelledby="pills-news-tab">
                  @foreach ($complete_close_data as $key => $data)
                  <a href="{{ route('supports.show',$data->id) }}">
                    <div class="small-box bg-white elevation-1 my-4">
                    <div class="inner py-3">
                      <div class="row">
                        <div class="col-lg-10 col-12">
                          <small class="mute">{{ $data->user_id }}</small>
                        </br>
                          <small class="mute">Created on {{ $data->created_at->format('mY') }} Thus, 5 May at 1:07 PM </small>
                          <h5><strong>Case Id: #{{ $data->case_id }} - {{ $data->title }}  </strong></h5>
                        </div>
                        @if ($data->complete == '1')
                        <div class="col-lg-2 col-12 text-center">
                          <span class="badge bg-success">THIS TICKET HAS BEEN COMPLETE</span>
                        </div>
                        @else
                        <div class="col-lg-2 col-12 text-center">
                          <span class="badge bg-warning">THIS TICKET HAS BEEN CLOSED</span>
                        </div>
                        @endif
                      </div>
                    </div>
                  </div>
                </a>
                  @endforeach
                </div>

              </div>
            </div>
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
@endcan
@can('support_admin')
<!-- Main content -->
<section class="content">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-0">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Overview</span>
                          <h3 class="m-0"><strong>All Support Tickets</strong></h3>
                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div><!-- /.card-header -->
          <div class="card-body">
            <div class="row">
  <div class="col-md-3">
    <!-- <a hidden="hidden" href="compose.html" class="btn btn-primary btn-block mb-3">Compose</a> -->

    <div class="card">
      <div class="card-header">
        <h3 class="card-title">Tickets</h3>

        <div class="card-tools">
          <button type="button" class="btn btn-tool py-3" data-card-widget="collapse">
            <i class="fas fa-minus"></i>
          </button>
        </div>
      </div>
      <div class="card-body p-0">
        <div class="nav  nav-pills flex-column" id="vert-tabs-tab" role="tablist" aria-orientation="vertical">
          <a class="nav-link active" id="vert-tabs-home-tab" data-toggle="pill" href="#vert-tabs-home" role="tab" aria-controls="vert-tabs-home" aria-selected="true">All Tickets
          </a>
          <a class="nav-link" id="vert-tabs-profile-tab" data-toggle="pill" href="#vert-tabs-profile" role="tab" aria-controls="vert-tabs-profile" aria-selected="false">
            Pending Tickets
            @if ($pending_data_count > '0')
            <span class="badge bg-danger float-right">{{$pending_data_count}}</span>
            @else
            @endif
          </a>
          <a class="nav-link" id="vert-tabs-messages-tab" data-toggle="pill" href="#vert-tabs-messages" role="tab" aria-controls="vert-tabs-messages" aria-selected="false">
            Ongoing Tickets
            @if ($ongoing_data_count > '0')
            <span class="badge bg-success float-right">{{$ongoing_data_count}}</span>
            @else
            @endif
          </a>
          <a class="nav-link" id="vert-tabs-settings-tab" data-toggle="pill" href="#vert-tabs-settings" role="tab" aria-controls="vert-tabs-settings" aria-selected="false">Complete/Done Tickets</a>
        </div>
      </div>
      <!-- /.card-body -->
    </div>
    <!-- /.card -->

  </div>
  <!-- /.col -->
  <div class="col-md-9">
    <div class="tab-content" id="vert-tabs-tabContent">
      <div class="tab-pane text-left fade active show" id="vert-tabs-home" role="tabpanel" aria-labelledby="vert-tabs-home-tab">
        <div class="card card-warning card-outline">
          <div class="card-header">
            <h3 class="card-title">All Tickets &nbsp;&nbsp;<span class="badge bg-dark float-right">{{$data_count}}</span></h3>
            <div class="card-tools">
              <div class="input-group input-group-sm" style="width: 150px;">
                    <input id="myInput" type="text" name="table_search" class="form-control float-right" placeholder="Search">
                  </div>
            </div>
            <!-- /.card-tools -->
          </div>
          <!-- /.card-header -->
          <div class="card-body p-0">
            <div class="table-responsive mailbox-messages">
              <table class="table table-hover table-striped">
                <thead>
                <tr>
                  <td><small><b>Case Id</b></small></td>
                  <td ><small><b>Name</b></small></a></td>
                  <td ><small><b>Subject</b></small>
                  </td>
                  <!-- <td class="mailbox-attachment"><i class="fas fa-paperclip"></i></td> -->
                  <td><small><b>Date</b></small></td>
                </tr>
                </thea>
                <tbody id="myTable">
                  @foreach ($data_admin as $key => $data)
                <tr>
                  <td class="mailbox-name"><a href="{{ route('supports.show',$data->id) }}">{{$data->case_id}}</a></td>
                  <td class="mailbox-name">{{$data->user_name}}</a></td>
                  <td class="mailbox-subject"><b>{{$data->title}}</b>
                  </td>
                  <!-- <td class="mailbox-attachment"><i class="fas fa-paperclip"></i></td> -->
                  <td class="mailbox-date">{{ $data->created_at->format(' j F Y') }}</td>
                </tr>
                @endforeach
                </tbody>
              </table>
              <!-- /.table -->
            </div>
            <!-- /.mail-box-messages -->
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <div class="tab-pane fade" id="vert-tabs-profile" role="tabpanel" aria-labelledby="vert-tabs-profile-tab">
        <div class="card card-warning card-outline">
          <div class="card-header">
            <h3 class="card-title">Pending Tickets &nbsp;&nbsp;<span class="badge bg-dark float-right">{{$pending_data_count}}</span></h3>
            <div class="card-tools">
              <div class="input-group input-group-sm" style="width: 150px;">
                    <input id="myInput2" type="text" name="table_search" class="form-control float-right" placeholder="Search">
                  </div>
            </div>
            <!-- /.card-tools -->
          </div>
          <!-- /.card-header -->
          <div class="card-body p-0">
            <div class="table-responsive mailbox-messages">
              <table class="table table-hover table-striped">
                <tbody id="myTable2">
                  @foreach ($pending_data_admin as $key => $data)
                <tr>
                  <td class="mailbox-name"><a href="{{ route('supports.show',$data->id) }}">{{$data->case_id}}</a></td>
                  <td class="mailbox-name">{{$data->user_name}}</a></td>
                  <td class="mailbox-subject"><b>{{$data->title}}</b>
                  </td>
                  <td class="mailbox-attachment"><i class="fas fa-paperclip"></i></td>
                  <td class="mailbox-date">{{ $data->created_at->format(' j F Y') }}</td>
                </tr>
                @endforeach
                </tbody>
              </table>
              <!-- /.table -->
            </div>
            <!-- /.mail-box-messages -->
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <div class="tab-pane fade" id="vert-tabs-messages" role="tabpanel" aria-labelledby="vert-tabs-messages-tab">
        <div class="card card-warning card-outline">
          <div class="card-header">
            <h3 class="card-title">Ongoing Tickets &nbsp;&nbsp;<span class="badge bg-dark float-right">{{$pending_data_count}}</span></h3>
            <div class="card-tools">
              <div class="input-group input-group-sm" style="width: 150px;">
                    <input id="myInput3" type="text" name="table_search" class="form-control float-right" placeholder="Search">
                  </div>
            </div>
            <!-- /.card-tools -->
          </div>
          <!-- /.card-header -->
          <div class="card-body p-0">
            <div class="table-responsive mailbox-messages">
              <table class="table table-hover table-striped">
                <tbody id="myTable3">
                  @foreach ($ongoing_data_admin as $key => $data)
                <tr>
                  <td class="mailbox-name"><a href="{{ route('supports.show',$data->id) }}">{{$data->case_id}}</a></td>
                  <td class="mailbox-name">{{$data->user_name}}</a></td>
                  <td class="mailbox-subject"><b>{{$data->title}}</b>
                  </td>
                  <td class="mailbox-attachment"><i class="fas fa-paperclip"></i></td>
                  <td class="mailbox-date">{{ $data->created_at->format(' j F Y') }}</td>
                </tr>
                @endforeach
                </tbody>
              </table>
              <!-- /.table -->
            </div>
            <!-- /.mail-box-messages -->
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
      <div class="tab-pane fade" id="vert-tabs-settings" role="tabpanel" aria-labelledby="vert-tabs-settings-tab">
        <div class="card card-warning card-outline">
          <div class="card-header">
            <h3 class="card-title">Complete/Done Tickets &nbsp;&nbsp;<span class="badge bg-dark float-right">{{$complete_close_data_count}}</span></h3>
            <div class="card-tools">
              <div class="input-group input-group-sm" style="width: 150px;">
                    <input id="myInput3" type="text" name="table_search" class="form-control float-right" placeholder="Search">
                  </div>
            </div>
            <!-- /.card-tools -->
          </div>
          <!-- /.card-header -->
          <div class="card-body p-0">
            <div class="table-responsive mailbox-messages">
              <table class="table table-hover table-striped">
                <tbody id="myTable4">
                  @foreach ($complete_close_data_admin as $key => $data)
                <tr>
                  <td class="mailbox-name"><a href="{{ route('supports.show',$data->id) }}">{{$data->case_id}}</a></td>
                  <td class="mailbox-name">{{$data->user_name}}</a></td>
                  <td class="mailbox-subject"><b>{{$data->title}}</b>
                  </td>
                  <td class="mailbox-attachment"><i class="fas fa-paperclip"></i></td>
                  <td class="mailbox-date">{{ $data->created_at->format(' j F Y') }}</td>
                </tr>
                @endforeach
                </tbody>
               </table>
              <!-- /.table -->
            </div>
            <!-- /.mail-box-messages -->
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
    </div>


  </div>
  <!-- /.col -->
</div>
<!-- /.row -->
          </div> <!-- /.card-body -->
        </div>
        </div>
        <!-- /.col -->

      </div>
      <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</section>
<!-- /.content -->
@endcan


   <script>
   $(document).ready(function(){
     $("#myInput").on("keyup", function() {
       var value = $(this).val().toLowerCase();
       $("#myTable tr").filter(function() {
         $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
       });
     });
   });
   </script>
   <script>
   $(document).ready(function(){
     $("#myInput2").on("keyup", function() {
       var value = $(this).val().toLowerCase();
       $("#myTable2 tr").filter(function() {
         $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
       });
     });
   });
   </script>
   <script>
   $(document).ready(function(){
     $("#myInput3").on("keyup", function() {
       var value = $(this).val().toLowerCase();
       $("#myTable3 tr").filter(function() {
         $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
       });
     });
   });
   </script>
   <script>
   $(document).ready(function(){
     $("#myInput4").on("keyup", function() {
       var value = $(this).val().toLowerCase();
       $("#myTable4 tr").filter(function() {
         $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
       });
     });
   });
   </script>
@endsection

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script>
  $(document).ready(function() {
      $('#summernote').summernote();
  });
</script>

<script type="text/javascript">
    $(document).ready(function() {
      $('.summernote').summernote({
        placeholder: 'Insert message here',
        tabsize: 2,
        height: 250,
        toolbar: [
          ['style', ['style']],
          ['font', ['bold', 'underline', 'clear']],
          ['color', ['color']],
          ['para', ['ul', 'ol', 'paragraph']],
          ['table', ['table']],
          //['insert', ['link', 'picture', 'video']],
          //['view', ['fullscreen', 'codeview', 'help']]
        ]
      });
    });
</script>
    <script type="text/javascript">
                  function deleteStocks(id) {
                    Swal.fire({
                      title: 'Are you sure?',
                      text: "You won't be able to revert this!",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
              if (result.value) {
                event.preventDefault();
                document.getElementById('delete-form-'+id).submit();

              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
              }
              })
                  }
    </script>
    <script>
    function readURL(input) {
        if (input.files && input.files[0]) {

            var reader = new FileReader();

            reader.onload = function (e) {
                $('.image-upload-wrap').hide();

                $('.file-upload-image').attr('src', e.target.result);
                $('.file-upload-content').show();

                $('.image-title').html(input.files[0].name);
            };

            reader.readAsDataURL(input.files[0]);

        } else {
            removeUpload();
        }
    }

    function removeUpload() {
        $('.file-upload-input').replaceWith($('.file-upload-input').clone());
        $('.file-upload-content').hide();
        $('.image-upload-wrap').show();
    }

    $('.image-upload-wrap').bind('dragover', function () {
        $('.image-upload-wrap').addClass('image-dropping');
    });
    $('.image-upload-wrap').bind('dragleave', function () {
        $('.image-upload-wrap').removeClass('image-dropping');
    });


    function readURL2(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('.image-upload-wrap2').hide();
                $('.file-upload-image2').attr('src', e.target.result);
                $('.file-upload-content2').show();
                $('.image-title2').html(input.files[0].name);
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            removeUpload();
        }
    }

    function removeUpload2() {
        $('.file-upload-input2').replaceWith($('.file-upload-input2').clone());
        $('.file-upload-content2').hide();
        $('.image-upload-wrap2').show();
    }

    $('.image-upload-wrap2').bind('dragover', function () {
        $('.image-upload-wrap2').addClass('image-dropping');
    });
    $('.image-upload-wrap2').bind('dragleave', function () {
        $('.image-upload-wrap2').removeClass('image-dropping');
    });

    function readURL3(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('.image-upload-wrap3').hide();
                $('.file-upload-image3').attr('src', e.target.result);
                $('.file-upload-content3').show();
                $('.image-title3').html(input.files[0].name);
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            removeUpload();
        }
    }

    function removeUpload3() {
        $('.file-upload-input3').replaceWith($('.file-upload-input3').clone());
        $('.file-upload-content3').hide();
        $('.image-upload-wrap3').show();
    }

    $('.image-upload-wrap3').bind('dragover', function () {
        $('.image-upload-wrap3').addClass('image-dropping');
    });
    $('.image-upload-wrap3').bind('dragleave', function () {
        $('.image-upload-wrap3').removeClass('image-dropping');
    });

    function readURL4(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('.image-upload-wrap4').hide();
                $('.file-upload-image4').attr('src', e.target.result);
                $('.file-upload-content4').show();
                $('.image-title4').html(input.files[0].name);
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            removeUpload();
        }
    }

    function removeUpload4() {
        $('.file-upload-input4').replaceWith($('.file-upload-input4').clone());
        $('.file-upload-content4').hide();
        $('.image-upload-wrap4').show();
    }

    $('.image-upload-wrap4').bind('dragover', function () {
        $('.image-upload-wrap4').addClass('image-dropping');
    });
    $('.image-upload-wrap4').bind('dragleave', function () {
        $('.image-upload-wrap4').removeClass('image-dropping');
    });


    function readURL5(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('.image-upload-wrap5').hide();
                $('.file-upload-image5').attr('src', e.target.result);
                $('.file-upload-content5').show();
                $('.image-title5').html(input.files[0].name);
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            removeUpload();
        }
    }

    function removeUpload5() {
        $('.file-upload-input5').replaceWith($('.file-upload-input5').clone());
        $('.file-upload-content5').hide();
        $('.image-upload-wrap5').show();
    }

    $('.image-upload-wrap5').bind('dragover', function () {
        $('.image-upload-wrap5').addClass('image-dropping');
    });
    $('.image-upload-wrap5').bind('dragleave', function () {
        $('.image-upload-wrap5').removeClass('image-dropping');
    });


    function readURL6(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('.image-upload-wrap6').hide();
                $('.file-upload-image6').attr('src', e.target.result);
                $('.file-upload-content6').show();
                $('.image-title6').html(input.files[0].name);
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            removeUpload();
        }
    }

    function removeUpload6() {
        $('.file-upload-input6').replaceWith($('.file-upload-input6').clone());
        $('.file-upload-content6').hide();
        $('.image-upload-wrap6').show();
    }

    $('.image-upload-wrap6').bind('dragover', function () {
        $('.image-upload-wrap6').addClass('image-dropping');
    });
    $('.image-upload-wrap6').bind('dragleave', function () {
        $('.image-upload-wrap6').removeClass('image-dropping');
    });

</script>
<script type="text/javascript">
  $(document).ready(function(){

    $(document).on('change','.category',function(){
      //console.log("hmm its change");

      var cat_id=$(this).val();
      // console.log(cat_id);
      var div=$(this).parent();

      var op=" ";

      $.ajax({
        type:'get',
        url:'{!!URL::to('findCategoryName')!!}',
        data:{'id':cat_id},
        success:function(data){
          //console.log('success');

          //console.log(data);
        //  console.log(data.length);
          op+='<option value="0" selected disabled>- Select Sub-Category/Sub-Brand - </option>';
                  for(var i=0;i<data.length;i++){
                  op+='<option value="'+data[i].id+'">'+data[i].name+'</option>';
                   }
                   div.find('.name').html(" ");
                   div.find('.name').append(op);

        },
        error:function(){

        }
      });
    });
  });
</script>
<script type="text/javascript">
    $(document).ready(function () {
        // count = 1;
    });

    function addMul(action) {
        // alert(action);

        var image2 = document.getElementById('image2');
        image2h = image2.hidden;
        var image3 = document.getElementById('image3');
        var image4 = document.getElementById('image4');
        var image5 = document.getElementById('image5');
        var image6 = document.getElementById('image6');

        var addImageDiv = document.getElementById('addImageDiv');
        var addImageDiv2 = document.getElementById('addImageDiv2');

        var btnAddmul = document.getElementById('btnAddmul');
        var btnAddmul6 = document.getElementById('btnAddmul6');
        // alert(btnAddmul);
        // return;

        if (action == 'add') {
            // alert(action);
            // alert(image2h);
            image2.style.display = 'block';
            addImageDiv.style.display = 'none';
        } else if (action == 'add2') {
            // alert(image2h);
            image3.style.display = 'block';
        } else if (action == 'add3') {
            // alert(image2h);
            image4.style.display = 'block';
        } else if (action == 'add4') {
            // alert(image2h);
            image5.style.display = 'block';
        } else if (action == 'add5') {
            // alert(image2h);
            image6.style.display = 'block';
            btnAddmul6.innerHTML = 'Full';
            btnAddmul6.disabled = true;
        }


        if (action == 'minus2') {
            addImageDiv.style.display = 'block';
            // alert(image2h);
            image2.style.display = 'none';
        } else if (action == 'minus3') {
            addImageDiv2.style.display = 'block';
            image3.style.display = 'none';
        } else if (action == 'minus4') {
            addImageDiv3.style.display = 'block';
            image4.style.display = 'none';
        } else if (action == 'minus5') {
            addImageDiv4.style.display = 'block';
            image5.style.display = 'none';
        } else if (action == 'minus6') {
            addImageDiv5.style.display = 'block';
            image6.style.display = 'none';
            btnAddmul.innerHTML = 'Add';
        }

    }
</script>
<style>
#addmul {

}



.file-uploadAll {
margin: 0 auto;
padding: 0;

}

.file-upload-btnAll {
width: 100%;
margin: 0;
background: #fbfbfb;
border: 1px solid;
padding: 5px 10px;
border-radius: 5px;
transition: all .2s ease;
text-transform: uppercase;
font-weight: 700;
color: #212529;
border-color: #dae0e5;
}

.file-upload-btnAll:hover {

transition: all .2s ease;
cursor: pointer;
background: #333;
color: #fff;
border-color: #333;
}

.file-upload-btnAll:active {
border: 0;
transition: all .2s ease;
}

.file-upload-contentAll {
display: none;
text-align: center;
margin-top: 20px;
position: relative;
padding: 0px 0;
}

.file-upload-inputAll {
position: absolute;
margin: 0;
padding: 0;
width: 100%;
height: 100%;
outline: none;
opacity: 0;
cursor: pointer;
}

.image-upload-wrapAll {
margin-top: 20px;
border: 4px dashed #ddd;
position: relative;
padding: 10px;
}
.drag-textAll h5{
margin: 0;
font-weight: 500;
font-size: 14px;
font-style: italic;
}
.image-droppingAll, .image-upload-wrapAll:hover {
background-color: #f5f5f5;
border: 4px dashed #ddd;
}

.image-title-wrapAll {
padding: 0 0px px 15px;
color: #222;
}

.drag-textAll {
text-align: center;
}

.drag-textAll h3 {
font-weight: 100;
text-transform: uppercase;
color: #15824B;
padding: 60px 0;
}

.file-upload-imageAll {
max-height: 180px;
max-width: 100%;
margin: auto;
padding: 0;
}

.remove-imageAll {
width: 100%;
margin: 10px 0;
color: #fff;
background: #cd4535;
border: none;
padding: 10px;
border-radius: 4px;
border-bottom: 4px solid #b02818;
transition: all .2s ease;
outline: none;
text-transform: capitalize;
font-weight: 700;
}

.remove-imageAll:hover {
background: #c13b2a;
color: #ffffff;
transition: all .2s ease;
cursor: pointer;
}

.remove-imageAll:active {
border: 0;
transition: all .2s ease;
}

</style>
