@extends('layouts.app')
@section('content')
<div class="container">
    <div class="justify-content-center">
        @if (count($errors) > 0)
            <div class="alert alert-danger">
                <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card">
            <div class="card-header">Create Stock
                <span class="float-right">
                    <a class="btn btn-primary" href="{{ route('stocks.index') }}">stocks</a>
                </span>
            </div>

            <div class="card-body">
                {!! Form::open(array('route' => 'stocks.store', 'method'=>'POST')) !!}
                    <div class="form-group">
                        <strong>Stock Name:</strong>
                        {!! Form::text('stocks_name', null, array('placeholder' => 'Stock','class' => 'form-control')) !!}
                    </div>
                    <div class="form-group">
                        <strong>Stock Symbol:</strong>
                        {!! Form::text('symbol', null, array('placeholder' => 'Symbol','class' => 'form-control')) !!}
                    </div>
                    <button type="submit" class="btn btn-primary">Submit</button>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>
@endsection
