@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->

  <!-- /.content-header -->
</br>
<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-0">
          <div class="card-body">
            <form action="{{ route('programstatistic.search') }}" method="POST" enctype="multipart/form-data">
              @csrf
              <h5 ><strong>Search Student </strong></h5>
            </br>
              <div class="row">
                <div class="col-12 col-md-6">
                    <div class="form-group">
                      <label class="form-label"><strong>Student Name :</strong></label>

                        <div>
                            <select class="form-control formselect required select2bs4"
                                id="sub_category_name" name="brokerage_id" style="width: 100%;" required="true">
                                <option value="0" disabled selected>Select  Student</option>
                                @foreach($data_broker as $broker)
                                <option  value="{{ $broker->id }}">
                                    {{ ucfirst($broker->name) }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <div   class="col-12 col-md-6">
                  <div class="form-group">
                    <label class="form-label"><strong>Portfolio :</strong></label>
                    <select class="form-control formselect required select2bs4" style="width: 100%;" required="true" id="sub_category" name="portfolio" >
                        <option value="0" disabled selected>Select  Portfolio</option>
                    </select>

                  </div>
                </div>
                <div class="col-12 col-md-1 ">
                    <div class="form-group">
                  <button type="submit" class="btn btn-dark  waves-effect">Search</button>
                </div>
                </div>
              </div>
            </form>
              <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

              <script>
                        $(document).ready(function () {
                        $('#sub_category_name').on('change', function () {
                        let data = $(this).val();
                        $('#sub_category').empty();
                        $('#sub_category').append(`<option value="0" disabled selected>Processing...</option>`);
                        $.ajax({
                        type: 'GET',
                        url: '/home/GetBroke/' + data,
                        success: function (response) {
                        var response = JSON.parse(response);
                        console.log(response);
                        $('#sub_category').empty();
                        $('#sub_category').append();
                        response.forEach(element => {
                        $('#sub_category').append(`<option value="${element['id']}">${element['portfolio_name']}</option>`);
                        });

                        }
                    });
                });
            });
            </script>
              </div>
        </div>
      </div>
    </div>
  </div>
</section>
<section class="content ">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    <div class="row">
      <div class="col-lg-12">
        @if ($data->count() == 0)
        <div class="card ">
        </br>
            <div class="card-body">

                <div class="row">
                  <div class="col-12 col-sm-12">

                    <div class="card">
                      <div class="card-body">
                        <div class=" clearfix">
                          <div class="text-center">
                            <img src="{{ URL::to('public/backend/images/invest.png') }}" class="rounded" width="65%">
                          </div>
                          <div class="text-center">
                            <div class="card-header border-0">
                              <h5 class="m-0"><strong>There is no trade record found in your account</strong></h5>

                            </div>

                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

            </div>
        </div>
        @else
        <div class="card elevation-0">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Overview</span>
                          <h3 class="m-0"><strong>Trade Statistic</strong></h3>
                        </div><!-- /.col -->
                        <div   class="col-sm-6">
                          <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><strong><a href="{{ url()->previous() }}"><i class="fas fa-angle-left nav-items"></i>&nbsp;Back</a></strong></li>
                          </ol>
                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div>

          <div class="card-header  border-0">
            <div class="row">
              <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Fund Available </strong></h6>
                    <h5><strong>MYR {{ round($fund_available ,2 )}}</strong></h5>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Total Profit </strong></h6>
                    <h5 class="text-success"><strong>MYR {{ round($profit , 2) }}</strong></h5>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Total Loss </strong></h6>
                    <h5 class="text-danger"><strong>MYR {{ round(abs($loss),2) }}</strong></h5>
                  </div>
                </div>
              </div>
              <!-- ./col -->

              <div  class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>ROI </strong></h6>
                    @if ($roi_port <= 0)
                    <h5 class="text-danger"><strong>{{round($roi_port, 2)}}%</strong></h5>
                    @elseif ($roi_port >= 0)
                    <h5 class="text-success"><strong>{{round($roi_port, 2)}}%</strong></h5>
                    @endif
                  </div>
                </div>
              </div>
              <!-- ./col -->
            </div>
            <div class="row">
              <div  class="col-lg-4 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Total Profit/Loss </strong></h6>
                    <h5><strong>MYR {{ round($total_q, 2) }}</strong></h5>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div  class="col-lg-4 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Total Winnings </strong></h6>
                    <h5><strong>{{ $winnings }}</strong></h5>
                  </div>
                </div>
              </div>
              <div  class="col-lg-4 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Total Losings </strong></h6>
                    <h5><strong>{{ $lossing }}</strong></h5>
                  </div>
                </div>
              </div>
              <!-- ./col -->
            </div>
            <div class="content-header">
              <div class="container-fluid">
                <div class="row mb-2">
                          <div class="col-sm-6">
                            <span class="m-0 text-muted">Account</span>
                            <h4 class="m-0"><strong> {{$portfolio->user->name}}</strong></h4>
                            <h4 class="m-0"><strong> {{$portfolio->portfolio_name}}</strong></h4>
                          </div><!-- /.col -->
                        </div><!-- /.row -->
              </div><!-- /.container-fluid -->
            </div>
          <div class="card-tools">
            <div  class="card-header border-0">

              <a class="btn btn-light  waves-effect" href="{{ route('programstatistic.print',$portfolio->id) }}"> <i class="nav-icon fas fa-plus-circle"></i> Export Pdf</a>


                      </div>
        </div>

          </div>
          <div class="card-header border-0 ">
            <div class="text-right">
                </div>
              </div>
          <!-- /.card-header -->
          <div class="card-body ">
            <div class="row mb-2">
                      <div class="col-sm-6">
                        <h4 class="m-0"><strong> Open Trade</strong></h4>
                      </div><!-- /.col -->
                      <div  hidden="hidden" class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                          <li class="breadcrumb-item"><a href="#">Home</a></li>
                          <li class="breadcrumb-item active">Dashboard</li>
                        </ol>
                      </div><!-- /.col -->
                    </div><!-- /.row -->
                  </br>
            <table id="example2" class="table table-bordered rounded table-hover">
              <thead class="bg-light">
            <tr class="text-center">
              <th>Status</th>
              <th>Stock Code</th>
              <th>Stock Name</th>

              <th>Open Date</th>
              <th>Buy Price </th>
              <th>Quantity </th>
              <th>Total Fees</th>
              <th>Total Cost</th>
              <th width="100px">Action</th>
            </tr>
            </thead>
            <tbody>
              @foreach ($data as $key => $row)
              @if ($row->status == Null)
              <tr class="text-center">
                <td class="align-middle" >
                  <h4> <span class="badge badge-primary">Open</span></h4>
                </td>
                <td class="align-middle" >{{ $row->stock_code }}</td>
                <td class="align-middle" >{{ $row->stock_name }}</td>
                <td class="align-middle" >{{ date('d/m/Y h:i A  ', strtotime($row->open_trade))}}</td>
                <!-- <td class="align-middle" >{{ date('d/m/Y h:i:s A ', strtotime($row->date))}}</td> -->
                <td class="align-middle" >MYR {{ round($row->average_buy, 2) }}</td>
                <td class="align-middle" >{{ $row->quantity_buy }} Unit</td>
                <td class="align-middle" >MYR {{ round($row->total_fees_buy, 2) }}</td>
                <td class="align-middle" >MYR {{ round($row->total_cost_buy, 2) }}</td>
                <td>

                  <a class="btn btn-warning btn-sm btn-block waves-effect" href="{{ route('programstatistic.history',$row->id) }}">  History</a>
                  @can('portfolio-edit')

                  @endcan

                  @can('portfolio-delete')

                       @endcan
                </td>
              </tr>
              @else

                @endif
            @endforeach
            </tbody>
          </table>
        </br>
        <div class="row">
          <div class="col-lg-4 col-6 offset-4">
            <!-- small box -->
            <div class="small-box bg-yellow elevation-1">
              <div class="inner text-center">
                <h6><strong>Total Cost </strong></h6>
                <h5><strong>MYR {{ round($result->sum('total_cost_buy'), 2) }}</strong></h5>
              </div>
            </div>
          </div>
        </div>
          </div>
          <!-- /.card-body -->
          <div class="card-body ">
            <div class="row mb-2">
                      <div class="col-sm-6">
                        <h4 class="m-0"><strong> Close Trade</strong></h4>
                      </div><!-- /.col -->
                      <div  hidden="hidden" class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                          <li class="breadcrumb-item"><a href="#">Home</a></li>
                          <li class="breadcrumb-item active">Dashboard</li>
                        </ol>
                      </div><!-- /.col -->
                    </div><!-- /.row -->
                  </br>
                  <table id="example1" class="table table-bordered rounded table-hover">
                    <thead class="bg-light">
                  <tr class="text-center">
                    <th>Status</th>
                    <th>Stock Code</th>
                    <th>Stock Name</th>
                    <th>Open Date</th>
                    <th>Close Date</th>
                    <th>Buy Price </th>
                    <th>Sell Price </th>
                    <th>Total Cost </th>
                    <th>Total Fees</th>
                    <th>Gross Profit</th>
                    <th>Net Profit</th>
                    <th width="100px">Action</th>
                  </tr>
                  </thead>
                  <tbody>
                    @foreach ($data as $key => $row)
                    @if ($row->status == Null)
                    @else
                      <tr class="text-center">
                        <td class="align-middle" >
                          @if ($row->status == 'WIN')
                          <h5> <span class="badge badge-info">WIN</span></h5>
                          @else
                          <h5> <span class="badge badge-danger">LOSS</span></h5>
                          @endif
                        </td>
                        <!-- <td class="align-middle">{{ $key + 1 }}</td> -->
                        <td class="align-middle" >{{ $row->stock_code }}</td>
                        <td class="align-middle" >{{ $row->stock_name }} | {{$row->stock_symbol}}</td>
                        <td class="align-middle" >{{ date('d/m/Y h:i A ', strtotime($row->open_trade))}}</td>
                        <td class="align-middle" >{{ date('d/m/Y  ', strtotime($row->close_trade))}}</td>
                        <!-- <td class="align-middle" >{{ date('d/m/Y h:i:s A ', strtotime($row->date))}}</td> -->
                        <td class="align-middle" >MYR {{ round($row->average_buy, 2) }}</td>
                        <td class="align-middle" >MYR {{ round($row->average_sell, 2) }}</td>
                        <td class="align-middle" >MYR {{ round($row->total_sell_cost, 2) }}</td>
                        <td class="align-middle" >MYR {{ round($row->total_fees_sell, 2) }} </td>
                        <td class="align-middle" >MYR {{ round($row->gross_profit, 2) }}
                          @if ($row->gross_profit > '0')
                          <h5> <span class="text-success">({{round($row->gross_roi, 2)}}%)</span></h5>
                          @else
                          <h5> <span class="text-danger">({{round($row->gross_roi, 2)}}%)</span></h5>
                          @endif
                        </td>
                        <td class="align-middle" >MYR {{ $row->net_profit }}
                          @if ($row->net_profit > '0')
                          <h5> <span class="text-success">({{round($row->net_roi, 2)}}%)</span></h5>
                          @else
                          <h5> <span class="text-danger">({{round($row->net_roi, 2)}}%)</span></h5>
                          @endif</td>
                        <td>

                          <a class="btn btn-warning btn-sm btn-block waves-effect" href="{{ route('programstatistic.history',$row->id) }}">  History</a>
                          @can('portfolio-edit')

                          @endcan

                          @can('portfolio-delete')

                               @endcan
                        </td>
                      </tr>
                  @endif
                  @endforeach
                  </tbody>
                </table>
              </br>
              <div class="row">
                <div class="col-lg-3 col-6 offset-3">
                  <!-- small box -->
                  <div class="small-box bg-yellow elevation-1">
                    <div class="inner text-center">
                      <h6><strong>Total Cost </strong></h6>
                      <h5><strong>MYR {{ round(($result->sum('total_sell_cost')) + ($result->sum('total_cost_buy')), 2) }}</strong></h5>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3 col-6">
                  <!-- small box -->
                  <div class="small-box bg-yellow elevation-1">
                    <div class="inner text-center">
                      <h6><strong>Net Profit/Loss </strong></h6>
                      <h5><strong>MYR {{ round($result->sum('net_profit'), 2) }}</strong></h5>
                    </div>
                  </div>
                </div>
              </div>
        </br>
        <div  class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
                      <div class="col-sm-6">
                        <span class="m-0 text-muted">Account</span>
                        <h4 class="m-0"><strong> Statistic</strong></h4>
                      </div><!-- /.col -->
                      <div  hidden="hidden" class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                          <li class="breadcrumb-item"><a href="#">Home</a></li>
                          <li class="breadcrumb-item active">Dashboard</li>
                        </ol>
                      </div><!-- /.col -->
                    </div><!-- /.row -->
          </div><!-- /.container-fluid -->
        </div>
        <script src="https://code.highcharts.com/highcharts.js"></script>
          <script src="https://code.highcharts.com/modules/exporting.js"></script>
          <script src="https://code.highcharts.com/modules/export-data.js"></script>
          <script src="https://code.highcharts.com/modules/accessibility.js"></script>


          <body>
    <div id="linechart" style="width:100%; height:400px;"></div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const total_harga = @json($total_harga);
            const bulan = @json($bulan);

            Highcharts.chart('linechart', {
                chart: {
                    type: 'line'
                },
                title: {
                    text: 'Net Profit Over Time'
                },
                xAxis: {
                    categories: bulan,
                    title: {
                        text: 'Date'
                    }
                },
                yAxis: {
                    title: {
                        text: 'Net Profit (MYR) '
                    }
                },
                legend: {
        layout: 'vertical',
        align: 'right',
        verticalAlign: 'middle'
    },

    plotOptions: {
      series: {
          allowPointSelect: true
      }
    },

                responsive: {
        rules: [{
            condition: {
                maxWidth: 500
            },
            chartOptions: {
                legend: {
                    layout: 'horizontal',
                    align: 'center',
                    verticalAlign: 'bottom'
                }
            }
        }]
    },
                series: [{
                    name: 'Net Profit',
                    data: total_harga.map(parseFloat) // Ensure the data is in the correct format
                }]
            });
        });
    </script>
</body>
      </br>
  <body>
    <div id="barchart"></div>
  </body>

  <script>
        document.addEventListener('DOMContentLoaded', function () {
            const profits = @json($profits);
            const losses = @json($losses);
            const months = @json($months);

            Highcharts.chart('barchart', {
                chart: {
                    type: 'column'
                },
                title: {
                    text: 'Monthly Profit and Loss'
                },
                xAxis: {
                    categories: Object.values(months),
                    title: {
                        text: 'Month'
                    }
                },
                yAxis: {
                    title: {
                        text: 'Amount (MYR)'
                    },
                    labels: {
                        formatter: function () {
                            return this.value;
                        }
                    }
                },
                legend: {
                  layout: 'vertical',
                  align: 'right',
                  verticalAlign: 'middle'
              },
              responsive: {
                  rules: [{
                      condition: {
                          maxWidth: 500
                      },
                      chartOptions: {
                          legend: {
                              layout: 'horizontal',
                              align: 'center',
                              verticalAlign: 'bottom'
                          }
                      }
                  }]
              },
              plotOptions: {
                  series: {
                      allowPointSelect: true
                  }
              },
                series: [{
                    name: 'Profit',
                    data: profits
                }, {
                    name: 'Loss',
                    data: losses
                }]

            });
        });
    </script>



        </div>
        <!-- /.card -->
        @endif
      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
@endsection

    <script type="text/javascript">
                  function deletePrograms(id) {
                    Swal.fire({
                      title: 'Are you sure?',
                      text: "You won't be able to revert this!",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
              if (result.value) {
                event.preventDefault();
                document.getElementById('delete-form-'+id).submit();

              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
              }
              })
                  }
    </script>
