@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->

  <!-- /.content-header -->
</br>
<section class="content">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-0">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Overview</span>
                          <h3 class="m-0"><strong>Batch List</strong></h3>
                        </div><!-- /.col -->
                        <div  hidden="hidden" class="col-sm-6">
                          <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                          </ol>
                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div>
          <div class="card-header  border-0">




          <div class="card-tools">
            <div class="card-header border-0">
                          @can('program-create')

                          <!-- Modal Popup Start -->
                          <button type="button" class="btn btn-warning btn-block waves-effect" data-toggle="modal" data-target="#createProgram">
                            Add Batch
                          </button>
                          <!-- Modal Popup End -->

                          <!-- Modal Start -->
                          <div class="modal fade" id="createProgram">
                          <div class="modal-dialog ">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title">Add Batch</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>
                              <div class="modal-body">
                                @if (count($errors) > 0)
                                    <div class="alert alert-danger">
                                        <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif

                                <form action="{{ route('programs.store') }}" method="POST" enctype="multipart/form-data">
                                  @csrf
                             <div class="form-group">
                               <label>Batch Name </label>
                               <input type="text"  class="form-control"  placeholder="Batch Name" name="program_name" >
                            </div>

                           <div class="form-group">
                             <label>Batch Date </label>
                             <input type="text" class="form-control"  placeholder="Batch Date" name="program_date" >
                          </div>

                          <div class="form-group">
                            <label>Batch Year </label>
                            <input type="text" class="form-control"  placeholder="Batch Year" name="program_year" >
                         </div>

                         <div class="form-group">
                           <label>Batch Code </label>
                           <input type="text" class="form-control"  placeholder="Batch Code" name="program_code" >
                        </div>

                           <div class=" text-right">
                             <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                           <button type="submit" class="btn btn-dark  waves-effect">Submit</button>
                           </div>
                       </form>
                              </div>
                            </div>
                            <!-- /.modal-content -->
                          </div>
                          <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                          @endcan
                      </div>
       </div>
          </div>
          <div class="card-header border-0 ">
            <div class="text-right">
                </div>
              </div>
          <!-- /.card-header -->
          <div class="card-body">
            <!-- <table id="example1" class="table table-bordered table-striped"> -->
              <table id="example2" class="table table-bordered rounded table-hover">
                <thead class="bg-warning">
              <tr class="text-center">
                <th width="100px">No</th>
                <th>Name</th>
                <th>Date</th>
                <th>Year</th>
                <th>Code</th>
                <th>Total User</th>
                <th width="100px">Action</th>
              </tr>
              </thead>
              <tbody>
                @foreach ($data as $key => $program)
              <tr class="text-center">
                <td class="align-middle">{{ $program->id }}</td>
                <td class="align-middle" >{{ $program->program_name }}</td>
                <td class="align-middle" >{{ $program->program_date }}</td>
                <td class="align-middle" >{{ $program->program_year }}</td>
                <td class="align-middle" >{{ $program->program_code }}</td>
                <td class="align-middle" >{{ $program->user_quantity }} <i class="fas fa-user nav-icons"></i></td>
                <td>
                  <a class="btn btn-warning btn-sm btn-block waves-effect" href="{{ route('programs.show',$program->id) }}"><i class="fas fa-eye"></i>  View</a>
                  @can('program-edit')
                  <!-- Modal Popup Start -->
                  <a type="button" class="btn btn-warning btn-sm btn-block waves-effect my-1" data-toggle="modal" data-target="#editProgram{{$program->id}}">
                  <i class="far fa-edit"></i>  Edit </a>
                  <!-- Modal Popup End -->
                  <!-- Modal Start -->
                  <div class="modal fade" id="editProgram{{$program->id}}">
                  <div class="modal-dialog">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title">Edit Batch</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      <div class="modal-body">
                        @if (count($errors) > 0)
                            <div class="alert alert-danger">
                                <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        {!! Form::model($program, ['route' => ['programs.update', $program->id], 'method'=>'PATCH']) !!}
                        <div class="form-group text-left">
                          <label for="exampleInputEmail1">Batch Name  </label>
                          {!! Form::text('program_name', null, array('placeholder' => 'Batch Name','class' => 'form-control')) !!}
                       </div>
                       <div class="form-group text-left">
                         <label for="exampleInputEmail1">Batch Date  </label>
                         {!! Form::text('program_date', null, array('placeholder' => 'Batch Date','class' => 'form-control')) !!}
                      </div>
                      <div class="form-group text-left">
                        <label for="exampleInputEmail1">Batch Year  </label>
                        {!! Form::text('program_year', null, array('placeholder' => 'Batch Year','class' => 'form-control')) !!}
                     </div>
                     <div class="form-group text-left">
                       <label for="exampleInputEmail1">Batch Code  </label>
                       {!! Form::text('program_code', null, array('placeholder' => 'Batch Code','class' => 'form-control')) !!}
                    </div>
                        <!-- /.card-body -->
                        <div class=" text-right">
                          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-dark  waves-effect">Submit</button>
                        </div>
                        {!! Form::close() !!}
                      </div>
                    </div>
                    <!-- /.modal-content -->
                  </div>
                  <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
                  @endcan

                  @can('program-delete')
                  <a class="btn btn-warning btn-sm btn-block waves-effect" type="button" onclick="deletePrograms({{ $program->id }})">
                       <i class="fas fa-trash-alt"></i> Delete
                     </a>
                       <form id="delete-form-{{ $program->id }}" action="{{ route('programs.destroy',$program->id) }}" method="POST" style="display: none;">
                       @csrf
                       @method('delete')
                       </form>
                       @endcan
                </td>

              </tr>
              @endforeach
              </tbody>
            </table>
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>

@endsection

    <script type="text/javascript">
                  function deletePrograms(id) {
                    Swal.fire({
                      title: 'Are you sure?',
                      text: "You won't be able to revert this!",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
              if (result.value) {
                event.preventDefault();
                document.getElementById('delete-form-'+id).submit();

              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
              }
              })
                  }
    </script>
