@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">


<section class="content">
  <div class="container-fluid">
    <div class="container py-5">
        <div class="justify-content-center">
            @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="card ">
            </br>
                <div class="card-header border-0">
                  
                  <div class="row mb-2">
                        <div class="col-sm-6">
                        <h5 class="m-0"><strong>Add Your Portfolio</strong></h5>
                  <span class="m-0 text-muted">Please fill the portfolio form with your information</span>
                  </div>
                  <div class="col-sm-6 text-right">
                        <div class="row mb-2">
 
                        <div class="col-sm-12 mb-1">
                        <a class="btn btn-dark  waves-effect elevation-1" id="restart-tour"> <i class="nav-icon fas fa fa-info-circle"></i>   Lunch page tour again!</a>&nbsp;&nbsp
                        </div>
                        </div>
                        </div>
                </div>
                </div>

                <div class="card-body">
                <form action="{{ route('portfolios.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                      <div class="col-12 col-md-12"  id="name-portfolio">
                        <div class="form-group">
                         <label>Portfolio Name <br>  <small class="text-danger">Please do not to put number infornt the text. <br>Example:<br> <i class="fa fa-times-circle" aria-hidden="true"></i>1234RHB i-Trade</small></label>
                         <input type="text"  class="form-control"  placeholder="Portfolio Name" name="portfolio_name" >
                        </div>
                      </div>

                      <div class="col-12 col-md-12"  id="inidepo-portfolio">
                          <div class="form-group">
                            <label class="form-label"><strong>Initial Deposit</strong></label>
                            <div class="input-group mb-3">
                           <input type="number" class="form-control"  placeholder="Initial Deposit" name="initial_deposit" required="true" step="0.01">
                        <div class="input-group-append">
                        <span class="input-group-text">MYR</i></span>
                      </div>
                        </div>
                          </div>
                      </div>

                      <div class="col-12 col-md-12"  id="date-portfolio">
                        <div class="form-group">
                         <label>Deposit Date :</label>
                         <input type="datetime-local" id="date" name="date" class="form-control" required="true">
                        </div>
                      </div>

                      <div class="col-12 col-sm-12">
                     <div class=" text-right">
                       <a href="{{ route('portfolios.index') }}" class="btn btn-default">Go Back</a>
                     <button type="submit" class="btn btn-dark  waves-effect" id="save-portfolio" >Save</button>
                   </div>
                 </div>
                  </div>
                

           </div>
         </form>
                </div>
            </div>
        </div>
    </div>



  </div>
  <!-- /.container-fluid -->
</section>
</div>
@endsection

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Function to start the tour
        function startTour() {
            introJs().setOptions({
                steps: [
                    {
                        intro: "Welcome to <b>Add Portfolio Page</b>! Let's take a quick tour step by step to add your portfolio"
                    },
                    {
                        element: '#name-portfolio',
                        intro: 'Enter the <b>Porfolio Name</b> without to put number infront to the text </br></br><span class="text-danger"> Example: </br>-11234RHB i-trade</br>-Mahmut 0012 Maybank</span>'
                    },
                    {
                        element: '#inidepo-portfolio',
                        intro: 'Enter your <b> Initial Deposit</b> of the portfolio'
                    },
                    {
                        element: '#date-portfolio',
                        intro: 'Enter your <b> Deposit Date</b> of the portfolio'
                    },
                    {
                        element: '#save-portfolio',
                        intro: 'Click  <b> Save</b> to save your portfolio details'
                    },
                    {
                        intro: `
                            <div style="text-align: center;">
                                <p>Would you like to enable or disable the tour for future visits?</p>
                                <label class="form-check-label">
                                    <input type="radio"  name="tourOption" value="enable" checked> Show again next time
                                </label>
                                </br>
                                <label class="form-check-label">
                                    <input type="radio" name="tourOption" value="disable"> Don't show it again 
                                </label>
                            </div>

                         
                        `,
                        position: 'bottom'
                    }
                ]
            })
            .onbeforeexit(function () {
                return confirm("Stop!! Please complete the page tour before you exit! Are you sure you want to quit page tour?");
            })
            .oncomplete(function() {
                handleTourOption('seventhTourOption', 'seventhTourDisabled');
            })
            .onexit(function() {
                handleTourOption('seventhTourOption', 'seventhTourDisabled');
            })
            .start();
        }

        // Function to handle the tour option
        function handleTourOption() {
            const selectedOption = document.querySelector('input[name="tourOption"]:checked').value;
            if (selectedOption === 'disable') {
                // Save preference to localStorage or send to server
                localStorage.setItem('seventhTourDisabled', 'true');
            } else {
                localStorage.removeItem('seventhTourDisabled');
            }
        }

        // Check if the tour is disabled
        if (!localStorage.getItem('seventhTourDisabled')) {
            startTour();
        }
    });
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('restart-tour').addEventListener('click', function() {
        introJs().setOptions({
          steps: [
            {
                        intro: "Welcome to <b>Add Portfolio Page</b>! Let's take a quick tour step by step to add your portfolio"
                    },
                    {
                        element: '#name-portfolio',
                        intro: 'Enter the <b>Porfolio Name</b> without to put number infront to the text </br></br><span class="text-danger"> Example: </br>-11234RHB i-trade</br>-Mahmut 0012 Maybank</span>'
                    },
                    {
                        element: '#inidepo-portfolio',
                        intro: 'Enter your <b> Initial Deposit</b> of the portfolio'
                    },
                    {
                        element: '#date-portfolio',
                        intro: 'Enter your <b> Deposit Date</b> of the portfolio'
                    },
                    {
                        element: '#save-portfolio',
                        intro: 'Click  <b> Save</b> to save your portfolio details'
                    },
               
            ]
        })
      
        .start();
    });
   
});
    </script>