@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
                <div class="col-sm-6">
                  <span class="m-0 text-muted">Overview</span>
                  <h3 class="m-0"><strong>Permission</strong></h3>
                </div><!-- /.col -->
                <div  hidden="hidden" class="col-sm-6">
                  <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                    <li class="breadcrumb-item active">Dashboard</li>
                  </ol>
                </div><!-- /.col -->
              </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
  <!-- /.content-header -->

<section class="content">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-2">
          <div class="card-header  border-0">
          <h3 class="card-title"><strong>Roles List</strong></h3>
          <div class="card-tools">
            <div class="card-header border-0">
                         @can('role-create')
                             <span class="float-right">
                                 <a class="btn btn-primary" href="{{ route('permissions.create') }}">New Permission</a>
                             </span>
                         @endcan
                     </div>
       </div>
          </div>
          <div class="card-header border-0 ">
            <div class="text-right">
              <!-- Button trigger modal
                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#exampleModal1">
                  New Brand
                </button>-->
              <!-- End Button trigger modal -->
              <button type="button" class="btn btn-default" data-toggle="modal" data-target="#exampleModal1">
                New Users
              </button>
                </div>
              </div>
          <!-- /.card-header -->
          <div class="card-body">
            <!-- <table id="example1" class="table table-bordered table-striped"> -->
              <table id="example2" class="table  table-hover">
                <thead class="bg-warning">
              <tr class="text-center">
                <th>ID</th>
                <th>Permission Name</th>
                <th>Action</th>
              </tr>
              </thead>
              <tbody>
                @foreach ($data as $key => $permission)
              <tr class="text-center">
                <td class="align-middle">{{ $permission->id }}</td>
                <td class="align-middle" >{{ $permission->name }}</td>
                <td>
                  <a class="btn btn-light btn-sm btn-block waves-effect" href="{{ route('permissions.show',$permission->id) }}">Show</a>
                  @can('role-edit')
                  <a class="btn btn-light btn-sm btn-block waves-effect" href="{{ route('permissions.edit',$permission->id) }}">Edit</a>
                                @endcan
                                @can('role-delete')
                                    {!! Form::open(['method' => 'DELETE','route' => ['permissions.destroy', $permission->id],'style'=>'display:inline']) !!}
                                    {!! Form::submit('Delete', ['class' => 'btn btn-light btn-sm btn-block waves-effect']) !!}
                                    {!! Form::close() !!}
                                @endcan
                </td>

              </tr>
              @endforeach
              </tbody>
            </table>
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
@endsection
