<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable 
{
    use HasFactory, HasRoles, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function portfolio()
    {
        return $this->hasMany('App\Models\Portfolio');
    }

    public function transaction()
    {
        return $this->hasMany('App\Models\Transaction');
    }
    public function trade()
    {
        return $this->hasMany('App\Models\Trade');
    }
    public function result()
    {
        return $this->hasMany('App\Models\Result');
    }
    public function support()
    {
        return $this->hasMany('App\Models\Support');
    }
    public function ticket()
    {
        return $this->hasMany('App\Models\Ticket');
    }
    public function batchuser()
    {
        return $this->hasMany('App\Models\Batchuser');
    }
}
