<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SupportUserMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public $til;
    public $mes;
    public $tic;


    public function __construct($title, $message, $ticid)
    {
        $this->til = $title;
        $this->mes = $message;
        $this->tic = $ticid;

    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $e_subject = $this->til;
        $e_message = $this->mes;
        $e_ticid = $this->tic;


        return $this->view('mail.supportusermail', compact('e_message', 'e_subject', 'e_ticid'))->subject("Re:(Autoresponder) $e_subject");
    }
}
