<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public $til;
    public $mes;
    public $tic;
    public $sen;


    public function __construct($title, $message, $ticid, $sentuser)
    {
        $this->til = $title;
        $this->mes = $message;
        $this->tic = $ticid;
        $this->sen = $sentuser;

    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $e_subject = $this->til;
        $e_message = $this->mes;
        $e_tic = $this->tic;
        $e_sen = $this->sen;


        return $this->view('mail.sentmail', compact('e_tic','e_sen','e_message', 'e_subject'))->subject("Re:(Autoresponder) $e_subject");
    }
}
