<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;

use App\Models\Portfolio;
use App\Models\Stock;
use App\Models\Trade;
use App\Models\Brokerage;
use App\Models\Result;
use App\Models\Transaction;
use Illuminate\Support\Facades\Auth;
use DB;
use Carbon\Carbon;
use PDF;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\UsersImport;
use App\Exports\UsersExport;


class TradeController extends Controller
{
    /**
     * create a new instance of the class
     *
     * @return void
     */
    function __construct()
    {
         $this->middleware('permission:trade-list|trade-create|trade-edit|trade-delete', ['only' => ['index','store']]);
         $this->middleware('permission:trade-create', ['only' => ['create','store']]);
         $this->middleware('permission:trade-edit', ['only' => ['edit','update']]);
         $this->middleware('permission:trade-delete', ['only' => ['destroy']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      $counter = Stock::latest()->get();
      $broker = Brokerage::latest()->get();
      $data = Auth::user()->portfolio()->get();
        return view('trades.index',compact('data','counter','broker'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function create()
    {
      $counter = Stock::latest()->get();
      $data = DB::table('brokerages')->get();
      $data2 = DB::table('stocks')->get();
      $portfolio = Auth::user()->portfolio()->get();
      $portfolio2 = Auth::user()->portfolio()->first();

      return view('trades.create',compact('counter','data', 'portfolio','data2','portfolio2'));
    }

    public function GetSubCatAgainstMainCatEdit($id){
         echo json_encode(DB::table('brokerages')->where('id', $id)->get());
     }

     public function GetStockAgainstMainCatEdit($id){
          echo json_encode(DB::table('stocks')->where('id', $id)->get());
      }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
          'action' => 'required',
          'stock_name' => 'required',
          'price' => 'required',
          'quantity' => 'required',
          'date' => 'required',
          'remark' => 'required',

        ]);
        $trades = Auth::user()->trade()->where('stock_name','=', $request->input('stock_name'))->where('portfolio_id','=', $request->input('portfolio_id'))->first();
        $results = Auth::user()->trade()->where('stock_name','=', $request->input('stock_name'))->where('portfolio_id','=', $request->input('portfolio_id'));
        $stock_code = DB::table('results')
                        ->where('portfolio_id', $request->portfolio_id)
                        ->where('stock_id', $request->stock_id)
                         ->where('user_id', Auth::id())
                                ->select('id')
                                ->count();


        if ($trades === null){

          $result = new Result();
          /** $result->trade_id = $trade->id;**/
          $result->user_id = Auth::id();
          $result->stock_code = $request->stock_symbol . Auth::id() . $request->portfolio_id . $stock_code;
          $result->portfolio_id = $request->portfolio_id;
          $result->open_trade = $request->date;
          $result->stock_id = $request->stock_id;
          $result->stock_name = $request->stock_name;
          $result->stock_symbol = $request->stock_symbol;
          $result->average_buy = $request->price;
          $result->quantity_buy = $request->quantity;
          $result->quantity_bal = $request->quantity;
          //Subtotal Calculation//
          $subtotal = $request->price * $request->quantity;
          $result->subtotal_buy = $subtotal;
          //Brokerage Fee Calculation //
          $broker_f = $subtotal * $request->second_fees/100;
          if($broker_f  >= $request->first_fees){
            $broker_fees = $subtotal * $request->second_fees/100;
          }
          elseif($broker_f <= $request->first_fees){
            $broker_fees =  $request->first_fees;
          }
          //Clearing Fee Calculation//
          $clearing_f = $subtotal * 0.03/100;
          //Stamp Duty Fee Calculation//
          $stamp_d = ceil($subtotal/1000) * 1.50;
          //Total Fees  Calculation//
          $total_fees = $broker_fees + $clearing_f +  $stamp_d;
          $result->total_fees_buy = $total_fees;
          //Total Cost  Calculation//
          $total_c = $subtotal + $broker_fees + $clearing_f + $stamp_d ;
          $result->total_cost_buy = $total_c;
          $result->user_id = Auth::id();
          $result->save();

          $trade = new Trade();
          $trade->action = $request->action;
          $trade->status = 1 ;
          $trade->stock_code = $request->stock_symbol . Auth::id() . $request->portfolio_id . $stock_code;
          $trade->portfolio_id = $request->portfolio_id;
          $trade->stock_id = $request->stock_id;
          $trade->stock_name = $request->stock_name;
          $trade->stock_symbol = $request->stock_symbol;
          $trade->first_fees = $request->first_fees;
          $trade->price = $request->price;
          $trade->brokerage_id = $request->brokerage_id;
          $trade->quantity = $request->quantity;
          $trade->date = $request->date;
          $trade->remark = $request->remark;

          //Subtotal Calculation//
          $subtotal = $request->price * $request->quantity;
          $trade->subtotal = $subtotal;
          //Brokerage Fee Calculation //
          $broker_f = $subtotal * $request->second_fees/100;
          if($broker_f  >= $request->first_fees){
            $broker_fees = $subtotal * $request->second_fees/100;
            $trade->broker_fee = $broker_fees;
          }
          elseif($broker_f <= $request->first_fees){
            $broker_fees =  $request->first_fees;
            $trade->broker_fee = $broker_fees;
          }
          //Clearing Fee Calculation//
          $clearing_f = $subtotal * 0.03/100;
          $trade->clearing_fee = $clearing_f;
          //Stamp Duty Fee Calculation//
          $stamp_d = ceil($subtotal/1000) * 1.50;
          $trade->stamp_duty = $stamp_d;
           //Total Cost  Calculation//
          $total_c = $subtotal + $broker_fees + $clearing_f + $stamp_d ;
          $trade->total_cost = $total_c;

          $trade->user_id = Auth::id();
          $trade->result_id = $result->id;

          $trade->save();

          $get_stock_code = DB::table('results')
                    ->where('portfolio_id', $request->portfolio_id)
                    ->where('stock_id', $request->stock_id)
                     ->where('user_id', Auth::id())
                     ->pluck('stock_code')
                     ->first();

                            $broke_total_fee_all = Auth::user()->portfolio()
                                    ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                    ->where('portfolio_id', $request->portfolio_id)
                                    ->where('stock_code',  $get_stock_code)
                                    ->where('stock_id',  $request->stock_id)
                                    ->sum('broker_fee');

                                $clearing_total_fee_all = Auth::user()->portfolio()
                                        ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                        ->where('portfolio_id', $request->portfolio_id)
                                        ->where('stock_code',  $get_stock_code)
                                        ->where('stock_id',  $request->stock_id)
                                        ->sum('clearing_fee');

                                $stamp_total_fee_all = Auth::user()->portfolio()
                                        ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                        ->where('portfolio_id', $request->portfolio_id)
                                        ->where('stock_code',  $get_stock_code)
                                        ->where('stock_id',  $request->stock_id)
                                        ->sum('stamp_duty');

                                        $subtotal_fee_all = $broke_total_fee_all + $clearing_total_fee_all + $stamp_total_fee_all;

                                        $Result_Update = DB::table('results')
                                        ->where('portfolio_id', $request->portfolio_id)
                                        ->where('stock_code',  $get_stock_code)
                                        ->where('stock_id', $request->stock_id)
                                        ->where('user_id', Auth::id())
                                              ->update([
                                                "subtotal_fee" => $subtotal_fee_all,
                                                      ]);

                                      // Update into balance_avaiable(portfolio) Strat //
                                      $trans_update_buy = DB::table('transactions')
                                            ->insert([
                                              "portfolio_id" => $request->portfolio_id,
                                              "user_id" => Auth::id(),
                                              "stock_code" => $request->stock_symbol . Auth::id() . $request->portfolio_id . $stock_code,
                                              "type" => 'Buy',
                                              "amount" => $total_c,
                                              "remark" => 'Buy ' . $request->stock_symbol ,
                                              "stock_id" => $request->stock_id,
                                              "date" => $request->date,
                                              "created_at" => Carbon::now(),
                                              "updated_at" => Carbon::now(),
                                                    ]);

                                                    $total_available_balance_in_portfolio = Portfolio::where('id' , $request->portfolio_id)
                                                                                          ->where ('user_id', Auth::id())
                                                                                          ->pluck('balance_available')
                                                                                          ->first();

                                                     $subtotal_balance_available = $total_available_balance_in_portfolio - $total_c;

                                                    //total open counter (portfolio)
                                                    $total_open_counter = DB::table('results')
                                                    ->where('portfolio_id', $request->portfolio_id)
                                                    ->where('user_id', Auth::id())
                                                    ->whereNull('status')
                                                     ->count();

                                                     $portfolio_Update = DB::table('portfolios')
                                                      ->where('id', $request->portfolio_id)
                                                      ->where('user_id', Auth::id())
                                                            ->update([
                                                              "balance_available" => $subtotal_balance_available,
                                                              "open_counter" => $total_open_counter,
                                                                    ]);

                                    // Update into balance_avaiable(portfolio) End //



          }
          else {

            $get_stock_code = DB::table('results')
                      ->where('portfolio_id', $request->portfolio_id)
                      ->where('stock_id', $request->stock_id)
                       ->where('user_id', Auth::id())
                       ->pluck('stock_code')
                       ->first();

           $quantity_stock_code_balance =  DB::table('results')
                                     ->where('portfolio_id', $request->portfolio_id)
                                     ->where('stock_id', $request->stock_id)
                                     ->where('stock_code',  $get_stock_code)
                                     ->where('user_id', Auth::id())
                                     ->sum('quantity_bal');

           if ($quantity_stock_code_balance == '0'){

                       $result = new Result();
                       /** $result->trade_id = $trade->id;**/
                       $result->user_id = Auth::id();
                       $result->stock_code = $request->stock_symbol . Auth::id() . $request->portfolio_id . $stock_code;
                       $result->portfolio_id = $request->portfolio_id;
                       $result->open_trade = $request->date;
                       $result->stock_id = $request->stock_id;
                       $result->stock_name = $request->stock_name;
                       $result->stock_symbol = $request->stock_symbol;
                       $result->average_buy = $request->price;
                       $result->quantity_buy = $request->quantity;
                       $result->quantity_bal = $request->quantity;
                       //Subtotal Calculation//
                       $subtotal = $request->price * $request->quantity;
                       $result->subtotal_buy = $subtotal;
                       //Brokerage Fee Calculation //
                       $broker_f = $subtotal * $request->second_fees/100;
                       if($broker_f  >= $request->first_fees){
                         $broker_fees = $subtotal * $request->second_fees/100;
                       }
                       elseif($broker_f <= $request->first_fees){
                         $broker_fees =  $request->first_fees;
                       }
                       //Clearing Fee Calculation//
                       $clearing_f = $subtotal * 0.03/100;
                       //Stamp Duty Fee Calculation//
                       $stamp_d = ceil($subtotal/1000) * 1.50;
                       //Total Fees  Calculation//
                       $total_fees = $broker_fees + $clearing_f +  $stamp_d;
                       $result->total_fees_buy = $total_fees;
                       //Total Cost  Calculation//
                       $total_c = $subtotal + $broker_fees + $clearing_f + $stamp_d ;
                       $result->total_cost_buy = $total_c;
                       $result->user_id = Auth::id();
                       $result->save();

                       $trade = new Trade();
                       $trade->action = $request->action;
                       $trade->status = 1 ;
                       $trade->stock_code = $request->stock_symbol . Auth::id() . $request->portfolio_id . $stock_code;
                       $trade->portfolio_id = $request->portfolio_id;
                       $trade->stock_id = $request->stock_id;
                       $trade->stock_name = $request->stock_name;
                       $trade->stock_symbol = $request->stock_symbol;
                       $trade->first_fees = $request->first_fees;
                       $trade->price = $request->price;
                       $trade->brokerage_id = $request->brokerage_id;
                       $trade->quantity = $request->quantity;
                       $trade->date = $request->date;
                       $trade->remark = $request->remark;

                       //Subtotal Calculation//
                       $subtotal = $request->price * $request->quantity;
                       $trade->subtotal = $subtotal;
                       //Brokerage Fee Calculation //
                       $broker_f = $subtotal * $request->second_fees/100;
                       if($broker_f  >= $request->first_fees){
                         $broker_fees = $subtotal * $request->second_fees/100;
                         $trade->broker_fee = $broker_fees;
                       }
                       elseif($broker_f <= $request->first_fees){
                         $broker_fees =  $request->first_fees;
                         $trade->broker_fee = $broker_fees;
                       }
                       //Clearing Fee Calculation//
                       $clearing_f = $subtotal * 0.03/100;
                       $trade->clearing_fee = $clearing_f;
                       //Stamp Duty Fee Calculation//
                       $stamp_d = ceil($subtotal/1000) * 1.50;
                       $trade->stamp_duty = $stamp_d;
                        //Total Cost  Calculation//
                       $total_c = $subtotal + $broker_fees + $clearing_f + $stamp_d ;
                       $trade->total_cost = $total_c;

                       $trade->user_id = Auth::id();
                       $trade->result_id = $result->id;

                       $trade->save();


                                         $broke_total_fee_all = Auth::user()->portfolio()
                                                 ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                                 ->where('portfolio_id', $request->portfolio_id)
                                                 ->where('stock_id',  $request->stock_id)
                                                 ->where('stock_code',  $get_stock_code)
                                                 ->sum('broker_fee');

                                             $clearing_total_fee_all = Auth::user()->portfolio()
                                                     ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                                     ->where('portfolio_id', $request->portfolio_id)
                                                     ->where('stock_id',  $request->stock_id)
                                                     ->where('stock_code',  $get_stock_code)
                                                     ->sum('clearing_fee');

                                             $stamp_total_fee_all = Auth::user()->portfolio()
                                                     ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                                     ->where('portfolio_id', $request->portfolio_id)
                                                     ->where('stock_id',  $request->stock_id)
                                                     ->where('stock_code',  $get_stock_code)
                                                     ->sum('stamp_duty');

                                                     $subtotal_fee_all = $broke_total_fee_all + $clearing_total_fee_all + $stamp_total_fee_all;

                                                     $Result_Update = DB::table('results')
                                                     ->where('portfolio_id', $request->portfolio_id)
                                                     ->where('stock_id', $request->stock_id)
                                                     ->where('stock_code',  $get_stock_code)
                                                     ->where('user_id', Auth::id())
                                                           ->update([
                                                             "subtotal_fee" => $subtotal_fee_all,
                                                                   ]);

                                                                   // Update into balance_avaiable(portfolio) Strat //
                                                                   $trans_update_buy = DB::table('transactions')
                                                                         ->insert([
                                                                           "portfolio_id" => $request->portfolio_id,
                                                                           "user_id" => Auth::id(),
                                                                           "stock_code" => $request->stock_symbol . Auth::id() . $request->portfolio_id . $stock_code,
                                                                           "type" => 'Buy',
                                                                           "amount" => $total_c,
                                                                           "remark" => 'Buy ' . $request->stock_symbol ,
                                                                           "stock_id" => $request->stock_id,
                                                                           "date" => $request->date,
                                                                           "created_at" => Carbon::now(),
                                                                           "updated_at" => Carbon::now(),
                                                                                 ]);


                                                                 $total_available_balance_in_portfolio = Portfolio::where('id' , $request->portfolio_id)
                                                                                                       ->where ('user_id', Auth::id())
                                                                                                       ->pluck('balance_available')
                                                                                                       ->first();

                                                                  $subtotal_balance_available = $total_available_balance_in_portfolio - $total_c;

                                                                   //total open counter (portfolio)
                                                                    $total_open_counter = DB::table('results')
                                                                    ->where('portfolio_id', $request->portfolio_id)
                                                                    ->where('user_id', Auth::id())
                                                                    ->whereNull('status')
                                                                    ->count();

                                                                  $portfolio_Update = DB::table('portfolios')
                                                                   ->where('id', $request->portfolio_id)
                                                                   ->where('user_id', Auth::id())
                                                                         ->update([
                                                                           "balance_available" => $subtotal_balance_available,
                                                                           "open_counter" => $total_open_counter,
                                                                                 ]);

                                                                 // Update into balance_avaiable(portfolio) End //
           } else {

           }
        }


        /**$trade->result()->attach($request->portfolio_id);**/


        //return redirect()->back()
        //return redirect()->route('trades.statistic')
        return redirect()->route('trades.statistic', ['id' => $request->portfolio_id])
            ->with('success','Trade created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
      return view('tardes.show');
    }
    public function tradeHistory($id)
    {
      $data = Auth::user()->result()
            ->join('trades', 'results.id', '=', 'trades.result_id')
            ->where('result_id', $id)
            ->get();

            $result = Auth::user()->result()->find($id);




       //$datax = Result::find($id);
       //$datac = $datax->average_buy;

    //  return $datac;
    //return $data;
      //return $result;
      return view('trades.history',compact('data','result','id'));
    }

    public function createPDF($id) {
      // retreive all records from db
      //$complaint = Auth::user()->complaint()->latest()->get()->find($id);
      $result = Auth::user()->result()
            ->where('portfolio_id', $id)
            ->get();

            $trade = Auth::user()->trade()
                  ->where('portfolio_id', $id)
                  ->get();

      $portfolio = Portfolio::find($id);

      // share data to view
      $pdf = PDF::setOptions(['isRemoteEnabled' => true])->loadView('trades.print',compact('result','trade','portfolio'))->setPaper('a4', 'portrait');
     //return $pdf->stream();
      // download PDF file with download method
      return $pdf->download('TradeStatistic.pdf');
}

public function fileExport()
   {
       return Excel::download(new UsersExport, 'user_list.xlsx');
   }

    public function tradeStatistic(Trade $trade, $id)
    {
      //$data = Auth::user()->trade()->where('status', 1)
      //->crossJoin('portfolios')
      //->get();
      //$trade = Trade::find($id);

      $fund_available = Portfolio::where('id' , $id)
                          ->where ('user_id', Auth::id())
                          ->pluck('balance_available')
                          ->first();

    //      $buy = Auth::user()->portfolio()
    //            ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
    //            ->where('portfolio_id', $id)
    //             ->where('action', 'buy')
    //             ->count();

    //             $trade_count = Auth::user()->portfolio()
    //                   ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
    //                   ->where('portfolio_id', $id)
    //                    ->where('action', 'buy')
    //               ->sum('price');

      //             $average_buy = $trade_count / $buy  ;



      //$Result_Update = DB::table('results')
      //->where('portfolio_id', $id)
            //->update(["average_buy" => $average_buy]);

       $trans = Auth::user()->transaction()->where('portfolio_id', $id)
              ->get();

       $initial = Transaction::where('portfolio_id' , $id)
                           ->where ('type', 'Initial')
                           ->sum('amount');

       $deposit = Transaction::where('portfolio_id' , $id)
                           ->where ('type', 'Deposit')
                           ->sum('amount');

       $withdraw = Transaction::where('portfolio_id' , $id)
                           ->where ('type', 'Withdraw')
                           ->sum('amount');

       $profit = Transaction::where('portfolio_id' , $id)
                           ->where ('type', 'Profit')
                           ->sum('amount');

       $winnings = Transaction::where('portfolio_id' , $id)
                          ->where ('type', 'Profit')
                          ->count();

       $lossing = Transaction::where('portfolio_id' , $id)
                          ->where ('type', 'Loss')
                          ->count();

       $loss = Transaction::where('portfolio_id' , $id)
                           ->where ('type', 'Loss')
                           ->sum('amount');


       $total_q = $profit + $loss;

       $total = $initial + $total_q - $withdraw + $deposit;

       $roi_port = ($total - $initial) / $initial *100;

      $portfolio = Portfolio::find($id);

      $data = Auth::user()->result()
            ->where('portfolio_id', $id)
            ->get();

     // $data_counter = Auth::user()->result()
       //     ->where('portfolio_id', $id)
         //   ->whereNull('status')
           // ->count();

                 //$data = Auth::user()->result()->where('status', 1)
      //->crossJoin('portfolios')
      //->get();
      //$trade = Trade::find($id);

      $result = DB::table('results')
            ->where('portfolio_id',$id)
            ->where('user_id', Auth::id())
            ->get();


            $total_deposit =   Transaction::where('portfolio_id' , $id)
                                  ->where ('type', 'Deposit')
                                  ->whereYear('date', date('Y'))
                                  ->select(DB::raw("SUM(amount) as count"))
                         ->groupBy(DB::raw("month(date)"))
                         ->pluck('count');

            $total_withdraw =   Transaction::where('portfolio_id' , $id)
                                 ->where ('type', 'Withdraw')
                                 ->whereYear('date', date('Y'))
                                 ->select(DB::raw("SUM(amount) as count"))
                        ->groupBy(DB::raw("month(date)"))
                        ->pluck('count');



           $total_loss =   Transaction::where('portfolio_id' , $id)
                                ->where ('type', 'Loss')
                                ->whereYear('date', date('Y'))
                                ->select(DB::raw("SUM(amount) as count"))
                       ->groupBy(DB::raw("month(date)"))
                       ->pluck('count');

                        $total_profit_loss = Portfolio::where('id' , $id)
                                 ->select(DB::raw("SUM(total_profit) as count"))
                                 ->whereYear('created_at', date('Y'))
                        ->groupBy(DB::raw("month(created_at)"))
                        ->pluck('count');

                      $balance =   Transaction::where('portfolio_id' , $id)
                                           ->where ('type', 'Loss')
                                          ->whereYear('date', date('Y'))
                                          ->select(DB::raw("SUM(amount) as count"))
                                 ->groupBy(DB::raw("month(date)"))
                                 ->pluck('count');


                      $balance_available =Portfolio::where('id' , $id)
                              ->select(DB::raw("SUM(balance_available) as count"))
                              ->whereYear('created_at', date('Y'))
                     ->groupBy(DB::raw("month(created_at)"))
                    ->pluck('count');

                        // Profit Date




                      //  $date_available =Transaction::where('id' , $id)
                      //           ->select(DB::raw("SUM(balance_available) as count"))
                      //           ->whereYear('created_at', date('Y'))
                      //  ->groupBy(DB::raw("month(created_at)"))
                      //  ->pluck('count');
                      $total_profit =   Transaction::where('portfolio_id' , $id)
                                           ->where ('type', 'Profit')
                                           ->whereYear('date', date('Y'))
                                           ->select(DB::raw("SUM(amount) as count"))
                                //  ->groupBy(DB::raw("month(date)"))
                                  ->pluck('count');

                      $total_net_profit =   Result::where('portfolio_id' , $id)
                                           ->whereYear('close_trade', date('Y'))
                                          // ->whereMonth('close_trade', date('m'))
                                          //->select(DB::raw("SUM(amount) as count"))
                                          //->select("net_profit as count")
                                           ->select(DB::raw("net_profit as count"))
                                           //->groupBy(DB::raw("month(created_at)"))
                                           //->groupBy(DB::raw("month(close_trade)"))
                                  ->pluck('count');



                                              $total_available_balance_in_portfolio = Portfolio::where('id' , '47')
                                                                                    ->where ('user_id', Auth::id())
                                                                                    ->pluck('balance_available')
                                                                                    ->first();

                                                                                    $total_profit_date =   Result::where('portfolio_id' , $id)
                                                                                                         ->whereYear('close_trade', date('Y'))
                                                                                                        // ->whereMonth('close_trade', date('m'))
                                                                                                        //->select(DB::raw("SUM(amount) as count"))
                                                                                                         ->select("close_trade as count")
                                                                                              //  ->groupBy(DB::raw("month(close_trade)"))
                                                                                                ->pluck('count');


                                                                                    $afif =   Result::where('portfolio_id' , $id)
                                                                                                         ->whereYear('close_trade', date('Y'))
                                                                                                         ->select('net_profit as count')
                                                                                                ->pluck('count');

                        $loss_available = Transaction::where('portfolio_id' , $id)
                                                  ->where ('type', 'Profit')
                                                  ->whereMonth('date', date('m'))
                                                  ->select(DB::raw("amount as count"))
                                         ->pluck('count');


                      //$total_harga = Result::where('portfolio_id' , $id)
                      //->select(DB::raw("SUM(net_profit) as total_harga"))
                      //->whereYear('close_trade', date('Y'))
                      //->GroupBy(DB::raw("close_trade"))
                      //->pluck("total_harga");

                      $total_harga = Result::where('portfolio_id', $id)
                      ->whereNotNull('status')
                      ->pluck('net_profit')
                      ->toArray();
                      
                      $bulan = Result::where('portfolio_id', $id)
                      ->select(DB::raw('DATE_FORMAT(close_trade, "%d/%b/%Y") as bulan'))
                      ->pluck('bulan')
                      ->toArray();

                    //  $bulan = Result::where('portfolio_id' , $id)
                    //  ->select(DB::raw("MONTHNAME(close_trade) as bulan"))
                    //  ->GroupBy(DB::raw("MONTHNAME(close_trade)"))
                    //  ->pluck('bulan');

                   // $total_harga2 = Transaction::where('portfolio_id' , $id)
                    //->where('type','Profit')
                    //->select(DB::raw("SUM(amount) as total_harga"))
                    //->whereYear('date', date('Y'))
                    //->GroupBy(DB::raw("Month(date)"))
                    //->pluck("total_harga");

                    //$total_harga3 = Transaction::where('portfolio_id' , $id)
                    //->where('type','Loss')
                    //->select(DB::raw("SUM(amount) as total_harga"))
                    //->whereYear('date', date('Y'))
                    //->GroupBy(DB::raw("Month(date)"))
                    //->pluck("total_harga");

                    $total_harga2 = Transaction::where('portfolio_id' , $id)
                    ->where('type','Profit')
                    ->pluck("amount")
                    ->toArray();


                    $total_harga3 = Transaction::where('portfolio_id' , $id)
                    ->where('type','Loss')
                    ->pluck("amount")
                    ->toArray();

                    $bulan2 = Result::where('portfolio_id', $id)
                    ->select(DB::raw('DATE_FORMAT(close_trade, "%d/%b/%Y") as bulan'))
                    ->pluck('bulan')
                    ->toArray();

                    //$bulan2 = Transaction::where('portfolio_id' , $id)
                     //->select(DB::raw("MONTHNAME(date) as bulan"))
                     //->GroupBy(DB::raw("MONTHNAME(date)"))
                     //->pluck('bulan');

// Fetch monthly profits ordered by month and year ascending
$monthlyProfits = Transaction::where('portfolio_id', $id)
    ->where('type', 'Profit')
    ->select(DB::raw('MONTH(date) as month'), DB::raw('YEAR(date) as year'), DB::raw('SUM(amount) as total'))
    ->groupBy(DB::raw('YEAR(date)'), DB::raw('MONTH(date)'))
    ->orderBy(DB::raw('YEAR(date)'), 'asc')
    ->orderBy(DB::raw('MONTH(date)'), 'asc')
    ->pluck('total', 'month')
    ->toArray();

// Fetch monthly losses (as negative values) ordered by month and year ascending
$monthlyLosses = Transaction::where('portfolio_id', $id)
    ->where('type', 'Loss')
    ->select(DB::raw('MONTH(date) as month'), DB::raw('YEAR(date) as year'), DB::raw('SUM(amount) as total'))
    ->groupBy(DB::raw('YEAR(date)'), DB::raw('MONTH(date)'))
    ->orderBy(DB::raw('YEAR(date)'), 'asc')
    ->orderBy(DB::raw('MONTH(date)'), 'asc')
    ->pluck('total', 'month')
    ->toArray();

// Fetch formatted month names and years ordered by month and year ascending
$months = Transaction::where('portfolio_id', $id)
    ->select(DB::raw('DISTINCT MONTH(date) as month'), DB::raw('YEAR(date) as year'), DB::raw('DATE_FORMAT(date, "%M %Y") as month_year'))
    ->orderBy(DB::raw('YEAR(date)'), 'asc')
    ->orderBy(DB::raw('MONTH(date)'), 'asc')
    ->pluck('month_year', 'month')
    ->toArray();

// Initialize arrays for Highcharts
$profits = [];
$losses = [];
foreach ($months as $month => $monthYear) {
    $profits[] = isset($monthlyProfits[$month]) ? (float)$monthlyProfits[$month] : 0;
    $losses[] = isset($monthlyLosses[$month]) ? (float)$monthlyLosses[$month] : 0; // Negate losses
}

// Prepare data for Highcharts
$chartData = [
    'categories' => array_values($months), // Month and Year labels
    'profits' => $profits,
    'losses' => $losses,
];

// Pass $chartData to your Highcharts view for rendering

      //return $total_harga3;
      //return $average_buy;
      //return $data_counter;

      //return view('trades.statistic',compact('profit_available','balance_available','total_profit','total_loss','total_deposit','total_withdraw','total_profit_loss','data','trans','portfolio','result','initial','deposit','withdraw','profit','total','loss','winnings','lossing','total_q','roi_port' ));
      return view('trades.statistic',compact('fund_available','bulan2','total_harga3','total_harga2','bulan','total_harga','loss_available','total_net_profit','total_profit_date','balance_available','total_profit','total_loss','total_deposit','total_withdraw','total_profit_loss','data','trans','portfolio','result','initial','deposit','withdraw','profit','total','loss','winnings','lossing','total_q','roi_port','profits', 'losses', 'months' , 'monthlyProfits' , 'monthlyLosses'));
    }

    public function sellTrade($id)
    {

      $result = Auth::user()->result()
            ->join('trades', 'results.id', '=', 'trades.result_id')
            ->join('brokerages', 'brokerages.id', '=', 'trades.brokerage_id')
            ->find($id);
            //->where('result_id', $id)
            //->get();
      //return $result;
      $result2 = Auth::user()->result()->find($id);

      return view('trades.sell',compact('result','result2'));
    }

    public function buyTrade($id)
    {

      $result = Auth::user()->result()
            ->join('trades', 'results.id', '=', 'trades.result_id')
            ->join('brokerages', 'brokerages.id', '=', 'trades.brokerage_id')
            ->find($id);
            //->where('result_id', $id)
            //->get();
      //return $result;
      $result2 = Auth::user()->result()->find($id);

      return view('trades.buy',compact('result','result2'));
    }
    public function sellStore()
    {

    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
      $data = Auth::user()->portfolio()
       ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')->where('status', 1)
       ->where('portfolio_id', $id)
       ->get();

       $trans = Auth::user()->transaction()->where('portfolio_id', $id)
              ->get();

       //return $data;
       return view('trades.edit',compact('data','trans' ));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
      $trade = Trade::find($id);
      $data = $trade->action;
      $data_status = $trade->status;
      $data_result = $trade->result_id;
      $data_portfolio = $trade->portfolio_id;
      $data_user = $trade->user_id;
      $data_stock = $trade->stock_id;
      $data_code = $trade->stock_code;
      $data_code = $trade->stock_code;
      $data_date = $trade->date;
      $data_total_cost = $trade->total_cost;

      if ($data == 'buy')
      {
        if($data_status == '1')
        {
          //Delete Profit into Balance Available Start //
                   $last_sell_history = Trade::where('result_id', $data_result)
                      ->where('portfolio_id', $data_portfolio)
                      ->where('user_id',   $data_user)
                      ->where('date',  $data_date)
                      ->pluck('total_cost')
                      ->first();

                   $total_available_balance = Portfolio::where('id' , $data_portfolio)
                                                         ->where ('user_id',  $data_user)
                                                         ->pluck('balance_available')
                                                         ->first();

                   $subtotal_balance_available = $total_available_balance + $last_sell_history;
                   $portfolio_update_balance = DB::table('portfolios')
                    ->where('id', $data_portfolio)
                    ->where('user_id', $data_user)
                          ->update([
                            "balance_available" => $subtotal_balance_available,
                                  ]);
          //Delete Profit into Balance Available End //
          //Delete Profit Transaction  into transaction Start //
                    Transaction::where('portfolio_id', $data_portfolio)
                      ->where ('type','Buy')
                      ->where('user_id',   $data_user)
                      ->where('stock_id',  $data_stock)
                      ->where('date',  $data_date)
                      ->where('stock_code',  $data_code)
                      ->delete();
          //Delete Profit Transaction  into transaction End //

            Trade::find($id)->delete();
            $Result_Update = DB::table('results')
                          ->where('id', $data_result)->delete();


             $win =  Result::where('portfolio_id' , $data_portfolio)
                               ->where ('user_id', $data_user)
                               ->where ('status', 'WIN')
                               ->count();

            $loss =  Result::where('portfolio_id' , $data_portfolio)
                              ->where ('user_id', $data_user)
                               ->where ('status', 'LOSS')
                               ->count();

             $profit_eq =  Result::where('portfolio_id' , $data_portfolio)
                               ->where ('user_id', $data_user)
                               ->where ('status', 'WIN')
                               ->sum('net_profit');

             $loss_eq = Result::where('portfolio_id' , $data_portfolio)
                               ->where ('user_id', $data_user)
                                ->where ('status', 'LOSS')
                                 ->sum('net_profit');

             $total_q = $profit_eq + $loss_eq;
             $initial = Transaction::where('portfolio_id' , $data_portfolio)
                                 ->where ('user_id', $data_user)
                                 ->where ('type', 'Initial')
                                 ->sum('amount');

             $deposit = Transaction::where('portfolio_id' , $data_portfolio)
                                 ->where ('user_id', $data_user)
                                 ->where ('type', 'Deposit')
                                 ->sum('amount');

             $withdraw = Transaction::where('portfolio_id' , $data_portfolio)
                                 ->where ('user_id', $data_user)
                                 ->where ('type', 'Withdraw')
                                 ->sum('amount');

             $profit = Transaction::where('portfolio_id' , $data_portfolio)
                                 ->where ('user_id', $data_user)
                                 ->where ('type', 'Profit')
                                 ->sum('amount');

             $winnings = Transaction::where('portfolio_id' , $data_portfolio)
                                 ->where ('user_id', $data_user)
                                ->where ('type', 'Profit')
                                ->count();

             $lossing = Transaction::where('portfolio_id' , $data_portfolio)
                                 ->where ('user_id', $data_user)
                                ->where ('type', 'Loss')
                                ->count();

             $sub_total = $initial + $total_q - $withdraw + $deposit;

             $roi_port = ($sub_total - $initial) / $initial *100;

                               //total close counter (portfolio)
                               $total_close_counter = DB::table('results')
                               ->where('portfolio_id', $request->portfolio_id)
                               ->where('user_id', Auth::id())
                               ->whereNotNull('status') 
                               ->count();
             
                               //total open counter (portfolio)
                               $total_open_counter = DB::table('results')
                               ->where('portfolio_id', $request->portfolio_id)
                               ->where('user_id', Auth::id())
                               ->whereNull('status')
                               ->count();

                           $portfolio_update = DB::table('portfolios')
                           ->where('id', $data_portfolio)
                           ->where('user_id', $data_user)
                           ->update([
                                   "win" => $win,
                                   "loss" => $loss,
                                   "total_profit" => $total_q,
                                   'roi_port' =>$roi_port,
                                   "open_counter" => $total_open_counter,
                                   "close_counter" => $total_close_counter,

                           ]);

       return redirect()->route('trades.statistic', ['id' => $data_portfolio])
                  ->with('success','Trade successfully delete.');

        }
        else {

          //Delete Profit into Balance Available Start //
                   $last_sell_history = Trade::where('result_id', $data_result)
                      ->where('portfolio_id', $data_portfolio)
                      ->where('user_id',   $data_user)
                      ->where('date',  $data_date)
                      ->pluck('total_cost')
                      ->first();

                   $total_available_balance = Portfolio::where('id' , $data_portfolio)
                                                         ->where ('user_id',  $data_user)
                                                         ->pluck('balance_available')
                                                         ->first();

                   $subtotal_balance_available = $total_available_balance + $last_sell_history;

                                  //total close counter (portfolio)
                                  $total_close_counter = DB::table('results')
                                  ->where('portfolio_id', $data_portfolio)
                                  ->where('user_id', $data_user)
                                  ->whereNotNull('status') 
                                  ->count();

                                  //total open counter (portfolio)
                                  $total_open_counter = DB::table('results')
                                  ->where('portfolio_id', $data_portfolio)
                                  ->where('user_id', $data_user)
                                  ->whereNull('status')
                                  ->count();

                   $portfolio_update_balance = DB::table('portfolios')
                    ->where('id', $data_portfolio)
                    ->where('user_id', $data_user)
                          ->update([
                            "balance_available" => $subtotal_balance_available,
                            "open_counter" => $total_open_counter,
                            "close_counter" => $total_close_counter,
                                  ]);

          //Delete Profit into Balance Available End //
          //Delete Profit Transaction  into transaction Start //
                    Transaction::where('portfolio_id', $data_portfolio)
                      ->where ('type','Buy')
                      ->where('user_id',   $data_user)
                      ->where('stock_id',  $data_stock)
                      ->where('date',  $data_date)
                      ->where('stock_code',  $data_code)
                      ->delete();
          //Delete Profit Transaction  into transaction End //

          Trade::find($id)->delete();
          //Average Buy//
          $open_buy = Trade::where('result_id', $data_result)
                ->where('action', 'buy')
                ->sum('price');

          $trade_count = Trade::where('result_id', $data_result)
                  ->where('action', 'buy')
                  ->count();

          $average_buy = $open_buy / $trade_count;

          //Quantity Buy//
          $sum_quantity = Trade::where('result_id', $data_result)
                ->where('action', 'buy')
                  ->sum('quantity');

          //Total Fees Buy //
          $broke_total_fee= Trade::where('result_id', $data_result)
                                  ->where('action', 'buy')
                                  ->sum('broker_fee');

          $clearing_total_fee = Trade::where('result_id', $data_result)
                                      ->where('action', 'buy')
                                      ->sum('clearing_fee');

          $stamp_total_fee = Trade::where('result_id', $data_result)
                                      ->where('action', 'buy')
                                      ->sum('stamp_duty');

          $subtotal_fee = $broke_total_fee + $clearing_total_fee + $stamp_total_fee;

          //SubTotal Buy //
          $subtotal_cost_buy = Trade::where('result_id', $data_result)
                                      ->where('action', 'buy')
                                      ->sum('total_cost');


          //Total Cous Buy//
          $subtotal_buy_result= Trade::where('result_id', $data_result)
                                      ->where('action', 'buy')
                                      ->sum('subtotal');

                  $Result_Update = DB::table('results')
                                ->where('id', $data_result)
                                ->update(
                                  ["average_buy" => $average_buy,
                                  "quantity_buy" => $sum_quantity,
                                  "total_fees_buy" => $subtotal_fee,
                                  "subtotal_buy" => $subtotal_buy_result,
                                  "total_cost_buy" => $subtotal_cost_buy,
                                  "quantity_bal" => $sum_quantity,
                                  "gross_profit" => Null,
                                  "gross_roi" => Null,
                                  "net_profit" => Null,
                                  "net_roi" => Null,
                                  "status" => Null]
                                );

                                $win =  Result::where('portfolio_id' , $data_portfolio)
                                                   ->where ('user_id', $data_user)
                                                   ->where ('status', 'WIN')
                                                   ->count();

                                $loss =  Result::where('portfolio_id' , $data_portfolio)
                                                  ->where ('user_id', $data_user)
                                                   ->where ('status', 'LOSS')
                                                   ->count();

                                 $profit_eq =  Result::where('portfolio_id' , $data_portfolio)
                                                   ->where ('user_id', $data_user)
                                                   ->where ('status', 'WIN')
                                                   ->sum('net_profit');

                                 $loss_eq = Result::where('portfolio_id' , $data_portfolio)
                                                   ->where ('user_id', $data_user)
                                                    ->where ('status', 'LOSS')
                                                     ->sum('net_profit');

                                 $total_q = $profit_eq + $loss_eq;
                                 $initial = Transaction::where('portfolio_id' , $data_portfolio)
                                                     ->where ('user_id', $data_user)
                                                     ->where ('type', 'Initial')
                                                     ->sum('amount');

                                 $deposit = Transaction::where('portfolio_id' , $data_portfolio)
                                                     ->where ('user_id', $data_user)
                                                     ->where ('type', 'Deposit')
                                                     ->sum('amount');

                                 $withdraw = Transaction::where('portfolio_id' , $data_portfolio)
                                                     ->where ('user_id', $data_user)
                                                     ->where ('type', 'Withdraw')
                                                     ->sum('amount');

                                 $profit = Transaction::where('portfolio_id' , $data_portfolio)
                                                     ->where ('user_id', $data_user)
                                                     ->where ('type', 'Profit')
                                                     ->sum('amount');

                                 $winnings = Transaction::where('portfolio_id' , $data_portfolio)
                                                     ->where ('user_id', $data_user)
                                                    ->where ('type', 'Profit')
                                                    ->count();

                                 $lossing = Transaction::where('portfolio_id' , $data_portfolio)
                                                     ->where ('user_id', $data_user)
                                                    ->where ('type', 'Loss')
                                                    ->count();

                                 $sub_total = $initial + $total_q - $withdraw + $deposit;

                                 $roi_port = ($sub_total - $initial) / $initial *100;

                                  //total close counter (portfolio)
                                  $total_close_counter = DB::table('results')
                                  ->where('portfolio_id', $data_portfolio)
                                  ->where('user_id', $data_user)
                                  ->whereNotNull('status') 
                                  ->count();

                                  //total open counter (portfolio)
                                  $total_open_counter = DB::table('results')
                                  ->where('portfolio_id', $data_portfolio)
                                  ->where('user_id', $data_user)
                                  ->whereNull('status')
                                  ->count();

                                               $portfolio_update = DB::table('portfolios')
                                               ->where('id', $data_portfolio)
                                               ->where('user_id', $data_user)
                                               ->update([
                                                       "win" => $win,
                                                       "loss" => $loss,
                                                       "total_profit" => $total_q,
                                                       'roi_port' =>$roi_port,
                                                       "open_counter" => $total_open_counter,
                                                       "close_counter" => $total_close_counter,


                                               ]);




        }

      }
      elseif ($data == 'sell')   {

        //Delete Profit into Balance Available Start //
                 $last_sell_history = Trade::where('result_id', $data_result)
                    ->where('portfolio_id', $data_portfolio)
                    ->where('user_id',   $data_user)
                    ->where('date',  $data_date)
                    ->pluck('total_cost')
                    ->first();

                 $total_available_balance = Portfolio::where('id' , $data_portfolio)
                                                       ->where ('user_id',  $data_user)
                                                       ->pluck('balance_available')
                                                       ->first();

                 $subtotal_balance_available = $total_available_balance - $last_sell_history;

                                  //total close counter (portfolio)
                                  $total_close_counter = DB::table('results')
                                  ->where('portfolio_id', $data_portfolio)
                                  ->where('user_id', $data_user)
                                  ->whereNotNull('status') 
                                  ->count();

                                  //total open counter (portfolio)
                                  $total_open_counter = DB::table('results')
                                  ->where('portfolio_id', $data_portfolio)
                                  ->where('user_id', $data_user)
                                  ->whereNull('status')
                                  ->count();

                 $portfolio_update_balance = DB::table('portfolios')
                  ->where('id', $data_portfolio)
                  ->where('user_id', $data_user)
                        ->update([
                          "balance_available" => $subtotal_balance_available,
                          "open_counter" => $total_open_counter,
                          "close_counter" => $total_close_counter,
                                ]);
        //Delete Profit into Balance Available End //

        //Delete Profit Transaction  into transaction Start //

                  Transaction::where('portfolio_id', $data_portfolio)
                    ->where ('type','Profit')
                    ->where('user_id',   $data_user)
                    ->where('stock_id',  $data_stock)
                    ->where('date',  $data_date)
                    ->where('stock_code',  $data_code)
                    ->delete();
        //Delete Profit Transaction  into transaction End //
        //Delete Loss Transaction  into transaction Start //

                  Transaction::where('portfolio_id', $data_portfolio)
                    ->where ('type','Loss')
                    ->where('user_id',   $data_user)
                    ->where('stock_id',  $data_stock)
                    ->where('date',  $data_date)
                    ->where('stock_code',  $data_code)
                    ->delete();
        //Delete Loss Transaction  into transaction End //
        //Delete Profit Transaction  into transaction Start //
                  Transaction::where('portfolio_id', $data_portfolio)
                    ->where ('type','Sell')
                    ->where('user_id',   $data_user)
                    ->where('stock_id',  $data_stock)
                    ->where('date',  $data_date)
                    ->where('stock_code',  $data_code)
                    ->delete();
        //Delete Profit Transaction  into transaction End //

          Trade::find($id)->delete();

          $sum_quantity = Trade::where('result_id', $data_result)
                  ->where('action', 'sell')
                  ->sum('quantity');

           $sum_quantity_buy = Trade::where('result_id', $data_result)
                   ->where('action', 'buy')
                   ->sum('quantity');

           $balance_quantity =   $sum_quantity_buy -   $sum_quantity;

                  $Result_Update = DB::table('results')
                                ->where('id', $data_result)
                                ->update(
                                  ["close_trade" => Null,
                                  "average_sell" => Null,
                                  "quantity_sell" => Null,
                                  "total_fees_sell" => Null,
                                  "subtotal_sell" => Null,
                                  "total_sell_cost" => Null,
                                  "quantity_bal" => $balance_quantity,
                                  "gross_profit" => Null,
                                  "gross_roi" => Null,
                                  "net_profit" => Null,
                                  "net_roi" => Null,
                                  "status" => Null]
                                );

              //Update into portfolio Start //
              $win =  Result::where('portfolio_id' , $data_portfolio)
                                ->where ('user_id', $data_user)
                                ->where ('status', 'WIN')
                                ->count();

              $loss =  Result::where('portfolio_id' , $data_portfolio)
                                ->where ('user_id', $data_user)
                                 ->where ('status', 'LOSS')
                                 ->count();

              $profit_eq =  Result::where('portfolio_id' , $data_portfolio)
                                ->where ('user_id', $data_user)
                                ->where ('status', 'WIN')
                                ->sum('net_profit');

              $loss_eq = Result::where('portfolio_id' , $data_portfolio)
                                ->where ('user_id', $data_user)
                                 ->where ('status', 'LOSS')
                                  ->sum('net_profit');

              $total_q = $profit_eq + $loss_eq;

              $initial = Transaction::where('portfolio_id' , $data_portfolio)
                                  ->where ('user_id', $data_user)
                                  ->where ('type', 'Initial')
                                  ->sum('amount');

              $deposit = Transaction::where('portfolio_id' , $data_portfolio)
                                  ->where ('user_id', $data_user)
                                  ->where ('type', 'Deposit')
                                  ->sum('amount');

              $withdraw = Transaction::where('portfolio_id' , $data_portfolio)
                                  ->where ('user_id', $data_user)
                                  ->where ('type', 'Withdraw')
                                  ->sum('amount');

              $profit = Transaction::where('portfolio_id' , $data_portfolio)
                                  ->where ('user_id', $data_user)
                                  ->where ('type', 'Profit')
                                  ->sum('amount');

              $winnings = Transaction::where('portfolio_id' , $data_portfolio)
                                  ->where ('user_id', $data_user)
                                 ->where ('type', 'Profit')
                                 ->count();

              $lossing = Transaction::where('portfolio_id' , $data_portfolio)
                                  ->where ('user_id', $data_user)
                                 ->where ('type', 'Loss')
                                 ->count();

              $sub_total = $initial + $total_q - $withdraw + $deposit;

              $roi_port = ($sub_total - $initial) / $initial *100;

                                  //total close counter (portfolio)
                                  $total_close_counter = DB::table('results')
                                  ->where('portfolio_id', $data_portfolio)
                                  ->where('user_id', $data_user)
                                  ->whereNotNull('status') 
                                  ->count();

                                  //total open counter (portfolio)
                                  $total_open_counter = DB::table('results')
                                  ->where('portfolio_id', $data_portfolio)
                                  ->where('user_id', $data_user)
                                  ->whereNull('status')
                                  ->count();

              $portfolio_update = DB::table('portfolios')
              ->where('id', $data_portfolio)
              ->where('user_id', $data_user)
              ->update([
                      "win" => $win,
                      "loss" => $loss,
                      "total_profit" => $total_q,
                      'roi_port' =>$roi_port,
                      "open_counter" => $total_open_counter,
                      "close_counter" => $total_close_counter,

                ]);
                //Update into portfolio End //



        }
      //return $last_sell_history;

      return redirect()->back()
      //return redirect()->route('trades.index')
          ->with('success', 'Trade deleted successfully.');
    }


}
