<?php

namespace App\Http\Controllers;

use App\Models\User;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Arr;

use Session;


class SettingsController extends Controller
{
    public function index()
    {
        return view('settings');
    }

    public function updateProfile(Request $request)
    {
        $this->validate($request,[
            'name' => 'required',
            'email' => 'required|email',
            'image' => 'image',
        ]);

        $user = User::findOrFail(Auth::id());

        $user->name = $request->name;
        $user->email = $request->email;
        $user->phone = $request->phone;
        $user->email_verified_at = null;
        $user->save();
        // Toastr::success('Profile Successfully Updated ','Success');
        return redirect()->back()
        ->with('success','Your profile updated successfully.');

    }

    public function updatePassword(Request $request)
    {
        Session::put('page','setting');
        $this->validate($request,[
            'old_password' => 'required',
            'password' => 'required|confirmed',
        ]);

        $hashedPassword = Auth::user()->password;
        if (Hash::check($request->old_password,$hashedPassword))
        {
            if (!Hash::check($request->password,$hashedPassword))
            {
                $user = User::find(Auth::id());
                $user->password = Hash::make($request->password);
                $user->save();

                Auth::logout();
                return redirect()->back()
                  ->with('success','Password Successfully Changed.');
            } else {
                return redirect()->back()
                  ->with('error','New password cannot be the same as old password.');
            }
        } else {
            return redirect()->back()
            ->with('error','Current password not match.');

        }

    }

    public function destroy($id)
{
//        return $id;
    $admin = User::findOrFail($id)->delete();
    Toastr::success('Your account have been deactivate','Success');
    return redirect('/');
}
}
