<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Portfolio;
use App\Models\Transaction;
use Illuminate\Support\Facades\Auth;
use DB;
use Carbon\Carbon;



class PortfolioController extends Controller
{
  /**
   * create a new instance of the class
   *
   * @return void
   */
  function __construct()
  {
       $this->middleware('permission:portfolio-list|portfolio-create|portfolio-edit|portfolio-delete', ['only' => ['index','store']]);
       $this->middleware('permission:portfolio-create', ['only' => ['create','store']]);
       $this->middleware('permission:portfolio-edit', ['only' => ['edit','update']]);
       $this->middleware('permission:portfolio-delete', ['only' => ['destroy']]);
  }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

      $data = Auth::user()->portfolio()->get();



      //$data_counter = Auth::user()->portfolio()->result()->whereNull('status')->get();

      /**$trans = Transaction::portfolio()->get();**/
      return view('portfolios.index',compact('data'));
      //return $data_counter;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
      return view('portfolios.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
          'portfolio_name' => 'required',
          'initial_deposit' => 'required',
        ]);

        $portfolio = new Portfolio();
        $portfolio->portfolio_name = $request->portfolio_name;
        $portfolio->initial_deposit = $request->initial_deposit;
        $portfolio->balance_available = $request->initial_deposit;
        $portfolio->user_id = Auth::id();
        $portfolio->save();
        $date = Carbon::now()->toDateTimeString();

        $transaction_Update = DB::table('transactions')
              ->insert([
                "type" => 'Initial',
                "remark" => 'Initial Deposit',
                "amount" => $request->initial_deposit,
                "date" => $request->date,
                "portfolio_id" => $portfolio->id,
                "created_at" => $date,
                "updated_at" => $date,
                "user_id" => Auth::id()
                      ]);



        //return redirect()->back()
        return redirect()->route('portfolios.index')
            ->with('success','Account created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
          $portfolio = Portfolio::find($id);

          $data = Transaction::where('portfolio_id' , $id)          
          ->orderBy('id', 'asc')->get();

          $date = Carbon::now()->toDateTimeString();

          $initial = Transaction::where('portfolio_id' , $id)
                              ->where ('type', 'Initial')
                              ->sum('amount');

          $deposit = Transaction::where('portfolio_id' , $id)
                              ->where ('type', 'Deposit')
                              ->sum('amount');

          $widthdraw = Transaction::where('portfolio_id' , $id)
                              ->where ('type', 'Withdraw')
                              ->sum('amount');

          $profit = Transaction::where('portfolio_id' , $id)
                              ->where ('type', 'Profit')
                              ->sum('amount');

          $loss = Transaction::where('portfolio_id' , $id)
                              ->where ('type', 'Loss')
                              ->sum('amount');
          $total_q = $profit + $loss;

          $total = $initial + $deposit + $profit -$loss - $widthdraw;


          //return $data;
          return view('portfolios.show', compact('portfolio','data','initial','deposit','widthdraw','profit','loss','total','total_q'));

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $portfolio = Portfolio::find($id);

        return view('portfolios.edit',compact('portfolio'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
          'portfolio_name' => 'required',
          'initial_deposit' => 'required',
        ]);

        $portfolio = Portfolio::find($id);

        $portfolio->update($request->all());

        // Update Available Balance if intinial change Start //
        $buy_amount = Transaction::where('portfolio_id' , $id)
                            ->where ('type', 'Buy')
                            ->sum('amount');

        $sell_amount = Transaction::where('portfolio_id' , $id)
                            ->where ('type', 'Sell')
                            ->sum('amount');

        $initail_depo = Portfolio::where('id' , $id)
                            ->sum('initial_deposit');

        $avai_balance = ($initail_depo - $buy_amount) + $sell_amount;

        $portfolio_update = DB::table('portfolios')
              ->where('id', $id)
               ->update([
                 "balance_available" => $avai_balance,
                       ]);

        $transaction_intial = DB::table('transactions')
                      ->where('portfolio_id', $id)
                      ->where('type', 'Initial')
               ->update([
                 "amount" => $initail_depo,
                       ]);

        // Update Available Balance if intinial change End //
        //return $avai_balance;
        return redirect()->route('portfolios.index')
            ->with('success','Account updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Portfolio::find($id)->delete();

        return redirect()->route('portfolios.index')
            ->with('success', 'Account deleted successfully.');
    }
}
