<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\User;

use App\Models\Portfolio;
use App\Models\Stock;
use App\Models\Trade;
use App\Models\Brokerage;
use App\Models\Result;
use App\Models\Transaction;
use Illuminate\Support\Facades\Auth;
use DB;
use Carbon\Carbon;

class BuyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      $this->validate($request, [
        'action' => 'required',
        'stock_name' => 'required',
        'price' => 'required',
        'quantity' => 'required',
        'date' => 'required',
        'remark' => 'required',

      ]);

      $trade = new Trade();
      $trade->action = $request->action;
      $trade->status = 0;
      $trade->portfolio_id = $request->portfolio_id;
      $trade->stock_code =  $request->stock_code;
      $trade->first_fees = $request->first_fees;
      $trade->stock_id = $request->stock_id;
      $trade->stock_name = $request->stock_name;
      $trade->stock_symbol = $request->stock_symbol;
      $trade->price = $request->price;
      $trade->brokerage_id = $request->brokerage_id;
      $trade->quantity = $request->quantity;
      $trade->date = $request->date;
      $trade->remark = $request->remark;

      //Subtotal Calculation//
      $subtotal = $request->price * $request->quantity;
      $trade->subtotal = $subtotal;
      //Brokerage Fee Calculation //
      $broker_f = $subtotal * $request->second_fees/100;
      if($broker_f  >= $request->first_fees){
        $broker_fees = $subtotal * $request->second_fees/100;
        $trade->broker_fee = $broker_fees;
      }
      elseif($broker_f <= $request->first_fees){
        $broker_fees =  $request->first_fees;
        $trade->broker_fee = $broker_fees;
      }
      //Clearing Fee Calculation//
      $clearing_f = $subtotal * 0.03/100;
      $trade->clearing_fee = $clearing_f;
      //Stamp Duty Fee Calculation//
      $stamp_d = ceil($subtotal/1000) * 1.50;
      $trade->stamp_duty = $stamp_d;
       //Total Cost  Calculation//
      $total_c = $subtotal + $broker_fees + $clearing_f + $stamp_d ;
      $trade->total_cost = $total_c;

      $trade->user_id = Auth::id();
      $trade->result_id = $request->result_id;

      $trade->save();

      $open_buy = Auth::user()->portfolio()
            ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
            ->where('portfolio_id', $request->portfolio_id)
            ->where('stock_id',  $request->stock_id)
            ->where('stock_code',  $request->stock_code)
            ->where('action', 'buy')
            ->sum('price');

      $trade_count = Auth::user()->portfolio()
            ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
            ->where('portfolio_id', $request->portfolio_id)
            ->where('stock_id',  $request->stock_id)
            ->where('stock_code',  $request->stock_code)
            ->where('action', 'buy')
            ->count();


      $sum_quantity = Auth::user()->portfolio()
              ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
              ->where('portfolio_id', $request->portfolio_id)
              ->where('stock_id',  $request->stock_id)
              ->where('stock_code',  $request->stock_code)
              ->where('action', 'buy')
              ->sum('quantity');

              $broke_total_fee = Auth::user()->portfolio()
                      ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                      ->where('portfolio_id', $request->portfolio_id)
                      ->where('stock_id',  $request->stock_id)
                      ->where('stock_code',  $request->stock_code)
                      ->where('action', 'buy')
                      ->sum('broker_fee');

                  $clearing_total_fee = Auth::user()->portfolio()
                          ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                          ->where('portfolio_id', $request->portfolio_id)
                          ->where('stock_id',  $request->stock_id)
                          ->where('stock_code',  $request->stock_code)
                          ->where('action', 'buy')
                          ->sum('clearing_fee');

                  $stamp_total_fee = Auth::user()->portfolio()
                          ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                          ->where('portfolio_id', $request->portfolio_id)
                          ->where('stock_id',  $request->stock_id)
                          ->where('stock_code',  $request->stock_code)
                          ->where('action', 'buy')
                          ->sum('stamp_duty');

                  $subtotal_cost_buy = Auth::user()->portfolio()
                          ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                          ->where('portfolio_id', $request->portfolio_id)
                          ->where('stock_id',  $request->stock_id)
                          ->where('stock_code',  $request->stock_code)
                          ->where('action', 'buy')
                          ->sum('total_cost');

                  $subtotal_buy_result = Auth::user()->portfolio()
                          ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                          ->where('portfolio_id', $request->portfolio_id)
                          ->where('stock_id',  $request->stock_id)
                          ->where('stock_code',  $request->stock_code)
                          ->where('action', 'buy')
                          ->sum('subtotal');

                  $subtotal_buy_result = Auth::user()->portfolio()
                          ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                          ->where('portfolio_id', $request->portfolio_id)
                          ->where('stock_id',  $request->stock_id)
                          ->where('stock_code',  $request->stock_code)
                          ->where('action', 'buy')
                          ->sum('subtotal');

                $subtotal_fee = $broke_total_fee + $clearing_total_fee + $stamp_total_fee;


      $average_buy = $open_buy / $trade_count;

      $broke_total_fee_all = Auth::user()->portfolio()
              ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
              ->where('portfolio_id', $request->portfolio_id)
              ->where('stock_id',  $request->stock_id)
              ->where('stock_code',  $request->stock_code)
              ->sum('broker_fee');

          $clearing_total_fee_all = Auth::user()->portfolio()
                  ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                  ->where('portfolio_id', $request->portfolio_id)
                  ->where('stock_id',  $request->stock_id)
                  ->where('stock_code',  $request->stock_code)
                  ->sum('clearing_fee');

          $stamp_total_fee_all = Auth::user()->portfolio()
                  ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                  ->where('portfolio_id', $request->portfolio_id)
                  ->where('stock_id',  $request->stock_id)
                  ->where('stock_code',  $request->stock_code)
                  ->sum('stamp_duty');

                  $subtotal_fee_all = $broke_total_fee_all + $clearing_total_fee_all + $stamp_total_fee_all;


        $Result_Update = DB::table('results')
        ->where('portfolio_id', $request->portfolio_id)
        ->where('stock_id', $request->stock_id)
        ->where('stock_code',  $request->stock_code)
        ->where('user_id', Auth::id())
              ->update([
                "average_buy" => $average_buy,
                "quantity_buy" => $sum_quantity,
                "total_fees_buy" => $subtotal_fee,
                "subtotal_buy" => $subtotal_buy_result,
                "total_cost_buy" => $subtotal_cost_buy,
                "quantity_bal" => $sum_quantity,
                "subtotal_fee" => $subtotal_fee_all,
                "status" => Null,
                "gross_roi" => Null,
                "gross_profit" => Null,
                "net_roi" => Null,
                "net_profit" => Null
                      ]);


               // Update into balance_avaiable(portfolio) Strat //
               $trans_update_buy = DB::table('transactions')
                     ->insert([
                       "portfolio_id" => $request->portfolio_id,
                       "user_id" => Auth::id(),
                       "stock_code" => $request->stock_code,
                       "type" => 'Buy',
                       "amount" => $total_c,
                       "remark" => 'Buy ' . $request->stock_symbol ,
                       "stock_id" => $request->stock_id,
                       "date" => $request->date,
                       "created_at" => Carbon::now(),
                       "updated_at" => Carbon::now(),
                             ]);


             $total_available_balance_in_portfolio = Portfolio::where('id' , $request->portfolio_id)
                                                   ->where ('user_id', Auth::id())
                                                   ->pluck('balance_available')
                                                   ->first();

              $subtotal_balance_available = $total_available_balance_in_portfolio - $total_c;
              $portfolio_Update = DB::table('portfolios')
               ->where('id', $request->portfolio_id)
               ->where('user_id', Auth::id())
                     ->update([
                       "balance_available" => $subtotal_balance_available,
                             ]);

             // Update into balance_avaiable(portfolio) End //


      return redirect()->route('trades.history', ['id' => $request->result_id])
           ->with('success','Buy created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
