<?php

namespace App\Http\Controllers;

use App\Models\Brokerage;
use Illuminate\Http\Request;

class BrokerageController extends Controller
{
    /**
     * create a new instance of the class
     *
     * @return void
     */
    function __construct()
    {
         $this->middleware('permission:brokerage-list|brokerage-create|brokerage-edit|brokerage-delete', ['only' => ['index', 'show']]);
         $this->middleware('permission:brokerage-create', ['only' => ['create', 'store']]);
         $this->middleware('permission:brokerage-edit', ['only' => ['edit', 'update']]);
         $this->middleware('permission:brokerage-delete', ['only' => ['destroy']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Brokerage::latest()->get();

        return view('brokerages.index',compact('data'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
      return view('brokerages.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
     public function store(Request $request)
     {
         $this->validate($request, [
             'broker_name' => 'required',
             'first_fees' => 'required',
             'second_fees' => 'required',
         ]);
         $input = $request->except(['_token']);

         Brokerage::create($input);

         return redirect()->route('brokerages.index')
             ->with('success','Broker created successfully.');
     }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $brokerage = Brokerage::find($id);

        return view('brokerages.show', compact('brokerage'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $brokerage = Brokerage::find($id);

        return view('brokerages.edit',compact('brokerage'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
          'broker_name' => 'required',
          'first_fees' => 'required',
          'second_fees' => 'required',
        ]);

        $brokerage = Brokerage::find($id);

        $brokerage->update($request->all());

        return redirect()->route('brokerages.index')
            ->with('success','Broker updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Brokerage::find($id)->delete();

        return redirect()->route('brokerages.index')
            ->with('success', 'Broker deleted successfully.');
    }
}
