<?php

namespace App\Http\Controllers;

use App\Models\Board;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use DB;
use Session;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Carbon\Carbon;
use App\Mail\SendEmail;
use App\Mail\SendMail;
use Mail;




class BoardController extends Controller
{
  /**
   * create a new instance of the class
   *
   * @return void
   */
  function __construct()
  {
       $this->middleware('permission:board-list|board-create|board-edit|board-delete', ['only' => ['index','store']]);
       $this->middleware('permission:board-create', ['only' => ['create','store']]);
       $this->middleware('permission:board-edit', ['only' => ['edit','update']]);
       $this->middleware('permission:board-delete', ['only' => ['destroy']]);
  }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      $data = Board::latest()->get();
      $users = User::role("2")->pluck('email')->all();
      //return $users;
      return view('boards.index',compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('baords.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
          'title' => 'required',
          'message' => 'required',
          'image' => 'mimes:jpeg,bmp,png,jpg|max:2048',

        ]);

        
        


        $image = $request->file('cover_image');
         if (isset($image))
        {
            
        $filenameWithExt = $image ->GetClientOriginalName();
        
        // Get Filename
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        
        // Get just Extension
        $extension = $image->getClientOriginalname();
        
        // Filename To store
        $fileNameToStore = $filename. '_'. time().'.'.$extension;
       

        // Upload Image
        $path = $image->storeAs('billboard/', $fileNameToStore);
        }
        // Else add a dummy image
        else {
        $fileNameToStore = 'default.png';
        }
        
        $board = new Board();
        $board->author = $request->author;
        $board->title = $request->title;
        $board->message = $request->message;
        $board->cover_image = $fileNameToStore;
        $board->status = true;
        $board->save();


        //email//
        $users = User::role("2")->pluck('email')->all();

        $emailsender =  $users;
        //$emailsender =  'apip.musa@gmail.com';
        $title = $request->title;
        $message = $request->message;
        $image = $fileNameToStore;

        Mail::to($emailsender)->send( new SendEmail($title, $message, $image) );

        //email //



        return redirect()->route('upadate-boards.index')
            ->with('success','Batch created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
      Board::find($id)->delete();

      return redirect()->route('upadate-boards.index')
          ->with('success', 'Batch deleted successfully.');
    }
}
