<?php

namespace App\Exports;

use App\Models\Program;
use App\Models\Trade;
use App\Models\Transaction;
use App\Models\Portfolio;
use App\Models\Result;
use App\Models\User;
use App\Models\Batchuser;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;


class ProgramStatisticExport implements FromView, ShouldAutoSize
{

    protected $id;

   function __construct($id) {
          $this->id = $id;
   }

    public function view(): View
    {
        return view('exports.programstatistic', [
            'program' => Program::find(  $this->id),
            'programs' => Program::find(  $this->id)
            ->join('batchusers', 'batchusers.batch_id', '=', 'programs.id')
            ->join('users', 'batchusers.user_id', '=', 'users.id')
            ->join('portfolios', 'portfolios.user_id', '=', 'users.id')
            ->orderByRaw('CAST(total_profit as DECIMAL) DESC')
            ->where('batch_id',   $this->id)
            ->get()
        ]);

    }
}
