@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
</br>
<section class="content">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    @if (count($errors) > 0)
        <div class="alert alert-danger">
            <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-0">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Overview</span>
                          <h3 class="m-0"><strong>User</strong></h3>
                        </div><!-- /.col -->
                        <div  class="col-sm-6">

                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div>
          <div class="card-header  border-0">
          <div class="card-tools">
            <div class="card-header border-0">
                          @can('user-create')

                          <!-- Modal Popup Start -->
                          <button type="button" class="btn btn-warning btn-block waves-effect" data-toggle="modal" data-target="#createUser">
                            Add User
                          </button>
                          <!-- Modal Popup End -->

                          <!-- Modal Start -->
                          <div class="modal fade" id="createUser">
                          <div class="modal-dialog ">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title">Add User</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>
                              <div class="modal-body">
                                @if (count($errors) > 0)
                                    <div class="alert alert-danger">
                                        <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif

                                {!! Form::open(array('route' => 'users.store','method'=>'POST')) !!}
                                <h5 class="m-0"><strong>User Details</strong></h5>
                                <span class="m-0 text-muted">Update the information below</span>
                              </br>
                            </br>
                                    <div class="form-group">
                                        <strong>Name:</strong>
                                        {!! Form::text('name', null, array('placeholder' => 'Name','class' => 'form-control')) !!}
                                    </div>
                                    <div class="form-group">
                                        <strong>Email:</strong>
                                        {!! Form::text('email', null, array('placeholder' => 'Email','class' => 'form-control')) !!}
                                    </div>
                                    <div class="form-group">
                                        <strong>Phone Number:</strong>
                                        {!! Form::text('phone', null, array('placeholder' => 'Phone Number','class' => 'form-control')) !!}
                                    </div>
                                    <div class="form-group">
                                        <strong>Role:</strong>
                                        {!! Form::select('roles[]', $roles,[], array('class' => 'form-control','multiple')) !!}
                                    </div>
                                    <h5 class="m-0"><strong>User Password</strong></h5>
                                    <span class="m-0 text-muted">Ensure your account is using a long, random password to stay secure.</span>
                                    <br>
                                    <strong><span class="m-0 text-danger">Use minimum 8 characters with a mix of letters, numbers & symbols.</span></strong>
                                  </br>
                                </br>
                                    <div class="form-group">
                                        <strong>Password:</strong>
                                        {!! Form::password('password', array('placeholder' => 'Password','class' => 'form-control')) !!}
                                    </div>
                                    <div class="form-group">
                                        <strong>Confirm Password:</strong>
                                        {!! Form::password('password_confirmation', array('placeholder' => 'Confirm Password','class' => 'form-control')) !!}
                                    </div>




                                <!-- /.card-body -->
                                <div class=" text-right">
                                  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-dark  waves-effect">Submit</button>
                                </div>
                                {!! Form::close() !!}
                              </div>
                            </div>
                            <!-- /.modal-content -->
                          </div>
                          <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->

                      <a class="btn btn-warning waves-effect mt-2" href="{{ route('file-export') }}"> <i class="nav-icon fas fa-plus-circle"></i> Export </a>

                          @endcan
                      </div>
       </div>
          </div>

          <!-- /.card-header -->
          <div class="card-body">
            <!-- <table id="example1" class="table table-bordered table-striped"> -->
            <table id="example2" class="table table-bordered rounded table-hover">
                <thead class="bg-warning">
                 <tr class="text-center">
                <th>ID</th>
                <th>Name</th>
                <th>Email</th>
                <th>Phone Number</th>
                <th>Create At</th>
                <th>Roles</th>
                <th>Action</th>
              </tr>
              </thead>
              <tbody>
                @foreach ($data as $key => $user)
              <tr class="text-center">
                <td class="align-middle">{{ $user->id }}</td>
                <td class="align-middle" >{{ $user->name }}</td>
                <td class="align-middle">{{ $user->email }}</td>
                <td class="align-middle">{{ $user->phone }}</td>
                <td class="align-middle" >{{ date('d/m/Y h:i A ', strtotime($user->created_at))}}</td>

                @if(!empty($user->getRoleNames()))
                    @foreach($user->getRoleNames() as $val)
                <td class="align-middle">{{ $val }}</td>
                @endforeach
            @endif
                <td>
                    @can('user-edit')
                        <a class="btn btn-warning btn-sm btn-block waves-effect" href="{{ route('users.edit',$user->id) }}">Edit</a>
                    @endcan
                    @can('user-delete')

                        <a class="btn btn-warning btn-sm btn-block waves-effect" type="button" onclick="deleteUser({{ $user->id }})">
                             <i class="fas fa-trash-alt"></i> Delete
                           </a>
                             <form id="delete-form-{{ $user->id }}" action="{{ route('users.destroy',$user->id) }}" method="POST" style="display: none;">
                             @csrf
                             @method('delete')
                             </form>
                    @endcan
                </td>
              </tr>
              @endforeach
              </tbody>
            </table>
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
@endsection
<script type="text/javascript">
              function deleteUser(id) {
                Swal.fire({
                  title: 'Are you sure?',
                  text: "You won't be able to revert this!",
                  icon: 'warning',
                  showCancelButton: true,
                  confirmButtonColor: '#3085d6',
                  cancelButtonColor: '#d33',
                  confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
          if (result.value) {
            event.preventDefault();
            document.getElementById('delete-form-'+id).submit();

          Swal.fire(
            'Deleted!',
            'Your file has been deleted.',
            'success'
          )
          }
          })
              }
</script>
