@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->

  <!-- /.content-header -->
</br>
<section class="content">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-0">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Overview</span>
                          <h3 class="m-0"><strong>Trade History</strong></h3>
                        </div><!-- /.col -->
                        <div class="col-sm-6 text-right">
                        <div class="row mb-2">
                        <div class="col-sm-12 mb-1">
                        <a class="btn btn-dark  waves-effect elevation-1" id="backstatistic" href="{{ route('trades.statistic',$result->portfolio_id) }}"> <i class="nav-icon fa fa-arrow-circle-left"></i>   Back to Trade Statistic</a>&nbsp;&nbsp;
                        </div>
                        <div class="col-sm-12 mb-1">
                        <a class="btn btn-dark  waves-effect elevation-1" id="tour" > <i class="nav-icon fas fa fa-info-circle"></i>   Start page tour again!</a>&nbsp;&nbsp
                        </div>
                        <div hidden="hidden" class="col-sm-12 ">
                        <a class="btn btn-dark  waves-effect elevation-1" id="need-help" data-toggle="modal" data-target="#page_tutorial"> <i class="nav-icon fas fa fa-info-circle"></i> Need Help?</a>&nbsp;&nbsp
                        </div>
                        </div>
                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.contaizner-fluid -->
            
          <!-- Modal Start -->
          <div class="modal fade" id="page_tutorial">
              <div class="modal-dialog modal-lg ">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title">Need Help?</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                  <div class="modal-body">

                    <div class="card card-widget collapsed-card elevation-1 mb-0 bg-light">
                        <div class="card-header">
                          <div class="user-block">
                            <span class=""><a class="text-secondary" href="" data-card-widget="collapse">xsdsadxasx</a></span>
                          </div>
                          <!-- /.user-block -->
                          <div class="card-tools ">
                          <button type="button" class="btn btn-tool" data-card-widget="remove">
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                              <i class="fas fa-plus"></i>
                            </button>

                          </div>
                          <!-- /.card-tools -->
                        </div>
                        <!-- /.card-header -->
                      
                        <div class="card-body bg-white" style="display: none;">
                          <img class="img-fluid pad" src="" alt="Photo">
                        <br></br>
                          <p>scascsa</p>
                        </div>
                     </div>

                     <div class="card card-widget collapsed-card elevation-1  bg-light">
                        <div class="card-header">
                          <div class="user-block">
                            <span class=""><a class="text-secondary" href="" data-card-widget="collapse">xsdsadxasx</a></span>
                          </div>
                          <!-- /.user-block -->
                          <div class="card-tools ">
                          <button type="button" class="btn btn-tool" data-card-widget="remove">
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                              <i class="fas fa-plus"></i>
                            </button>
                          </div>
                          <!-- /.card-tools -->
                        </div>
                        <!-- /.card-header -->
                      
                        <div class="card-body bg-white" style="display: none;">
                          <img class="img-fluid pad" src="" alt="Photo">
                        <br></br>
                          <p>scascsa</p>
                        </div>
                      </div>

               <!-- /.card-body -->
               <div class=" text-right">
                 <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
               </div>

                  </div>
                </div>
                <!-- /.modal-content -->
              </div>
              <!-- /.modal-dialog -->
            </div>
            <!-- /.modal emd -->

            </br>
            <div class="row mb-2">
            <div class="col-sm-6">
            <div class="row" id="trade-history">
              <div class="col-lg-6 col-6" >
                <!-- small box -->
                <div class="small-box bg-light elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Average Buy </strong></h6>
                    <h6><strong>MYR {{round($data->sum('price') / $data->count(),2) }}</strong></h6>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div class="col-lg-6 col-6">
                <!-- small box -->
                <div class="small-box bg-light elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Available Shares </strong></h6>
                    <h6><strong>{{$result->quantity_bal}} Unit</strong></h6>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div class="col-lg-6 col-6">
                <!-- small box -->
                <div class="small-box bg-light elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Total Fee </strong></h6>
                    <h6><strong>MYR {{round($result->total_fees_buy + $result->total_fees_sell , 2)}}</strong></h6>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div  class="col-lg-6 col-6">
                <!-- small box -->
                <div class="small-box bg-light elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Profit/Loss </strong></h6>
                    @if ($result->status == 'WIN')
                    <h6 class="text-success"><strong>MYR {{ round($result->gross_profit , 2) }}</strong></h6>
                    @elseif ($result->status == 'LOSS')
                    <h6 class="text-danger"><strong>MYR {{ round($result->gross_profit , 2) }}</strong></h6>
                    @else
                    <h6 ><strong>MYR 0.00</strong></h6>
                    @endif
                  </div>
                </div>
              </div>
              <div  class="col-lg-6 col-6">
                <!-- small box -->
                <div class="small-box bg-light elevation-1">
                  <div class="inner text-center">
                    <h6><strong>ROI (%) </strong></h6>
                    @if ($result->status == 'WIN')
                    <h6 class="text-success"><strong>{{round($result->net_roi, 2)}}%</strong></h6>
                    @elseif ($result->status == 'LOSS')
                    <h6 class="text-danger"><strong>{{round($result->net_roi, 2)}}%</strong></h6>
                    @else
                    <h6 ><strong>0.00%</strong></h6>
                    @endif
                  </div>
                </div>
              </div>
              <div  class="col-lg-6 col-6">
                <!-- small box -->
                <div class="small-box bg-light elevation-1">
                  <div class="inner text-center">
                    <h6><strong>Total Profit/Loss </strong></h6>
                    @if ($result->status == 'WIN')
                    <h6 class="text-success"><strong>MYR {{ round($result->net_profit , 2) }}</strong></h6>
                    @elseif ($result->status == 'LOSS')
                    <h6 class="text-danger"><strong>MYR {{ round($result->net_profit , 2) }}</strong></h6>
                    @else
                    <h6 ><strong>MYR 0.00</strong></h6>
                    @endif
                  </div>
                </div>
              </div>
              <!-- ./col -->
            </div>
          </div>
              <div class="col-sm-6 "> <!-- col 116 start -->
                <div class="row mb-2"><!-- row 117 start -->
                     <div class="col-sm-12"><!-- col 118 start -->

                     <div class="card elevation-1 pb-3 bg-gradient-light text-dark mb-0" id="counter-details">
                  <div class="content-header">
                    <div class="container-fluid ">
                      <div class="row mb-2">
                                <div class="col-sm-12">
                                  <h3 class="m-0"><strong>{{ $result->stock_name }} | {{ $result->stock_symbol }}</strong></h3>
                                  <span class="m-0 text-muted">Open Date : {{ date('d/m/Y h:i A  ', strtotime($result->open_trade))}}</span>
                                </br>
                                @if ($result->close_trade === NULL)
                                @else
                                <span class="m-0 text-muted">Close Date : {{ date('d/m/Y h:i A  ', strtotime($result->close_trade))}}</span>
                                @endif
                                </div><!-- /.col 122-->
                                <div  class="col-sm-12 mt-2">
                                  <div class="float-sm-left">
                          
                                        @if ($result->status == 'WIN')
                                        <span class="m-0 text-muted">Profit/ROI:</span>
                                        <h4> <span class="text-success float-left"><strong>MYR {{round($result->net_profit, 2)}} ({{round($result->net_roi, 2)}}%)</strong></span></h4>
                                        <h2> <span class="badge badge-success float-left">PROFIT</span></h2>

                                        @elseif ($result->status == 'LOSS')
                                        <span class="m-0 text-muted">Profit:</span>
                                        <h4> <span class="text-danger float-left"><strong>MYR {{round($result->net_profit , 2)}} ({{round($result->net_roi, 2)}}%)</strong></span></h4>
                                        <h2> <span class="badge badge-danger float-left">LOSS</span></h2>
                                        @else
                                        @endif

                                  </div>
                                </div><!-- /.col 131 -->
                               
                              </div><!-- /.row 121-->
                    </div><!-- /.container-fluid -->
                  </div><!-- /.content-header -->
                </div><!-- /.card -->
                     </div> <!-- col 118 -->
                  @can('trade-create')
                  @if ($result->quantity_bal == '0')
                  @else
                  <div class="col-sm-12 text-center mt-4" ><!-- col 157 start -->

                  <div class="row" id="tradehistory-action">
                  <div class="col-sm-12">
                  <small>To add your <b>BUY</b> and <b>SELL</b> in your Trade History, Please click button below:</small>
                    </div>
                <div class="col-sm-6"><!-- col 157 start -->
                  <a class="btn btn-outline-dark btn-lg btn-block waves-effect mt-2" id="tradehistory-buy" href="{{ route('trades.buy',$result->id) }}"><i class="nav-icon fas fa-plus-circle"></i>  Buy Trade</a>
                </div> <!-- col 157 -->
                <div class="col-sm-6"><!-- col 160 start -->
                     <a class="btn btn-outline-dark btn-lg btn-block waves-effect mt-2" id="tradehistory-sell" href="{{ route('trades.sell',$result->id) }}"><i class="nav-icon fas fa-minus-circle"></i>  Sell Trade</a>
                </div> <!-- col 160 -->
                </div>
                </div>
                @endif
                @endcan

              </div> <!-- row 117 -->
           </div><!-- col 116 -->

          </div>
          <div class="card-header  border-0">
          <div class="card-tools">
            <!-- <div hidden="hidden" class="card-header border-0">
                          @can('trade-create')
                          @if ($result->quantity_bal == '0')
                          @else
                          <button class="btn btn-warning dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="nav-icon fas fa-plus-circle"></i>&nbsp;&nbsp;Trade
                          </button>

                          <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="{{ route('trades.buy',$result->id) }}">Buy</a>
                            <a class="dropdown-item" href="{{ route('trades.sell',$result->id) }}">Sell</a>
                          </div>
                          @endif
                          @endcan
                      </div> -->
       </div>
          </div>
          <div class="card-header border-0 ">
            <div class="text-right">
                </div>
              </div>
          <!-- /.card-header -->
          <div class="card-body" id="tradehistory-table">
            <table id="example2" class="table table-bordered rounded table-hover">
              <thead class="bg-light">
            <tr class="text-center">
              <th width="100px">No</th>
              <th >Action</th>
              <th>Date</th>
              <th >Price</th>
              <th >Quantity</th>
              <th >Total</th>
              <th >Broker Fee</th>
              <th >Stamp Fee</th>
              <th >Clearing Fee</th>
              <th >Total Cost</th>
              <th >Reason</th>
              <th >Action</th>
            </tr>
            </thead>
            <tbody>
              @foreach ($data as $key => $row)
            <tr class="text-center">
              <td class="align-middle">{{ $key + 1 }}</td>
              <td class="align-middle" >
                @if ($row->action == 'buy')
                <h5> <span class="badge badge-primary">BUY</span></h5>
                @else
                <h5> <span class="badge badge-danger">SELL</span></h5>
                @endif
              </td>
              <td class="align-middle" >{{ date('d/m/Y h:i A ', strtotime($row->date))}}</td>
              <td class="align-middle">MYR {{ $row -> price }}</td>
              <td class="align-middle">{{ $row -> quantity }} Unit</td>
              <td class="align-middle">MYR {{ round($row -> subtotal, 2) }}</td>
              <td class="align-middle">MYR {{ round($row -> broker_fee, 2) }}</td>
              <td class="align-middle">MYR {{ round($row -> stamp_duty, 2) }}</td>
              <td class="align-middle">MYR {{ round($row -> clearing_fee, 2) }}</td>
              <td class="align-middle">MYR {{ round($row -> total_cost, 2) }}</td>
              <td class="align-middle">{{ $row -> remark }}</td>
              <td>
                @can('portfolio-edit')

                @endcan

                @can('portfolio-delete')
                <a class="btn btn-secondary elevation-1 btn-sm btn-block waves-effect" id="tradehistory-delete" type="button" onclick="deleteTrade({{ $row->id }})">
                      Delete
                   </a>
                     <form id="delete-form-{{ $row->id }}" action="{{ route('trades.destroy',$row->id) }}" method="POST" style="display: none;">
                     @csrf
                     @method('delete')
                     </form>
                 @endcan
              </td>

            </tr>
            @endforeach
            </tbody>

          </table>

          </div>
          <!-- /.card-body -->

      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
@endsection

    <script type="text/javascript">
                  function deleteTrade(id) {
                    Swal.fire({
                      title: 'Are you sure?',
                      text: "You won't be able to revert this!",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
              if (result.value) {
                event.preventDefault();
                document.getElementById('delete-form-'+id).submit();

              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
              }
              })
                  }
    </script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Function to start the tour
        function startTour() {
            introJs().setOptions({
                steps: [
                    {
                        intro: "Welcome to <b>Trade History Page</b>! Let's take a quick tour."
                    },
                    {
                      element: '#trade-history',
                        intro: 'This is your porfolio details contains of</br></br><ul><li>Average Buy</li><li>Available Shares</li><li>Totak Fee</li><li>Total Profit/Loss</li><li>ROI (Return of Investment)</li><li>Total Profit/Loss</li></ul>that available in your portfolio.'
                    },
                    {
                        element: '#counter-details',
                        intro: 'This is your counter details such contains of </br></br><ul><li>Stock Name</li><li>Stock Symbol </li><li>Open Trade Date</li><li>Close Trade Date</li><li>Total Profit/Loss</li><li>ROI (Return of Investment)</li></ul>.'
                    },
                    {
                        element: '#tradehistory-action',
                        intro: 'This is action button for <b>Buy Trade</b> and <b>Sell Trade</b> on the open counter details.'
                    },
                    {
                        element: '#tradehistory-buy',
                        intro: 'This is the button for <b>Buy Trade</b> to add buy trade in the counter.'
                    },
                    {
                        element: '#tradehistory-sell',
                        intro: 'This is the button for <b>Sell Trade</b> to add sell trade by partially or fully in the counter.'
                    },
                    {
                        element: '#tradehistory-table',
                        intro: 'This is the table show <b>Trade History</b> in your open trade counter.'
                    },
                    {
                        element: '#tradehistory-delete',
                        intro: 'This is the button <b>Delete</b> your trade in trade history.'
                    },
                    {
                        element: '#backstatistic',
                        intro: 'Click this <b>Back to Trade Statistic</b> button for going back to your trade statistic page.'
                    },
                    {
                        element: '#tour',
                        intro: 'You can start the tour again, when you need to help.'
                    },
                    //{
                      //  element: '#need-help',
                        //intro: 'This is the button for show <b>Trade Statistic</b> in your portfolio.'
                    //},
                    {
                        intro: `
                            <div style="text-align: center;">
                                <p>Would you like to enable or disable the tour for future visits?</p>
                                <label class="form-check-label">
                                    <input type="radio"  name="tourOption" value="enable" checked> Show again next time
                                </label>
                                </br>
                                <label class="form-check-label">
                                    <input type="radio" name="tourOption" value="disable"> Don't show it again 
                                </label>
                            </div>

                         
                        `,
                        position: 'bottom'
                    }
                ]
            })
            .onbeforeexit(function () {
                return confirm("Stop!! Please complete the page tour before you exit! Are you sure you want to quit page tour?");
            })
            .oncomplete(function() {
                handleTourOption('sixthTourOption', 'sixthTourDisabled');
            })
            .onexit(function() {
                handleTourOption('sixthTourOption', 'sixthTourDisabled');
            })
            .start();
        }

        // Function to handle the tour option
        function handleTourOption() {
            const selectedOption = document.querySelector('input[name="tourOption"]:checked').value;
            if (selectedOption === 'disable') {
                // Save preference to localStorage or send to server
                localStorage.setItem('sixthTourDisabled', 'true');
            } else {
                localStorage.removeItem('sixthTourDisabled');
            }
        }

        // Check if the tour is disabled
        if (!localStorage.getItem('sixthTourDisabled')) {
            startTour();
        }
    });
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('tour').addEventListener('click', function() {
        introJs().setOptions({
          steps: [
            {
                        intro: "Welcome to <b>Portfolio Page</b>! Let's take a quick tour."
                    },
                    {
                        element: '#trade-history',
                        intro: 'This is your porfolio details.'
                    },
                    {
                        element: '#counter-details',
                        intro: 'This is the button for <b>Delete</b> of your portfolio.'
                    },
                    {
                        element: '#tradehistory-action',
                        intro: 'This is the button for show <b>Transaction</b> in your portfolio.'
                    },
                    {
                        element: '#tradehistory-buy',
                        intro: 'This is the button for <b>Delete</b> of your portfolio.'
                    },
                    {
                        element: '#tradehistory-sell',
                        intro: 'This is show <b>ROI</b> in your portfolio.'
                    },
                    {
                        element: '#tradehistory-table',
                        intro: 'This is show the <b>Open and Close Trade</b> in your portfolio.'
                    },
                    {
                        element: '#tradehistory-delete',
                        intro: 'This is show the <b>Winnings and Lossing Trade</b> in your portfolio.'
                    },
                    {
                        element: '#backstatistic',
                        intro: 'This is show th <b>Total Profit</b> in your portfolio.'
                    },
                    {
                        element: '#tour',
                        intro: 'This is show th <b>Fund Available</b> in your portfolio.'
                    },
                    {
                        element: '#need-help',
                        intro: 'This is the button for show <b>Trade Statistic</b> in your portfolio.'
                    }
               
            ]
        })
      
        .start();
    });
   
});

    </script>