@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->

  <!-- /.content-header -->
</br>
<section class="content ">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-0">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Overview</span>
                          <h3 class="m-0"><strong>Trade Statistic</strong></h3>
                        </div><!-- /.col -->
                        <div  hidden="hidden" class="col-sm-6">
                          <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                          </ol>
                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div>

          <div class="card-header  border-0">
            <div class="row">
              <div class="col-lg-2 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h5><strong>Fund Available </strong></h5>
                    <h3>{{ $trans->sum('amount') }}</h3>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div class="col-lg-2 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h5><strong>Total Profit </strong></h5>
                    <h3>6,000</h3>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div class="col-lg-2 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h5><strong>Total Loss </strong></h5>
                    <h3>900</h3>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div  class="col-lg-2 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h5><strong>Total Winnings </strong></h5>
                    <h3>1,500</h3>
                  </div>
                </div>
              </div>
              <div  class="col-lg-2 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h5><strong>Total Losings </strong></h5>
                    <h3>1,500</h3>
                  </div>
                </div>
              </div>
              <div  class="col-lg-2 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h5><strong>ROI </strong></h5>
                    <h3>1,500</h3>
                  </div>
                </div>
              </div>
              <!-- ./col -->
            </div>
            <div class="row">
              <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h5><strong>Balance Available </strong></h5>
                    <h3>20</h3>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h5><strong>Total Widthdraw  </strong></h5>
                    <h3>6,000</h3>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h5><strong>Total Deposit</strong></h5>
                    <h3>900</h3>
                  </div>
                </div>
              </div>
              <!-- ./col -->
              <div  class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-white elevation-1">
                  <div class="inner text-center">
                    <h5><strong>Total Profit/Loss </strong></h5>
                    <h3>1,500</h3>
                  </div>
                </div>
              </div>
              <!-- ./col -->
            </div>
          <h3 class="card-title"><strong></strong></h3>
          <div class="card-tools">
            <div class="card-header border-0">
                          @can('trade-create')
                          <a class="btn btn-warning  btn-block waves-effect" href="{{ route('trades.create') }}">  Add Trade</a>
                          @endcan
                      </div>
       </div>

          </div>
          <div class="card-header border-0 ">
            <div class="text-right">
                </div>
              </div>
          <!-- /.card-header -->
          <div class="card-body">
            <table id="example2" class="table table-bordered rounded table-hover">
              <thead class="bg-warning">
          <!--  <tr class="text-center">
              <th width="100px">No</th>
              <th>Portfolio Name</th>
              <th width="100px">Action</th>
            </tr> -->
            </thead>
            <tbody>
              @foreach ($data as $key => $row)
            <tr class="text-center">
              <td class="align-middle">{{ $key + 1 }}</td>
              <td class="align-middle" >{{ $row->id}}</td>
              <td class="align-middle" >{{ $row->user_id}}</td>
              <td class="align-middle" >{{ $row->portfolio_name}}</td>
              <td class="align-middle" >{{ $row->initial_deposit}}</td>
              <td class="align-middle" >{{ $row->action}}</td>
              <td class="align-middle" >{{ $row->status}}</td>
              <td class="align-middle" >{{ $row->portfolio_id}}</td>
              <td class="align-middle" >{{ $row->stock_name}}</td>
              <td class="align-middle" >{{ $row->date}}</td>
              <td class="align-middle" >{{ $row->price}}</td>
              <td class="align-middle" >{{ $row->quantity}}</td>
              <td class="align-middle" >{{ $row->brokerage_id}}</td>
              <td class="align-middle" >{{ $row->subtotal}}</td>
              <td class="align-middle" >{{ $row->total_cost}}</td>
              <td>
                <a class="btn btn-warning btn-sm btn-block waves-effect" href="{{ route('trades.history') }}"> Sell</a>
                <a class="btn btn-warning btn-sm btn-block waves-effect" href="{{ route('trades.history') }}">  History</a>
              </td>
            </tr>
            @endforeach
            </tbody>
          </table>
        </br>


          <table id="example2" class="table table-bordered rounded table-hover">
            <thead class="bg-warning">
        <!--  <tr class="text-center">
            <th width="100px">No</th>
            <th>Portfolio Name</th>
            <th width="100px">Action</th>
          </tr> -->
          </thead>
          <tbody>
            @foreach ($trans as $key => $row)
          <tr class="text-center">
            <td class="align-middle">{{ $key + 1 }}</td>
            <td class="align-middle" >{{ $row->id}}</td>
            <td class="align-middle" >{{ $row->user_id}}</td>
            <td class="align-middle" >{{ $row->portfolio_name}}</td>
            <td class="align-middle" >{{ $row->initial_deposit}}</td>
            <td class="align-middle" >{{ $row->action}}</td>
            <td class="align-middle" >{{ $row->status}}</td>
            <td class="align-middle" >{{ $row->portfolio_id}}</td>
            <td class="align-middle" >{{ $row->stock_name}}</td>
            <td class="align-middle" >{{ $row->date}}</td>
            <td class="align-middle" >{{ $row->price}}</td>
            <td class="align-middle" >{{ $row->quantity}}</td>
            <td class="align-middle" >{{ $row->brokerage_id}}</td>
            <td class="align-middle" >{{ $row->subtotal}}</td>
            <td class="align-middle" >{{ $row->total_cost}}</td>
            <td>
              <a class="btn btn-warning btn-sm btn-block waves-effect" href="{{ route('trades.history') }}"> Sell</a>
              <a class="btn btn-warning btn-sm btn-block waves-effect" href="{{ route('trades.history') }}">  History</a>
            </td>
          </tr>
          @endforeach
          </tbody>
        </table>

          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
@endsection

    <script type="text/javascript">
                  function deletePrograms(id) {
                    Swal.fire({
                      title: 'Are you sure?',
                      text: "You won't be able to revert this!",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
              if (result.value) {
                event.preventDefault();
                document.getElementById('delete-form-'+id).submit();

              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
              }
              })
                  }
    </script>
