@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">


<section class="content">
  <div class="container-fluid">
    <div class="container py-5">
        <div class="justify-content-center">
            @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="card ">
            </br>
                <div class="card-header border-0">
                <div class="row mb-2">
                        <div class="col-sm-6">
                  <h5 class="m-0"><strong>Add Trade Counter</strong></h5>
                  <span class="m-0 text-muted">Please fill the trade form with your information</span>
                  </div>
                  <div class="col-sm-6 text-right">
                        <div class="row mb-2">
                        <div class="col-sm-12 mb-1">
                        <a class="btn btn-dark  waves-effect elevation-1" id="close" href="{{ route('trades.statistic',$portfolio2->id) }}"> <i class="nav-icon fa fa-arrow-circle-left"></i>   Back to Trade Statistic</a>&nbsp;&nbsp;
                        </div>
                        <div class="col-sm-12 mb-1">
                        <a class="btn btn-dark  waves-effect elevation-1" id="restart-tour"> <i class="nav-icon fas fa fa-info-circle"></i>   Start page tour again!</a>&nbsp;&nbsp
                        </div>
                        </div>
                        </div>
                </div>
                <div class="card-body">
                  <form action="{{ route('trades.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                      <div class="col-12 col-sm-12">
                        <label>Action:</label>
                        <div class="card">
                          <div class="card-body">
                            <div class=" clearfix">
                              <div class="icheck-primary d-inline">
                                <input type="radio" id="radioPrimary1" name="action" value="buy" checked="">
                                <label for="radioPrimary1">
                                  <strong>Buy</strong>
                                </label>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="col-12 col-sm-6" id="porfolio">
                        <div class="form-group">
                         <label>Portfolio</label>
                         <!-- Modal Popup Start -->
                         <a hidden="hidden" type="button" class="float-right" data-toggle="modal" data-target="#createPortfolio">
                           <strong>Create Account</strong>
                         </a>
                         <!-- Modal Popup End -->
                          <select class="form-control select2bs4" style="width: 100%;" name="portfolio_id" required="true" >
                            @foreach ($portfolio as $key => $portfolio)
                            <option value="{{ $portfolio->id}}">{{$portfolio->portfolio_name}}</option>
                            @endforeach
                          </select>
                        </div>
                      </div>



                      <div class="col-12 col-md-6" id="stock">
                          <div class="form-group">
                            <label class="form-label"><strong>Stock:</strong></label>
                            <!-- Modal Popup Start -->
                            <a type="button" class="float-right" data-toggle="modal" data-target="#createStock">
                             <span id="create-stock"> <strong>Create Stock</strong></span>
                            </a>
                            <!-- Modal Popup End -->
                              <div>
                                  <select class="form-control formselect required select2bs4" placeholder="Select Broker"
                                      id="stock_name" name="stock_id" style="width: 100%;" required="true">
                                      <option value="0" disabled selected>Select
                                          Stock</option>
                                      @foreach($data2 as $stock)
                                      <option  value="{{ $stock->id }}">
                                          {{ ucfirst($stock->stocks_name) }} | {{ $stock->symbol}}</option>
                                      @endforeach
                                  </select>
                              </div>
                          </div>
                      </div>

                      <div hidden="hidden" class="col-md-6">
                        <div class="form-group">
                          <label class="form-label"><strong>Stock Name :</strong></label>
                          <select class="form-control formselect required"  id="stock_id" name="stock_name" readonly>
                          </select>
                          <label class="form-label"><strong>Stock Symbol  :</strong></label>
                          <select class="form-control formselect required"  id="stock_id2" name="stock_symbol" readonly>
                          </select>

                        </div>
                      </div>

                  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

              <script>
                          $(document).ready(function () {
                          $('#stock_name').on('change', function () {
                          let id = $(this).val();
                          $('#stock_id').empty();
                          $('#stock_id').append(`<option value="0" disabled selected>Processing...</option>`);
                          $('#stock_id2').empty();
                          $('#stock_id2').append(`<option value="0" disabled selected>Processing...</option>`);
                          $.ajax({
                          type: 'GET',
                          url: 'GetStockAgainstMainCatEdit/' + id,
                          success: function (response) {
                          var response = JSON.parse(response);
                          console.log(response);
                          $('#stock_id').empty();
                          $('#stock_id').append();
                          response.forEach(element => {
                              $('#stock_id').append(`<option value="${element['stocks_name']}">${element['stocks_name']}</option>`);
                              });
                         $('#stock_id2').empty();
                         $('#stock_id2').append();
                         response.forEach(element => {
                             $('#stock_id2').append(`<option value="${element['symbol']}">${element['symbol']}</option>`);
                             });
                          }
                      });
                  });
              });
              </script>


                      <div class="col-12 col-sm-6" id="price">
                        <div class="form-group">
                         <label>Price</label>
                         <div class="input-group mb-3" >
                           <input type="number" id="num1" class="form-control"  placeholder="Insert Price" name="price" required="true" step="0.000001">
                        <div class="input-group-append">
                        <span class="input-group-text">MYR</i></span>
                      </div>
                        </div>
                        </div>
                      </div>

                      <div class="col-12 col-sm-6" id="quantity">
                        <div class="form-group">
                         <label>Quantity</label>
                         <div class="input-group mb-3">
                           <input type="number" id="num2" class="form-control"  placeholder="Insert Unit" name="quantity" required>
                        <div class="input-group-append">
                        <span class="input-group-text">Unit</i></span>
                      </div>
                        </div>
                        </div>



                        <script>
                      //  $(function() {
                        //  $("#num1, #num2").on("keydown keyup", sum);
                        //	function sum() {
                        //	$("#sum").val(Number($("#num1").val()) * Number($("#num2").val()));

                        //  $("#subt").val(Number($("#sum").val()) * 0.38/100);
                        //  $("#stamp_duty").val(Number($("#sum").val())/1000 * 1.50);
                        //  $("#clearing_fee").val(Number($("#sum").val()) * 0.03/100);
                        //  $("#total_cost").val(Number($("#sum").val()) + Number($("#subt").val()) + Number($("#stamp_duty").val()) + Number($("#clearing_fee").val())  );

                          }
                        });


                      </script>
                      </div>

                      <div hidden="hidden" class="col-6 col-sm-6">
                        <div class="form-group">
                         <label>Total</label>
                         <div class="input-group mb-3">
                           <input type="text" id="sum" class="form-control"  readonly name="" >
                        <div class="input-group-append">
                        <span class="input-group-text">MYR</i></span>
                      </div>
                        </div>
                        </div>
                      </div>
                      <div hidden="hidden" class="col-6 col-sm-6">
                        <div class="form-group">
                         <label>Broker Fee</label>
                         <div class="input-group mb-3">
                           <input type="text" id="subt" class="form-control"  readonly name="" >
                        <div class="input-group-append">
                        <span class="input-group-text">MYR</i></span>
                      </div>
                        </div>
                        </div>
                      </div>
                      <div hidden="hidden" class="col-6 col-sm-6">
                        <div class="form-group">
                         <label>Stamp Duty </label>
                         <div class="input-group mb-3">
                           <input type="text" id="stamp_duty" class="form-control"  readonly name="" >
                        <div class="input-group-append">
                        <span class="input-group-text">MYR</i></span>
                      </div>
                        </div>
                        </div>
                      </div>
                      <div hidden="hidden" class="col-6 col-sm-6">
                        <div class="form-group">
                         <label>Clearing Fee </label>
                         <div class="input-group mb-3">
                           <input type="text" id="clearing_fee" class="form-control"  readonly name="" >
                        <div class="input-group-append">
                        <span class="input-group-text">MYR</i></span>
                      </div>
                        </div>
                        </div>
                      </div>
                      <div hidden="hidden" class="col-6 col-sm-6">
                        <div class="form-group">
                         <label>Total Cost</label>
                         <div class="input-group mb-3">
                           <input type="text" id="total_cost" class="form-control"  readonly name="" >
                        <div class="input-group-append">
                        <span class="input-group-text">MYR</i></span>
                      </div>
                        </div>
                        </div>
                      </div>

                      <div class="col-12 col-sm-6" id="date">
                     <div class="form-group">
                       <label class="form-label"><strong>Date and Time :</strong></label>
                       <input type="datetime-local" id="date_out" name="date" class="form-control" required="true">
                     </div>
                      </div>


                      <div class="col-12 col-md-6" id="broker">
                          <div class="form-group">
                            <label class="form-label"><strong>Broker :</strong></label>

                              <div>
                                  <select class="form-control formselect required select2bs4" placeholder="Select Broker"
                                      id="sub_category_name" name="brokerage_id" style="width: 100%;" required="true">
                                      <option value="0" disabled selected>Select  Broker</option>
                                      @foreach($data as $broker)
                                      <option  value="{{ $broker->id }}">
                                          {{ ucfirst($broker->broker_name) }}</option>
                                      @endforeach
                                  </select>
                              </div>
                          </div>
                      </div>

                      <div  hidden="hidden" class="col-12 col-md-6">
                        <div class="form-group">
                          <label class="form-label"><strong>First Fees :</strong></label>
                          <select class="form-control formselect required"  id="sub_category" name="first_fees" readonly>
                          </select>
                          <label class="form-label"><strong>Second Fees :</strong></label>
                          <select class="form-control formselect required"  id="sub_category2" name="second_fees" readonly>
                          </select>
                        </div>
                      </div>

                      <div class="col-12 col-sm-12" id="remark">
                        <div class="form-group">
                          <label>Remark</label>
                          <textarea class="form-control" rows="3" placeholder="" name="remark" required="true"></textarea>
                        </div>
                      </div>
                      <div class="col-12 col-sm-12">
                     <div class=" text-right">
                       <!-- <button type="button" class="btn btn-default" data-dismiss="modal" id="close">Close</button> -->
                     <button type="submit" class="btn btn-dark  waves-effect" id="save">Save</button>
                   </div>
                 </div>
                  </div>
                  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

                  <script>
                            $(document).ready(function () {
                            $('#sub_category_name').on('change', function () {
                            let id = $(this).val();
                            $('#sub_category').empty();
                            $('#sub_category').append(`<option value="0" disabled selected>Processing...</option>`);
                            $('#sub_category2').empty();
                            $('#sub_category2').append(`<option value="0" disabled selected>Processing...</option>`);
                            $.ajax({
                            type: 'GET',
                            url: 'GetSubCatAgainstMainCatEdit/' + id,
                            success: function (response) {
                            var response = JSON.parse(response);
                            console.log(response);
                            $('#sub_category').empty();
                            $('#sub_category').append();
                            response.forEach(element => {
                            $('#sub_category').append(`<option value="${element['first_fees']}">${element['first_fees']}</option>`);
                            });
                            $('#sub_category2').empty();
                            $('#sub_category2').append();
                            response.forEach(element => {
                                $('#sub_category2').append(`<option value="${element['second_fees']}">${element['second_fees']}</option>`);
                                });
                            }
                        });
                    });
                });
                </script>




           </div>
         </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Start -->
    <div class="modal fade" id="createStock">
    <div class="modal-dialog ">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Create Stocks</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          @if (count($errors) > 0)
              <div class="alert alert-danger">
                  <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                  <ul>
                      @foreach ($errors->all() as $error)
                          <li>{{ $error }}</li>
                      @endforeach
                  </ul>
              </div>
          @endif
          {!! Form::open(array('route' => 'stocks.store', 'method'=>'POST')) !!}
            <div class="form-group">
              <label for="exampleInputEmail1">Stocks Name: </br>  <small class="text-danger">Please insert data with capitals letter</small> </label>

              {!! Form::text('stocks_name', null, array('placeholder' => 'Please fill with capital letter : BERJAYA CORPORATION BERHAD','class' => 'form-control')) !!}
           </div>
          <div class="form-group">
            <label for="exampleInputEmail1">Stock Symbol: </br>  <small class="text-danger">Please insert data with capitals letter</small> </label>
            {!! Form::text('symbol', null, array('placeholder' => 'Please fill with capital letter : BJCORP','class' => 'form-control')) !!}
         </div>
          <!-- /.card-body -->
          <div class=" text-right">
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-dark  waves-effect">Submit</button>
          </div>
          {!! Form::close() !!}
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->

    <!-- Modal Start -->
    <div class="modal fade" id="createPortfolio">
    <div class="modal-dialog ">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Create Stocks</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          @if (count($errors) > 0)
              <div class="alert alert-danger">
                  <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                  <ul>
                      @foreach ($errors->all() as $error)
                          <li>{{ $error }}</li>
                      @endforeach
                  </ul>
              </div>
          @endif
          <form action="{{ route('portfolios.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
       <div class="form-group">
         <label for="exampleInputEmail1">Account Name  </label>
         <input type="text"  class="form-control"  placeholder="Portfolio Name" name="portfolio_name" >
      </div>

     <div class="form-group">
       <label for="exampleInputEmail1">Initial Deposit  </label>
       <input type="text" class="form-control"  placeholder="Initial Deposit" name="initial_deposit" >
    </div>

    <div class="form-group">
      <label class="form-label"><strong>Deposit Date :</strong></label>
      <input type="datetime-local" id="date" name="date" class="form-control" required="true">
    </div>



     <!-- /.card-body -->
     <div class=" text-right">
       <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
     <button type="submit" class="btn btn-dark  waves-effect">Submit</button>
     </div>
    </form>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->


  </div>
  <!-- /.container-fluid -->
</section>
</div>
@endsection

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Function to start the tour
        function startTour() {
            introJs().setOptions({
                steps: [
                    {
                        intro: "Welcome to <b>Add Trade Counter</b> page! Let's take a quick tour."
                    },
                    {
                        element: '#porfolio',
                        intro: 'Please select your portfolio in the list tab. Just click the tab and search for your portfolio. '
                    },
                    {
                        element: '#stock',
                        intro: `Please select your stock counter in the list tab. Just click the tab and search for your stock counter. `
                    },
                    {
                        element: '#create-stock',
                        intro: 'You can create the stock counter if are not in the list. Make sure you are follow insturction below.<br></br><small></b>Please enter the correct stock name and stock code acording with the real name. You can follow an example below</br><b>Stock Name : BERJAYA CORPORATION BERHAD</br>Stock Code : BJCORP</small>'
                    },
                    {
                        element: '#price',
                        intro: `Please select your acurate open price counter when your start open your trade counter. `
                    },
                    {
                        element: '#quantity',
                        intro: 'Please enter the accurate quantity that you buy when your start open your trade counter.'
                    },
                    {
                        element: '#date',
                        intro: 'Please enter the accurate date and time when your start open your trade counter.'
                    },
                    {
                        element: '#broker',
                        intro: 'Please select the broker when your start open your trade counter.'
                    },
                    {
                        element: '#remark',
                        intro: 'Your can put the remark for reference.'
                    },
                    {
                        element: '#save',
                        intro: 'Click this <b>Save</b> button for save your open trade counter details.'
                    },
                    {
                        element: '#close',
                        intro: 'Click this <b>Back to Trade Statistic</b> button for going back to your trade statistic page.'
                    },
                    {
                        element: '#restart-tour',
                        intro: 'You can start the tour again, when you need to help.'
                    },
                    {
                        intro: `
                            <div style="text-align: center;">
                                <p>Would you like to enable or disable the tour for future visits?</p>
                                <label class="form-check-label">
                                    <input type="radio"  name="tourOption" value="enable" checked> Show again next time
                                </label>
                                </br>
                                <label class="form-check-label">
                                    <input type="radio" name="tourOption" value="disable"> Don't show it again 
                                </label>
                            </div>
                        `,
                        position: 'bottom'
                    }
                ]
            })
            .onbeforeexit(function () {
                return confirm("Stop!! Please complete the page tour before you exit! Are you sure you want to quit page tour?");
            })
            .oncomplete(function() {
                handleTourOption('thirdTourOption', 'thirdTourDisabled');
            })
            .onexit(function() {
                handleTourOption('thirdTourOption', 'thirdTourDisabled');
            })
            .start();
        }

        // Function to handle the tour option
        function handleTourOption() {
            const selectedOption = document.querySelector('input[name="tourOption"]:checked').value;
            if (selectedOption === 'disable') {
                // Save preference to localStorage or send to server
                localStorage.setItem('thirdTourDisabled', 'true');
            } else {
                localStorage.removeItem('thirdTourDisabled');
            }
        }

        // Check if the tour is disabled
        if (!localStorage.getItem('thirdTourDisabled')) {
            startTour();
        }

    });
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('restart-tour').addEventListener('click', function() {
        introJs().setOptions({
          steps: [
            {
                        intro: "Welcome to <b>Add Trade Counter</b> page! Let's take a quick tour."
                    },
                    {
                        element: '#porfolio',
                        intro: 'Please select your portfolio in the list tab. Just click the tab and search for your portfolio. '
                    },
                    {
                        element: '#stock',
                        intro: `Please select your stock counter in the list tab. Just click the tab and search for your stock counter. `
                    },
                    {
                        element: '#create-stock',
                        intro: 'You can create the stock counter if are not in the list. Make sure you are follow insturction below.<br></br><small></b>Please enter the correct stock name and stock code acording with the real name. You can follow an example below</br><b>Stock Name : BERJAYA CORPORATION BERHAD</br>Stock Code : BJCORP</small>'
                    },
                    {
                        element: '#price',
                        intro: `Please select your acurate open price counter when your start open your trade counter. `
                    },
                    {
                        element: '#quantity',
                        intro: 'Please enter the accurate quantity that you buy when your start open your trade counter.'
                    },
                    {
                        element: '#date',
                        intro: 'Please enter the accurate date and time when your start open your trade counter.'
                    },
                    {
                        element: '#broker',
                        intro: 'Please select the broker when your start open your trade counter.'
                    },
                    {
                        element: '#remark',
                        intro: 'Your can put the remark for reference.'
                    },
                    {
                        element: '#save',
                        intro: 'Click this <b>Save</b> button for save your open trade counter details.'
                    },
                    {
                        element: '#close',
                        intro: 'Click this <b>Back to Trade Statistic</b> button for going back to your trade statistic page.'
                    },
                    {
                        element: '#restart-tour',
                        intro: 'You can start the tour again, when you need to help.'
                    },
               
            ]
        })
      
        .start();
    });
   
});

    </script>