@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->

  <!-- /.content-header -->
</br>
<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-0">
          @if (count($errors) > 0)
              <div class="alert alert-danger">
                  <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                  <ul>
                      @foreach ($errors->all() as $error)
                          <li>{{ $error }}</li>
                      @endforeach
                  </ul>
              </div>
          @endif
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">View</span>
                          <h3 class="m-0"><strong>Batch Users Account</strong></h3>
                        </div><!-- /.col -->
                        <div  hidden="hidden" class="col-sm-6">
                          <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                          </ol>
                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div>
          <!-- /.card-header -->
          <div class="card-body">
              <div class="row">
            <div class="col-lg-6">
              <div class="card">
                <div class="card-header  border-0">
                <h3 class="card-title"><strong>Batch Information:</strong></h3>
                <div class="card-tools">
                  <div class="card-header border-0">
                    @can('program-edit')
                    <!-- Modal Popup Start -->
                    <a type="button" class="btn btn-warning btn-sm btn-block waves-effect my-1" data-toggle="modal" data-target="#editProgram{{$program->id}}">
                    <i class="far fa-edit"></i>  Edit Batch</a>
                    <!-- Modal Popup End -->
                    <!-- Modal Start -->
                    <div class="modal fade" id="editProgram{{$program->id}}">
                    <div class="modal-dialog">
                      <div class="modal-content">
                        <div class="modal-header">
                          <h4 class="modal-title">Edit Batch</h4>
                          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                          </button>
                        </div>
                        <div class="modal-body">

                          {!! Form::model($program, ['route' => ['programs.update', $program->id], 'method'=>'PATCH']) !!}
                          <div class="form-group text-left">
                            <label for="exampleInputEmail1">Batch Name  </label>
                            {!! Form::text('program_name', null, array('placeholder' => 'Batch Name','class' => 'form-control')) !!}
                         </div>
                         <div class="form-group text-left">
                           <label for="exampleInputEmail1">Batch Date  </label>
                           {!! Form::text('program_date', null, array('placeholder' => 'Batch Date','class' => 'form-control')) !!}
                        </div>
                        <div class="form-group text-left">
                          <label for="exampleInputEmail1">Batch Year  </label>
                          {!! Form::text('program_year', null, array('placeholder' => 'Batch Year','class' => 'form-control')) !!}
                       </div>
                          <!-- /.card-body -->
                          <div class=" text-right">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                          <button type="submit" class="btn btn-dark  waves-effect">Submit</button>
                          </div>
                          {!! Form::close() !!}
                        </div>
                      </div>
                      <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                  </div>
                  <!-- /.modal -->
                    @endcan
                            </div>
             </div>
                </div>
                <div class="card-body">
                  <div class="form-group">
                    <label >Batch Name :  </label><label >&nbsp;&nbsp;&nbsp;{{$program->program_name}}  </label>
                  </br>
                    <label >Batch Date :  </label><label >&nbsp;&nbsp;&nbsp;{{$program->program_date}}  </label>
                  </br>
                    <label >Batch Year :  </label><label >&nbsp;&nbsp;&nbsp;{{$program->program_year}}  </label>
                  </br>
                    <label >Number of User :  </label><label >&nbsp;&nbsp;&nbsp;{{$batchuser_count}}  </label>
                  </div>

                </div>
            </div>
            </div>

            </div>
          </br>
            <table id="example2" class="table table-bordered rounded table-hover">
            <thead class="bg-warning">
          <tr class="text-center">
            <th width="100px">No</th>
            <th>Name</th>
            <th>Portfolio</th>
            <th>Total Winning</th>
            <th>Total Lossing</th>
            <th>Total Profit</th>
            <th>ROI</th>
            <th width="100px">Action</th>
          </tr>
          </thead>
          <tbody>
            @foreach ($programs as $key => $row)
          <tr class="text-center">
            <td class="align-middle">{{ $key + 1 }}</td>
            <td class="align-middle" >{{$row->name}}</td>
            <td class="align-middle" >{{$row->portfolio_name}}</td>
            <td class="align-middle" >{{$row->win}}</td>
            <td class="align-middle" >{{$row->loss}}</td>
            <td class="align-middle" >MYR {{round($row->total_profit, 2)}} </td>
            @if ($row->roi_port > 0)
            <td class="align-middle text-success" >{{round($row->roi_port, 2)}}%</td>
            @else
            <td class="align-middle text-danger" >{{round($row->roi_port, 2)}}%</td>
            @endif
            <td>
              <a class="btn btn-warning btn-sm btn-block waves-effect" href="{{ route('programstatistic.statistic',$row->id) }}"><i class="fas fa-eye"></i>  View</a>


          </tr>
          @endforeach

          </tbody>
        </table>
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
@endsection

    <script type="text/javascript">
                  function deletePrograms(id) {
                    Swal.fire({
                      title: 'Are you sure?',
                      text: "You won't be able to revert this!",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
              if (result.value) {
                event.preventDefault();
                document.getElementById('delete-form-'+id).submit();

              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
              }
              })
                  }
    </script>
