@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">

</br>
<section class="content">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-0">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Overview</span>
                          <h3 class="m-0"><strong>Roles</strong></h3>
                        </div><!-- /.col -->
                        <div  hidden="hidden" class="col-sm-6">
                          <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                          </ol>
                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div>
          <div class="card-header  border-0">
          <div class="card-tools">
            <div class="card-header border-0">
                          @can('role-create')
                          <!-- Modal Popup Start -->
                          <button type="button" class="btn btn-warning btn-block waves-effect" data-toggle="modal" data-target="#createRole">
                            Add Roles
                          </button>
                          <!-- Modal Popup End -->

                          <!-- Modal Start -->
                          <div class="modal fade" id="createRole">
                          <div class="modal-dialog ">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h4 class="modal-title">Add Roles</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>
                              <div class="modal-body">
                                @if (count($errors) > 0)
                                    <div class="alert alert-danger">
                                        <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                                {!! Form::open(array('route' => 'roles.store','method'=>'POST')) !!}
                                  <div class="form-group">
                                    <label for="exampleInputEmail1">Role Name  </label>
                                    {!! Form::text('name', null, array('placeholder' => 'Name','class' => 'form-control')) !!}
                                 </div>
                                 <div class="form-group">
                                     <strong>Permission:</strong>
                                     <br/>
                                     <div class="row">
                                     @foreach($permission as $value)
                                     <div class="col-lg-4">
                                         <label>{{ Form::checkbox('permission[]', $value->id, false, array('class' => 'name')) }}
                                         {{ $value->name }}</label>
                                     <br/>
                                     </div>
                                     @endforeach
                                   </div>
                                 </div>
                                <!-- /.card-body -->
                                <div class=" text-right">
                                  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-dark  waves-effect">Submit</button>
                                </div>
                                {!! Form::close() !!}
                              </div>
                            </div>
                            <!-- /.modal-content -->
                          </div>
                          <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->
                          @endcan
                      </div>
       </div>
          </div>
          <!-- /.card-header -->
          <div class="card-body">
              <table id="example2" class="table table-bordered  table-hover">
                <thead class="bg-warning">
              <tr class="text-center">
                <th width="100px">ID</th>
                <th>Role Name</th>
                <th width="100px">Action</th>
              </tr>
              </thead>
              <tbody>
                @foreach ($data as $key => $role)
              <tr class="text-center">
                <td class="align-middle">{{ $role->id }}</td>
                <td class="align-middle" >{{ $role->name }}</td>
                <td>
                  <a class="btn btn-warning btn-sm btn-block waves-effect" href="{{ route('roles.show',$role->id) }}" alt="Edit"><i class="far fa-eye"></i> View</a>
                  @can('role-edit')
                  <a class="btn btn-warning btn-sm btn-block waves-effect" href="{{ route('roles.edit',$role->id) }}"><i class="far fa-edit"></i> Permission</a>

                  @endcan
                  @can('role-delete')
                  <button class="btn btn-warning btn-sm btn-block waves-effect" type="button" onclick="deleteRoles({{ $role->id }})">
                       <i class="fas fa-trash-alt"></i>  Delete
                       </button>
                       <form id="delete-form-{{ $role->id }}" action="{{ route('roles.destroy',$role->id) }}" method="POST" style="display: none;">
                       @csrf
                       @method('delete')
                       </form>
                       @endcan
                </td>

              </tr>
              @endforeach
              </tbody>
            </table>
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
@endsection

    <script type="text/javascript">
                  function deleteRoles(id) {
                    Swal.fire({
                      title: 'Are you sure?',
                      text: "You won't be able to revert this!",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
              if (result.value) {
                event.preventDefault();
                document.getElementById('delete-form-'+id).submit();

              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
              }
              })
                  }
    </script>
