@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->

  <!-- /.content-header -->
</br>
<section class="content">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-0">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Overview</span>
                          <h3 class="m-0"><strong>User Statistic</strong></h3>
                        </div><!-- /.col -->
                        <div  hidden="hidden" class="col-sm-6">
                          <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                          </ol>
                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div>

          <div class="card-header border-0 ">
            <div class="text-right">
                </div>
              </div>
          <!-- /.card-header -->
          <div class="card-body">
            <!-- <table id="example1" class="table table-bordered table-striped"> -->
              <table id="example2" class="table table-bordered rounded table-hover">
                <thead class="bg-warning">
              <tr class="text-center">
                <th width="100px">No</th>
                <th>Name</th>
                <th>Date</th>
                <th>Year</th>
                <th>Total User</th>
                <th width="100px">Action</th>
              </tr>
              </thead>
              <tbody>
                @foreach ($data as $key => $program)
              <tr class="text-center">
                <td class="align-middle">{{ $program->id }}</td>
                <td class="align-middle" >{{ $program->program_name }}</td>
                <td class="align-middle" >{{ $program->program_date }}</td>
                <td class="align-middle" >{{ $program->program_year }}</td>
                <td class="align-middle" >{{ $program->user_quantity }} <i class="fas fa-user nav-icons"></i></td>
                <td>
                  <a class="btn btn-warning btn-sm btn-block waves-effect" href="{{ route('programstatistic.show',$program->id) }}"><i class="fas fa-eye"></i>  View</a>
                 
                </td>

              </tr>
              @endforeach
              </tbody>
            </table>
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
@endsection

    <script type="text/javascript">
                  function deletePrograms(id) {
                    Swal.fire({
                      title: 'Are you sure?',
                      text: "You won't be able to revert this!",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
              if (result.value) {
                event.preventDefault();
                document.getElementById('delete-form-'+id).submit();

              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
              }
              })
                  }
    </script>
