@extends('layouts.backend.app')
@section('content')



<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->

<section class="content ">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    @if (count($errors) > 0)
        <div class="alert alert-danger">
            <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
      
      <div class="row mb-2"> <!-- big row 1 end-->
      @if ($data->count() == 0)
      <div class="col-lg-12"> <!-- 1 -->
        <div class="card h-100 "> <!-- 2 -->
            <div class="card-body"> <!-- 3 -->

                <div class="row"> <!-- 4 -->
                  <div class="col-12 col-sm-12"> <!-- 5 -->

                    <div class="card elevation-0 h-100"> <!-- 6 -->
                      <div class="card-body"> <!-- 7 -->
                        <div class=" clearfix"> <!-- 8 -->
                          <div class="text-center"> <!-- 9 -->
                            <img src="{{ URL::to('public/backend/images/portfolio.png') }}" class="rounded" width="65%">
                          </div> <!-- 9 -->
                          <div class="text-center mt-2"> <!-- 10 -->
                            <div class="card-header border-0"> <!-- 11 -->
                              <h5 class="m-0"><strong>There is no portfolio record found in your account</strong></h5>
                              <span class="m-0 text-muted">Click button <b>Add Portfolio</b> to add your portfolio record</span>
                            </div> <!-- 11 -->
                          <!--   <a type="button" hidden="hidden" class="btn btn-light" href="{{ route('trades.create') }}"><i class="nav-icon fas fa-plus-circle"></i>    Import</a> -->
                            <a type="button" class="btn btn-light" id="add-portfolio" href="{{ route('portfolios.create') }}"><i class="nav-icon fas fa-plus-circle"></i> Add Porfolio</a>
                          </div> <!-- 10 -->
                        </div> <!-- 9 -->
                      </div> <!-- 8 -->
                    </div><!-- 7 -->
                  </div> <!-- 6 -->
                </div> <!-- 5 -->
            </div> <!-- 4 -->
            </div> <!-- 3 -->
            </div> <!-- 2 -->
            </div> <!-- 1 -->
        @else

        
          <div class="col-lg-12 "> <!-- big col 1 start -->
            <div class="content-header">
      <div class="row mr-0">
                <div  class="col-sm-4 text-right">
                  
                </div><!-- /.col -->
                <div class="col-sm-8 text-right mr-0">
                <a class="btn btn-dark  waves-effect elevation-1 my-1" href="{{ route('portfolios.create') }}" id="portfolio-add" > <i class="nav-icon fas fa-plus-circle"></i>   Add Portfolio</a>&nbsp;&nbsp
                <a class="btn btn-dark  waves-effect elevation-1 my-1" id="restart-tour"> <i class="nav-icon fas fa fa-info-circle"></i>   Start page tour again!</a>&nbsp;&nbsp
                <button class="btn btn-dark  waves-effect elevation-1 my-1" id="need-help" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="nav-icon fas fa fa-info-circle"></i> Need Help?
                </button>&nbsp;&nbsp;

              <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
              <a class="dropdown-item" id="launch-tour-add" ><small>How to add new portfolio?</small></a>
              <a class="dropdown-item" id="launch-tour-edit" ><small>How to edit my portfolio details?</small></a>
              <a class="dropdown-item" id="launch-tour-delete"><small>How to delete my existing portfolio?</small></a>
              <a class="dropdown-item" id="launch-tour-trade"><small>How to open my trade statistic?</small></a>
              <a class="dropdown-item" id="launch-tour-transaction"><small>How to open my portfolio money transaction?</small></a>
              <a class="dropdown-item" id="launch-tour-tradenew"> <small>How to add new trade into my portfolio?</small></a>
              </div>
                </div>
        </div><!-- /.row -->
  </div>
  <!-- /.content-header -->
            <div class="row mb-2"> <!-- small row start -->
              @foreach ($data as $key => $portfolio)
              <div class="col-lg-3"> <!-- small col2 start 1 -->
              <div class="card elevation-1" id="porfolio-details">
                  <div class="content-header">
                    <div class="container-fluid">
                    <div class="row mb-2"> <!-- small row 2 start -->
                        <div class="col-sm-9"> <!-- small col 3 start -->
                          <h5 class="m-0"><strong>{{ $portfolio->portfolio_name }}</strong></h5>
                        </div> <!-- small col 3 end -->
                        <div class="col-sm-3 text-right"> <!-- small col 4 start -->
                            @can('portfolio-edit')
                              <!-- Modal Popup Start -->
                              <a type="button" class="btn btn-light btn-sm btn-block waves-effect my-1" id="porfolio-edit" data-toggle="modal" data-target="#editPortfolio{{$portfolio->id}}" alt="Edit" @if ($loop->first) data-intro="This is the introduction for the first item." @endif>
                              &nbsp;Edit   </a>
                                         <!-- Modal Popup End -->
                              <!-- Modal Start -->
                              <div class="modal fade" id="editPortfolio{{$portfolio->id}}">
                                <div class="modal-dialog">
                                  <div class="modal-content">
                                    <div class="modal-header">
                                      <h5 class="modal-title">Edit Portfolio</h5>
                                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                      </button>
                                    </div>
                                    <div class="modal-body">
                                      @if (count($errors) > 0)
                                          <div class="alert alert-danger">
                                              <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                                              <ul>
                                                  @foreach ($errors->all() as $error)
                                                      <li>{{ $error }}</li>
                                                  @endforeach
                                              </ul>
                                          </div>
                                      @endif
                                      {!! Form::model($portfolio, ['route' => ['portfolios.update', $portfolio->id], 'method'=>'PATCH']) !!}
                                        <div class="form-group text-left">
                                          <label for="exampleInputEmail1">Portfolio Name <br>  <small class="text-danger">Please do not to put number infornt the text. </br>Example:<br> <i class="fa fa-times-circle" aria-hidden="true"></i>1234RHB i-Trade</small>   </label>
                                          {!! Form::text('portfolio_name', null, array('placeholder' => 'portfolio_name','class' => 'form-control')) !!}
                                        </div>
                                        <div class="form-group text-left">
                                          <label for="exampleInputEmail1">Initial Deposit: </label>
                                          {!! Form::number('initial_deposit', null, array('placeholder' => 'Initial Deposit','class' => 'form-control')) !!}
                                        </div>
                                      <!-- /.card-body -->
                                      <div class=" text-right">
                                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                      <button type="submit" class="btn btn-dark  waves-effect">Submit</button>
                                      </div>
                                      {!! Form::close() !!}
                                    </div>
                                  </div>
                                  <!-- /.modal-content -->
                                </div>
                                <!-- /.modal-dialog -->
                            </div>
                            <!-- /.modal -->
                              @endcan
                              @can('portfolio-delete')
                              <button class="btn btn-light btn-sm btn-block waves-effect " id="porfolio-delete" type="button" onclick="deletePortfolio({{ $portfolio->id }})" @if ($loop->first) data-intro="This is the introduction for the cond item." @endif>
                                  &nbsp;Delete
                                  </button>
                                  <form id="delete-form-{{ $portfolio->id }}" action="{{ route('portfolios.destroy',$portfolio->id) }}" method="POST" style="display: none;">
                                  @csrf
                                  @method('delete')
                                  </form>
                                  @endcan
                        </div> <!-- small col 4 end -->
                      </div> <!-- small row 2 start -->
                    </div> <!-- container fluid end -->
                    </div> <!-- container header end -->
                    <div class="card-body text-center" id="porfolio-roi">
                                  <h6>ROI</h6>
                                  @if ($portfolio->roi_port < 0)
                                  <h1 class="align-middle text-danger display-4" > <strong>{{ round($portfolio->roi_port, 2) }}%</strong></h1>
                                  @elseif ($portfolio->roi_port > 1)
                                  <h1 class="align-middle text-success display-4" > <strong>{{ round($portfolio->roi_port, 2) }}%</strong></h1>
                                  @else
                                  <h1 class="align-middle display-4" > <strong>{{ round($portfolio->roi_port, 2) }}%</strong></h1>
                                  @endif
                              </div> <!-- Card Body End -->
                                <div class="card-tools">
                                  <div class="card-header border-0">
                                    <div class="row" id="porfolio-counter"> <!-- small row 3 start -->
                                    <div class="col-sm-6 mt-2" >
                                        <a class="btn btn-primary btn-sm btn-block waves-effect" >  <span>Open Trade </br> {{ $portfolio->open_counter }}</span></a>
                                      </div>
                                      <div class="col-sm-6 mt-2">
                                        <a class="btn btn-danger btn-sm  btn-block waves-effect" >   <span>Close Trade </br> {{ $portfolio->close_counter }}</span></a>
                                      </div>
                                    </div>
                                    <div class="row" id="porfolio-winloss">
                                      <div class="col-sm-6 mt-2">
                                        <a class="btn btn-secondary btn-sm btn-block waves-effect" >  <span>Total Winnings </br> {{ $portfolio->win }}</span></a>
                                      </div>
                                      <div class="col-sm-6 mt-2">
                                        <a class="btn btn-secondary btn-sm  btn-block waves-effect" >   <span>Total Lossings </br> {{ $portfolio->loss }}</span></a>
                                        </div>
                                    </div>
                                        <div class="row" id="porfolio-profit">
                                      <div class="col-sm-12 mt-2">
                                        @if ($portfolio->total_profit < 0)
                                        <a class="btn btn-danger btn-sm btn-block waves-effect" >  <span> Total Profits/Loss  </br>  MYR MYR {{ round($portfolio->total_profit, 2) }} </span></a>
                                        @elseif ($portfolio->total_profit > 1)
                                        <a class="btn btn-success btn-sm btn-block waves-effect" > <span>Total Profits/Loss  </br>MYR MYR {{ round($portfolio->total_profit, 2) }} </span></a>
                                          @else
                                        <a class="btn btn-dark btn-sm btn-block waves-effect" > <span>Total Profits/Loss  </br> MYR {{ round($portfolio->total_profit, 2) }} </span></a>
                                          @endif
                                      </div>  
                                      </div>  
                                      <div class="row" id="porfolio-fund">
                                    <div hidden="hidden" class="col-sm-12 mt-2">
                                      <a class="btn btn-secondary btn-sm btn-block waves-effect" >   <span>Initial Deposit </br> MYR {{ $portfolio->initial_deposit }}</span></a>
                                    </div>
                                    <div class="col-sm-12 mt-2">
                                      <a class="btn btn-info  btn-sm btn-block waves-effect" >   <span>Fund Available </br> MYR {{ round($portfolio->balance_available, 2) }}</span></a>
                                    </div> 
                                   
                                 </div> <!-- small row 3 end -->
                                </div> <!-- card header tools end -->
                               </div><!-- card tools end -->
                               <div class="card-footer border-1">
                              <div class="row "> <!-- small row 4 start -->
                              <div class="col-sm-12 ">
                                          <a class="btn btn-outline-dark btn-sm btn-block waves-effect" href="{{ route('trades.statistic',$portfolio->id) }}" id="porfolio-tradestatistic">  Trade Statistic</a>
                                            </div>
                                            <div class="col-sm-12 mt-2">
                                            <a class="btn btn-outline-dark btn-sm btn-block waves-effect" href="{{ route('portfolios.show',$portfolio->id) }}" id="porfolio-transaction">  Transaction</a>
                                          </div>
                                          <div class="col-sm-12 mt-2">
                                            <a class="btn btn-outline-dark btn-sm btn-block waves-effect" href="{{ route('trades.create') }}" id="porfolio-addtrade">  Add Trade Counter</a>
                                          </div>
                                </div><!-- small row 4 end -->
                              </div><!-- card footer end -->
                </div> <!-- card  end -->
              </div>  <!-- small col2 end 1 -->
              @endforeach 
              
            </div> <!-- small row end -->
          </div> <!-- big col 1 end -->

            <!-- big col 2 start 
            <div class="col-lg-3 order-1 order-md-2"> 

            <div class="row mb-2">
            <div class="col-lg-12 ">
            <div class="card elevation-0" id="portfolio-add">
                <div class="content-header">
                  <div class="container-fluid">
                    <div class="row mb-2">
                              <div class="col-sm-12 text-center">
                                  <h5 class="m-0 "><b>Add Portfolio</b></h5>
                                  <small class="text-center mt-2">Click button below to Add Your Portfolio</small>

                                  <a class="btn btn-outline-dark btn-block waves-effect mt-2" href="{{ route('portfolios.create') }}">  Add Portfolio</a>

                                </div>
                      </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-12 ">
            <div class="card elevation-0" id="portfolio-tutorial">
                <div class="content-header">
                  <div class="container-fluid">
                    <div class="row mb-2">
                              <div class="col-sm-12 text-center">
                                  <h5 class="m-0 "><b>Tutorial</b></h5>
                                  <small class="text-center mt-2">Click button below to lunch tutorial tour</small>
                                  <a class="btn btn-outline-dark btn-block waves-effect mt-2" href="" id="launch-tour-edit">  <small>How to edit my portfolio details?</small></a>
                                  <a class="btn btn-outline-dark btn-block waves-effect mt-2" href="" id="launch-tour-delete">  <small>How to delete my existing portfolio?</small></a>
                                  <a class="btn btn-outline-dark btn-block waves-effect mt-2" href="" id="launch-tour-trade"> <small>How to open my trade statistic?</small></a>
                                  <a class="btn btn-outline-dark btn-block waves-effect mt-2" href="" id="launch-tour-transaction"> <small>How to open my portfolio money transaction?</small></a>
                                  <a class="btn btn-outline-dark btn-block waves-effect mt-2" href="" id="launch-tour-tradenew"> <small>How to add new trade into my portfolio?</small></a>


                                </div>
                      </div>
                  </div>
                </div>
              </div>
            </div>
            </div>
          </div>  big col 2 end -->

      </div> <!-- big row 1 end -->
  </div>
  <!-- /.container-fluid -->

  <!-- Tour for portfolio if have data -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Function to start the tour
        function startTour() {
            introJs().setOptions({
                steps: [
                    {
                        intro: "Welcome to <b>Portfolio Page</b>! Let's take a quick tour."
                    },
                    {
                        element: '#porfolio-details',
                        intro: 'This is your porfolio details.'
                    },
                    {
                        element: '#porfolio-edit',
                        intro: `<div style="text-align: center;">
                                <p>This is the button for <b>Edit</b> your portfolio name and initial deposit in your portfolio. <br> <br><small> Enter the infomation to the popup</small></p>
                                <img src="{{ url('public/backend/images/editportfolio.png') }}" alt="Intro Image" style="max-width: 100%; height: auto;">
                            </div>`
                    },
                    {
                        element: '#porfolio-delete',
                        intro: 'This is the button for <b>Delete</b> of your portfolio.'
                    },
                    {
                        element: '#porfolio-roi',
                        intro: 'This is show <b>ROI</b> in your portfolio. </br></br><b class="text-danger">Red</b> Text = <b class="text-danger">Loss</b></br><b class="text-success">Green</b> Text = <b class="text-success">Profit</b>'
                    },
                    {
                        element: '#porfolio-counter',
                        intro: 'This is show the <b>Open and Close Trade Counter</b> in your portfolio.</br></br><b class="text-primary">Blue</b> Box = <b class="text-primary">Open Trade Counter</b></br><b class="text-danger">Red</b> Box = <b class="text-danger">Close Trade Counter</b>'
                    },
                    {
                        element: '#porfolio-winloss',
                        intro: 'This is show the <b>Winnings and Lossing Trade</b> in your portfolio.'
                    },
                    {
                        element: '#porfolio-profit',
                        intro: 'This is show th <b>Total Profit</b> in your portfolio.</br></br><b class="text-danger">Red</b> Box = <b class="text-danger">Loss</b></br><b class="text-success">Green</b> Box = <b class="text-success">Profit</b>'
                    },
                    {
                        element: '#porfolio-fund',
                        intro: 'This is show th <b>Fund Available</b> in your portfolio.'
                    },
                    {
                        element: '#porfolio-tradestatistic',
                        intro: 'This is the button for show <b>Trade Statistic</b> in your portfolio.'
                    },
                    {
                        element: '#porfolio-transaction',
                        intro: 'This is the button for show <b>Transaction</b> in your portfolio.'
                    },
                    {
                        element: '#porfolio-addtrade',
                        intro: 'This is the button for <b>Add Trade Counter</b> in your portfolio.'
                    },
                    {
                        element: '#portfolio-add',
                        intro: 'This is the button for <b>Add Portfolio</b>'
                    },
                    {
                        element: '#restart-tour',
                        intro: 'This button are fuction to restart again <b>Tutorial Tour</b> in your account.'
                    },
                    {
                        element: '#need-help',
                        intro: 'This is the button for <b>Help Support</b> about your account.'
                    },
                    {
                        intro: `
                            <div style="text-align: center;">
                                <p>Would you like to enable or disable the tour for future visits?</p>
                                <label class="form-check-label">
                                    <input type="radio"  name="tourOption" value="enable" checked> Show again next time
                                </label>
                                </br>
                                <label class="form-check-label">
                                    <input type="radio" name="tourOption" value="disable"> Don't show it again 
                                </label>
                            </div>

                         
                        `,
                        position: 'bottom'
                    }
                ]
            })
            .onbeforeexit(function () {
                return confirm("Stop!! Please complete the page tour before you exit! Are you sure you want to quit page tour?");
            })
            .oncomplete(function() {
                handleTourOption('firstTourOption', 'firstTourDisabled');
            })
            .onexit(function() {
                handleTourOption('firstTourOption', 'firstTourDisabled');
            })
            .start();
        }

        // Function to handle the tour option
        function handleTourOption() {
            const selectedOption = document.querySelector('input[name="tourOption"]:checked').value;
            if (selectedOption === 'disable') {
                // Save preference to localStorage or send to server
                localStorage.setItem('firstTourDisabled', 'true');
            } else {
                localStorage.removeItem('firstTourDisabled');
            }
        }

        // Check if the tour is disabled
        if (!localStorage.getItem('firstTourDisabled')) {
            startTour();
        }
    });
</script>
  @endif


  
</section>
</div>
@endsection




<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-add').addEventListener('click', function() {
        introJs().setOptions({
            steps: [
                {
                    element: '#portfolio-add',
                    intro: 'Click this button <b>Add Portfolio</b> for add new portfolio in your account.'
                },
                {
                    element: '#portfolio-add',
                    intro: 'After you click the page with redirect to create portfolio page'
                },
               
            ]
        })
      
        .start();
    });
   
});

    </script>


<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-edit').addEventListener('click', function() {
        introJs().setOptions({
            steps: [
                {
                    element: '#porfolio-edit',
                    intro: 'Click this button <b>Edit</b> for edit details in your portfolio.'
                },
                {
                    element: '#porfolio-edit',
                    intro: 'After you click the button, modal popup will come out for you enter the details'
                },
               
            ]
        })
      
        .start();
    });
   
});

    </script>


<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-delete').addEventListener('click', function() {
        introJs().setOptions({
          steps: [
            {
                    element: '#porfolio-delete',
                    intro: 'Click this button <b>Delete</b> for delete your existing portfolio.'
                },
                {
                    element: '#porfolio-delete',
                    intro: 'After you click the button, modal popup will come out for confirm your delete portfolio'
                },
               
            ]
        })
      
        .start();
    });
   
});

    </script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-trade').addEventListener('click', function() {
        introJs().setOptions({
          steps: [
            {
                    element: '#porfolio-trade',
                    intro: 'Click this button <b>Trade Statistic</b> for check your trade statistic and trade history'
                },
                {
                    element: '#porfolio-trade',
                    intro: 'After you click the page with redirect to trade statistic page'
                },
               
            ]
        })
      
        .start();
    });
   
});

    </script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('launch-tour-transaction').addEventListener('click', function() {
        introJs().setOptions({
          steps: [
            {
                    element: '#porfolio-transaction',
                    intro: 'Click this button <b>Transaction</b> for check your portfolio transaction and add your transaction deposit and withdrawal'
                },
                {
                    element: '#porfolio-transaction',
                    intro: 'After you click the page with redirect to trade transaction page'
                },
            ]
        })
      
        .start();
    });
   
});
    </script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('porfolio-addtrade').addEventListener('click', function() {
        introJs().setOptions({
          steps: [
            {
                    element: '#porfolio-addtrade',
                    intro: 'Click this button <b>Add Trade</b> for add your trade counter'
                },
                {
                  element: '#porfolio-addtrade',
                    intro: 'After you click the page with redirect to add trade counter page'
                },
               
            ]
        })
      
        .start();
    });
   
});
    </script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('restart-tour').addEventListener('click', function() {
        introJs().setOptions({
          steps: [
            {
                        intro: "Welcome to <b>Portfolio Page</b>! Let's take a quick tour."
                    },
                    {
                        element: '#porfolio-details',
                        intro: 'This is your porfolio details.'
                    },
                    {
                        element: '#porfolio-edit',
                        intro: `<div style="text-align: center;">
                                <p>This is the button for <b>Edit</b> your portfolio name and initial deposit in your portfolio. <br> <br><small> Enter the infomation to the popup</small></p>
                                <img src="{{ url('public/backend/images/editportfolio.png') }}" alt="Intro Image" style="max-width: 100%; height: auto;">
                            </div>`
                    },
                    {
                        element: '#porfolio-delete',
                        intro: 'This is the button for <b>Delete</b> of your portfolio.'
                    },
                    {
                        element: '#porfolio-roi',
                        intro: 'This is show <b>ROI</b> in your portfolio. </br></br><b class="text-danger">Red</b> Text = <b class="text-danger">Loss</b></br><b class="text-success">Green</b> Text = <b class="text-success">Profit</b>'
                    },
                    {
                        element: '#porfolio-counter',
                        intro: 'This is show the <b>Open and Close Trade Counter</b> in your portfolio.</br></br><b class="text-primary">Blue</b> Box = <b class="text-primary">Open Trade Counter</b></br><b class="text-danger">Red</b> Box = <b class="text-danger">Close Trade Counter</b>'
                    },
                    {
                        element: '#porfolio-winloss',
                        intro: 'This is show the <b>Winnings and Lossing Trade</b> in your portfolio.'
                    },
                    {
                        element: '#porfolio-profit',
                        intro: 'This is show the <b>Total Profit</b> in your portfolio.</br></br><b class="text-danger">Red</b> Box = <b class="text-danger">Loss</b></br><b class="text-success">Green</b> Box = <b class="text-success">Profit</b>'
                    },
                    {
                        element: '#porfolio-fund',
                        intro: 'This is show th <b>Fund Available</b> in your portfolio.'
                    },
                    {
                        element: '#porfolio-tradestatistic',
                        intro: 'This is the button for show <b>Trade Statistic</b> in your portfolio.'
                    },
                    {
                        element: '#porfolio-transaction',
                        intro: 'This is the button for show <b>Transaction</b> in your portfolio.'
                    },
                    {
                        element: '#porfolio-addtrade',
                        intro: 'This is the button for <b>Add Trade Counter</b> in your portfolio.'
                    },
                    {
                        element: '#portfolio-add',
                        intro: 'This is the button for <b>Add Portfolio</b>'
                    },
                    {
                        element: '#restart-tour',
                        intro: 'This button are fuction to restart again <b>Tutorial Tour</b> in your account.'
                    },
                    {
                        element: '#need-help',
                        intro: 'This is the button for <b>Help Support</b> about your account.'
                    },
               
            ]
        })
      
        .start();
    });
   
});
    </script>






    <script type="text/javascript">
                  function deletePortfolio(id) {
                    Swal.fire({
                      title: 'Are you sure?',
                      text: "You won't be able to revert this!",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
              if (result.value) {
                event.preventDefault();
                document.getElementById('delete-form-'+id).submit();

              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
              }
              })
                  }
    </script>
