@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->

  <!-- /.content-header -->
</br>
<section class="content">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    @if (count($errors) > 0)
        <div class="alert alert-danger">
            <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-0">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Overview</span>
                          <h3 class="m-0"><strong>Brokerage</strong></h3>
                        </div><!-- /.col -->
                        <div  hidden="hidden" class="col-sm-6">
                          <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                          </ol>
                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div>
          <div class="card-header  border-0">
          <div class="card-tools">
            <div class="card-header border-0">
                          @can('brokerage-create')
                              <!-- Modal Popup Start -->
                              <button type="button" class="btn btn-warning btn-block waves-effect" data-toggle="modal" data-target="#createBrokerage">
                                Add Broker
                              </button>
                              <!-- Modal Popup End -->

                              <!-- Modal Start -->
                              <div class="modal fade" id="createBrokerage">
                              <div class="modal-dialog ">
                                <div class="modal-content">
                                  <div class="modal-header ">
                                    <h5 class="modal-title">Add Broker</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                      <span aria-hidden="true">&times;</span>
                                    </button>
                                  </div>
                                  <div class="modal-body">

                                    {!! Form::open(array('route' => 'brokerages.store', 'method'=>'POST')) !!}
                                      <div class="form-group">
                                        <label for="exampleInputEmail1">Broker Name  </label>
                                        {!! Form::text('broker_name', null, array('placeholder' => 'Brokerage','class' => 'form-control')) !!}
                                     </div>
                                    <div class="form-group">
                                      <label for="exampleInputEmail1">First Fees: </label>
                                      {!! Form::text('first_fees', null, array('placeholder' => 'First Fees','class' => 'form-control')) !!}
                                   </div>
                                   <div class="form-group">
                                     <label for="exampleInputEmail1">Second Fees: </label>
                                     {!! Form::text('second_fees', null, array('placeholder' => 'Second Fees','class' => 'form-control')) !!}
                                  </div>
                                    <!-- /.card-body -->
                                    <div class=" text-right">
                                      <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-dark  waves-effect">Submit</button>
                                    </div>
                                    {!! Form::close() !!}
                                  </div>
                                </div>
                                <!-- /.modal-content -->
                              </div>
                              <!-- /.modal-dialog -->
                            </div>
                            <!-- /.modal -->
                          @endcan
                      </div>
       </div>
          </div>
          <div class="card-header border-0 ">
            <div class="text-right">
              <!-- Button trigger modal
                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#exampleModal1">
                  New Brand
                </button>-->
              <!-- End Button trigger modal
              <button type="button" class="btn btn-default" data-toggle="modal" data-target="#exampleModal1">
                New Users
              </button>-->
                </div>
              </div>
          <!-- /.card-header -->
          <div class="card-body">
            <!-- <table id="example1" class="table table-bordered table-striped"> -->
              <table id="example2" class="table table-bordered rounded table-hover">
                <thead class="bg-warning">
              <tr class="text-center">
                <th width="100px">No</th>
                <th>Broker Name</th>
                <th>Minimum Fees</th>
                <th>Maximum Fees</th>
                <th width="150px">Action</th>
              </tr>
              </thead>
              <tbody>
                @foreach ($data as $key => $brokerage)
              <tr class="text-center">
                <td class="align-middle">{{ $brokerage->id }}</td>
                <td class="align-middle" >{{ $brokerage->broker_name }}</td>
                <td class="align-middle" >{{ $brokerage->first_fees }} MYR</td>
                <td class="align-middle" >{{ $brokerage->second_fees }}%</td>
                <td>
                  @can('stock-edit')

                  <!-- Modal Popup Start -->
                  <a type="button" class="btn btn-warning btn-sm btn-block waves-effect my-1" data-toggle="modal" data-target="#editBrokerage{{$brokerage->id}}">
                  <i class="far fa-edit"></i>  Edit </a>
                  <!-- Modal Popup End -->

                  <!-- Modal Start -->
                  <div class="modal fade" id="editBrokerage{{$brokerage->id}}">
                  <div class="modal-dialog">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h4 class="modal-title">Edit Broker</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      <div class="modal-body">
                        @if (count($errors) > 0)
                            <div class="alert alert-danger">
                                <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        {!! Form::model($brokerage, ['route' => ['brokerages.update', $brokerage->id], 'method'=>'PATCH']) !!}
                          <div class="form-group text-left">
                            <label for="exampleInputEmail1">Broker Name  </label>
                            {!! Form::text('broker_name', null, array('placeholder' => 'Brokerage','class' => 'form-control')) !!}
                         </div>
                        <div class="form-group text-left">
                          <label for="exampleInputEmail1">first Fees: </label>
                          {!! Form::text('first_fees', null, array('placeholder' => 'First Fees','class' => 'form-control')) !!}
                       </div>
                       <div class="form-group text-left">
                         <label for="exampleInputEmail1">Second Fees: </label>
                         {!! Form::text('second_fees', null, array('placeholder' => 'Second Fees','class' => 'form-control')) !!}
                      </div>
                        <!-- /.card-body -->
                        <div class=" text-right">
                          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-dark  waves-effect">Submit</button>
                        </div>
                        {!! Form::close() !!}
                      </div>
                    </div>
                    <!-- /.modal-content -->
                  </div>
                  <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
                  @endcan
                  @can('stock-delete')
                  <button class="btn btn-warning btn-sm btn-block waves-effect" type="button" onclick="deleteBrokerages({{ $brokerage->id }})">
                       <i class="fas fa-trash-alt"></i>  Delete
                       </button>
                       <form id="delete-form-{{ $brokerage->id }}" action="{{ route('brokerages.destroy',$brokerage->id) }}" method="POST" style="display: none;">
                       @csrf
                       @method('delete')
                       </form>
                       @endcan
                </td>

              </tr>
              @endforeach
              </tbody>
            </table>
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
@endsection

    <script type="text/javascript">
                  function deleteBrokerages(id) {
                    Swal.fire({
                      title: 'Are you sure?',
                      text: "You won't be able to revert this!",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
              if (result.value) {
                event.preventDefault();
                document.getElementById('delete-form-'+id).submit();

              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
              }
              })
                  }
    </script>
