@extends('layouts.app')
@section('content')
<div class="container">
    <div class="justify-content-center">
        @if (count($errors) > 0)
            <div class="alert alert-danger">
                <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card">
            <div class="card-header">Add Broker
                <span class="float-right">
                    <a class="btn btn-primary" href="{{ route('brokerages.index') }}">Brokerages</a>
                </span>
            </div>

            <div class="card-body">
                {!! Form::open(array('route' => 'brokerages.store', 'method'=>'POST')) !!}
                    <div class="form-group">
                        <strong>Broker Name:</strong>
                        {!! Form::text('broker_name', null, array('placeholder' => 'Brokerage','class' => 'form-control')) !!}
                    </div>
                    <div class="form-group">
                        <strong>First Fees:</strong>
                        {!! Form::text('first_fees', null, array('placeholder' => 'First Fees','class' => 'form-control')) !!}
                    </div>

                    <div class="form-group">
                        <strong>Second Fees:</strong>
                        {!! Form::text('second_fees', null, array('placeholder' => 'Second Fees','class' => 'form-control')) !!}
                    </div>
                    <button type="submit" class="btn btn-primary">Submit</button>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>
@endsection
