@extends('layouts.backend.app')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->

  <!-- /.content-header -->
</br>
<section class="content">
  <div class="container-fluid">
    @if (\Session::has('success'))
        <div class="alert alert-success">
            <p>{{ \Session::get('success') }}</p>
        </div>
    @endif
    <div class="row">
      <div class="col-lg-12">
        <div class="card elevation-0">
          <div class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                        <div class="col-sm-6">
                          <span class="m-0 text-muted">Update</span>
                          <h3 class="m-0"><strong>Board</strong></h3>
                        </div><!-- /.col -->
                        <div  hidden="hidden" class="col-sm-6">
                          <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                          </ol>
                        </div><!-- /.col -->
                      </div><!-- /.row -->
            </div><!-- /.container-fluid -->
          </div>

          <!-- /.card-header -->
          <div class="card-body">
            @can('board-create')
            <a href="#createBrokerage" class="btn btn-warning btn-block mb-3" class="btn btn-warning btn-block waves-effect" data-toggle="modal" data-target="#createBrokerage"> <i class="nav-icon far fa-comment-alt"></i>&nbsp;&nbsp;New Update</a>
            @endcan

            @can('board-create')
            <!-- <a href="#createBrokerage" class="btn btn-warning btn-block mb-3" class="btn btn-warning btn-block waves-effect" data-toggle="modal" data-target="#createBrokerage"> <i class="nav-icon far fa-comment-alt"></i>&nbsp;&nbsp;New Update</a> -->

                <!-- Modal Start -->
                <div class="modal fade" id="createBrokerage">
                <div class="modal-dialog ">
                  <div class="modal-content">
                    <div class="modal-header ">
                      <h5 class="modal-title">Add Update</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
                    <div class="modal-body">
                      @if (count($errors) > 0)
                          <div class="alert alert-danger">
                              <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                              <ul>
                                  @foreach ($errors->all() as $error)
                                      <li>{{ $error }}</li>
                                  @endforeach
                              </ul>
                          </div>
                      @endif
                      <form action="{{ route('upadate-boards.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="form-group">
                          <label class="form-label">Cover Image</label>
                          <div class="row clearfix">
                            <div class="col-lg-12 ">
                              <div class="file-upload file-uploadAll">
                                <div class="image-upload-wrap image-upload-wrapAll">

                                  <input class="file-upload-input file-upload-inputAll" type='file'
                                  onchange="readURL(this);" accept="image/*" name="cover_image"
                                  multiple/>
                                  <div class="drag-text drag-textAll">
                                    <h5>Drag and drop a image or select upload image</br>
                                    Image size : 1024 x 768px </br>
                                  File Size : Max 10MB </h5>
                                  </div>
                                </div>
                                <div class="file-upload-content file-upload-contentAll">
                                  <img class="file-upload-image file-upload-imageAll" src="#"
                                  alt="your image"/>
                                  <div class="image-title-wrap image-title-wrapAll">
                                    <button type="button" onclick="removeUpload()"
                                    class="btn-sm remove-image remove-imageAll">Remove <span
                                    class="image-title image-titleAll">Uploaded Image</span>
                                  </button>
                                </div>
                              </div>
                            </div>
                            <div hidden="hidden" id="addImageDiv">
                              <center>
                                <button id="btnAddmul" type="button" onclick="addMul('add')"
                                class="btn btn-success"
                                style="width: 140px;height: 36px; font-size: 1.5em; padding: 3px;">
                                Add
                              </button>
                            </center>
                          </div>
                        </div>
                      </div>
                    </div>


                   <div class="form-group">
                     <label for="exampleInputEmail1">Title  </label>
                     <input type="text"  class="form-control"  placeholder="Title" name="title" >
                  </div>

                <div class="form-group">
                   <label for="exampleInputEmail1">Message </label>
                   <textarea class="summernote" name="message" ></textarea>
                </div>
                <div hidden="hidden" class="form-group">
                  <label for="exampleInputEmail1">Status  </label>
                  <input type="text"  class="form-control"  value="1" name="status" >
               </div>
               <div hidden="hidden" class="form-group">
                 <label for="exampleInputEmail1">Author  </label>
                 <input type="text"  class="form-control"  value="{{ Auth::user()->name }}" name="author" >
              </div>

                 <!-- /.card-body -->
                 <div class=" text-right">
                   <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                 <button type="submit" class="btn btn-dark  waves-effect">Submit</button>
                 </div>
             </form>
                    </div>
                  </div>
                  <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
              </div>
              <!-- /.modal -->
            @endcan
            @foreach ($data as $key => $board)

            <div class="card card-widget collapsed-card">
                      <div class="card-header">
                        <div class="user-block">

                          <img class="img-circle" src="{{ url('public/backend/images/user2-160x160.jpg') }}" width="40" height="40" alt="">
                          <span class="username"><a href="" data-card-widget="collapse">{{ $board -> title}}</a></span>
                          <span class="description">{{$board->author}} - {{ $board->created_at->format('D, j F Y, h:i A') }}</span>
                        </div>
                        <!-- /.user-block -->
                        <div class="card-tools">
                          <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-plus"></i>
                          </button>
                          <button type="button" class="btn btn-tool" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                          </button>
                            <a  type="button" onclick="deleteBoard({{ $board->id }})">
                                 <i class="fas fa-trash-alt btn-tool"></i>
                               </a>
                               <form id="delete-form-{{ $board->id }}" action="{{ route('upadate-boards.destroy',$board->id) }}" method="POST" style="display: none;">
                               @csrf
                               @method('delete')
                               </form>
                        </div>
                        <!-- /.card-tools -->
                      </div>
                      <!-- /.card-header -->
                       @if ($board->cover_image == 'default.png')
                      <div class="card-body" style="display: none;">
                        <p>{!! html_entity_decode($board->message) !!}</p>

                      </div>
                       @else
                      <div class="card-body" style="display: none;">
                        <img class="img-fluid pad" src="{{ url('/storage/app/billboard/' . $board->cover_image) }}" alt="Photo">
                      <br></br>
                        <p>{!! html_entity_decode($board->message) !!}</p>

                      </div>                       
                       @endif
                     
                      <!-- /.card-body -->
                      <div hidden="hidden" class="card-footer card-comments" style="display: none;">
                        <div class="card-comment">
                          <!-- User image -->
                          <img class="img-circle img-sm" src="../dist/img/user3-128x128.jpg" alt="User Image">

                          <div class="comment-text">
                            <span class="username">
                              Maria Gonzales
                              <span class="text-muted float-right">8:03 PM Today</span>
                            </span><!-- /.username -->
                            It is a long established fact that a reader will be distracted
                            by the readable content of a page when looking at its layout.
                          </div>
                          <!-- /.comment-text -->
                        </div>
                        <!-- /.card-comment -->
                        <div class="card-comment">
                          <!-- User image -->
                          <img class="img-circle img-sm" src="../dist/img/user4-128x128.jpg" alt="User Image">

                          <div class="comment-text">
                            <span class="username">
                              Luna Stark
                              <span class="text-muted float-right">8:03 PM Today</span>
                            </span><!-- /.username -->
                            It is a long established fact that a reader will be distracted
                            by the readable content of a page when looking at its layout.
                          </div>
                          <!-- /.comment-text -->
                        </div>
                        <!-- /.card-comment -->
                      </div>
                      <!-- /.card-footer -->
                      <div  class="card-footer" style="display: none;">
                      <span class="description"><small>{{ $board->created_at->format('D, j F Y') }}</small></span>
                      </div>
                      <!-- /.card-footer -->
                    </div>
                    @endforeach

        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->

    </div>
    <!-- /.row -->
  </div>
  <!-- /.container-fluid -->
</section>
@endsection
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>

<script>
  $(document).ready(function() {
      $('#summernote').summernote();
  });
</script>

<script type="text/javascript">
    $(document).ready(function() {
      $('.summernote').summernote({
        placeholder: 'Insert message here ',
        tabsize: 2,
        height: 200,});
    });
</script>
    <script type="text/javascript">
                  function deleteBoard(id) {
                    Swal.fire({
                      title: 'Are you sure?',
                      text: "You won't be able to revert this!",
                      icon: 'warning',
                      showCancelButton: true,
                      confirmButtonColor: '#3085d6',
                      cancelButtonColor: '#d33',
                      confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
              if (result.value) {
                event.preventDefault();
                document.getElementById('delete-form-'+id).submit();

              Swal.fire(
                'Deleted!',
                'Your file has been deleted.',
                'success'
              )
              }
              })
                  }
    </script>
    <script>
    function readURL(input) {
        if (input.files && input.files[0]) {

            var reader = new FileReader();

            reader.onload = function (e) {
                $('.image-upload-wrap').hide();

                $('.file-upload-image').attr('src', e.target.result);
                $('.file-upload-content').show();

                $('.image-title').html(input.files[0].name);
            };

            reader.readAsDataURL(input.files[0]);

        } else {
            removeUpload();
        }
    }

    function removeUpload() {
        $('.file-upload-input').replaceWith($('.file-upload-input').clone());
        $('.file-upload-content').hide();
        $('.image-upload-wrap').show();
    }

    $('.image-upload-wrap').bind('dragover', function () {
        $('.image-upload-wrap').addClass('image-dropping');
    });
    $('.image-upload-wrap').bind('dragleave', function () {
        $('.image-upload-wrap').removeClass('image-dropping');
    });


    function readURL2(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('.image-upload-wrap2').hide();
                $('.file-upload-image2').attr('src', e.target.result);
                $('.file-upload-content2').show();
                $('.image-title2').html(input.files[0].name);
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            removeUpload();
        }
    }

    function removeUpload2() {
        $('.file-upload-input2').replaceWith($('.file-upload-input2').clone());
        $('.file-upload-content2').hide();
        $('.image-upload-wrap2').show();
    }

    $('.image-upload-wrap2').bind('dragover', function () {
        $('.image-upload-wrap2').addClass('image-dropping');
    });
    $('.image-upload-wrap2').bind('dragleave', function () {
        $('.image-upload-wrap2').removeClass('image-dropping');
    });

    function readURL3(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('.image-upload-wrap3').hide();
                $('.file-upload-image3').attr('src', e.target.result);
                $('.file-upload-content3').show();
                $('.image-title3').html(input.files[0].name);
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            removeUpload();
        }
    }

    function removeUpload3() {
        $('.file-upload-input3').replaceWith($('.file-upload-input3').clone());
        $('.file-upload-content3').hide();
        $('.image-upload-wrap3').show();
    }

    $('.image-upload-wrap3').bind('dragover', function () {
        $('.image-upload-wrap3').addClass('image-dropping');
    });
    $('.image-upload-wrap3').bind('dragleave', function () {
        $('.image-upload-wrap3').removeClass('image-dropping');
    });

    function readURL4(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('.image-upload-wrap4').hide();
                $('.file-upload-image4').attr('src', e.target.result);
                $('.file-upload-content4').show();
                $('.image-title4').html(input.files[0].name);
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            removeUpload();
        }
    }

    function removeUpload4() {
        $('.file-upload-input4').replaceWith($('.file-upload-input4').clone());
        $('.file-upload-content4').hide();
        $('.image-upload-wrap4').show();
    }

    $('.image-upload-wrap4').bind('dragover', function () {
        $('.image-upload-wrap4').addClass('image-dropping');
    });
    $('.image-upload-wrap4').bind('dragleave', function () {
        $('.image-upload-wrap4').removeClass('image-dropping');
    });


    function readURL5(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('.image-upload-wrap5').hide();
                $('.file-upload-image5').attr('src', e.target.result);
                $('.file-upload-content5').show();
                $('.image-title5').html(input.files[0].name);
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            removeUpload();
        }
    }

    function removeUpload5() {
        $('.file-upload-input5').replaceWith($('.file-upload-input5').clone());
        $('.file-upload-content5').hide();
        $('.image-upload-wrap5').show();
    }

    $('.image-upload-wrap5').bind('dragover', function () {
        $('.image-upload-wrap5').addClass('image-dropping');
    });
    $('.image-upload-wrap5').bind('dragleave', function () {
        $('.image-upload-wrap5').removeClass('image-dropping');
    });


    function readURL6(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('.image-upload-wrap6').hide();
                $('.file-upload-image6').attr('src', e.target.result);
                $('.file-upload-content6').show();
                $('.image-title6').html(input.files[0].name);
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            removeUpload();
        }
    }

    function removeUpload6() {
        $('.file-upload-input6').replaceWith($('.file-upload-input6').clone());
        $('.file-upload-content6').hide();
        $('.image-upload-wrap6').show();
    }

    $('.image-upload-wrap6').bind('dragover', function () {
        $('.image-upload-wrap6').addClass('image-dropping');
    });
    $('.image-upload-wrap6').bind('dragleave', function () {
        $('.image-upload-wrap6').removeClass('image-dropping');
    });

  </script>
  <script type="text/javascript">
  $(document).ready(function(){

    $(document).on('change','.category',function(){
      //console.log("hmm its change");

      var cat_id=$(this).val();
      // console.log(cat_id);
      var div=$(this).parent();

      var op=" ";

      $.ajax({
        type:'get',
        url:'{!!URL::to('findCategoryName')!!}',
        data:{'id':cat_id},
        success:function(data){
          //console.log('success');

          //console.log(data);
        //  console.log(data.length);
          op+='<option value="0" selected disabled>- Select Sub-Category/Sub-Brand - </option>';
                  for(var i=0;i<data.length;i++){
                  op+='<option value="'+data[i].id+'">'+data[i].name+'</option>';
                   }
                   div.find('.name').html(" ");
                   div.find('.name').append(op);

        },
        error:function(){

        }
      });
    });
  });
  </script>
  <script type="text/javascript">
    $(document).ready(function () {
        // count = 1;
    });

    function addMul(action) {
        // alert(action);

        var image2 = document.getElementById('image2');
        image2h = image2.hidden;
        var image3 = document.getElementById('image3');
        var image4 = document.getElementById('image4');
        var image5 = document.getElementById('image5');
        var image6 = document.getElementById('image6');

        var addImageDiv = document.getElementById('addImageDiv');
        var addImageDiv2 = document.getElementById('addImageDiv2');

        var btnAddmul = document.getElementById('btnAddmul');
        var btnAddmul6 = document.getElementById('btnAddmul6');
        // alert(btnAddmul);
        // return;

        if (action == 'add') {
            // alert(action);
            // alert(image2h);
            image2.style.display = 'block';
            addImageDiv.style.display = 'none';
        } else if (action == 'add2') {
            // alert(image2h);
            image3.style.display = 'block';
        } else if (action == 'add3') {
            // alert(image2h);
            image4.style.display = 'block';
        } else if (action == 'add4') {
            // alert(image2h);
            image5.style.display = 'block';
        } else if (action == 'add5') {
            // alert(image2h);
            image6.style.display = 'block';
            btnAddmul6.innerHTML = 'Full';
            btnAddmul6.disabled = true;
        }


        if (action == 'minus2') {
            addImageDiv.style.display = 'block';
            // alert(image2h);
            image2.style.display = 'none';
        } else if (action == 'minus3') {
            addImageDiv2.style.display = 'block';
            image3.style.display = 'none';
        } else if (action == 'minus4') {
            addImageDiv3.style.display = 'block';
            image4.style.display = 'none';
        } else if (action == 'minus5') {
            addImageDiv4.style.display = 'block';
            image5.style.display = 'none';
        } else if (action == 'minus6') {
            addImageDiv5.style.display = 'block';
            image6.style.display = 'none';
            btnAddmul.innerHTML = 'Add';
        }

    }
  </script>
  <style>
  #addmul {

  }



  .file-uploadAll {
  margin: 0 auto;
  padding: 0;

  }

  .file-upload-btnAll {
  width: 100%;
  margin: 0;
  background: #fbfbfb;
  border: 1px solid;
  padding: 5px 10px;
  border-radius: 5px;
  transition: all .2s ease;
  text-transform: uppercase;
  font-weight: 700;
  color: #212529;
  border-color: #dae0e5;
  }

  .file-upload-btnAll:hover {

  transition: all .2s ease;
  cursor: pointer;
  background: #333;
  color: #fff;
  border-color: #333;
  }

  .file-upload-btnAll:active {
  border: 0;
  transition: all .2s ease;
  }

  .file-upload-contentAll {
  display: none;
  text-align: center;
  margin-top: 20px;
  position: relative;
  padding: 0px 0;
  }

  .file-upload-inputAll {
  position: absolute;
  margin: 0;
  padding: 0;
  width: 100%;
  height: 100%;
  outline: none;
  opacity: 0;
  cursor: pointer;
  }

  .image-upload-wrapAll {
  margin-top: 0px;
  border: 4px dashed #ddd;
  position: relative;
  padding: 10px;
  }
  .drag-textAll h5{
  margin: 0;
  font-weight: 500;
  font-size: 14px;
  font-style: italic;
  }
  .image-droppingAll, .image-upload-wrapAll:hover {
  background-color: #f5f5f5;
  border: 4px dashed #ddd;
  }

  .image-title-wrapAll {
  padding: 0 0px px 15px;
  color: #222;
  }

  .drag-textAll {
  text-align: center;
  }

  .drag-textAll h3 {
  font-weight: 100;
  text-transform: uppercase;
  color: #15824B;
  padding: 60px 0;
  }

  .file-upload-imageAll {
  max-height: 180px;
  max-width: 100%;
  margin: auto;
  padding: 0;
  }

  .remove-imageAll {
  width: 100%;
  margin: 10px 0;
  color: #fff;
  background: #cd4535;
  border: none;
  padding: 10px;
  border-radius: 4px;
  border-bottom: 4px solid #b02818;
  transition: all .2s ease;
  outline: none;
  text-transform: capitalize;
  font-weight: 700;
  }

  .remove-imageAll:hover {
  background: #c13b2a;
  color: #ffffff;
  transition: all .2s ease;
  cursor: pointer;
  }

  .remove-imageAll:active {
  border: 0;
  transition: all .2s ease;
  }

  </style>
