@extends('layouts.verify.app')

@section('content')
</br>
</br>
</br>
</br>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Verify Your Email Address') }}</div>

                <div class="card-body">
                    @if (session('resent'))
                        <div class="alert alert-success" role="alert">
                            {{ __('A fresh verification link has been sent to your email address.') }}
                        </div>
                    @endif

                    {{ __('Before proceeding to the system, please check your email for a verification link.') }}
                    {{ __('If you did not receive the email') }},
                    <form class="d-inline" method="POST" action="{{ route('verification.resend') }}">
                        @csrf
                        <button type="submit" class="btn btn-link p-0 m-0 align-baseline">{{ __('Click here to request another') }}</button>.
                    </form>
                </div>
            </div>
        </div>
    </div>
    <section class="content">
      <div class="container-fluid">

                <div class="row justify-content-center">
                  <div class="col-md-8">
                    <div class="card elevation-1">
                      <div class="card-body">
                        <h5 class="m-0"><strong>User Details</strong></h5>
                        <span class="m-0 text-muted">Update the information below. Please insert the true email.</span>
                      </br>
                    </br>
                    @if (\Session::has('success'))
                        <div class="alert alert-success">
                            <p>{{ \Session::get('success') }}</p>
                        </div>
                    @endif
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Opps!</strong> Something went wrong, please check below errors.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form id="update-form-{{ Auth::user()->id }}" method="POST" action="{{ route('profile.update') }}" class="form-horizontal" enctype="multipart/form-data">
                      @csrf
                       @method('PUT')
                      <div class="card-body">
                        <div class="form-group">
                          <label for="exampleInputEmail1">Name  </label>
                          <input type="text" id="name" class="form-control"  placeholder="Enter your name" name="name" value="{{ Auth::user()->name }}">
                       </div>
                        <div class="form-group">
                          <label for="exampleInputPassword1">Email Address</label>
                          <input type="text" id="email_address_2" class="form-control" placeholder="Enter your email address" name="email" value="{{ Auth::user()->email }}">
                        </div>
                        <div class="form-group">
                          <label for="exampleInputPassword1">Phone Number</label>
                          <input type="text" id="phone" class="form-control" placeholder="Enter your phone number" name="phone" value="{{ Auth::user()->phone }}">
                        </div>

                      </div>
                      <!-- /.card-body -->
                      <div class="float-right">
                          <button type="submit" class="btn btn-warning m-t-15 waves-effect" onclick="updateAuthors({{ Auth::user()->id }})">Update Account</button>
                          <!-- <button type="submit" class="btn btn-warning m-t-15 waves-effect" onclick="deleteAuthors({{ Auth::user()->id }})">Deactive Account</button> -->
                          </div>
                       </form>

                      <form id="delete-form-{{ Auth::user()->id }}" action="{{ route('profile.destroy',Auth::user()->id) }}" method="POST" style="display: none;">
                       @csrf
                       @method('DELETE')
                       </form>
                      </div>
                    </div>
                  </div>
                </div>


      </div>
      <!-- /.container-fluid -->
    </section>
</div>


@endsection
