<head>
	<title>Register</title>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	    <link rel="icon" href="{{ URL::to('public/backend/images/AdminLTELogo.png') }}" width="20px"  type="image/x-icon">
<!-- Google Font: Source Sans Pro -->
 <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
 <!-- Font Awesome -->
 <link rel="stylesheet" href="{{ URL::to('public/backend/plugins/fontawesome-free/css/all.min.css') }}">
 <!-- icheck bootstrap -->
 <link rel="stylesheet" href="{{ URL::to('public/backend/plugins/icheck-bootstrap/icheck-bootstrap.min.css') }}">
 <!-- Theme style -->
 <link rel="stylesheet" href="{{ URL::to('public/backend/css/adminlte.min.css') }}">
</head>

 <body class="hold-transition register-page">
<div class="register-box">
  <div class="register-logo">
    <a href="{{url ('home')}}"><strong>The Protege Portal</strong></a>
  </div>

  <div class="card">
    <div class="card-body register-card-body">
			<h5 class="text-center mb-3"><strong>Register a new student</strong></h5>

      <form method="POST" action="{{ route('register') }}">
				@csrf
				<hr></hr>
				<h6 class="text-center mb-3 text-mute">Information Details</h6>
        <div class="input-group mb-3">
					<input class="form-control @error('name') is-invalid @enderror" id="name" type="text" name="name" value="{{ old('name') }}" required autofocus placeholder="Full Name">
					<div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-user"></span>
            </div>
          </div>
					@error('name')
							<span class="invalid-feedback" role="alert">
									<strong>{{ $message }}</strong>
							</span>
					@enderror
        </div>
        <div class="input-group mb-3">
					<input class="form-control @error('email') is-invalid @enderror" id="email" type="text" name="email" value="{{ old('email') }}" required autofocus placeholder="Email">
					<div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-envelope"></span>
            </div>
          </div>
					@error('email')
						 <span class="invalid-feedback" role="alert">
								 <strong>{{ $message }}</strong>
						 </span>
				 @enderror
        </div>
				<div class="input-group mb-3">
					<input class="form-control @error('phone') is-invalid @enderror" id="phone" type="text" name="phone" value="{{ old('phone') }}" required autofocus placeholder="Phone">
					<div class="input-group-append">
						<div class="input-group-text">
							<span class="fas fa-phone"></span>
						</div>
					</div>
					@error('phone')
						 <span class="invalid-feedback" role="alert">
								 <strong>{{ $message }}</strong>
						 </span>
				 @enderror
			 </div>

				<div class="form-group">
													<select name="batch_id" id="batch_id" class="form-control @error('batch_id') is-invalid @enderror" required>
													<option>Select Batch</option>
													@foreach($data as $data)
															 <option  value="{{$data->id}}">{{$data->program_name}}  {{$data->program_date}}</option>
															 @endforeach
												</select>
											</div>
				<hr></hr>
				<h6 class="text-center mb-3 text-mute">Password Details </br><small class="text-center mb-3 text-mute text-danger ">Use minimum 8 characters with a mix of letters, numbers & symbols.</small></h6>

        <div class="input-group mb-3">
					<input class="form-control @error('password') is-invalid @enderror" id="password" type="password" name="password" required placeholder="Password">
				  <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-lock"></span>
            </div>
          </div>
					@error('password')
							<span class="invalid-feedback" role="alert">
									<strong>{{ $message }}</strong>
							</span>
					@enderror
        </div>
        <div class="input-group mb-3">
					<input class="form-control" id="password-confirm" type="password" name="password_confirmation" required autocomplete="new-password" placeholder="Retype Password">
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-lock"></span>
            </div>
          </div>
        </div>


        <div class="row">

          <div class="col-12">
            <button type="submit" class="btn btn-warning btn-block">Register</button>
          </div>
          <!-- /.col -->
        </div>
      </form>



			<h6 class="text-center mb-3 text-mute"><strong>Have an Account ?</strong></h6>

						<a class="btn btn-warning btn-block" href="{{ route('login') }}" >
							Login Here
						</a>
    </div>
    <!-- /.form-box -->
  </div><!-- /.card -->
</div>
<!-- /.register-box -->

<!-- jQuery -->
<script src="{{ URL::to('public/backend/plugins/jquery/jquery.min.js') }}"></script>
<!-- Bootstrap 4 -->
<script src="{{ URL::to('public/backend/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
<!-- AdminLTE App -->
<script src="{{ URL::to('public/backend/dist/js/adminlte.min.js') }}"></script>
