<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTradesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trades', function (Blueprint $table) {
            $table->id();
            $table->string('user_id');
            $table->string('action');
            $table->string('portfolio_id');
            $table->string('stock_name');
            $table->string('date');
            $table->string('price');
            $table->string('quantity');
            $table->string('brokerage_id');
            $table->string('subtotal');
            $table->string('broker_fee');
            $table->string('stamp_duty');
            $table->string('clearing_fee');
            $table->string('total_cost');
            $table->string('remark');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('trades');
    }
}
