<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Trade extends Model
{
  use HasFactory;

  public function user()
   {
       return $this->belongsTo('App\Models\User');
   }
   public function portfolio()
    {
        return $this->belongsTo('App\Models\Portfolio');
    }
    public function brokerage()
     {
         return $this->belongsTo('App\Models\Brokerage');
     }

     public function result()
     {
         return $this->belongsTo('App\Models\Result');
     }


  /**
   * The attributes that are mass assignable.
   *
   * @var array
   */
  protected $fillable = [
      'user_id',
      'portfolio_id',
      'result_id',
      'brokerage_id',
      'action',
      'stock_name',
      'price',
      'quantity',
      'date',
      'remark',
  ];
}
