<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Result extends Model
{
  use HasFactory;

  public function user()
   {
       return $this->belongsTo('App\Models\User');
   }
   public function portfolio()
    {
        return $this->belongsTo('App\Models\Portfolio');
    }

    public function trade()
    {
        return $this->hasMany('App\Models\Trade','result_id','id');
    }
    public function result()
    {
        return $this->hasMany('App\Models\Result');
    }
  /**
   * The attributes that are mass assignable.
   *
   * @var array
   */
  protected $fillable = [
      'user_id',
      'portfolio_id',
      'trade_id',
  ];
}
