<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Portfolio extends Model
{
  use HasFactory;

  public function user()
   {
       return $this->belongsTo('App\Models\User');
   }

   public function transaction()
   {
       return $this->hasMany('App\Models\Transaction');
   }
   public function trade()
   {
       return $this->hasMany('App\Models\Trade');
   }
   public function result()
   {
       return $this->hasMany('App\Models\Result');
   }
  /**
   * The attributes that are mass assignable.
   *
   * @var array
   */
  protected $fillable = [
      'portfolio_name',
      'initial_deposit',
  ];
}
