<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendEmail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public $sub;
    public $mes;
    public $ima;


    public function __construct($title, $message, $image)
    {
        $this->sub = $title;
        $this->mes = $message;
        $this->ima = $image;

    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $e_subject = $this->sub;
        $e_message = $this->mes;
        $e_image = $this->ima;


        return $this->view('mail.sendmail', compact('e_message' , 'e_subject' , 'e_image'))->subject("Website  : $e_subject");
    }
}
