<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Transaction;
use App\Models\Portfolio;
use Illuminate\Support\Facades\Auth;
use DB;

class TransactionController extends Controller
{
  /**
   * create a new instance of the class
   *
   * @return void
   */
  function __construct()
  {
       $this->middleware('permission:transaction-list|transaction-create|transaction-edit|transaction-delete', ['only' => ['index','store']]);
       $this->middleware('permission:transaction-create', ['only' => ['create','store']]);
       $this->middleware('permission:transaction-edit', ['only' => ['edit','update']]);
       $this->middleware('permission:transaction-delete', ['only' => ['destroy']]);
  }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      $data = Auth::user()->transaction()->latest()->get();
      return view('transactions.index',compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
      return view('transactions.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
          'type' => 'required',
          'amount' => 'required',
          'remark' => 'required',
        ]);

        $transaction = new Transaction();
        $transaction->type = $request->type;
        $transaction->amount = $request->amount;
        $transaction->remark = $request->remark;
        $transaction->date = $request->date;
        $transaction->portfolio_id = $request->portfolio_id;
        $transaction->user_id = Auth::id();
        $transaction->save();

        if ($request->type == 'Deposit')
        {
          $total_deposit = Transaction::where('portfolio_id', $request->portfolio_id)
          ->where('user_id', Auth::id())
          ->where('type', 'Deposit')
          ->sum('amount');

          $update_port = DB::table('portfolios')
          ->where('id', $request->portfolio_id)
          ->where('user_id', Auth::id())
          ->update([
            "deposit" => $total_deposit,
          ]);
          // Update into balance_avaiable(portfolio) Strat //

          $total_available_balance_in_portfolio = Portfolio::where('id' , $request->portfolio_id)
                                                ->where ('user_id', Auth::id())
                                                ->pluck('balance_available')
                                                ->first();

           $subtotal_balance_available = $total_available_balance_in_portfolio + $total_deposit;

           $portfolio_ppdate = DB::table('portfolios')
            ->where('id', $request->portfolio_id)
            ->where('user_id', Auth::id())
                  ->update([
                    "balance_available" => $subtotal_balance_available,
                          ]);
        // Update into balance_avaiable(portfolio) End //
        $total_initial_deposit_in_portfolio = Portfolio::where('id' , $request->portfolio_id)
                                              ->where ('user_id', Auth::id())
                                              ->pluck('initial_deposit')
                                              ->first();

         $roi_port = ($subtotal_balance_available - $total_initial_deposit_in_portfolio) / $total_initial_deposit_in_portfolio *100;

         $update_roi_port = DB::table('portfolios')
         ->where('id', $request->portfolio_id)
         ->where('user_id', Auth::id())
         ->update([
           "roi_port" => $roi_port,
         ]);

        }
        else
        {
          $total_withdraw = Transaction::where('portfolio_id', $request->portfolio_id)
                  ->where('user_id', Auth::id())
                  ->where('type', 'Withdraw')
                  ->sum('amount');

          $update_port = DB::table('portfolios')
          ->where('id', $request->portfolio_id)
          ->where('user_id', Auth::id())
                ->update([
                  "withdraw" => $total_withdraw,
                        ]);

          // Update into balance_avaiable(portfolio) Strat //

          $total_available_balance_in_portfolio = Portfolio::where('id' , $request->portfolio_id)
                                                ->where ('user_id', Auth::id())
                                                ->pluck('balance_available')
                                                ->first();

           $subtotal_balance_available = $total_available_balance_in_portfolio - $total_withdraw;

           $portfolio_ppdate = DB::table('portfolios')
            ->where('id', $request->portfolio_id)
            ->where('user_id', Auth::id())
                  ->update([
                    "balance_available" => $subtotal_balance_available,
                          ]);
        // Update into balance_avaiable(portfolio) End //
        $total_initial_deposit_in_portfolio = Portfolio::where('id' , $request->portfolio_id)
                                              ->where ('user_id', Auth::id())
                                              ->pluck('initial_deposit')
                                              ->first();

         $roi_port = ($subtotal_balance_available - $total_initial_deposit_in_portfolio) / $total_initial_deposit_in_portfolio *100;

         $update_roi_port = DB::table('portfolios')
         ->where('id', $request->portfolio_id)
         ->where('user_id', Auth::id())
         ->update([
           "roi_port" => $roi_port,
         ]);

        }
        //return $total_deposit;
       return redirect()->back()
            ->with('success','Batch created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
      $portfolio = Portfolio::find($id);
      return view('portfolios.show', compact('portfolio'));

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
      {
        $trans = Transaction::find($id);
        $data_type = $trans->type;
        $data_amount = $trans->amount;
        $data_portfolio = $trans->portfolio_id;
        $data_user = $trans->user_id;

        if ($data_type == 'Deposit')
        {

          // Update into balance_avaiable(portfolio) Strat //


          $total_available_balance_in_portfolio = Portfolio::where('id' , $data_portfolio)
                                                ->where ('user_id', $data_user)
                                                ->pluck('balance_available')
                                                ->first();

           $subtotal_balance_available = $total_available_balance_in_portfolio - $data_amount;

           $portfolio_ppdate = DB::table('portfolios')
            ->where('id', $data_portfolio)
            ->where('user_id', Auth::id())
                  ->update([
                    "balance_available" => $subtotal_balance_available,
                          ]);
        // Update into balance_avaiable(portfolio) End //

          Transaction::find($id)->delete();

          $total_deposit = Transaction::where('portfolio_id', $trans->portfolio_id)
          ->where('user_id', Auth::id())
          ->where('type', 'Deposit')
          ->sum('amount');

          $update_port = DB::table('portfolios')
          ->where('id', $trans->portfolio_id)
          ->where('user_id', Auth::id())
          ->update([
            "deposit" => $total_deposit,
              ]);

              $total_initial_deposit_in_portfolio = Portfolio::where('id' , $data_portfolio)
                                                    ->where ('user_id', Auth::id())
                                                    ->pluck('initial_deposit')
                                                    ->first();

               $roi_port = ($subtotal_balance_available - $total_initial_deposit_in_portfolio) / $total_initial_deposit_in_portfolio *100;

               $update_roi_port = DB::table('portfolios')
               ->where('id', $data_portfolio)
               ->where('user_id', Auth::id())
               ->update([
                 "roi_port" => $roi_port,
               ]);

        }
        elseif ($data_type == 'Withdraw')
        {
          // Update into balance_avaiable(portfolio) Strat //


          $total_available_balance_in_portfolio = Portfolio::where('id' , $data_portfolio)
                                                ->where ('user_id', $data_user)
                                                ->pluck('balance_available')
                                                ->first();

           $subtotal_balance_available = $total_available_balance_in_portfolio + $data_amount;

           $portfolio_ppdate = DB::table('portfolios')
            ->where('id', $data_portfolio)
            ->where('user_id', Auth::id())
                  ->update([
                    "balance_available" => $subtotal_balance_available,
                          ]);
        // Update into balance_avaiable(portfolio) End //

          Transaction::find($id)->delete();

          $total_withdraw = Transaction::where('portfolio_id', $trans->portfolio_id)
                  ->where('user_id', Auth::id())
                  ->where('type', 'Withdraw')
                  ->sum('amount');

          $update_port = DB::table('portfolios')
          ->where('id', $trans->portfolio_id)
          ->where('user_id', Auth::id())
                ->update([
                  "withdraw" => $total_withdraw,
                        ]);


        }
        elseif ($data_type == 'Loss')
        {
          Transaction::find($id)->delete();
        }
        elseif ($data_type == 'Profit')
        {
          Transaction::find($id)->delete();
        }
        else {

        }




          return redirect()->back();
      }
    }
}
