<?php

namespace App\Http\Controllers;

use App\Models\Support;
use App\Models\Ticket;
use App\Models\User;
use Illuminate\Http\Request;
use DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use App\Mail\SendMail;
use Mail;

class TicketController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      $this->validate($request,[
        'image1' => 'mimes:jpeg,bmp,png,jpg|max:2048',
        'image2' => 'mimes:jpeg,bmp,png,jpg|max:2048',
        'image3' => 'mimes:jpeg,bmp,png,jpg|max:2048',
        'image4' => 'mimes:jpeg,bmp,png,jpg|max:2048',
      ]);

      $image = $request->file('image1');
      $image2 = $request->file('image2');
      $image3 = $request->file('image3');
      $image4 = $request->file('image4');
      
      //Image 1 
         if (isset($image))
        {
            
        $filenameWithExt = $image ->GetClientOriginalName();
        
        // Get Filename
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        
        // Get just Extension
        $extension = $image->GetClientOriginalName();
        
        // Filename To store
        $fileNameToStore = $filename. '_'. time().'.'.$extension;
       

        // Upload Image
        $path = $image->storeAs('support/', $fileNameToStore);
        }
        // Else add a dummy image
        else {
        $fileNameToStore = 'default.png';
        }
      //End Image 1
      
      //Image 2
         if (isset($image2))
        {
            
        $filenameWithExt = $image2 ->GetClientOriginalName();
        
        // Get Filename
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        
        // Get just Extension
        $extension = $image2->GetClientOriginalName();
        
        // Filename To store
        $fileNameToStore2 = $filename. '_'. time().'.'.$extension;
       

        // Upload Image
        $path = $image2->storeAs('support/', $fileNameToStore2);
        }
        // Else add a dummy image
        else {
        $fileNameToStore2 = 'default.png';
        }
      //End Image 2
      
       //Image 3
         if (isset($image3))
        {
            
        $filenameWithExt = $image3 ->GetClientOriginalName();
        
        // Get Filename
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        
        // Get just Extension
        $extension = $image3->GetClientOriginalName();
        
        // Filename To store
        $fileNameToStore3 = $filename. '_'. time().'.'.$extension;
       

        // Upload Image
        $path = $image3->storeAs('support/', $fileNameToStore3);
        }
        // Else add a dummy image
        else {
        $fileNameToStore3 = 'default.png';
        }
      //End Image 3
      
       //Image 4
         if (isset($image4))
        {
            
        $filenameWithExt = $image4 ->GetClientOriginalName();
        
        // Get Filename
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        
        // Get just Extension
        $extension = $image4->GetClientOriginalName();
        
        // Filename To store
        $fileNameToStore4 = $filename. '_'. time().'.'.$extension;
       

        // Upload Image
        $path = $image4->storeAs('support/', $fileNameToStore4);
        }
        // Else add a dummy image
        else {
        $fileNameToStore4 = 'default.png';
        }
      //End Image 4
      
      
        

      $slug = str_slug($request->title);
    


      $currentDatenow = Carbon::now()->format('mY');
      $support = new Support();
      $support->user_id = Auth::id();
      $support->title = $request->title;
      $support->case_id = $request->case_id;
      $support->slug = $slug;
      $support->body = $request->body;
      $support->user_name = Auth::user()->name;
      $support->sender_email = $request->sender_email;
      $support->image1 = $fileNameToStore;
      $support->image2 = $fileNameToStore2;
      $support->image3 = $fileNameToStore3;
      $support->image4 = $fileNameToStore4;
      $support->image1_name = 'image-'.uniqid();
      $support->image2_name = 'image-'.uniqid();
      $support->image3_name = 'image-'.uniqid();
      $support->image4_name = 'image-'.uniqid();
      $support -> ticket_id = $request->ticket_id;
      $support->save();

      $status = $request->complete;

 if( $status == Null)
 {
   $support->supportInfo = DB::table('tickets')
          ->where ('case_id' ,$request->case_id)
            ->update([
              'pending' => 0,
              'ongoing' => 1,
              'complete' => 0,
              'close' => 0,
            ]);
 }else{
   $support->supportInfo = DB::table('tickets')
          ->where ('case_id' ,$request->case_id)
            ->update([
              'pending' => 0,
              'ongoing' => 0,
              'complete' => 1,
              'close' => 0,

            ]);
 }

       //email//

       $emailsender =  $request->sender_email;
       $sentuser = $request->sent_name;
       $title = $request->title;
       $ticid = $request->ticket_id;
       $message = $request->body;

       Mail::to($emailsender)->send( new SendMail($title, $message, $sentuser, $ticid) );
       //email //

      //return $status;
      return redirect()->back()
          ->with('success','Ticket created successfully.');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    public function approval($id)
    {
          $tickets = Ticket::find($id);
          $tickets->ongoing = false;
          $tickets->complete = true;
            $tickets->save();

            return redirect()->back()
                ->with('success','Ticket was completed.');

    }

    public function close($id)
    {
          $tickets = Ticket::find($id);
            $tickets->ongoing = false;
            $tickets->close = true;
            $tickets->save();

            return redirect()->back()
                ->with('success','Ticket was completed.');

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
