<?php

namespace App\Http\Controllers;

use App\Models\Support;
use App\Models\Ticket;
use App\Models\Batchuser;
use App\Models\User;
use Illuminate\Http\Request;
use DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use App\Mail\SupportMail;
use App\Mail\SupportUserMail;
use App\Mail\SendMail;
use Mail;

class SupportController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
     public function index(Request $request)
     {
         $batch_program = Auth::user()->batchuser()
         ->join('programs', 'batchusers.batch_id', '=', 'programs.id')
         ->pluck('program_name')
         ->first();

         $data = Auth::user()->ticket()->latest()->get();
         $pending_data = Auth::user()->ticket()->where('pending','1')->get();
         $ongoing_data = Auth::user()->ticket()->where('ongoing','1')->get();
         $complete_close_data = Auth::user()->ticket()->where('complete','1')->orWhere('close','1')->get();
         $close_data = Auth::user()->ticket()->where('close','1')->get();

         $data_admin = Ticket::latest()->get();
         $pending_data_admin = Ticket::where('pending','1')->get();
         $ongoing_data_admin = Ticket::where('ongoing','1')->get();
         $complete_close_data_admin = Ticket::where('complete','1')->orWhere('close','1')->get();
         $close_data = Auth::user()->ticket()->where('close','1')->get();

         $data_count = Ticket::latest()->count();
         $pending_data_count = Ticket::where('pending','1')->count();
         $ongoing_data_count = Ticket::where('ongoing','1')->count();
         $complete_close_data_count = Ticket::where('complete','1')->orWhere('close','1')->count();

         //return $batch_program;
         return view('supports.index',compact('batch_program','data_count','pending_data_count','ongoing_data_count','complete_close_data_count','data','data_admin','pending_data','ongoing_data_admin','complete_close_data_admin','pending_data_admin','ongoing_data','complete_close_data','close_data'));
     }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
          $this->validate($request,[
            'image1' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            'image2' => 'mimes:jpeg,bmp,png,jpg|max:2048',
            'image3' => 'mimes:jpeg,bmp,png,jpg|max:2048',
            'image4' => 'mimes:jpeg,bmp,png,jpg|max:2048',
          ]);

          $slug = str_slug($request->title);
          $currentDatenow = Carbon::now()->format('mY');


            //Ticket//
         $tickets = new Ticket();
         $tickets->user_id = Auth::id();
         $tickets->title = $request->title;
         $tickets->slug = $slug;
         $tickets->user_name = Auth::user()->name;
         $tickets->sender_email = Auth::user()->email;
         $tickets->user_batch = $request->user_batch;
         $tickets->pending = true;
         $tickets->ongoing = false;
         $tickets->complete = false;
         $tickets->close = false;
         $tickets->save();

         $tickets->ticketInfo = DB::table('tickets')
         ->where ('id' ,$tickets->id)
           ->update([
          'case_id' =>$currentDatenow . Auth::id() . $tickets->id,
           ]);

            //Tckiet//

            //Support //
          $image = $request->file('image1');
          $image2 = $request->file('image2');
          $image3 = $request->file('image3');
          $image4 = $request->file('image4');

      //Image 1 
         if (isset($image))
        {
            
        $filenameWithExt = $image ->GetClientOriginalName();
        
        // Get Filename
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        
        // Get just Extension
        $extension = $image->GetClientOriginalName();
        
        // Filename To store
        $fileNameToStore = $filename. '_'. time().'.'.$extension;
       

        // Upload Image
        $path = $image->storeAs('support/', $fileNameToStore);
        }
        // Else add a dummy image
        else {
        $fileNameToStore = 'default.png';
        }
      //End Image 1
      
      //Image 2
         if (isset($image2))
        {
            
        $filenameWithExt = $image2 ->GetClientOriginalName();
        
        // Get Filename
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        
        // Get just Extension
        $extension = $image2->GetClientOriginalName();
        
        // Filename To store
        $fileNameToStore2 = $filename. '_'. time().'.'.$extension;
       

        // Upload Image
        $path = $image2->storeAs('support/', $fileNameToStore2);
        }
        // Else add a dummy image
        else {
        $fileNameToStore2 = 'default.png';
        }
      //End Image 2
      
       //Image 3
         if (isset($image3))
        {
            
        $filenameWithExt = $image3 ->GetClientOriginalName();
        
        // Get Filename
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        
        // Get just Extension
        $extension = $image3->GetClientOriginalName();
        
        // Filename To store
        $fileNameToStore3 = $filename. '_'. time().'.'.$extension;
       

        // Upload Image
        $path = $image3->storeAs('support/', $fileNameToStore3);
        }
        // Else add a dummy image
        else {
        $fileNameToStore3 = 'default.png';
        }
      //End Image 3
      
       //Image 4
         if (isset($image4))
        {
            
        $filenameWithExt = $image4 ->GetClientOriginalName();
        
        // Get Filename
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        
        // Get just Extension
        $extension = $image4->GetClientOriginalName();
        
        // Filename To store
        $fileNameToStore4 = $filename. '_'. time().'.'.$extension;
       

        // Upload Image
        $path = $image4->storeAs('support/', $fileNameToStore4);
        }
        // Else add a dummy image
        else {
        $fileNameToStore4 = 'default.png';
        }
      //End Image 4


          $slug = str_slug($request->title);
          $currentDatenow = Carbon::now()->format('mY');
          $support = new Support();
          $support->user_id = Auth::id();
          $support->title = $request->title;
          $support->slug = $slug;
          $support->user_name = Auth::user()->name;
          $support->sender_email = Auth::user()->email;
          $support->body = $request->body;
          $support->image1 = $fileNameToStore;
          $support->image2 = $fileNameToStore2;
          $support->image3 = $fileNameToStore3;
          $support->image4 = $fileNameToStore4;
          $support->image1_name = 'image-'.uniqid();
          $support->image2_name = 'image-'.uniqid();
          $support->image3_name = 'image-'.uniqid();
          $support->image4_name = 'image-'.uniqid();
          $support -> ticket_id = $tickets->id;
          $support->save();

          $support->supportInfo = DB::table('supports')
                 ->where ('id' ,$support->id)
                   ->update([
                  'case_id' =>$currentDatenow . Auth::id() . $tickets->id,
                   ]);

                   //email//

                //   $emailsender =  "support@theprotegeportal.com";
                //   $title = $request->title;
                //   $message = $request->body;
                //   $ticid = $tickets->id;

                 //  Mail::to($emailsender)->send( new SupportMail($title, $message, $ticid) );
                   //email //

//Support//

          return redirect()->back()
              ->with('success','Ticket created successfully.');
       }

       public function storeUser(Request $request)
       {
         $this->validate($request,[
           //'image' => 'required',
           'image1' => 'mimes:jpeg,bmp,png,jpg|max:2048',
           'image2' => 'mimes:jpeg,bmp,png,jpg|max:2048',
           'image3' => 'mimes:jpeg,bmp,png,jpg|max:2048',
           'image4' => 'mimes:jpeg,bmp,png,jpg|max:2048',
         ]);

         $image = $request->file('image1');
         $image2 = $request->file('image2');
         $image3 = $request->file('image3');
         $image4 = $request->file('image4');
         
      //Image 1 
         if (isset($image))
        {
            
        $filenameWithExt = $image ->GetClientOriginalName();
        
        // Get Filename
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        
        // Get just Extension
        $extension = $image->GetClientOriginalName();
        
        // Filename To store
        $fileNameToStore = $filename. '_'. time().'.'.$extension;
       

        // Upload Image
        $path = $image->storeAs('support/', $fileNameToStore);
        }
        // Else add a dummy image
        else {
        $fileNameToStore = 'default.png';
        }
      //End Image 1
      
      //Image 2
         if (isset($image2))
        {
            
        $filenameWithExt = $image2 ->GetClientOriginalName();
        
        // Get Filename
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        
        // Get just Extension
        $extension = $image2->GetClientOriginalName();
        
        // Filename To store
        $fileNameToStore2 = $filename. '_'. time().'.'.$extension;
       

        // Upload Image
        $path = $image2->storeAs('support/', $fileNameToStore2);
        }
        // Else add a dummy image
        else {
        $fileNameToStore2 = 'default.png';
        }
      //End Image 2
      
       //Image 3
         if (isset($image3))
        {
            
        $filenameWithExt = $image3 ->GetClientOriginalName();
        
        // Get Filename
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        
        // Get just Extension
        $extension = $image3->GetClientOriginalName();
        
        // Filename To store
        $fileNameToStore3 = $filename. '_'. time().'.'.$extension;
       

        // Upload Image
        $path = $image3->storeAs('support/', $fileNameToStore3);
        }
        // Else add a dummy image
        else {
        $fileNameToStore3 = 'default.png';
        }
      //End Image 3
      
       //Image 4
         if (isset($image4))
        {
            
        $filenameWithExt = $image4 ->GetClientOriginalName();
        
        // Get Filename
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        
        // Get just Extension
        $extension = $image4->GetClientOriginalName();
        
        // Filename To store
        $fileNameToStore4 = $filename. '_'. time().'.'.$extension;
       

        // Upload Image
        $path = $image4->storeAs('support/', $fileNameToStore4);
        }
        // Else add a dummy image
        else {
        $fileNameToStore4 = 'default.png';
        }
      //End Image 4

         $slug = str_slug($request->title);
         $currentDatenow = Carbon::now()->format('mY');
         $support = new Support();
         $support->user_id = Auth::id();
         $support->title = $request->title;
         $support->case_id = $request->case_id;
         $support->slug = $slug;
         $support->body = $request->body;
         $support->user_name = Auth::user()->name;
         $support->sender_email = $request->sender_email;
         $support->image1 = $fileNameToStore;
         $support->image2 = $fileNameToStore2;
         $support->image3 = $fileNameToStore3;
         $support->image4 = $fileNameToStore4;
         $support->image1_name = 'image-'.uniqid();
         $support->image2_name = 'image-'.uniqid();
         $support->image3_name = 'image-'.uniqid();
         $support->image4_name = 'image-'.uniqid();
         $support -> ticket_id = $request->ticket_id;
         $support->save();

         $status = $request->complete;

     if( $status == Null)
     {
      $support->supportInfo = DB::table('tickets')
             ->where ('case_id' ,$request->case_id)
               ->update([
                 'pending' => 0,
                 'ongoing' => 1,
                 'complete' => 0,
                 'close' => 0,
               ]);
     }else{
      $support->supportInfo = DB::table('tickets')
             ->where ('case_id' ,$request->case_id)
               ->update([
                 'pending' => 0,
                 'ongoing' => 0,
                 'complete' => 1,
                 'close' => 0,

               ]);
     }

          //email//

          $emailsender =  "support@theprotegeportal.com";
          $title = $request->title;
          $message = $request->body;
          $ticid = $request->ticket_id;

          Mail::to($emailsender)->send( new SupportUserMail($title, $message, $ticid) );
          //email //

         //return $status;
         return redirect()->back()
             ->with('success','Ticket created successfully.');

       }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
      $dataTicket = Ticket::where('id',$id)->first();
    //  $dataTicket = Ticket::where('id',$id)->pluck('case_id')->first();
        $data = Support::where('ticket_id',$id)->get();
        //return $data;

        return view('supports.show',compact('data','dataTicket'));
    }

    public function showUser($id)
    {
      $dataTicket2 = Ticket::where('id',$id)->pluck('user_id')->first();

      if ($dataTicket2 != Auth::id())
        {
          return redirect()->back()
              ->with('error','Ticket created successfully.');
        }

      $dataTicket = Ticket::where('id',$id)->first();
      //  $dataTicket = Ticket::where('id',$id)->pluck('case_id')->first();
        $data = Support::where('ticket_id',$id)->get();
        //return $data;
        //return $dataTicket2;

        return view('supports.supportuser',compact('data','dataTicket'));
    }



    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
