<?php

namespace App\Http\Controllers;

use App\Models\Stock;
use Illuminate\Http\Request;

class StockController extends Controller
{
  /**
   * create a new instance of the class
   *
   * @return void
   */
  function __construct()
  {
       $this->middleware('permission:stock-list|stock-create|stock-edit|stock-delete', ['only' => ['index', 'show']]);
       $this->middleware('permission:stock-create', ['only' => ['create', 'store']]);
       $this->middleware('permission:stock-edit', ['only' => ['edit', 'update']]);
       $this->middleware('permission:stock-delete', ['only' => ['destroy']]);
  }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
     public function index(Request $request)
     {
         $data = Stock::latest()->get();

         return view('stocks.index',compact('data'));
     }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
     public function create()
     {
         return view('stocks.create');
     }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
     public function store(Request $request)
     {
         $this->validate($request, [
             'stocks_name' => 'required|unique:stocks',
             'symbol' => 'required|alpha',
         ],[
           "stocks_name.unique" => "Stock name aready have in database. Please search first before insert the stock name",
           "symbol.alpha" => "Please dont insert the number, just insert alphabert only"
         ]);

         $input = $request->except(['_token']);

         Stock::create($input);

         return redirect()->back()
             ->with('success','Stocks created successfully.');
     }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
     public function show($id)
     {
         $stock = Stock::find($id);

         return view('stocks.show', compact('stock'));
     }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
     public function edit($id)
     {
         $stock = Stock::find($id);

         return view('stocks.edit',compact('stock'));
     }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'stocks_name' => 'required',
            'symbol' => 'required',
        ]);

        $stock = Stock::find($id);

        $stock->update($request->all());

        return redirect()->route('stocks.index')
            ->with('success','Stocks updated successfully.');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Stock::find($id)->delete();

        return redirect()->route('stocks.index')
            ->with('success', 'Stocks deleted successfully.');
    }
}
