<?php

namespace App\Http\Controllers;

use App\Models\Program;
use App\Models\Trade;
use App\Models\Transaction;
use App\Models\Portfolio;
use App\Models\Result;
use App\Models\User;
use App\Models\Batchuser;
use Illuminate\Http\Request;
use DB;

class StatisticsController extends Controller
{
    /**
     * create a new instance of the class
     *
     * @return void
     */
    function __construct()
    {
         $this->middleware('permission:program-list|program-create|program-edit|program-delete', ['only' => ['index', 'show']]);
         $this->middleware('permission:program-create', ['only' => ['create', 'store']]);
         $this->middleware('permission:program-edit', ['only' => ['edit', 'update']]);
         $this->middleware('permission:program-delete', ['only' => ['destroy']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
     public function index(Request $request)
     {
         $data = Program::latest()->get();

         return view('statistics.index',compact('data'));
     }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('statistics.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
     public function store(Request $request)
     {
         $this->validate($request, [
           'program_name' => 'required',
           'program_date' => 'required',
           'program_year' => 'required',
         ]);
         $input = $request->except(['_token']);

         Program::create($input);

         return redirect()->route('statistics.index')
             ->with('success','Batch created successfully.');
     }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $program = Program::find($id);

        $programx = Program::find($id)
                  ->join('batchusers', 'programs.id', '=', 'batchusers.batch_id')
                  ->where('batch_id', $id)
                  ->get();

                  $programs = Program::find($id)
                  ->join('batchusers', 'batchusers.batch_id', '=', 'programs.id')
                  ->join('users', 'batchusers.user_id', '=', 'users.id')
                  ->join('portfolios', 'portfolios.user_id', '=', 'users.id')
                  ->where('batch_id', $id)
                  ->get();

                  $batchuser_count = Program::find($id)
                  ->join('batchusers', 'batchusers.batch_id', '=', 'programs.id')
                  ->join('users', 'batchusers.user_id', '=', 'users.id')
                  ->where('batch_id', $id)
                  ->count();

                  $programc = Program::find($id)
                  ->join('batchusers', 'batchusers.batch_id', '=', 'programs.id')
                  ->join('users', 'batchusers.user_id', '=', 'users.id')
                  ->join('results', 'batchusers.user_id', '=', 'results.user_id')
                  ->where('batch_id', $id)
                  ->get();

                  $programc = Program::find($id)
                  ->join('batchusers', 'batchusers.batch_id', '=', 'programs.id')
                  ->join('users', 'batchusers.user_id', '=', 'users.id')
                  ->join('transactions', 'batchusers.user_id', '=', 'transactions.user_id')
                  ->where('batch_id', $id)
                  ->get();

        //return $programs;
        return view('statistics.show', compact('program','programs','batchuser_count','programc'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

     public function ProgramUsertradeHistory($id)
     {
       $data = Result::join('trades', 'results.id', '=', 'trades.result_id')
             ->where('result_id', $id)
             ->get();

       $result = Result::find($id);


       return view('statistics.history',compact('data','result'));
     }

     public function ProgramUsertradeStatistic(Trade $trade, $id)
     {
       $fund_available = Portfolio::where('id' , $id)
                           ->pluck('balance_available')
                           ->first();

        $trans = Transaction::where('portfolio_id', $id)
               ->get();

        $initial = Transaction::where('portfolio_id' , $id)
                            ->where ('type', 'Initial')
                            ->sum('amount');

        $deposit = Transaction::where('portfolio_id' , $id)
                            ->where ('type', 'Deposit')
                            ->sum('amount');

        $withdraw = Transaction::where('portfolio_id' , $id)
                            ->where ('type', 'Withdraw')
                            ->sum('amount');

        $profit = Transaction::where('portfolio_id' , $id)
                            ->where ('type', 'Profit')
                            ->sum('amount');

        $winnings = Transaction::where('portfolio_id' , $id)
                           ->where ('type', 'Profit')
                           ->count();

        $lossing = Transaction::where('portfolio_id' , $id)
                           ->where ('type', 'Loss')
                           ->count();

        $loss = Transaction::where('portfolio_id' , $id)
                            ->where ('type', 'Loss')
                            ->sum('amount');


        $total_q = $profit + $loss;

        $total = $initial + $total_q - $withdraw + $deposit;

        $roi_port = ($total - $initial) / $initial *100;

       $portfolio = Portfolio::find($id);

       $data = Result::where('portfolio_id', $id)
             ->get();

       $result = DB::table('results')
             ->where('portfolio_id',$id)
             ->get();

             $total_harga = Result::where('portfolio_id' , $id)
             ->select(DB::raw("SUM(net_profit) as total_harga"))
             ->whereYear('close_trade', date('Y'))
             ->GroupBy(DB::raw("close_trade"))
             ->pluck("total_harga");

             $bulan = Result::where('portfolio_id' , $id)
             ->select(DB::raw('DATE_FORMAT(close_trade, "%d/%b/%Y") as bulan'))
             ->GroupBy(DB::raw("close_trade"))
             ->pluck('bulan');

           //  $bulan = Result::where('portfolio_id' , $id)
           //  ->select(DB::raw("MONTHNAME(close_trade) as bulan"))
           //  ->GroupBy(DB::raw("MONTHNAME(close_trade)"))
           //  ->pluck('bulan');

           $total_harga2 = Transaction::where('portfolio_id' , $id)
           ->where('type','Profit')
           ->select(DB::raw("SUM(amount) as total_harga"))
           ->whereYear('date', date('Y'))
           ->GroupBy(DB::raw("Month(date)"))
           ->pluck("total_harga");

           $total_harga3 = Transaction::where('portfolio_id' , $id)
           ->where('type','Loss')
           ->select(DB::raw("SUM(amount) as total_harga"))
           ->whereYear('date', date('Y'))
           ->GroupBy(DB::raw("Month(date)"))
           ->pluck("total_harga");

           $bulan2 = Transaction::where('portfolio_id' , $id)
            ->select(DB::raw("MONTHNAME(date) as bulan"))
            ->GroupBy(DB::raw("MONTHNAME(date)"))
            ->pluck('bulan');
       //return $initial;
       //return $average_buy;

       return view('statistics.statistic',compact('bulan2','total_harga3','total_harga2','bulan','total_harga','fund_available','data','trans','portfolio','result','initial','deposit','withdraw','profit','total','loss','winnings','lossing','total_q','roi_port','portfolio' ));
     }


    public function edit($id)
    {
        $program = Program::find($id);

        return view('statistics.edit',compact('program'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
          'program_name' => 'required',
          'program_date' => 'required',
          'program_year' => 'required',
        ]);

        $program = Program::find($id);

        $program->update($request->all());

        return redirect()->route('statistics.index')
            ->with('success','Batch updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Program::find($id)->delete();

        return redirect()->route('statistics.index')
            ->with('success', 'Batch deleted successfully.');
    }
}
