<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;

use App\Models\Portfolio;
use App\Models\Stock;
use App\Models\Trade;
use App\Models\Brokerage;
use App\Models\Result;
use App\Models\Transaction;
use Illuminate\Support\Facades\Auth;
use DB;
use Carbon\Carbon;


class SellController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      $open_buy = Auth::user()->portfolio()
            ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
            ->where('portfolio_id', 3)
            ->where('stock_id',  1)
            ->where('action', 'buy')
            ->sum('price');

      $trade_count = Auth::user()->portfolio()
            ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
            ->where('portfolio_id', 3)
            ->where('stock_id',  1)
            ->where('action', 'buy')
            ->count();

      $average_buy = $open_buy / $trade_count;

      $quantity_buy = Auth::user()->portfolio()
              ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
              ->where('portfolio_id', 3)
              ->where('stock_id',  1)
              ->where('action', 'buy')
              ->sum('quantity');

      $subtotal_gross_buy = $average_buy * $quantity_buy;

      $open_sell = Auth::user()->portfolio()
            ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
            ->where('portfolio_id', 3)
            ->where('stock_id',  1)
            ->where('action', 'sell')
            ->sum('price');

      $trade_count_sell = Auth::user()->portfolio()
            ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
            ->where('portfolio_id', 3)
            ->where('stock_id',  1)
            ->where('action', 'sell')
            ->count();

      $average_sell = $open_sell / $trade_count_sell;

      $quantity_sell = Auth::user()->portfolio()
              ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
              ->where('portfolio_id', 3)
              ->where('stock_id',  1)
              ->where('action', 'sell')
              ->sum('quantity');

      $subtotal_gross_sell = $average_sell * $quantity_sell;

      //Profit Formula//
      //Profit : Sell Price (subtotal_gross_sell)- Buy Price(subtotal_gross_buy)//

      $gross_profits = $subtotal_gross_sell - $subtotal_gross_buy;



      return $gross_profits;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {


    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
     public function store(Request $request)
     {
         $this->validate($request, [
           'action' => 'required',
           'stock_name' => 'required',
           'price' => 'required',
           'quantity' => 'required',
           'date' => 'required',
           'remark' => 'required',

         ]);
         $trades = Auth::user()->trade()->where('stock_name','=', $request->input('stock_name'))->where('portfolio_id','=', $request->input('portfolio_id'))->where('action', 'sell')->first();
         $results = Auth::user()->trade()->where('stock_name','=', $request->input('stock_name'))->where('portfolio_id','=', $request->input('portfolio_id'));

         if ($trades === null){
           // Create into trade Start //
           $trade = new Trade();
           $trade->action = 'sell';
           $trade->status = 1;
           $trade->portfolio_id = $request->portfolio_id;
           $trade->stock_code = $request->stock_code;
           $trade->first_fees = $request->first_fees;
           $trade->stock_id = $request->stock_id;
           $trade->stock_name = $request->stock_name;
           $trade->stock_symbol = $request->stock_symbol;
           $trade->price = $request->price;
           $trade->brokerage_id = $request->brokerage_id;
           $trade->quantity = $request->quantity;
           $trade->date = $request->date;
           $trade->remark = $request->remark;

           //Subtotal Calculation//
           $subtotal = $request->price * $request->quantity;
           $trade->subtotal = $subtotal;

           //Brokerage Fee Calculation //
           $broker_f = $subtotal * $request->second_fees/100;
           if($broker_f  > $request->first_fees){
             $broker_fees = $subtotal * $request->second_fees/100;
             $trade->broker_fee = $broker_fees;
           }
           elseif($broker_f < $request->first_fees){
             $broker_fees =  $request->first_fees;
             $trade->broker_fee = $broker_fees;
           }

           //Clearing Fee Calculation//
           $clearing_f = $subtotal * 0.03/100;
           $trade->clearing_fee = $clearing_f;

           //Stamp Duty Fee Calculation//
           $stamp_d = ceil($subtotal/1000) * 1.50;
           $trade->stamp_duty = $stamp_d;

           //Total Fees  Calculation//
           $total_fees = $broker_fees + $clearing_f +  $stamp_d;

           //Total Cost  Calculation//
          $total_c = $subtotal - $broker_fees - $clearing_f - $stamp_d ;
          $trade->total_cost = $total_c;

           $trade->user_id = Auth::id();
           $trade->result_id = $request->result_id;

           $trade->save();
           // Create into trade End //

           // Update into Result Start //
           $sum_quantity = Auth::user()->portfolio()
                   ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                   ->where('portfolio_id', $request->portfolio_id)
                   ->where('stock_code', $request->stock_code)
                   ->where('stock_id',  $request->stock_id)
                   ->where('action', 'sell')
                   ->sum('quantity');

            $sum_quantity_buy = Auth::user()->portfolio()
                    ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                    ->where('portfolio_id', $request->portfolio_id)
                    ->where('stock_code', $request->stock_code)
                    ->where('stock_id',  $request->stock_id)
                    ->where('action', 'buy')
                    ->sum('quantity');

            $balance_quantity =   $sum_quantity_buy -   $sum_quantity;


        $broke_total_fee_all = Auth::user()->portfolio()
                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                ->where('portfolio_id', $request->portfolio_id)
                ->where('stock_code', $request->stock_code)
                ->where('stock_id',  $request->stock_id)
                              ->sum('broker_fee');

            $clearing_total_fee_all = Auth::user()->portfolio()
                    ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                    ->where('portfolio_id', $request->portfolio_id)
                    ->where('stock_code', $request->stock_code)
                    ->where('stock_id',  $request->stock_id)
                    ->sum('clearing_fee');

            $stamp_total_fee_all = Auth::user()->portfolio()
                    ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                    ->where('portfolio_id', $request->portfolio_id)
                    ->where('stock_code', $request->stock_code)
                    ->where('stock_id',  $request->stock_id)
                    ->sum('stamp_duty');

              $subtotal_fee_all = $broke_total_fee_all + $clearing_total_fee_all + $stamp_total_fee_all;



           $Result_Update = DB::table('results')
           ->where('portfolio_id', $request->portfolio_id)
           ->where('stock_code', $request->stock_code)
           ->where('stock_id', $request->stock_id)
           ->where('user_id', Auth::id())
                 ->update([
                   "close_trade" => $request->date,
                   "average_sell" => $request->price,
                   "quantity_sell" => $request->quantity,
                   "total_fees_sell" => $total_fees,
                   "subtotal_sell" => $subtotal,
                   "total_sell_cost" => $total_c,
                   "quantity_bal" => $balance_quantity,
                   "subtotal_fee" => $subtotal_fee_all,

                         ]);
           // Update into Result End //




           // Update into (result) Start //
           // Update ROI into (result) Start //
           if ($balance_quantity == 0)
           {
             $open_buy = Auth::user()->portfolio()
                   ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                   ->where('portfolio_id', $request->portfolio_id)
                   ->where('stock_code', $request->stock_code)
                   ->where('stock_id',  $request->stock_id)
                   ->where('action', 'buy')
                   ->sum('price');

             $trade_count = Auth::user()->portfolio()
                   ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                   ->where('portfolio_id', $request->portfolio_id)
                   ->where('stock_code', $request->stock_code)
                   ->where('stock_id',  $request->stock_id)
                   ->where('action', 'buy')
                   ->count();

             $average_buy = $open_buy / $trade_count;

             $quantity_buy = Auth::user()->portfolio()
                     ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                     ->where('portfolio_id', $request->portfolio_id)
                     ->where('stock_code', $request->stock_code)
                     ->where('stock_id',  $request->stock_id)
                     ->where('action', 'buy')
                     ->sum('quantity');

             $subtotal_gross_buy = $average_buy * $quantity_buy;

             $open_sell = Auth::user()->portfolio()
                   ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                   ->where('portfolio_id', $request->portfolio_id)
                   ->where('stock_code', $request->stock_code)
                   ->where('stock_id',  $request->stock_id)
                   ->where('action', 'sell')
                   ->sum('price');

             $trade_count_sell = Auth::user()->portfolio()
                   ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                   ->where('portfolio_id', $request->portfolio_id)
                   ->where('stock_code', $request->stock_code)
                   ->where('stock_id',  $request->stock_id)
                   ->where('action', 'sell')
                   ->count();

             $average_sell = $open_sell / $trade_count_sell;

             $quantity_sell = Auth::user()->portfolio()
                     ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                     ->where('portfolio_id', $request->portfolio_id)
                     ->where('stock_code', $request->stock_code)
                     ->where('stock_id',  $request->stock_id)
                     ->where('action', 'sell')
                     ->sum('quantity');

             $subtotal_gross_sell = $average_sell * $quantity_sell;



             $gross_profits = $subtotal_gross_sell - $subtotal_gross_buy;

             $subtotal_buy = Auth::user()->portfolio()
                     ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                     ->where('portfolio_id', $request->portfolio_id)
                     ->where('stock_code', $request->stock_code)
                     ->where('stock_id',  $request->stock_id)
                     ->where('action', 'buy')
                     ->sum('subtotal');

             $ROI_gros_profits = $gross_profits/$subtotal_buy * 100;

             $subtotal_cost_buy = Auth::user()->portfolio()
                     ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                     ->where('portfolio_id', $request->portfolio_id)
                     ->where('stock_code', $request->stock_code)
                     ->where('stock_id',  $request->stock_id)
                     ->where('action', 'buy')
                     ->sum('total_cost');

             $subtotal_cost_sell = Auth::user()->portfolio()
                     ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                     ->where('portfolio_id', $request->portfolio_id)
                     ->where('stock_code', $request->stock_code)
                     ->where('stock_id',  $request->stock_id)
                     ->where('action', 'sell')
                     ->sum('total_cost');

              $net_profits = $subtotal_cost_sell - $subtotal_cost_buy;

              $ROI_net_profits = $net_profits/$subtotal_cost_buy * 100;
              // Update status into (result) End //
              if ($net_profits < 0)
              {

                $status = 'LOSS';
                $trans_update = DB::table('transactions')
                      ->insert([
                        "portfolio_id" => $request->portfolio_id,
                        "user_id" => Auth::id(),
                        "stock_code" => $request->stock_code,
                        "type" => 'Loss',
                        "amount" => $net_profits,
                        "remark" => 'Loss',
                        "stock_id" => $request->stock_id,
                        "date" => $request->date,
                        "created_at" => Carbon::now(),
                        "updated_at" => Carbon::now(),
                              ]);
              }
              else
              {
                $status = 'WIN';
                $trans_update = DB::table('transactions')
                      ->insert([
                        "portfolio_id" => $request->portfolio_id,
                        "user_id" => Auth::id(),
                        "stock_code" => $request->stock_code,
                        "type" => 'Profit',
                        "amount" => $net_profits,
                        "remark" => 'Profit',
                        "stock_id" => $request->stock_id,
                        "date" => $request->date,
                        "created_at" => Carbon::now(),
                        "updated_at" => Carbon::now(),
                              ]);
              }
              // Update status into (result) End //

             $Result_Update = DB::table('results')
             ->where('portfolio_id', $request->portfolio_id)
             ->where('stock_code', $request->stock_code)
             ->where('stock_id', $request->stock_id)
             ->where('user_id', Auth::id())
                   ->update([
                     "close_trade" => $request->date,
                     "gross_profit" => $gross_profits,
                     "gross_roi" => $ROI_gros_profits,
                     "net_profit" => $net_profits,
                     "net_roi" => $ROI_net_profits,
                     "status" => $status
                           ]);

                           // Update into balance_avaiable(portfolio) Strat //
                           $trans_update_buy = DB::table('transactions')
                                 ->insert([
                                   "portfolio_id" => $request->portfolio_id,
                                   "user_id" => Auth::id(),
                                   "stock_code" => $request->stock_code,
                                   "type" => 'Sell',
                                   "amount" => $subtotal_cost_sell,
                                   "remark" => 'Sell ' . $request->stock_symbol ,
                                   "stock_id" => $request->stock_id,
                                   "date" => $request->date,
                                   "created_at" => Carbon::now(),
                                   "updated_at" => Carbon::now(),
                                         ]);

                           $total_available_balance_in_portfolio = Portfolio::where('id' , $request->portfolio_id)
                                                                 ->where ('user_id', Auth::id())
                                                                 ->pluck('balance_available')
                                                                 ->first();

                            $subtotal_balance_available = $total_available_balance_in_portfolio + $subtotal_cost_sell;


                            $portfolio_Update = DB::table('portfolios')
                             ->where('id', $request->portfolio_id)
                             ->where('user_id', Auth::id())
                                   ->update([
                                     "balance_available" => $subtotal_balance_available,
                                           ]);
                         // Update into balance_avaiable(portfolio) End //

          //Update into portfolio Start //

          $win =  Result::where('portfolio_id' , $request->portfolio_id)
                            ->where ('user_id', Auth::id())
                            ->where ('status', 'WIN')
                            ->count();

         $loss =  Result::where('portfolio_id' , $request->portfolio_id)
                           ->where ('user_id', Auth::id())
                            ->where ('status', 'LOSS')
                            ->count();

         $profit_eq =  Result::where('portfolio_id' , $request->portfolio_id)
                           ->where ('user_id', Auth::id())
                           ->where ('status', 'WIN')
                           ->sum('net_profit');

         $loss_eq = Result::where('portfolio_id' , $request->portfolio_id)
                           ->where ('user_id', Auth::id())
                            ->where ('status', 'LOSS')
                             ->sum('net_profit');

          $total_q = $profit_eq + $loss_eq;

          $initial = Portfolio::where('id' , $request->portfolio_id)
                    ->where ('user_id', Auth::id())
                    ->pluck('initial_deposit')
                    ->first();

          $deposit = Transaction::where('portfolio_id' , $request->portfolio_id)
                              ->where ('type', 'Deposit')
                              ->sum('amount');

          $withdraw = Transaction::where('portfolio_id' , $request->portfolio_id)
                              ->where ('type', 'Withdraw')
                              ->sum('amount');

          $profit = Result::where('portfolio_id' , $request->portfolio_id)
                            ->where ('user_id', Auth::id())
                             ->where ('status', 'WIN')
                              ->sum('net_profit');

          $profit = Result::where('portfolio_id' , $request->portfolio_id)
                            ->where ('user_id', Auth::id())
                             ->where ('status', 'LOSS')
                              ->sum('net_profit');

          $winnings = Result::where('portfolio_id' , $request->portfolio_id)
                            ->where ('user_id', Auth::id())
                             ->where ('status', 'WIN')
                             ->count();

          $lossing = Result::where('portfolio_id' , $request->portfolio_id)
                            ->where ('user_id', Auth::id())
                             ->where ('status', 'LOSS')
                             ->count();

          $sub_total = $initial + $total_q - $withdraw + $deposit;

          $roi_port = ($sub_total - $initial) / $initial *100;

             //total close counter (portfolio)
             $total_close_counter = DB::table('results')
             ->where('portfolio_id', $request->portfolio_id)
             ->where('user_id', Auth::id())
             ->whereNotNull('status') 
             ->count();

             //total open counter (portfolio)
             $total_open_counter = DB::table('results')
             ->where('portfolio_id', $request->portfolio_id)
             ->where('user_id', Auth::id())
             ->whereNull('status')
             ->count();


          $portfolio_update_details = DB::table('portfolios')
          ->where('id', $request->portfolio_id)
          ->where('user_id', Auth::id())
          ->update([
                  "win" => $win,
                  "loss" => $loss,
                  "total_profit" => $total_q,
                  'roi_port' =>$roi_port,
                  'close_counter' =>$total_close_counter,
                  'open_counter' =>$total_open_counter,
          ]);

          //Update into portfolio End //




           } else
           {
             $subtotal_cost_sell = Auth::user()->portfolio()
                     ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                     ->where('portfolio_id', $request->portfolio_id)
                     ->where('stock_code', $request->stock_code)
                     ->where('stock_id',  $request->stock_id)
                     ->where('action', 'sell')
                     ->sum('total_cost');

             // Update into balance_avaiable(portfolio) Strat //
             $trans_update_buy = DB::table('transactions')
                   ->insert([
                     "portfolio_id" => $request->portfolio_id,
                     "user_id" => Auth::id(),
                     "stock_code" => $request->stock_code,
                     "type" => 'Sell',
                     "amount" => $subtotal_cost_sell,
                     "remark" => 'Sell ' . $request->stock_symbol ,
                     "stock_id" => $request->stock_id,
                     "date" => $request->date,
                     "created_at" => Carbon::now(),
                     "updated_at" => Carbon::now(),
                           ]);

             $total_available_balance_in_portfolio = Portfolio::where('id' , $request->portfolio_id)
                                                   ->where ('user_id', Auth::id())
                                                   ->pluck('balance_available')
                                                   ->first();

              $subtotal_balance_available = $total_available_balance_in_portfolio + $subtotal_cost_sell;

                           //total close counter (portfolio)
             $total_close_counter = DB::table('results')
             ->where('portfolio_id', $request->portfolio_id)
             ->where('user_id', Auth::id())
             ->whereNotNull('status') 
             ->count();

             //total open counter (portfolio)
             $total_open_counter = DB::table('results')
             ->where('portfolio_id', $request->portfolio_id)
             ->where('user_id', Auth::id())
             ->whereNull('status')
             ->count();

              $portfolio_Update = DB::table('portfolios')
               ->where('id', $request->portfolio_id)
               ->where('user_id', Auth::id())
                     ->update([
                       "balance_available" => $subtotal_balance_available,
                       'close_counter' =>$total_close_counter,
                       'open_counter' =>$total_open_counter,
                             ]);


           // Update into balance_avaiable(portfolio) End //



             $Result_Update = DB::table('results')
             ->where('portfolio_id', $request->portfolio_id)
             ->where('stock_code', $request->stock_code)
             ->where('stock_id', $request->stock_id)
             ->where('user_id', Auth::id())
                   ->update([
                     "gross_profit" => Null,
                     "gross_roi" => Null

                       ]);
           }
           // Update ROI into (result) End //
           // Update into (resukt) End //







           }else {
             // Create into trade Start //
             $trade = new Trade();
             $trade->action = 'sell';
             $trade->status = 0;
             $trade->portfolio_id = $request->portfolio_id;
             $trade->stock_code = $request->stock_code;
             $trade->first_fees = $request->first_fees;
             $trade->stock_id = $request->stock_id;
             $trade->stock_name = $request->stock_name;
             $trade->stock_symbol = $request->stock_symbol;
             $trade->price = $request->price;
             $trade->brokerage_id = $request->brokerage_id;
             $trade->quantity = $request->quantity;
             $trade->date = $request->date;
             $trade->remark = $request->remark;

             //Subtotal Calculation//
             $subtotal = $request->price * $request->quantity;
             $trade->subtotal = $subtotal;
             //Brokerage Fee Calculation //
             $broker_f = $subtotal * $request->second_fees/100;
             if($broker_f  > $request->first_fees){
               $broker_fees = $subtotal * $request->second_fees/100;
               $trade->broker_fee = $broker_fees;
             }
             elseif($broker_f < $request->first_fees){
               $broker_fees =  $request->first_fees;
               $trade->broker_fee = $broker_fees;
             }
             //Clearing Fee Calculation//
             $clearing_f = $subtotal * 0.03/100;
             $trade->clearing_fee = $clearing_f;
             //Stamp Duty Fee Calculation//
             $stamp_d = ceil($subtotal/1000) * 1.50;
             $trade->stamp_duty = $stamp_d;
             //Total Fees  Calculation//
             $total_fees = $broker_fees + $clearing_f +  $stamp_d;
             //Total Cost  Calculation//
            $total_c = $subtotal - $broker_fees - $clearing_f - $stamp_d ;
            $trade->total_cost = $total_c;

             $trade->user_id = Auth::id();
             $trade->result_id = $request->result_id;

             $trade->save();
             // Create into trade End //

             // Create into Result Start //
             $close_sell = Auth::user()->portfolio()
                   ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                   ->where('portfolio_id', $request->portfolio_id)
                   ->where('stock_code', $request->stock_code)
                   ->where('stock_id',  $request->stock_id)
                   ->where('action', 'sell')
                   ->sum('price');

             $trade_count = Auth::user()->portfolio()
                   ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                   ->where('portfolio_id', $request->portfolio_id)
                   ->where('stock_code', $request->stock_code)
                   ->where('stock_id',  $request->stock_id)
                   ->where('action', 'sell')
                   ->count();

             $average_sell_trade = $close_sell / $trade_count;

             $sum_quantity = Auth::user()->portfolio()
                     ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                     ->where('portfolio_id', $request->portfolio_id)
                     ->where('stock_code', $request->stock_code)
                     ->where('stock_id',  $request->stock_id)
                     ->where('action', 'sell')
                     ->sum('quantity');

             $broke_total_fee = Auth::user()->portfolio()
                     ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                     ->where('portfolio_id', $request->portfolio_id)
                     ->where('stock_code', $request->stock_code)
                     ->where('stock_id',  $request->stock_id)
                     ->where('action', 'sell')
                     ->sum('broker_fee');

           $clearing_total_fee = Auth::user()->portfolio()
                   ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                   ->where('portfolio_id', $request->portfolio_id)
                   ->where('stock_code', $request->stock_code)
                   ->where('stock_id',  $request->stock_id)
                   ->where('action', 'sell')
                   ->sum('clearing_fee');

           $stamp_total_fee = Auth::user()->portfolio()
                   ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                   ->where('portfolio_id', $request->portfolio_id)
                 ->where('stock_code', $request->stock_code)
                   ->where('stock_id',  $request->stock_id)
                   ->where('action', 'sell')
                   ->sum('stamp_duty');

             $subtotal_fees_sell = $broke_total_fee + $clearing_total_fee + $stamp_total_fee;

             $subtotal_sell_trade = Auth::user()->portfolio()
                     ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                     ->where('portfolio_id', $request->portfolio_id)
                     ->where('stock_code', $request->stock_code)
                     ->where('stock_id',  $request->stock_id)
                     ->where('action', 'sell')
                     ->sum('subtotal');

             $subtotal_cost_sell = Auth::user()->portfolio()
                     ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                     ->where('portfolio_id', $request->portfolio_id)
                     ->where('stock_code', $request->stock_code)
                     ->where('stock_id',  $request->stock_id)
                     ->where('action', 'sell')
                     ->sum('total_cost');

             $sum_quantity_buy = Auth::user()->portfolio()
                     ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                     ->where('portfolio_id', $request->portfolio_id)
                     ->where('stock_code', $request->stock_code)
                     ->where('stock_id',  $request->stock_id)
                     ->where('action', 'buy')
                     ->sum('quantity');

             $balance_quantity =   $sum_quantity_buy -   $sum_quantity;

             $broke_total_fee_all = Auth::user()->portfolio()
                     ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                     ->where('portfolio_id', $request->portfolio_id)
                     ->where('stock_code', $request->stock_code)
                     ->where('stock_id',  $request->stock_id)
                     ->sum('broker_fee');

                 $clearing_total_fee_all = Auth::user()->portfolio()
                         ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                         ->where('portfolio_id', $request->portfolio_id)
                         ->where('stock_code', $request->stock_code)
                         ->where('stock_id',  $request->stock_id)
                         ->sum('clearing_fee');

                 $stamp_total_fee_all = Auth::user()->portfolio()
                         ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                         ->where('portfolio_id', $request->portfolio_id)
                         ->where('stock_code', $request->stock_code)
                         ->where('stock_id',  $request->stock_id)
                         ->sum('stamp_duty');

                         $subtotal_fee_all = $broke_total_fee_all + $clearing_total_fee_all + $stamp_total_fee_all;

             $Result_Update = DB::table('results')
             ->where('portfolio_id', $request->portfolio_id)
             ->where('stock_code', $request->stock_code)
             ->where('stock_id', $request->stock_id)
             ->where('user_id', Auth::id())
                   ->update([
                     "average_sell" => $average_sell_trade,
                     "quantity_sell" => $sum_quantity,
                     "total_fees_sell" => $subtotal_fees_sell,
                     "subtotal_sell" => $subtotal_sell_trade,
                     "total_sell_cost" => $subtotal_cost_sell,
                     "quantity_bal" => $balance_quantity,
                     "subtotal_fee" => $subtotal_fee_all,
                           ]);
               // Create into Result End //




               // Update into (result) Start //
               // Update ROI into (result) Start //
               if ($balance_quantity == 0)
               {
                 $open_buy = Auth::user()->portfolio()
                       ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                       ->where('portfolio_id', $request->portfolio_id)
                       ->where('stock_code', $request->stock_code)
                       ->where('stock_id',  $request->stock_id)
                       ->where('action', 'buy')
                       ->sum('price');

                 $trade_count = Auth::user()->portfolio()
                       ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                       ->where('portfolio_id', $request->portfolio_id)
                       ->where('stock_code', $request->stock_code)
                       ->where('stock_id',  $request->stock_id)
                       ->where('action', 'buy')
                       ->count();

                 $average_buy = $open_buy / $trade_count;

                 $quantity_buy = Auth::user()->portfolio()
                         ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                         ->where('portfolio_id', $request->portfolio_id)
                         ->where('stock_code', $request->stock_code)
                         ->where('stock_id',  $request->stock_id)
                         ->where('action', 'buy')
                         ->sum('quantity');

                 $subtotal_gross_buy = $average_buy * $quantity_buy;

                 $open_sell = Auth::user()->portfolio()
                       ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                       ->where('portfolio_id', $request->portfolio_id)
                       ->where('stock_code', $request->stock_code)
                       ->where('stock_id',  $request->stock_id)
                       ->where('action', 'sell')
                       ->sum('price');

                 $trade_count_sell = Auth::user()->portfolio()
                       ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                       ->where('portfolio_id', $request->portfolio_id)
                       ->where('stock_code', $request->stock_code)
                       ->where('stock_id',  $request->stock_id)
                       ->where('action', 'sell')
                       ->count();

                 $average_sell = $open_sell / $trade_count_sell;

                 $quantity_sell = Auth::user()->portfolio()
                         ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                         ->where('portfolio_id', $request->portfolio_id)
                         ->where('stock_code', $request->stock_code)
                         ->where('stock_id',  $request->stock_id)
                         ->where('action', 'sell')
                         ->sum('quantity');

                 $subtotal_gross_sell = $average_sell * $quantity_sell;



                 $gross_profits = $subtotal_gross_sell - $subtotal_gross_buy;

                 $subtotal_buy = Auth::user()->portfolio()
                         ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                         ->where('portfolio_id', $request->portfolio_id)
                         ->where('stock_code', $request->stock_code)
                         ->where('stock_id',  $request->stock_id)
                         ->where('action', 'buy')
                         ->sum('subtotal');

                 $ROI_gros_profits = $gross_profits/$subtotal_buy * 100;

                 $subtotal_cost_buy = Auth::user()->portfolio()
                         ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                         ->where('portfolio_id', $request->portfolio_id)
                         ->where('stock_code', $request->stock_code)
                         ->where('stock_id',  $request->stock_id)
                         ->where('action', 'buy')
                         ->sum('total_cost');

                 $subtotal_cost_sell = Auth::user()->portfolio()
                         ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                         ->where('portfolio_id', $request->portfolio_id)
                         ->where('stock_code', $request->stock_code)
                         ->where('stock_id',  $request->stock_id)
                         ->where('action', 'sell')
                         ->sum('total_cost');

                  $net_profits = $subtotal_cost_sell - $subtotal_cost_buy;

                  $ROI_net_profits = $net_profits/$subtotal_cost_buy * 100;
                  // Update status into (result) End //
                  if ($net_profits < 0)
                  {

                    $status = 'LOSS';
                    $trans_update = DB::table('transactions')
                          ->insert([
                            "portfolio_id" => $request->portfolio_id,
                            "user_id" => Auth::id(),
                            "stock_code" => $request->stock_code,
                            "type" => 'Loss',
                            "amount" => $net_profits,
                            "remark" => 'Loss',
                            "stock_id" => $request->stock_id,
                            "date" => $request->date,
                            "created_at" => Carbon::now(),
                            "updated_at" => Carbon::now(),
                                  ]);
                  }
                  else
                  {
                    $status = 'WIN';
                    $trans_update = DB::table('transactions')
                          ->insert([
                            "portfolio_id" => $request->portfolio_id,
                            "user_id" => Auth::id(),
                            "stock_code" => $request->stock_code,
                            "type" => 'Profit',
                            "amount" => $net_profits,
                            "remark" => 'Profit',
                            "stock_id" => $request->stock_id,
                            "date" => $request->date,
                            "created_at" => Carbon::now(),
                            "updated_at" => Carbon::now(),
                                  ]);
                  }
                  // Update status into (result) End //

                             $Result_Update = DB::table('results')
                             ->where('portfolio_id', $request->portfolio_id)
                             ->where('stock_code', $request->stock_code)
                             ->where('stock_id', $request->stock_id)
                             ->where('user_id', Auth::id())
                                   ->update([
                                    "close_trade" => $request->date,
                                     "gross_profit" => $gross_profits,
                                     "gross_roi" => $ROI_gros_profits,
                                     "net_profit" => $net_profits,
                                     "net_roi" => $ROI_net_profits,
                                     "status" => $status
                                           ]);

                                           // Update into balance_avaiable(portfolio) Strat //
                                                $trans_update_buy = DB::table('transactions')
                                                      ->insert([
                                                        "portfolio_id" => $request->portfolio_id,
                                                        "user_id" => Auth::id(),
                                                        "stock_code" => $request->stock_code,
                                                        "type" => 'Sell',
                                                        "amount" => $total_c,
                                                        "remark" => 'Sell ' . $request->stock_symbol ,
                                                        "stock_id" => $request->stock_id,
                                                        "date" => $request->date,
                                                        "created_at" => Carbon::now(),
                                                        "updated_at" => Carbon::now(),
                                                              ]);

                                                $total_available_balance_in_portfolio = Portfolio::where('id' , $request->portfolio_id)
                                                                                      ->where ('user_id', Auth::id())
                                                                                      ->pluck('balance_available')
                                                                                      ->first();

                                                 $subtotal_balance_available = $total_available_balance_in_portfolio + $total_c;
                                                 $portfolio_Update = DB::table('portfolios')
                                                  ->where('id', $request->portfolio_id)
                                                  ->where('user_id', Auth::id())
                                                        ->update([
                                                          "balance_available" => $subtotal_balance_available,
                                                                ]);
                                              // Update into balance_avaiable(portfolio) End //

                                              //Update into portfolio Start //

                                              $win =  Result::where('portfolio_id' , $request->portfolio_id)
                                                                ->where ('user_id', Auth::id())
                                                                ->where ('status', 'WIN')
                                                                ->count();

                                              $loss =  Result::where('portfolio_id' , $request->portfolio_id)
                                                               ->where ('user_id', Auth::id())
                                                                ->where ('status', 'LOSS')
                                                                ->count();

                                              $profit_eq =  Result::where('portfolio_id' , $request->portfolio_id)
                                                               ->where ('user_id', Auth::id())
                                                               ->where ('status', 'WIN')
                                                               ->sum('net_profit');

                                              $loss_eq = Result::where('portfolio_id' , $request->portfolio_id)
                                                               ->where ('user_id', Auth::id())
                                                                ->where ('status', 'LOSS')
                                                                 ->sum('net_profit');

                                              $total_q = $profit_eq + $loss_eq;

                                              $initial = Portfolio::where('id' , $request->portfolio_id)
                                                        ->where ('user_id', Auth::id())
                                                        ->pluck('initial_deposit')
                                                        ->first();

                                              $deposit = Transaction::where('portfolio_id' , $request->portfolio_id)
                                                                  ->where ('type', 'Deposit')
                                                                  ->sum('amount');

                                              $withdraw = Transaction::where('portfolio_id' , $request->portfolio_id)
                                                                  ->where ('type', 'Withdraw')
                                                                  ->sum('amount');

                                              $profit = Result::where('portfolio_id' , $request->portfolio_id)
                                                                ->where ('user_id', Auth::id())
                                                                 ->where ('status', 'WIN')
                                                                  ->sum('net_profit');

                                              $profit = Result::where('portfolio_id' , $request->portfolio_id)
                                                                ->where ('user_id', Auth::id())
                                                                 ->where ('status', 'LOSS')
                                                                  ->sum('net_profit');

                                              $winnings = Result::where('portfolio_id' , $request->portfolio_id)
                                                                ->where ('user_id', Auth::id())
                                                                 ->where ('status', 'WIN')
                                                                 ->count();

                                              $lossing = Result::where('portfolio_id' , $request->portfolio_id)
                                                                ->where ('user_id', Auth::id())
                                                                 ->where ('status', 'LOSS')
                                                                 ->count();

                                              $sub_total = $initial + $total_q - $withdraw + $deposit;

                                              $roi_port = ($sub_total - $initial) / $initial *100;

                                                //total close counter (portfolio)
                                                $total_close_counter = DB::table('results')
                                                ->where('portfolio_id', $request->portfolio_id)
                                                ->where('user_id', Auth::id())
                                                ->whereNotNull('status') 
                                                ->count();

                                                //total open counter (portfolio)
                                                $total_open_counter = DB::table('results')
                                                ->where('portfolio_id', $request->portfolio_id)
                                                ->where('user_id', Auth::id())
                                                ->whereNull('status')
                                                ->count();
            

                                              $portfolio_update_details = DB::table('portfolios')
                                              ->where('id', $request->portfolio_id)
                                              ->where('user_id', Auth::id())
                                              ->update([
                                                      "win" => $win,
                                                      "loss" => $loss,
                                                      "total_profit" => $total_q,
                                                      'roi_port' =>$roi_port,
                                                      "open_counter" => $total_open_counter,
                                                      "close_counter" =>$total_close_counter,
                                              ]);

                                              //Update into portfolio End //

               } else
               {

                 // Update into balance_avaiable(portfolio) Strat //
                      $trans_update_buy = DB::table('transactions')
                            ->insert([
                              "portfolio_id" => $request->portfolio_id,
                              "user_id" => Auth::id(),
                              "stock_code" => $request->stock_code,
                              "type" => 'Sell',
                              "amount" => $total_c,
                              "remark" => 'Sell ' . $request->stock_symbol ,
                              "stock_id" => $request->stock_id,
                              "date" => $request->date,
                              "created_at" => Carbon::now(),
                              "updated_at" => Carbon::now(),
                                    ]);

                      $total_available_balance_in_portfolio = Portfolio::where('id' , $request->portfolio_id)
                                                            ->where ('user_id', Auth::id())
                                                            ->pluck('balance_available')
                                                            ->first();

                       $subtotal_balance_available = $total_available_balance_in_portfolio + $total_c;

                        //total close counter (portfolio)
                        $total_close_counter = DB::table('results')
                        ->where('portfolio_id', $request->portfolio_id)
                        ->where('user_id', Auth::id())
                        ->whereNotNull('status') 
                        ->count();

                        //total open counter (portfolio)
                        $total_open_counter = DB::table('results')
                        ->where('portfolio_id', $request->portfolio_id)
                        ->where('user_id', Auth::id())
                        ->whereNull('status')
                        ->count();

                       $portfolio_Update = DB::table('portfolios')
                        ->where('id', $request->portfolio_id)
                        ->where('user_id', Auth::id())
                              ->update([
                                "balance_available" => $subtotal_balance_available,
                                "open_counter" => $total_open_counter,
                                "close_counter" =>$total_close_counter,
                                      ]);


                    // Update into balance_avaiable(portfolio) End //

                 $Result_Update = DB::table('results')
                 ->where('portfolio_id', $request->portfolio_id)
                 ->where('stock_code', $request->stock_code)
                 ->where('stock_id', $request->stock_id)
                 ->where('user_id', Auth::id())
                       ->update([
                         "gross_profit" => Null,
                         "gross_roi" => Null

                           ]);
               }
               // Update ROI into (result) End //
               // Update into (resukt) End //




              }


        // return redirect()->back()
        return redirect()->route('trades.statistic', ['id' => $request->portfolio_id])
             ->with('success','Sell created successfully.');
     }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
