<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;

use App\Models\Portfolio;
use App\Models\Stock;
use App\Models\Trade;
use App\Models\Brokerage;
use App\Models\Result;
use App\Models\Transaction;
use Illuminate\Support\Facades\Auth;
use DB;
use Carbon\Carbon;


class ResultController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
      $result = Result::find($id);
      $data_result_id = $result->id;
      $data_code = $result->stock_code;
      $data_portfolio = $result->portfolio_id;
      $data_user = $result->user_id;
      $data_date = $result->date;

      //Balance Avaialabel Start //
      $total_available_balance = Portfolio::where('id' , $data_portfolio)
                                            ->where ('user_id',  $data_user)
                                            ->pluck('balance_available')
                                            ->first();
      //Balance Avaialabel End //

      // Total sell Trade Start //
      $sell_history = Trade::where('result_id', $data_result_id)
         ->where('portfolio_id', $data_portfolio)
         ->where('user_id',   $data_user)
         ->where('stock_code',   $data_code)
         ->where('action',  'sell')
         ->sum('total_cost');
      // Total Sell Trade End //

      // Total sell Trade Start //
      $buy_history = Trade::where('result_id', $data_result_id)
         ->where('portfolio_id', $data_portfolio)
         ->where('user_id',   $data_user)
         ->where('stock_code',   $data_code)
         ->where('action', 'buy')
         ->sum('total_cost');
      // Total Sell Trade End //

       $subtotal_balance_available = $total_available_balance - $sell_history + $buy_history;

       $portfolio_update_balance = DB::table('portfolios')
        ->where('id', $data_portfolio)
        ->where('user_id', $data_user)
              ->update([
                "balance_available" => $subtotal_balance_available,
                      ]);

        Result::find($id)->delete();
        $trade_update = DB::table('trades')
                      ->where('result_id', $data_result_id)->delete();


            //total open counter (portfolio)
            $total_open_counter = DB::table('results')
            ->where('portfolio_id', $data_portfolio)
            ->where('user_id', $data_user)
            ->whereNull('status')
            ->count();

            $portfolio_update_counter = DB::table('portfolios')
            ->where('id', $data_portfolio)
            ->where('user_id', $data_user)
                  ->update([
                    "open_counter" => $total_open_counter,
                          ]);

                      return redirect()->route('trades.statistic', ['id' => $data_portfolio])
                                 ->with('success','Trade successfully delete.');    }
}
