<?php

namespace App\Http\Controllers;

use App\Models\Program;
use App\Models\Trade;
use App\Models\Transaction;
use App\Models\Portfolio;
use App\Models\Result;
use App\Models\User;
use App\Models\Batchuser;
use Illuminate\Http\Request;
use DB;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\ProgramStatisticExport;
use PDF;



class ProgramStatisticController extends Controller
{
    /**
     * create a new instance of the class
     *
     * @return void
     */
    function __construct()
    {
         $this->middleware('permission:program-list|program-create|program-edit|program-delete', ['only' => ['index', 'show']]);
         $this->middleware('permission:program-create', ['only' => ['create', 'store']]);
         $this->middleware('permission:program-edit', ['only' => ['edit', 'update']]);
         $this->middleware('permission:program-delete', ['only' => ['destroy']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
     public function index(Request $request)
     {
         $data = Program::latest()->get();

         return view('programstatistic.index',compact('data'));
     }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('programstatistic.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
     public function store(Request $request)
     {
         $this->validate($request, [
           'program_name' => 'required',
           'program_date' => 'required',
           'program_year' => 'required',
         ]);
         $input = $request->except(['_token']);

         Program::create($input);

         return redirect()->route('programstatistic.index')
             ->with('success','Batch created successfully.');
     }

     public function GetBroke($data){
          echo json_encode(DB::table('portfolios')->where('user_id', $data)->get());
      }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $program = Program::find($id);


                  $programs = Program::find($id)
                  ->join('batchusers', 'batchusers.batch_id', '=', 'programs.id')
                  ->join('users', 'batchusers.user_id', '=', 'users.id')
                  ->join('portfolios', 'portfolios.user_id', '=', 'users.id')
                  ->orderByRaw('CAST(total_profit as DECIMAL) DESC')
                  ->where('batch_id', $id)
                  ->get();

                  $batchuser_count = Program::find($id)
                  ->join('batchusers', 'batchusers.batch_id', '=', 'programs.id')
                  ->join('users', 'batchusers.user_id', '=', 'users.id')
                  ->where('batch_id', $id)
                  ->count();

        //return $programs_desending;
        return view('programstatistic.show', compact('program','programs','batchuser_count'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

     public function export($id)
        {
            return Excel::download(new ProgramStatisticExport($id), 'list.xlsx');
        }

     public function ProgramUsertradeHistory($id)
     {
       $data = Result::join('trades', 'results.id', '=', 'trades.result_id')
             ->where('result_id', $id)
             ->get();

       $result = Result::find($id);


       return view('programstatistic.history',compact('data','result'));
     }

     public function ProgramUsertradeStatistic(Trade $trade, $id)
     {
       $fund_available = Portfolio::where('id' , $id)
                           ->pluck('balance_available')
                           ->first();

        $trans = Transaction::where('portfolio_id', $id)
               ->get();

        $initial = Transaction::where('portfolio_id' , $id)
                            ->where ('type', 'Initial')
                            ->sum('amount');

        $deposit = Transaction::where('portfolio_id' , $id)
                            ->where ('type', 'Deposit')
                            ->sum('amount');

        $withdraw = Transaction::where('portfolio_id' , $id)
                            ->where ('type', 'Withdraw')
                            ->sum('amount');

        $profit = Transaction::where('portfolio_id' , $id)
                            ->where ('type', 'Profit')
                            ->sum('amount');

        $winnings = Transaction::where('portfolio_id' , $id)
                           ->where ('type', 'Profit')
                           ->count();

        $lossing = Transaction::where('portfolio_id' , $id)
                           ->where ('type', 'Loss')
                           ->count();

        $loss = Transaction::where('portfolio_id' , $id)
                            ->where ('type', 'Loss')
                            ->sum('amount');


        $total_q = $profit + $loss;

        $total = $initial + $total_q - $withdraw + $deposit;

        $roi_port = ($total - $initial) / $initial *100;

       $portfolio = Portfolio::find($id);

       $data = Result::where('portfolio_id', $id)
             ->get();

       $result = DB::table('results')
             ->where('portfolio_id',$id)
             ->get();

             $total_harga = Result::where('portfolio_id', $id)
             ->whereNotNull('status')
             ->pluck('net_profit')
             ->toArray();
             
             $bulan = Result::where('portfolio_id', $id)
             ->select(DB::raw('DATE_FORMAT(close_trade, "%d/%b/%Y") as bulan'))
             ->pluck('bulan')
             ->toArray();

           //  $bulan = Result::where('portfolio_id' , $id)
           //  ->select(DB::raw("MONTHNAME(close_trade) as bulan"))
           //  ->GroupBy(DB::raw("MONTHNAME(close_trade)"))
           //  ->pluck('bulan');

          // $total_harga2 = Transaction::where('portfolio_id' , $id)
           //->where('type','Profit')
           //->select(DB::raw("SUM(amount) as total_harga"))
           //->whereYear('date', date('Y'))
           //->GroupBy(DB::raw("Month(date)"))
           //->pluck("total_harga");

           //$total_harga3 = Transaction::where('portfolio_id' , $id)
           //->where('type','Loss')
           //->select(DB::raw("SUM(amount) as total_harga"))
           //->whereYear('date', date('Y'))
           //->GroupBy(DB::raw("Month(date)"))
           //->pluck("total_harga");

           $total_harga2 = Transaction::where('portfolio_id' , $id)
           ->where('type','Profit')
           ->pluck("amount")
           ->toArray();


           $total_harga3 = Transaction::where('portfolio_id' , $id)
           ->where('type','Loss')
           ->pluck("amount")
           ->toArray();

           $bulan2 = Result::where('portfolio_id', $id)
           ->select(DB::raw('DATE_FORMAT(close_trade, "%d/%b/%Y") as bulan'))
           ->pluck('bulan')
           ->toArray();

           //$bulan2 = Transaction::where('portfolio_id' , $id)
            //->select(DB::raw("MONTHNAME(date) as bulan"))
            //->GroupBy(DB::raw("MONTHNAME(date)"))
            //->pluck('bulan');

// Fetch monthly profits ordered by month and year ascending
$monthlyProfits = Transaction::where('portfolio_id', $id)
->where('type', 'Profit')
->select(DB::raw('MONTH(date) as month'), DB::raw('YEAR(date) as year'), DB::raw('SUM(amount) as total'))
->groupBy(DB::raw('YEAR(date)'), DB::raw('MONTH(date)'))
->orderBy(DB::raw('YEAR(date)'), 'asc')
->orderBy(DB::raw('MONTH(date)'), 'asc')
->pluck('total', 'month')
->toArray();

// Fetch monthly losses (as negative values) ordered by month and year ascending
$monthlyLosses = Transaction::where('portfolio_id', $id)
->where('type', 'Loss')
->select(DB::raw('MONTH(date) as month'), DB::raw('YEAR(date) as year'), DB::raw('SUM(amount) as total'))
->groupBy(DB::raw('YEAR(date)'), DB::raw('MONTH(date)'))
->orderBy(DB::raw('YEAR(date)'), 'asc')
->orderBy(DB::raw('MONTH(date)'), 'asc')
->pluck('total', 'month')
->toArray();

// Fetch formatted month names and years ordered by month and year ascending
$months = Transaction::where('portfolio_id', $id)
->select(DB::raw('DISTINCT MONTH(date) as month'), DB::raw('YEAR(date) as year'), DB::raw('DATE_FORMAT(date, "%M %Y") as month_year'))
->orderBy(DB::raw('YEAR(date)'), 'asc')
->orderBy(DB::raw('MONTH(date)'), 'asc')
->pluck('month_year', 'month')
->toArray();

// Initialize arrays for Highcharts
$profits = [];
$losses = [];
foreach ($months as $month => $monthYear) {
$profits[] = isset($monthlyProfits[$month]) ? (float)$monthlyProfits[$month] : 0;
$losses[] = isset($monthlyLosses[$month]) ? (float)$monthlyLosses[$month] : 0; // Negate losses
}

// Prepare data for Highcharts
$chartData = [
'categories' => array_values($months), // Month and Year labels
'profits' => $profits,
'losses' => $losses,
];
       //return $initial;
       //return $average_buy;

       $data_broker = DB::table('users')->get();

       return view('programstatistic.statistic',compact('bulan2','total_harga3','total_harga2','bulan','total_harga','fund_available','data','trans','portfolio','result','initial','deposit','withdraw','profit','total','loss','winnings','lossing','total_q','roi_port','portfolio','data_broker' ,'profits', 'losses', 'months' , 'monthlyProfits' , 'monthlyLosses'));
     }

     public function search(Request $request)
     {
          $portfolio = $request->portfolio;
          //return $portfolio;
          return redirect()->route('programstatistic.statistic', [$portfolio]);
     }

     public function createuserPDF($id) {
       // retreive all records from db
       //$complaint = Auth::user()->complaint()->latest()->get()->find($id);
       $result = Result::where('portfolio_id', $id)->get();

             $trade = Trade::where('portfolio_id', $id)
                   ->get();

       $portfolio = Portfolio::find($id);

       // share data to view
       $pdf = PDF::setOptions(['isRemoteEnabled' => true])->loadView('trades.print',compact('result','trade','portfolio'))->setPaper('a4', 'portrait');
      //return $pdf->stream();
       // download PDF file with download method
       return $pdf->download('TradeUserStatistic.pdf');
     }

    public function edit($id)
    {
        $program = Program::find($id);

        return view('programstatistic.edit',compact('program'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
          'program_name' => 'required',
          'program_date' => 'required',
          'program_year' => 'required',
        ]);

        $program = Program::find($id);

        $program->update($request->all());

        return redirect()->route('programstatistic.index')
            ->with('success','Batch updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Program::find($id)->delete();

        return redirect()->route('programstatistic.index')
            ->with('success', 'Batch deleted successfully.');
    }
}
