<?php

namespace App\Http\Controllers;

use App\Models\Post;
use Illuminate\Http\Request;

class PostController extends Controller
{
    /**
     * create a new instance of the class
     *
     * @return void
     */
    function __construct()
    {
         $this->middleware('permission:post-list|post-create|post-edit|post-delete', ['only' => ['index', 'show']]);
         $this->middleware('permission:post-create', ['only' => ['create', 'store']]);
         $this->middleware('permission:post-edit', ['only' => ['edit', 'update']]);
         $this->middleware('permission:post-delete', ['only' => ['destroy']]);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = Post::latest()->paginate(5);

        return view('posts.index',compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
      $trades = Auth::user()->trade()->where('stock_name','=', $request->input('stock_name'))->where('portfolio_id','=', $request->input('portfolio_id'))->where('action', 'sell')->first();
      $results = Auth::user()->trade()->where('stock_name','=', $request->input('stock_name'))->where('portfolio_id','=', $request->input('portfolio_id'));

if ($trades === null){
        $trade = new Trade();
        $trade->action = 'sell';
        $trade->status = 1;
        $trade->portfolio_id = $request->portfolio_id;
        $trade->stock_code = $request->stock_code;
        $trade->first_fees = $request->first_fees;
        $trade->stock_id = $request->stock_id;
        $trade->stock_name = $request->stock_name;
        $trade->stock_symbol = $request->stock_symbol;
        $trade->price = $request->price;
        $trade->brokerage_id = $request->brokerage_id;
        $trade->quantity = $request->quantity;
        $trade->date = $request->date;
        $trade->remark = $request->remark;

        //Subtotal Calculation//
        $subtotal = $request->price * $request->quantity;
        $trade->subtotal = $subtotal;

        //Brokerage Fee Calculation //
        $broker_f = $subtotal * $request->second_fees/100;
        if($broker_f  > $request->first_fees){
          $broker_fees = $subtotal * $request->second_fees/100;
          $trade->broker_fee = $broker_fees;
        }
        elseif($broker_f < $request->first_fees){
          $broker_fees =  $request->first_fees;
          $trade->broker_fee = $broker_fees;
        }

        //Clearing Fee Calculation//
        $clearing_f = $subtotal * 0.03/100;
        $trade->clearing_fee = $clearing_f;

        //Stamp Duty Fee Calculation//
        $stamp_d = ceil($subtotal/1000) * 1.50;
        $trade->stamp_duty = $stamp_d;

        //Total Fees  Calculation//
        $total_fees = $broker_fees + $clearing_f +  $stamp_d;

        //Total Cost  Calculation//
       $total_c = $subtotal - $broker_fees - $clearing_f - $stamp_d ;
       $trade->total_cost = $total_c;

        $trade->user_id = Auth::id();
        $trade->result_id = $request->result_id;

        $trade->save();

        $sum_quantity = Auth::user()->portfolio()
                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                ->where('portfolio_id', $request->portfolio_id)
                ->where('stock_code', $request->stock_code)
                ->where('stock_id',  $request->stock_id)
                ->where('action', 'sell')
                ->sum('quantity');

         $sum_quantity_buy = Auth::user()->portfolio()
                 ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                 ->where('portfolio_id', $request->portfolio_id)
                 ->where('stock_code', $request->stock_code)
                 ->where('stock_id',  $request->stock_id)
                 ->where('action', 'buy')
                 ->sum('quantity');

         $balance_quantity =   $sum_quantity_buy -   $sum_quantity;




     $broke_total_fee_all = Auth::user()->portfolio()
             ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
             ->where('portfolio_id', $request->portfolio_id)
             ->where('stock_code', $request->stock_code)
             ->where('stock_id',  $request->stock_id)
                           ->sum('broker_fee');

         $clearing_total_fee_all = Auth::user()->portfolio()
                 ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                 ->where('portfolio_id', $request->portfolio_id)
                 ->where('stock_code', $request->stock_code)
                 ->where('stock_id',  $request->stock_id)
                 ->sum('clearing_fee');

         $stamp_total_fee_all = Auth::user()->portfolio()
                 ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                 ->where('portfolio_id', $request->portfolio_id)
                 ->where('stock_code', $request->stock_code)
                 ->where('stock_id',  $request->stock_id)
                 ->sum('stamp_duty');

                 $subtotal_fee_all = $broke_total_fee_all + $clearing_total_fee_all + $stamp_total_fee_all;



        $Result_Update = DB::table('results')
        ->where('portfolio_id', $request->portfolio_id)
        ->where('stock_code', $request->stock_code)
        ->where('stock_id', $request->stock_id)
        ->where('user_id', Auth::id())
              ->update([
                "close_trade" => $request->date,
                "average_sell" => $request->price,
                "quantity_sell" => $request->quantity,
                "total_fees_sell" => $total_fees,
                "subtotal_sell" => $subtotal,
                "total_sell_cost" => $total_c,
                "quantity_bal" => $balance_quantity,
                "subtotal_fee" => $subtotal_fee_all,

                      ]);

                      if ($balance_quantity == 0)
                      {
                        $open_buy = Auth::user()->portfolio()
                              ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                              ->where('portfolio_id', $request->portfolio_id)
                              ->where('stock_code', $request->stock_code)
                              ->where('stock_id',  $request->stock_id)
                              ->where('action', 'buy')
                              ->sum('price');

                        $trade_count = Auth::user()->portfolio()
                              ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                              ->where('portfolio_id', $request->portfolio_id)
                              ->where('stock_code', $request->stock_code)
                              ->where('stock_id',  $request->stock_id)
                              ->where('action', 'buy')
                              ->count();

                        $average_buy = $open_buy / $trade_count;

                        $quantity_buy = Auth::user()->portfolio()
                                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                ->where('portfolio_id', $request->portfolio_id)
                                ->where('stock_code', $request->stock_code)
                                ->where('stock_id',  $request->stock_id)
                                ->where('action', 'buy')
                                ->sum('quantity');

                        $subtotal_gross_buy = $average_buy * $quantity_buy;

                        $open_sell = Auth::user()->portfolio()
                              ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                              ->where('portfolio_id', $request->portfolio_id)
                              ->where('stock_code', $request->stock_code)
                              ->where('stock_id',  $request->stock_id)
                              ->where('action', 'sell')
                              ->sum('price');

                        $trade_count_sell = Auth::user()->portfolio()
                              ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                              ->where('portfolio_id', $request->portfolio_id)
                              ->where('stock_code', $request->stock_code)
                              ->where('stock_id',  $request->stock_id)
                              ->where('action', 'sell')
                              ->count();

                        $average_sell = $open_sell / $trade_count_sell;

                        $quantity_sell = Auth::user()->portfolio()
                                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                ->where('portfolio_id', $request->portfolio_id)
                                ->where('stock_code', $request->stock_code)
                                ->where('stock_id',  $request->stock_id)
                                ->where('action', 'sell')
                                ->sum('quantity');

                        $subtotal_gross_sell = $average_sell * $quantity_sell;



                        $gross_profits = $subtotal_gross_sell - $subtotal_gross_buy;

                        $subtotal_buy = Auth::user()->portfolio()
                                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                ->where('portfolio_id', $request->portfolio_id)
                                ->where('stock_code', $request->stock_code)
                                ->where('stock_id',  $request->stock_id)
                                ->where('action', 'buy')
                                ->sum('subtotal');

                        $ROI_gros_profits = $gross_profits/$subtotal_buy * 100;

                        $subtotal_cost_buy = Auth::user()->portfolio()
                                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                ->where('portfolio_id', $request->portfolio_id)
                                ->where('stock_code', $request->stock_code)
                                ->where('stock_id',  $request->stock_id)
                                ->where('action', 'buy')
                                ->sum('total_cost');

                        $subtotal_cost_sell = Auth::user()->portfolio()
                                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                ->where('portfolio_id', $request->portfolio_id)
                                ->where('stock_code', $request->stock_code)
                                ->where('stock_id',  $request->stock_id)
                                ->where('action', 'sell')
                                ->sum('total_cost');

                         $net_profits = $subtotal_cost_sell - $subtotal_cost_buy;

                         $ROI_net_profits = $net_profits/$subtotal_cost_buy * 100;





                         if ($net_profits < 0)
                         {

                           $status = 'LOSS';
                           $trans_update = DB::table('transactions')
                                 ->insert([
                                   "portfolio_id" => $request->portfolio_id,
                                   "user_id" => Auth::id(),
                                   "stock_code" => $request->stock_code,
                                   "type" => 'Loss',
                                   "amount" => $net_profits,
                                   "remark" => 'Loss',
                                   "stock_id" => $request->stock_id,
                                   "date" => Carbon::now(),
                                   "created_at" => Carbon::now(),
                                   "updated_at" => Carbon::now(),
                                         ]);
                         }
                         else
                         {
                           $status = 'WIN';
                           $trans_update = DB::table('transactions')
                                 ->insert([
                                   "portfolio_id" => $request->portfolio_id,
                                   "user_id" => Auth::id(),
                                   "stock_code" => $request->stock_code,
                                   "type" => 'Profit',
                                   "amount" => $net_profits,
                                   "remark" => 'Profit',
                                   "stock_id" => $request->stock_id,
                                   "date" => Carbon::now(),
                                   "created_at" => Carbon::now(),
                                   "updated_at" => Carbon::now(),
                                         ]);
                         }


                        $Result_Update = DB::table('results')
                        ->where('portfolio_id', $request->portfolio_id)
                        ->where('stock_code', $request->stock_code)
                        ->where('stock_id', $request->stock_id)
                        ->where('user_id', Auth::id())
                              ->update([
                                "gross_profit" => $gross_profits,
                                "gross_roi" => $ROI_gros_profits,
                                "net_profit" => $net_profits,
                                "net_roi" => $ROI_net_profits,
                                "status" => $status
                                      ]);

                          $win =  Result::where('portfolio_id' , $request->portfolio_id)
                                            ->where ('user_id', Auth::id())
                                            ->where('stock_code', $request->stock_code)
                                            ->where ('status', 'WIN')
                                            ->count();

                         $loss =  Result::where('portfolio_id' , $request->portfolio_id)
                                           ->where ('user_id', Auth::id())
                                           ->where('stock_code', $request->stock_code)
                                            ->where ('status', 'LOSS')
                                            ->count();

                                            $profit_eq =  Result::where('portfolio_id' , $request->portfolio_id)
                                                              ->where ('user_id', Auth::id())
                                                              ->where('stock_code', $request->stock_code)
                                                              ->where ('status', 'WIN')
                                                              ->sum('net_profit');

                                            $loss_eq = Result::where('portfolio_id' , $request->portfolio_id)
                                                              ->where ('user_id', Auth::id())
                                                              ->where('stock_code', $request->stock_code)
                                                               ->where ('status', 'LOSS')
                                                                ->sum('net_profit');

                                            $total_q = $profit_eq + $loss_eq;

                                            $initial = Transaction::where('portfolio_id' , $request->portfolio_id)
                                                                ->where ('user_id', Auth::id())
                                                                ->where ('type', 'Initial')
                                                                ->sum('amount');

                                            $deposit = Transaction::where('portfolio_id' , $request->portfolio_id)
                                                                ->where ('user_id', Auth::id())
                                                                ->where ('type', 'Deposit')
                                                                ->sum('amount');

                                            $withdraw = Transaction::where('portfolio_id' , $request->portfolio_id)
                                                                ->where ('user_id', Auth::id())
                                                                ->where ('type', 'Withdraw')
                                                                ->sum('amount');

                                            $profit = Transaction::where('portfolio_id' , $request->portfolio_id)
                                                                ->where ('user_id', Auth::id())
                                                                ->where ('type', 'Profit')
                                                                ->sum('amount');

                                            $winnings = Transaction::where('portfolio_id' , $request->portfolio_id)
                                                                ->where ('user_id', Auth::id())
                                                               ->where ('type', 'Profit')
                                                               ->count();

                                            $lossing = Transaction::where('portfolio_id' , $request->portfolio_id)
                                                                ->where ('user_id', Auth::id())
                                                               ->where ('type', 'Loss')
                                                               ->count();




                                            $sub_total = $initial + $total_q - $withdraw + $deposit;

                                            $roi_port = ($sub_total - $initial) / $initial *100;

                                            $balance_avaiable = Transaction::where('portfolio_id' , $request->portfolio_id)
                                                                ->sum('amount');


                                                          $portfolio_update = DB::table('portfolios')
                                                          ->where('id', $request->portfolio_id)
                                                          ->where('user_id', Auth::id())
                                                          ->update([
                                                                  "win" => $win,
                                                                  "loss" => $loss,
                                                                  "total_profit" => $total_q,
                                                                  'roi_port' =>$roi_port,
                                                                  'balance_available' =>$balance_avaiable,
                                                          ]);
                                                          $broke_total_fee = Auth::user()->portfolio()
                                                                  ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                                                  ->where('portfolio_id', $request->portfolio_id)
                                                                  ->where('stock_code', $request->stock_code)
                                                                  ->where('stock_id',  $request->stock_id)
                                                                  ->sum('broker_fee');

                                                              $clearing_total_fee = Auth::user()->portfolio()
                                                                      ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                                                      ->where('portfolio_id', $request->portfolio_id)
                                                                      ->where('stock_code', $request->stock_code)
                                                                      ->where('stock_id',  $request->stock_id)
                                                                      ->sum('clearing_fee');

                                                              $stamp_total_fee = Auth::user()->portfolio()
                                                                      ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                                                      ->where('portfolio_id', $request->portfolio_id)
                                                                      ->where('stock_code', $request->stock_code)
                                                                      ->where('stock_id',  $request->stock_id)
                                                                      ->sum('stamp_duty');

                                                                      $subtotal_fee = $broke_total_fee + $clearing_total_fee + $stamp_total_fee;

                                                                      $Result_Update = DB::table('results')
                                                                      ->where('portfolio_id', $request->portfolio_id)
                                                                      ->where('stock_code', $request->stock_code)
                                                                      ->where('stock_id', $request->stock_id)
                                                                      ->where('user_id', Auth::id())
                                                                            ->update([
                                                                              "subtotal_fee" => $subtotal_fee,
                                                                                    ]);
                      } else
                      {
                        $Result_Update = DB::table('results')
                        ->where('portfolio_id', $request->portfolio_id)
                        ->where('stock_code', $request->stock_code)
                        ->where('stock_id', $request->stock_id)
                        ->where('user_id', Auth::id())
                              ->update([
                                "gross_profit" => Null,
                                "gross_roi" => Null

                                  ]);
                      }


        }else {
          $trade = new Trade();
          $trade->action = 'sell';
          $trade->status = 0;
          $trade->portfolio_id = $request->portfolio_id;
          $trade->stock_code = $request->stock_code;
          $trade->first_fees = $request->first_fees;
          $trade->stock_id = $request->stock_id;
          $trade->stock_name = $request->stock_name;
          $trade->stock_symbol = $request->stock_symbol;
          $trade->price = $request->price;
          $trade->brokerage_id = $request->brokerage_id;
          $trade->quantity = $request->quantity;
          $trade->date = $request->date;
          $trade->remark = $request->remark;

          //Subtotal Calculation//
          $subtotal = $request->price * $request->quantity;
          $trade->subtotal = $subtotal;
          //Brokerage Fee Calculation //
          $broker_f = $subtotal * $request->second_fees/100;
          if($broker_f  > $request->first_fees){
            $broker_fees = $subtotal * $request->second_fees/100;
            $trade->broker_fee = $broker_fees;
          }
          elseif($broker_f < $request->first_fees){
            $broker_fees =  $request->first_fees;
            $trade->broker_fee = $broker_fees;
          }
          //Clearing Fee Calculation//
          $clearing_f = $subtotal * 0.03/100;
          $trade->clearing_fee = $clearing_f;
          //Stamp Duty Fee Calculation//
          $stamp_d = ceil($subtotal/1000) * 1.50;
          $trade->stamp_duty = $stamp_d;
          //Total Fees  Calculation//
          $total_fees = $broker_fees + $clearing_f +  $stamp_d;
          //Total Cost  Calculation//
         $total_c = $subtotal - $broker_fees - $clearing_f - $stamp_d ;
         $trade->total_cost = $total_c;

          $trade->user_id = Auth::id();
          $trade->result_id = $request->result_id;

          $trade->save();

          $close_sell = Auth::user()->portfolio()
                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                ->where('portfolio_id', $request->portfolio_id)
                ->where('stock_code', $request->stock_code)
                ->where('stock_id',  $request->stock_id)
                ->where('action', 'sell')
                ->sum('price');

          $trade_count = Auth::user()->portfolio()
                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                ->where('portfolio_id', $request->portfolio_id)
                ->where('stock_code', $request->stock_code)
                ->where('stock_id',  $request->stock_id)
                ->where('action', 'sell')
                ->count();

          $average_sell_trade = $close_sell / $trade_count;

          $sum_quantity = Auth::user()->portfolio()
                  ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                  ->where('portfolio_id', $request->portfolio_id)
                  ->where('stock_code', $request->stock_code)
                  ->where('stock_id',  $request->stock_id)
                  ->where('action', 'sell')
                  ->sum('quantity');

                  $broke_total_fee = Auth::user()->portfolio()
                          ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                          ->where('portfolio_id', $request->portfolio_id)
                          ->where('stock_code', $request->stock_code)
                          ->where('stock_id',  $request->stock_id)
                          ->where('action', 'sell')
                          ->sum('broker_fee');

                          $clearing_total_fee = Auth::user()->portfolio()
                                  ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                  ->where('portfolio_id', $request->portfolio_id)
                                  ->where('stock_code', $request->stock_code)
                                  ->where('stock_id',  $request->stock_id)
                                  ->where('action', 'sell')
                                  ->sum('clearing_fee');

                                  $stamp_total_fee = Auth::user()->portfolio()
                                          ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                          ->where('portfolio_id', $request->portfolio_id)
                                          ->where('stock_code', $request->stock_code)
                                          ->where('stock_id',  $request->stock_id)
                                          ->where('action', 'sell')
                                          ->sum('stamp_duty');

          $subtotal_fees_sell = $broke_total_fee + $clearing_total_fee + $stamp_total_fee;

          $subtotal_sell_trade = Auth::user()->portfolio()
                  ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                  ->where('portfolio_id', $request->portfolio_id)
                  ->where('stock_code', $request->stock_code)
                  ->where('stock_id',  $request->stock_id)
                  ->where('action', 'sell')
                  ->sum('subtotal');

          $subtotal_cost_sell = Auth::user()->portfolio()
                  ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                  ->where('portfolio_id', $request->portfolio_id)
                  ->where('stock_code', $request->stock_code)
                  ->where('stock_id',  $request->stock_id)
                  ->where('action', 'sell')
                  ->sum('total_cost');

          $sum_quantity_buy = Auth::user()->portfolio()
                  ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                  ->where('portfolio_id', $request->portfolio_id)
                  ->where('stock_code', $request->stock_code)
                  ->where('stock_id',  $request->stock_id)
                  ->where('action', 'buy')
                  ->sum('quantity');

          $balance_quantity =   $sum_quantity_buy -   $sum_quantity;

          $broke_total_fee_all = Auth::user()->portfolio()
                  ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                  ->where('portfolio_id', $request->portfolio_id)
                  ->where('stock_code', $request->stock_code)
                  ->where('stock_id',  $request->stock_id)
                  ->sum('broker_fee');

              $clearing_total_fee_all = Auth::user()->portfolio()
                      ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                      ->where('portfolio_id', $request->portfolio_id)
                      ->where('stock_code', $request->stock_code)
                      ->where('stock_id',  $request->stock_id)
                      ->sum('clearing_fee');

              $stamp_total_fee_all = Auth::user()->portfolio()
                      ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                      ->where('portfolio_id', $request->portfolio_id)
                      ->where('stock_code', $request->stock_code)
                      ->where('stock_id',  $request->stock_id)
                      ->sum('stamp_duty');

                      $subtotal_fee_all = $broke_total_fee_all + $clearing_total_fee_all + $stamp_total_fee_all;

          $Result_Update = DB::table('results')
          ->where('portfolio_id', $request->portfolio_id)
          ->where('stock_code', $request->stock_code)
          ->where('stock_id', $request->stock_id)
          ->where('user_id', Auth::id())
                ->update([
                  "average_sell" => $average_sell_trade,
                  "quantity_sell" => $sum_quantity,
                  "total_fees_sell" => $subtotal_fees_sell,
                  "subtotal_sell" => $subtotal_sell_trade,
                  "total_sell_cost" => $subtotal_cost_sell,
                  "quantity_bal" => $balance_quantity,
                  "subtotal_fee" => $subtotal_fee_all,


                        ]);

                        if ($balance_quantity == 0)
                        {
                          $open_buy = Auth::user()->portfolio()
                                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                ->where('portfolio_id', $request->portfolio_id)
                                ->where('stock_code', $request->stock_code)
                                ->where('stock_id',  $request->stock_id)
                                ->where('action', 'buy')
                                ->sum('price');

                          $trade_count = Auth::user()->portfolio()
                                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                ->where('portfolio_id', $request->portfolio_id)
                                ->where('stock_code', $request->stock_code)
                                ->where('stock_id',  $request->stock_id)
                                ->where('action', 'buy')
                                ->count();

                          $average_buy = $open_buy / $trade_count;

                          $quantity_buy = Auth::user()->portfolio()
                                  ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                  ->where('portfolio_id', $request->portfolio_id)
                                  ->where('stock_code', $request->stock_code)
                                  ->where('stock_id',  $request->stock_id)
                                  ->where('action', 'buy')
                                  ->sum('quantity');

                          $subtotal_gross_buy = $average_buy * $quantity_buy;

                          $open_sell = Auth::user()->portfolio()
                                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                ->where('portfolio_id', $request->portfolio_id)
                                ->where('stock_code', $request->stock_code)
                                ->where('stock_id',  $request->stock_id)
                                ->where('action', 'sell')
                                ->sum('price');

                          $trade_count_sell = Auth::user()->portfolio()
                                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                ->where('portfolio_id', $request->portfolio_id)
                                ->where('stock_code', $request->stock_code)
                                ->where('stock_id',  $request->stock_id)
                                ->where('action', 'sell')
                                ->count();

                          $average_sell = $open_sell / $trade_count_sell;

                          $quantity_sell = Auth::user()->portfolio()
                                  ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                  ->where('portfolio_id', $request->portfolio_id)
                                  ->where('stock_code', $request->stock_code)
                                  ->where('stock_id',  $request->stock_id)
                                  ->where('action', 'sell')
                                  ->sum('quantity');

                          $subtotal_gross_sell = $average_sell * $quantity_sell;



                          $gross_profits = $subtotal_gross_sell - $subtotal_gross_buy;

                          $subtotal_buy = Auth::user()->portfolio()
                                  ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                  ->where('portfolio_id', $request->portfolio_id)
                                  ->where('stock_code', $request->stock_code)
                                  ->where('stock_id',  $request->stock_id)
                                  ->where('action', 'buy')
                                  ->sum('subtotal');

                          $ROI_gros_profits = $gross_profits/$subtotal_buy * 100;

                          $subtotal_cost_buy = Auth::user()->portfolio()
                                  ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                  ->where('portfolio_id', $request->portfolio_id)
                                  ->where('stock_code', $request->stock_code)
                                  ->where('stock_id',  $request->stock_id)
                                  ->where('action', 'buy')
                                  ->sum('total_cost');

                          $subtotal_cost_sell = Auth::user()->portfolio()
                                  ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                  ->where('portfolio_id', $request->portfolio_id)
                                  ->where('stock_code', $request->stock_code)
                                  ->where('stock_id',  $request->stock_id)
                                  ->where('action', 'sell')
                                  ->sum('total_cost');

                           $net_profits = $subtotal_cost_sell - $subtotal_cost_buy;

                           $ROI_net_profits = $net_profits/$subtotal_cost_buy * 100;

                           if ($net_profits < 0)
                           {
                             $status = 'LOSS';

                             $trans_update = DB::table('transactions')
                                   ->insert([
                                     "portfolio_id" => $request->portfolio_id,
                                     "user_id" => Auth::id(),
                                     "type" => 'Loss',
                                     "amount" => $net_profits,
                                     "remark" => 'Loss',
                                     "stock_id" => $request->stock_id,
                                     "date" => Carbon::now(),
                                     "created_at" => Carbon::now(),
                                     "updated_at" => Carbon::now(),
                                           ]);

                           }
                           else
                           {
                             $status = 'WIN';

                             $trans_update = DB::table('transactions')
                                   ->insert([
                                     "portfolio_id" => $request->portfolio_id,
                                     "user_id" => Auth::id(),
                                     "type" => 'Profit',
                                     "amount" => $net_profits,
                                     "remark" => 'Profit',
                                     "stock_id" => $request->stock_id,
                                     "date" => Carbon::now(),
                                     "created_at" => Carbon::now(),
                                     "updated_at" => Carbon::now(),
                                           ]);


                           }


                          $Result_Update = DB::table('results')
                          ->where('portfolio_id', $request->portfolio_id)
                          ->where('stock_code', $request->stock_code)
                          ->where('stock_id', $request->stock_id)
                          ->where('user_id', Auth::id())
                                ->update([
                                  "gross_profit" => $gross_profits,
                                  "gross_roi" => $ROI_gros_profits,
                                  "net_profit" => $net_profits,
                                  "net_roi" => $ROI_net_profits,
                                  "status" => $status
                                        ]);

                          $win =  Result::where('portfolio_id' , $request->portfolio_id)
                                            ->where ('user_id', Auth::id())
                                            ->where ('status', 'WIN')
                                            ->count();

                         $loss =  Result::where('portfolio_id' , $request->portfolio_id)
                                           ->where ('user_id', Auth::id())
                                            ->where ('status', 'LOSS')
                                            ->count();

                          $profit_eq =  Result::where('portfolio_id' , $request->portfolio_id)
                                            ->where ('user_id', Auth::id())
                                            ->where ('status', 'WIN')
                                            ->sum('net_profit');

                          $loss_eq = Result::where('portfolio_id' , $request->portfolio_id)
                                            ->where ('user_id', Auth::id())
                                             ->where ('status', 'LOSS')
                                              ->sum('net_profit');

                          $total_q = $profit_eq + $loss_eq;
                          $initial = Transaction::where('portfolio_id' , $request->portfolio_id)
                                              ->where ('user_id', Auth::id())
                                              ->where ('type', 'Initial')
                                              ->sum('amount');

                          $deposit = Transaction::where('portfolio_id' , $request->portfolio_id)
                                              ->where ('user_id', Auth::id())
                                              ->where ('type', 'Deposit')
                                              ->sum('amount');

                          $withdraw = Transaction::where('portfolio_id' , $request->portfolio_id)
                                              ->where ('user_id', Auth::id())
                                              ->where ('type', 'Withdraw')
                                              ->sum('amount');

                          $profit = Transaction::where('portfolio_id' , $request->portfolio_id)
                                              ->where ('user_id', Auth::id())
                                              ->where ('type', 'Profit')
                                              ->sum('amount');

                          $winnings = Transaction::where('portfolio_id' , $request->portfolio_id)
                                              ->where ('user_id', Auth::id())
                                             ->where ('type', 'Profit')
                                             ->count();

                          $lossing = Transaction::where('portfolio_id' , $request->portfolio_id)
                                              ->where ('user_id', Auth::id())
                                             ->where ('type', 'Loss')
                                             ->count();




                          $sub_total = $initial + $total_q - $withdraw + $deposit;

                          $roi_port = ($sub_total - $initial) / $initial *100;


                          $balance_avaiable = Transaction::where('portfolio_id' , $request->portfolio_id)
                                              ->sum('amount');

                                        $portfolio_update = DB::table('portfolios')
                                        ->where('id', $request->portfolio_id)
                                        ->where('user_id', Auth::id())
                                        ->update([
                                                "win" => $win,
                                                "loss" => $loss,
                                                "total_profit" => $total_q,
                                                'roi_port' =>$roi_port,
                                                'balance_available' =>$balance_avaiable,
                                        ]);

                                        $broke_total_fee = Auth::user()->portfolio()
                                                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                                ->where('portfolio_id', $request->portfolio_id)
                                                ->where('stock_code', $request->stock_code)
                                                ->where('stock_id',  $request->stock_id)
                                                ->sum('broker_fee');

                                            $clearing_total_fee = Auth::user()->portfolio()
                                                    ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                                    ->where('portfolio_id', $request->portfolio_id)
                                                    ->where('stock_code', $request->stock_code)
                                                    ->where('stock_id',  $request->stock_id)
                                                    ->sum('clearing_fee');

                                            $stamp_total_fee = Auth::user()->portfolio()
                                                    ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                                    ->where('portfolio_id', $request->portfolio_id)
                                                    ->where('stock_code', $request->stock_code)
                                                    ->where('stock_id',  $request->stock_id)
                                                    ->sum('stamp_duty');

                                                    $subtotal_fee = $broke_total_fee + $clearing_total_fee + $stamp_total_fee;

                                                    $Result_Update = DB::table('results')
                                                    ->where('portfolio_id', $request->portfolio_id)
                                                    ->where('stock_code', $request->stock_code)
                                                    ->where('stock_id', $request->stock_id)
                                                    ->where('user_id', Auth::id())
                                                          ->update([
                                                            "subtotal_fee" => $subtotal_fee,
                                                                  ]);

                        } else
                        {
                          $Result_Update = DB::table('results')
                          ->where('portfolio_id', $request->portfolio_id)
                          ->where('stock_code', $request->stock_code)
                          ->where('stock_id', $request->stock_id)
                          ->where('user_id', Auth::id())
                                ->update([
                                  "gross_profit" => Null,
                                  "gross_roi" => Null

                                    ]);

                                    $broke_total_fee = Auth::user()->portfolio()
                                            ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                            ->where('portfolio_id', $request->portfolio_id)
                                            ->where('stock_code', $request->stock_code)
                                            ->where('stock_id',  $request->stock_id)
                                            ->sum('broker_fee');

                                        $clearing_total_fee = Auth::user()->portfolio()
                                                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                                ->where('portfolio_id', $request->portfolio_id)
                                                ->where('stock_code', $request->stock_code)
                                                ->where('stock_id',  $request->stock_id)
                                                ->sum('clearing_fee');

                                        $stamp_total_fee = Auth::user()->portfolio()
                                                ->join('trades', 'portfolios.id', '=', 'trades.portfolio_id')
                                                ->where('portfolio_id', $request->portfolio_id)
                                                ->where('stock_code', $request->stock_code)
                                                ->where('stock_id',  $request->stock_id)
                                                ->sum('stamp_duty');

                                                $subtotal_fee = $broke_total_fee + $clearing_total_fee + $stamp_total_fee;

                                                $Result_Update = DB::table('results')
                                                ->where('portfolio_id', $request->portfolio_id)
                                                ->where('stock_code', $request->stock_code)
                                                ->where('stock_id', $request->stock_id)
                                                ->where('user_id', Auth::id())
                                                      ->update([
                                                        "subtotal_fee" => $subtotal_fee,
                                                              ]);
                        }

           }
     // return redirect()->back()
     return redirect()->route('trades.statistic', ['id' => $request->portfolio_id])
          ->with('success','Sell created successfully.');
  }

        return view('posts.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'title' => 'required',
            'body' => 'required',
        ]);
        $input = $request->except(['_token']);

        Post::create($input);

        return redirect()->route('posts.index')
            ->with('success','Post created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $post = Post::find($id);

        return view('posts.show', compact('post'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $post = Post::find($id);

        return view('posts.edit',compact('post'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title' => 'required',
            'body' => 'required',
        ]);

        $post = Post::find($id);

        $post->update($request->all());

        return redirect()->route('posts.index')
            ->with('success', 'Post updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Post::find($id)->delete();

        return redirect()->route('posts.index')
            ->with('success', 'Post deleted successfully.');
    }
}
